/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import junit.framework.Assert;

public class TestNavigatorStates
extends FuncTestCase {
    public void testStayInAdvancedWhenLoadingFilterWithErrors() {
        this.administration.restoreData("TestIllegalJqlFunctionParameters.xml");
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.navigation.issueNavigator().loadFilter(10014L, null);
        TestNavigatorStates.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.VIEW), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.tester.clickLink("editfilter");
        Assert.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorEditMode.ADVANCED), (Object)((Object)this.navigation.issueNavigator().getCurrentEditMode()));
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='filter-type']/li", "simple");
        this.tester.clickLink("switchnavtype");
        Assert.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorEditMode.SIMPLE), (Object)((Object)this.navigation.issueNavigator().getCurrentEditMode()));
    }

    public void testCreateNewLinkDoesntAppearOnEdit() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoPage("/secure/IssueNavigator.jspa");
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//div[@id='filter-description']"), "Create new");
        this.tester.clickLink("viewfilter");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='filter-description']"), "Create new");
        this.tester.clickLink("managefilters");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='filter-description']"), "Create new");
        this.tester.clickLink("new_filter");
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//div[@id='filter-description']"), "Create new");
        this.tester.clickLink("switchnavtype");
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//div[@id='filter-description']"), "Create new");
    }

    public void testEmptySearchAndOrderSummary() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.issueNavigator().createSearch("");
        this.navigation.issueNavigator().gotoViewMode();
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='filter-summary']"), "All Issues");
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='filter-summary']"), "Sorted by", "Key descending");
        this.navigation.issueNavigator().createSearch("type = bug");
        this.navigation.issueNavigator().gotoViewMode();
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='filter-summary']"), "Issue Type", "Bug");
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='filter-summary']"), "Sorted by", "Key descending");
        this.navigation.issueNavigator().createSearch("order by type asc");
        this.navigation.issueNavigator().gotoViewMode();
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='filter-summary']"), "All Issues", new String[0]);
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='filter-summary']"), "Sorted by", " Issue Type ascending");
        this.navigation.issueNavigator().createSearch("type = bug order by type asc");
        this.navigation.issueNavigator().gotoViewMode();
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='filter-summary']"), "Issue Type", "Bug");
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='filter-summary']"), "Sorted by", " Issue Type ascending");
    }

    public void testExecuteAdvancedCommandSetsNavigatorEditState() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.issueNavigator().createSearch("");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?clear=true&runQuery=true&jqlQuery=project+%3D+hsp+or+type+%3D+bug");
        TestNavigatorStates.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorEditMode.ADVANCED), (Object)((Object)this.navigation.issueNavigator().getCurrentEditMode()));
        this.text.assertTextPresent(new XPathLocator(this.tester, "//ul[@class='filter-type']"), "This query is too complex to display in Simple mode.");
    }
}

