/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import java.util.Collections;
import org.w3c.dom.Node;

public class TestJqlQueryTextBox
extends AbstractJqlFuncTest {
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestJqlQueryTextBox.xml");
    }

    public void testQueryHistoryTrimQuery() throws Exception {
        String query = "project = homosapien";
        this.assertSearchWithResults(query, "HSP-3", "HSP-2", "HSP-1");
        this.assertQueryHistory(query);
        this.navigation.issueNavigator().createSearch("   " + query + " ORDER BY key DESC" + "      ");
        this.assertIssues("HSP-3", "HSP-2", "HSP-1");
        this.assertQueryHistory(query);
    }

    public void testQueryHistoryKeepWhitespaceInsideQuery() throws Exception {
        String query1 = "project =  homosapien";
        String query2 = "project    = homosapien";
        this.assertSearchWithResults(query1, "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults(query2, "HSP-3", "HSP-2", "HSP-1");
        this.assertQueryHistory(query2, query1);
    }

    public void testQueryHistoryBoxNoDuplicateQueries() throws Exception {
        String queryHSP1 = "Issue = \"HSP-1\"";
        String queryHSP2 = "Issue = \"HSP-2\"";
        String longQueryHSP1 = "Issue = \"HSP-1\" AND affectedVersion is empty AND summary ~ sample AND assignee = \"fred\" AND reporter = \"Administrator\" AND priority = \"Major\"";
        String longQueryHSP2 = "Issue = \"HSP-2\" AND affectedVersion is empty AND summary ~ sample AND assignee = \"fred\" AND reporter = \"Administrator\"";
        this.assertSearchWithResults(queryHSP1, "HSP-1");
        this.assertQueryHistory(queryHSP1);
        this.assertSearchWithResults(queryHSP2, "HSP-2");
        this.assertQueryHistory(queryHSP2, queryHSP1);
        this.assertSearchWithResults(queryHSP1, "HSP-1");
        this.assertQueryHistory(queryHSP1, queryHSP2);
        this.assertSearchWithResults(longQueryHSP1, "HSP-1");
        this.assertQueryHistory(longQueryHSP1, queryHSP1, queryHSP2);
        this.assertSearchWithResults(longQueryHSP2, new String[0]);
        this.assertQueryHistory(longQueryHSP2, longQueryHSP1, queryHSP1, queryHSP2);
    }

    public void testClickingQueryHistoryClearsCurrentFilter() throws Exception {
        String queryHSP1 = "Issue = \"HSP-1\"";
        String queryHSP2 = "Issue = \"HSP-2\"";
        this.assertSearchWithResults(queryHSP1, "HSP-1");
        this.assertQueryHistory(queryHSP1);
        this.assertSearchWithResults(queryHSP2, "HSP-2");
        this.assertQueryHistory(queryHSP2, queryHSP1);
        long filterId = this.navigation.issueNavigator().saveCurrentAsNewFilter("My New Filter", "", true, Collections.emptySet());
        this.navigation.issueNavigator().loadFilter(filterId, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.clickLink("historyItem1");
        XPathLocator locator = new XPathLocator(this.tester, "//div[@id='filter-description']");
        this.assertions.getTextAssertions().assertTextNotPresent(locator, "Filter modified since loading");
        this.assertQueryHistory(queryHSP1, queryHSP2);
    }

    private void assertQueryHistory(String ... items) {
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        XPathLocator locator = new XPathLocator(this.tester, "//a[@class='jqlQuickLink']");
        Node[] nodes = locator.getNodes();
        TestJqlQueryTextBox.assertEquals((String)"Size of query history items doesn't match expected ", (int)items.length, (int)nodes.length);
        for (int i = 0; i < items.length; ++i) {
            TestJqlQueryTextBox.assertEquals((String)(items[i] + " ORDER BY key DESC"), (String)locator.getText(nodes[i]));
        }
    }
}

