/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestIssueNavigatorCommentsRSSView
extends AbstractJqlFuncTest {
    private List<String> homosapienIssueKeys = CollectionBuilder.newBuilder("HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1").asList();
    private List<String> monkeyIssueKeys = CollectionBuilder.newBuilder("MKY-10", "MKY-9", "MKY-8", "MKY-7", "MKY-6", "MKY-5", "MKY-4", "MKY-3", "MKY-2", "MKY-1").asList();
    private XPathFactory factory = XPathFactory.newInstance();

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueNavigatorCommentsRSSView.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueNavigatorCommentsRSSView() throws Exception {
        int responseCode;
        String monkeyKey;
        String hspKey;
        ArrayList<Comment> tempComment;
        String jqlQuery;
        int i;
        this.navigation.login("fred");
        List<Comment> comments = CollectionBuilder.newBuilder(new Comment("", "A comment from Fred", "Fred"), new Comment("", "I was here... - You not! :P", "Administrator"), new Comment("", "Again a comment for issue", "Administrator"), new Comment("", "Another comment for issue", "Administrator"), new Comment("", "A comment for issue", "Administrator")).asList();
        for (String homosapienIssueKey : this.homosapienIssueKeys) {
            this._executeCommentsRSSView("issue = \"" + homosapienIssueKey + "\"");
            this._verifyIssueComments(comments);
        }
        for (String monkeyIssueKey : this.monkeyIssueKeys) {
            this._executeCommentsRSSView("issue = \"" + monkeyIssueKey + "\"");
            this._verifyIssueComments(comments);
        }
        ArrayList<String> queries = new ArrayList<String>();
        queries.add("affectedVersion IS EMPTY AND assignee IS EMPTY AND component IS EMPTY AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY");
        queries.add("affectedVersion IS NOT EMPTY AND assignee IS EMPTY AND component IS EMPTY AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY");
        queries.add("assignee IS NOT EMPTY AND component IS EMPTY AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY");
        queries.add("component IS NOT EMPTY AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY");
        queries.add("description IS NOT EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY");
        queries.add("environment IS NOT EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY");
        queries.add("fixVersion IS NOT EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY");
        queries.add("level IS NOT EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY");
        queries.add("originalEstimate IS NOT EMPTY AND reporter IS EMPTY");
        queries.add("reporter IS NOT EMPTY");
        TestIssueNavigatorCommentsRSSView.assertEquals((int)this.homosapienIssueKeys.size(), (int)this.monkeyIssueKeys.size());
        for (i = 0; i < queries.size(); ++i) {
            jqlQuery = (String)queries.get(i);
            this._executeCommentsRSSView(jqlQuery);
            tempComment = new ArrayList<Comment>();
            hspKey = this.homosapienIssueKeys.get(this.homosapienIssueKeys.size() - i - 1);
            monkeyKey = this.monkeyIssueKeys.get(this.monkeyIssueKeys.size() - i - 1);
            tempComment.add(new Comment(hspKey, "A comment from Fred", "Fred"));
            tempComment.add(new Comment(monkeyKey, "A comment from Fred", "Fred"));
            tempComment.add(new Comment(hspKey, "I was here... - You not! :P", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "I was here... - You not! :P", "Administrator"));
            tempComment.add(new Comment(hspKey, "Again a comment for issue", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "Again a comment for issue", "Administrator"));
            tempComment.add(new Comment(hspKey, "Another comment for issue", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "Another comment for issue", "Administrator"));
            tempComment.add(new Comment(hspKey, "A comment for issue", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "A comment for issue", "Administrator"));
            this._verifyIssueComments(tempComment);
        }
        this.navigation.login("admin");
        for (i = 0; i < queries.size(); ++i) {
            jqlQuery = (String)queries.get(i);
            this._executeCommentsRSSView(jqlQuery);
            tempComment = new ArrayList();
            hspKey = this.homosapienIssueKeys.get(this.homosapienIssueKeys.size() - i - 1);
            monkeyKey = this.monkeyIssueKeys.get(this.monkeyIssueKeys.size() - i - 1);
            tempComment.add(new Comment(hspKey, "Not visible for Fred", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "Not visible for Fred", "Administrator"));
            tempComment.add(new Comment(hspKey, "A comment from Fred", "Fred"));
            tempComment.add(new Comment(monkeyKey, "A comment from Fred", "Fred"));
            tempComment.add(new Comment(hspKey, "I was here... - You not! :P", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "I was here... - You not! :P", "Administrator"));
            tempComment.add(new Comment(hspKey, "Again a comment for issue", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "Again a comment for issue", "Administrator"));
            tempComment.add(new Comment(hspKey, "Another comment for issue", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "Another comment for issue", "Administrator"));
            tempComment.add(new Comment(hspKey, "A comment for issue", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "A comment for issue", "Administrator"));
            this._verifyIssueComments(tempComment);
        }
        try {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
            this._executeCommentsRSSView("sdfdsfBLJLSKJLSKJF");
            responseCode = this.tester.getDialog().getResponse().getResponseCode();
            TestIssueNavigatorCommentsRSSView.assertEquals((int)400, (int)responseCode);
        }
        finally {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(true);
        }
        try {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
            this._executeCommentsRSSView("issue = \"BLJLSKJLSKJF\"");
            responseCode = this.tester.getDialog().getResponse().getResponseCode();
            TestIssueNavigatorCommentsRSSView.assertEquals((int)400, (int)responseCode);
        }
        finally {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(true);
        }
    }

    private void _verifyIssueComments(List<Comment> comments) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException {
        String xpathExpr = "//rss/channel/item";
        String responseText = this.tester.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        XPath xpath = this.factory.newXPath();
        XPathExpression expr = xpath.compile("//rss/channel/item");
        NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        TestIssueNavigatorCommentsRSSView.assertEquals((int)comments.size(), (int)nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Comment comment = comments.get(i);
            String issueKey = comment.getIssueKey();
            if (issueKey != null && issueKey.length() > 0) {
                Node titleNode = node.getChildNodes().item(1);
                String title = titleNode.getFirstChild().getNodeValue();
                TestIssueNavigatorCommentsRSSView.assertEquals((String)("Incorrect issue key in title! Expected: " + issueKey + " Title:" + title), (boolean)true, (boolean)title.contains(issueKey));
            }
            Node authorNode = node.getChildNodes().item(7);
            String author = authorNode.getFirstChild().getNodeValue();
            TestIssueNavigatorCommentsRSSView.assertEquals((String)("Incorrect Author. Expected: " + author), (boolean)true, (boolean)author.contains(comment.getAuthor()));
            Node descriptionNode = node.getChildNodes().item(9);
            String description = descriptionNode.getFirstChild().getNodeValue();
            TestIssueNavigatorCommentsRSSView.assertEquals((String)"Incorrect comment (order)!", (boolean)true, (boolean)description.contains(comment.getDescription()));
        }
    }

    private void _executeCommentsRSSView(String jqlQuery) throws UnsupportedEncodingException {
        String encodedQuery = URLEncoder.encode(jqlQuery, "UTF-8");
        String url = "/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?jqlQuery=" + encodedQuery + "&tempMax=1000";
        this.tester.gotoPage(url);
    }

    class Comment {
        private final String issueKey;
        private final String description;
        private final String author;

        Comment(String issueKey, String description, String author) {
            this.issueKey = issueKey;
            this.description = description;
            this.author = author;
        }

        public String getIssueKey() {
            return this.issueKey;
        }

        public String getDescription() {
            return this.description;
        }

        public String getAuthor() {
            return this.author;
        }
    }
}

