/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigator.ContainsIssueKeysCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.navigator.NumberOfIssuesCondition;
import com.atlassian.jira.functest.framework.navigator.ProjectCondition;
import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCustomFieldLiterals
extends AbstractJqlFuncTest {
    private static final AtomicBoolean dataSetUp = new AtomicBoolean(false);

    @Override
    protected void setUpTest() {
        super.setUpTest();
        if (!dataSetUp.getAndSet(true)) {
            this.administration.restoreData("TestCustomFieldLiterals.xml");
        }
    }

    public void testCascadingSelect() throws Exception {
        String fieldName = "CSF";
        String projKey = "ONE";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'first option'", new Result(new String[]{"ONE-6", "ONE-5"}));
        matrix.put("'10020'", new Result(new String[]{"ONE-7"}));
        matrix.put("'10022'", new Result(new String[]{"ONE-7"}));
        matrix.put("'Bad String'", new Result(ErrorType.OPTION_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.OPTION_NOT_FOUND));
        matrix.put("10020", new Result(new String[]{"ONE-6", "ONE-5"}));
        matrix.put("10022", new Result(new String[]{"ONE-7"}));
        matrix.put("999", new Result(new String[]{"ONE-6"}));
        matrix.put("666", new Result(ErrorType.OPTION_NOT_FOUND_WITH_QUOTES));
        matrix.put("EMPTY", new Result(new String[0]));
        this._testLiteralMatrix("ONE", "CSF", matrix);
    }

    public void testDatePicker() throws Exception {
        String fieldName = "DP";
        String projKey = "TWO";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("1242604510000", new Result(new String[]{"TWO-4", "TWO-3", "TWO-2"}));
        matrix.put("'1d'", new Result(new String[]{"TWO-4", "TWO-3", "TWO-2"}));
        matrix.put("'dd'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2009/05/13 18:50'", new Result(new String[]{"TWO-3", "TWO-2"}));
        matrix.put("'2009-05-13 18:50'", new Result(new String[]{"TWO-3", "TWO-2"}));
        matrix.put("'2009/05/14'", new Result(new String[]{"TWO-3", "TWO-2"}));
        matrix.put("'2009-05-14'", new Result(new String[]{"TWO-3", "TWO-2"}));
        matrix.put("'14/May/09'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'09/1/1'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2009/05/14 bad'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2010/02/35'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_DATE_FORMAT));
        this._testLiteralMatrix("TWO", "DP", "<", matrix);
        matrix = new LinkedHashMap();
        matrix.put("'2009/05/13 18:50'", new Result(new String[0]));
        matrix.put("'2009-05-13 18:50'", new Result(new String[0]));
        matrix.put("'2009/05/13'", new Result(new String[]{"TWO-3"}));
        matrix.put("'2009-05-13'", new Result(new String[]{"TWO-3"}));
        this._testLiteralMatrix("TWO", "DP", "=", matrix);
    }

    public void testDateTime() throws Exception {
        String fieldName = "DT";
        String projKey = "THREE";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("1242604510000", new Result(new String[]{"THREE-4", "THREE-3", "THREE-2"}));
        matrix.put("'1d'", new Result(new String[]{"THREE-4", "THREE-3", "THREE-2"}));
        matrix.put("'dd'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2009/05/11 13:00'", new Result(new String[]{"THREE-3", "THREE-2"}));
        matrix.put("'2009-05-11 13:00'", new Result(new String[]{"THREE-3", "THREE-2"}));
        matrix.put("'2009/05/12'", new Result(new String[]{"THREE-4", "THREE-3", "THREE-2"}));
        matrix.put("'2009-05-12'", new Result(new String[]{"THREE-4", "THREE-3", "THREE-2"}));
        matrix.put("'11/May/09'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'09/1/1'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2009/05/14 bad'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2010/02/35'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_DATE_FORMAT));
        this._testLiteralMatrix("THREE", "DT", "<", matrix);
        matrix = new LinkedHashMap();
        matrix.put("'2009/05/11 12:00'", new Result(new String[]{"THREE-3"}));
        matrix.put("'2009-05-11 12:00'", new Result(new String[]{"THREE-3"}));
        matrix.put("'2009/05/11'", new Result(new String[0]));
        matrix.put("'2009-05-11'", new Result(new String[0]));
        this._testLiteralMatrix("THREE", "DT", "=", matrix);
    }

    public void testFreeTextField() throws Exception {
        String fieldName = "FTF";
        String projKey = "FOUR";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Test'", new Result(new String[]{"FOUR-5"}));
        matrix.put("'-Test'", new Result(new String[]{"FOUR-6"}));
        matrix.put("'123456'", new Result(new String[]{"FOUR-6"}));
        matrix.put("'?'", new Result(ErrorType.INVALID_START_CHAR));
        matrix.put("'BAD +'", new Result(ErrorType.CANT_PARSE_QUERY));
        matrix.put("''", new Result(ErrorType.EMPTY_STRING_NOT_SUPPORTED));
        matrix.put("Test", new Result(new String[]{"FOUR-5"}));
        matrix.put("123456", new Result(new String[]{"FOUR-6"}));
        matrix.put("EMPTY", new Result(new String[]{"FOUR-4"}));
        this._testLiteralMatrix("FOUR", "FTF", "~", matrix);
    }

    public void testGroupPicker() throws Exception {
        String fieldName = "GP";
        String projKey = "FIVE";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'jira-users'", new Result(new String[]{"FIVE-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.GROUP_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.GROUP_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"FIVE-1"}));
        matrix.put("123456", new Result(new String[]{"FIVE-3"}));
        matrix.put("'123456'", new Result(new String[]{"FIVE-3"}));
        matrix.put("666", new Result(ErrorType.GROUP_NOT_FOUND_WITH_QUOTES));
        this._testLiteralMatrix("FIVE", "GP", matrix);
    }

    public void testImportId() throws Exception {
        String fieldName = "II";
        String projKey = "SIX";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'0'", new Result(new String[0]));
        matrix.put("'-2'", new Result(new String[0]));
        matrix.put("'4'", new Result(new String[]{"SIX-3"}));
        matrix.put("'Bad String'", new Result(ErrorType.INVALID_NUMBER_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_NUMBER_FORMAT));
        matrix.put("EMPTY", new Result(new String[]{"SIX-1"}));
        matrix.put("6", new Result(new String[]{"SIX-4"}));
        matrix.put("666", new Result(new String[0]));
        this._testLiteralMatrix("SIX", "II", matrix);
    }

    public void testMultiCheckboxes() throws Exception {
        String fieldName = "MC";
        String projKey = "SEVEN";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'opt1'", new Result(new String[]{"SEVEN-4", "SEVEN-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.OPTION_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.OPTION_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"SEVEN-1"}));
        matrix.put("2222", new Result(new String[]{"SEVEN-4", "SEVEN-3"}));
        matrix.put("'2222'", new Result(new String[]{"SEVEN-4", "SEVEN-3"}));
        matrix.put("666", new Result(ErrorType.OPTION_NOT_FOUND_WITH_QUOTES));
        this._testLiteralMatrix("SEVEN", "MC", matrix);
    }

    public void testMultiGroupPicker() throws Exception {
        String fieldName = "MGP";
        String projKey = "EIGHT";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'jira-users'", new Result(new String[]{"EIGHT-4", "EIGHT-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.GROUP_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.GROUP_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"EIGHT-1"}));
        matrix.put("123456", new Result(new String[]{"EIGHT-4", "EIGHT-3"}));
        matrix.put("'123456'", new Result(new String[]{"EIGHT-4", "EIGHT-3"}));
        matrix.put("666", new Result(ErrorType.GROUP_NOT_FOUND_WITH_QUOTES));
        this._testLiteralMatrix("EIGHT", "MGP", matrix);
    }

    public void testMultiSelect() throws Exception {
        String fieldName = "MS";
        String projKey = "NINE";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'select1'", new Result(new String[]{"NINE-4", "NINE-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.OPTION_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.OPTION_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"NINE-1"}));
        matrix.put("2222222", new Result(new String[]{"NINE-4", "NINE-3"}));
        matrix.put("'2222222'", new Result(new String[]{"NINE-4", "NINE-3"}));
        matrix.put("666", new Result(ErrorType.OPTION_NOT_FOUND_WITH_QUOTES));
        this._testLiteralMatrix("NINE", "MS", matrix);
    }

    public void testMultiUserPicker() throws Exception {
        String fieldName = "MUP";
        String projKey = "TEN";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'fred'", new Result(new String[]{"TEN-4", "TEN-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"TEN-1"}));
        matrix.put("987654", new Result(new String[]{"TEN-4", "TEN-3"}));
        matrix.put("'987654'", new Result(new String[]{"TEN-4", "TEN-3"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        this._testLiteralMatrix("TEN", "MUP", matrix);
    }

    public void testNumberField() throws Exception {
        String fieldName = "NF";
        String projKey = "ELEVEN";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'0'", new Result(new String[0]));
        matrix.put("'-2'", new Result(new String[0]));
        matrix.put("'20'", new Result(new String[]{"ELEVEN-3"}));
        matrix.put("'Bad String'", new Result(ErrorType.INVALID_NUMBER_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_NUMBER_FORMAT));
        matrix.put("EMPTY", new Result(new String[]{"ELEVEN-1"}));
        matrix.put("30", new Result(new String[]{"ELEVEN-4"}));
        matrix.put("666", new Result(new String[0]));
        this._testLiteralMatrix("ELEVEN", "NF", matrix);
    }

    public void testProjectPicker() throws Exception {
        String fieldName = "PP";
        String projKey = "TWELVE";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'10029'", new Result(new String[]{"TWELVE-2"}));
        matrix.put("'10030'", new Result(new String[]{"TWELVE-2"}));
        matrix.put("'SH'", new Result(new String[]{"TWELVE-3"}));
        matrix.put("'SHORT'", new Result(new String[]{"TWELVE-4"}));
        matrix.put("'NotAsShort'", new Result(new String[]{"TWELVE-4"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10029", new Result(new String[0]));
        matrix.put("10030", new Result(new String[]{"TWELVE-2"}));
        matrix.put("987654", new Result(new String[]{"TWELVE-5"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"TWELVE-1"}));
        this._testLiteralMatrix("TWELVE", "PP", matrix);
        ProjectCondition projectTwelve = new ProjectCondition().addProject("twelve");
        ProjectCondition ppCondition = new ProjectCondition("customfield_10011").addProject("Short");
        NavigatorSearch search = new NavigatorSearch(projectTwelve, ppCondition);
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("TWELVE-3");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertJqlQueryInTextArea("project = TWELVE AND PP = SH");
        ppCondition = new ProjectCondition("customfield_10011").addProject("NotAsShort");
        search = new NavigatorSearch(projectTwelve, ppCondition);
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("TWELVE-4");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertJqlQueryInTextArea("project = TWELVE AND PP = SHORT");
    }

    public void testRadioButton() throws Exception {
        String fieldName = "RB";
        String projKey = "THIRTEEN";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'rad1'", new Result(new String[]{"THIRTEEN-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.OPTION_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.OPTION_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"THIRTEEN-1"}));
        matrix.put("4444", new Result(new String[]{"THIRTEEN-3"}));
        matrix.put("'4444'", new Result(new String[]{"THIRTEEN-3"}));
        matrix.put("666", new Result(ErrorType.OPTION_NOT_FOUND_WITH_QUOTES));
        this._testLiteralMatrix("THIRTEEN", "RB", matrix);
    }

    public void testReadOnlyTextField() throws Exception {
        String fieldName = "ROTF";
        String projKey = "FOURTEEN";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Test'", new Result(new String[]{"FOURTEEN-2"}));
        matrix.put("'-Test'", new Result(new String[]{"FOURTEEN-3"}));
        matrix.put("'123456'", new Result(new String[]{"FOURTEEN-3"}));
        matrix.put("'?'", new Result(ErrorType.INVALID_START_CHAR));
        matrix.put("'BAD +'", new Result(ErrorType.CANT_PARSE_QUERY));
        matrix.put("''", new Result(ErrorType.EMPTY_STRING_NOT_SUPPORTED));
        matrix.put("Test", new Result(new String[]{"FOURTEEN-2"}));
        matrix.put("123456", new Result(new String[]{"FOURTEEN-3"}));
        matrix.put("EMPTY", new Result(new String[]{"FOURTEEN-1"}));
        this._testLiteralMatrix("FOURTEEN", "ROTF", "~", matrix);
    }

    public void testSelectList() throws Exception {
        String fieldName = "SL";
        String projKey = "FIFTEEN";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'select1'", new Result(new String[]{"FIFTEEN-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.OPTION_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.OPTION_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"FIFTEEN-1"}));
        matrix.put("5555555", new Result(new String[]{"FIFTEEN-3"}));
        matrix.put("'5555555'", new Result(new String[]{"FIFTEEN-3"}));
        matrix.put("666", new Result(ErrorType.OPTION_NOT_FOUND_WITH_QUOTES));
        this._testLiteralMatrix("FIFTEEN", "SL", matrix);
    }

    public void testSingleVersionPicker() throws Exception {
        String fieldName = "SVP";
        String projKey = "SIXTEEN";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'10010'", new Result(new String[]{"SIXTEEN-3"}));
        matrix.put("'10011'", new Result(new String[]{"SIXTEEN-3"}));
        matrix.put("'v1'", new Result(new String[]{"SIXTEEN-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10010", new Result(new String[]{"SIXTEEN-2"}));
        matrix.put("10011", new Result(new String[]{"SIXTEEN-3"}));
        matrix.put("224466", new Result(new String[]{"SIXTEEN-4"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"SIXTEEN-1"}));
        this._testLiteralMatrix("SIXTEEN", "SVP", matrix);
    }

    public void testTextField() throws Exception {
        String fieldName = "TF";
        String projKey = "SEVENTEEN";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Test'", new Result(new String[]{"SEVENTEEN-2"}));
        matrix.put("'-Test'", new Result(new String[]{"SEVENTEEN-3"}));
        matrix.put("'123456'", new Result(new String[]{"SEVENTEEN-3"}));
        matrix.put("'?'", new Result(ErrorType.INVALID_START_CHAR));
        matrix.put("'BAD +'", new Result(ErrorType.CANT_PARSE_QUERY));
        matrix.put("''", new Result(ErrorType.EMPTY_STRING_NOT_SUPPORTED));
        matrix.put("Test", new Result(new String[]{"SEVENTEEN-2"}));
        matrix.put("123456", new Result(new String[]{"SEVENTEEN-3"}));
        matrix.put("EMPTY", new Result(new String[]{"SEVENTEEN-1"}));
        this._testLiteralMatrix("SEVENTEEN", "TF", "~", matrix);
    }

    public void testUrlField() throws Exception {
        String fieldName = "URL";
        String projKey = "EIGHTEEN";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'http://www.atlassian.com'", new Result(new String[]{"EIGHTEEN-2"}));
        matrix.put("'Bad String'", new Result(new String[0]));
        matrix.put("''", new Result(new String[0]));
        matrix.put("666", new Result(new String[0]));
        matrix.put("EMPTY", new Result(new String[]{"EIGHTEEN-1"}));
        this._testLiteralMatrix("EIGHTEEN", "URL", matrix);
    }

    public void testUserPicker() throws Exception {
        String fieldName = "UP";
        String projKey = "NINETEEN";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'fred'", new Result(new String[]{"NINETEEN-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"NINETEEN-1"}));
        matrix.put("987654", new Result(new String[]{"NINETEEN-3"}));
        matrix.put("'987654'", new Result(new String[]{"NINETEEN-3"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        this._testLiteralMatrix("NINETEEN", "UP", matrix);
    }

    public void testVersionPicker() throws Exception {
        String fieldName = "VP";
        String projKey = "TWENTY";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'10013'", new Result(new String[]{"TWENTY-5", "TWENTY-3"}));
        matrix.put("'10014'", new Result(new String[]{"TWENTY-5", "TWENTY-3"}));
        matrix.put("'v1'", new Result(new String[]{"TWENTY-5", "TWENTY-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10013", new Result(new String[]{"TWENTY-5", "TWENTY-2"}));
        matrix.put("10014", new Result(new String[]{"TWENTY-5", "TWENTY-3"}));
        matrix.put("335577", new Result(new String[]{"TWENTY-5", "TWENTY-4"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"TWENTY-1"}));
        this._testLiteralMatrix("TWENTY", "VP", matrix);
    }

    private void _testLiteralMatrix(String projKey, String fieldName, Map<String, Result> matrix) {
        this._testLiteralMatrix(projKey, fieldName, "=", matrix);
    }

    private void _testLiteralMatrix(String projKey, String fieldName, String operator, Map<String, Result> matrix) {
        for (Map.Entry<String, Result> entry : matrix.entrySet()) {
            String operand = entry.getKey();
            String jqlQuery = String.format("project = %s AND %s %s %s", projKey, fieldName, operator, operand);
            Result result = entry.getValue();
            if (result.issueKeys == null && result.errorType != null) {
                this.navigation.issueNavigator().createSearch(jqlQuery);
                String errorMsg = result.errorType.formatError(fieldName, operand);
                this.assertErrorMessagePresent(errorMsg);
                continue;
            }
            this.assertSearchResults(jqlQuery, result.issueKeys);
        }
    }

    private void assertSearchResults(String jqlQuery, String ... issueKeys) {
        ArrayList<SearchResultsCondition> conditions = new ArrayList<SearchResultsCondition>();
        conditions.add(new ContainsIssueKeysCondition(this.assertions.getTextAssertions(), issueKeys));
        conditions.add(new NumberOfIssuesCondition(this.assertions.getTextAssertions(), issueKeys.length));
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(conditions);
    }

    private void assertErrorMessagePresent(String msg) {
        this.assertions.getTextAssertions().assertTextPresent(new WebPageLocator(this.tester), msg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ErrorType {
        EMPTY_STRING_NOT_SUPPORTED{

            String formatError(String fieldName, String operand) {
                return String.format("The field '%s' does not support searching for an empty string.", fieldName);
            }
        }
        ,
        INVALID_DATE_FORMAT{

            String formatError(String fieldName, String operand) {
                return String.format("Date value %s for field '%s' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'.", operand, fieldName);
            }
        }
        ,
        CANT_PARSE_QUERY{

            String formatError(String fieldName, String operand) {
                return String.format("Unable to parse the text %s for field '%s'.", operand, fieldName);
            }
        }
        ,
        INVALID_START_CHAR{

            String formatError(String fieldName, String operand) {
                return String.format("The text query %s for field '%s' is not allowed to start with %1$s.", operand, fieldName);
            }
        }
        ,
        INVALID_NUMBER_FORMAT{

            String formatError(String fieldName, String operand) {
                return String.format("Value %s for the '%s' field is not a valid number.", operand, fieldName);
            }
        }
        ,
        GROUP_NOT_FOUND{

            String formatError(String fieldName, String operand) {
                return String.format("The group %s for field '%s' does not exist.", operand, fieldName);
            }
        }
        ,
        GROUP_NOT_FOUND_WITH_QUOTES{

            String formatError(String fieldName, String operand) {
                return String.format("The group '%s' for field '%s' does not exist.", operand, fieldName);
            }
        }
        ,
        OPTION_NOT_FOUND{

            String formatError(String fieldName, String operand) {
                return String.format("The option %s for field '%s' does not exist.", operand, fieldName);
            }
        }
        ,
        OPTION_NOT_FOUND_WITH_QUOTES{

            String formatError(String fieldName, String operand) {
                return String.format("The option '%s' for field '%s' does not exist.", operand, fieldName);
            }
        }
        ,
        NAME_NOT_FOUND{

            String formatError(String fieldName, String operand) {
                return String.format("The value %s does not exist for the field '%s'.", operand, fieldName);
            }
        }
        ,
        ID_NOT_FOUND{

            String formatError(String fieldName, String operand) {
                return String.format("A value with ID '%s' does not exist for the field '%s'.", operand, fieldName);
            }
        };


        abstract String formatError(String var1, String var2);
    }

    private static class Result {
        private String[] issueKeys = null;
        private ErrorType errorType = null;

        private Result(String ... issueKeys) {
            this.issueKeys = issueKeys;
        }

        private Result(ErrorType errorType) {
            this.errorType = errorType;
        }
    }
}

