/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;

public class TestCurrentUser
extends AbstractJqlFuncTest {
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestCurrentUser.xml");
    }

    public void testCurrentUserUrlFlag() throws Exception {
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.gotoPage("/secure/IssueNavigator.jspa?reset=true&&reporterSelect=issue_current_user");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("HSP-3", "HSP-2", "HSP-1");
        this.navigation.logout();
        this.navigation.gotoPage("/");
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.gotoPage("/secure/IssueNavigator.jspa?reset=true&&reporterSelect=issue_current_user");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(new String[0]);
        TestCurrentUser.assertEquals((Object)((Object)this.navigation.issueNavigator().getCurrentEditMode()), (Object)((Object)IssueNavigatorNavigation.NavigatorEditMode.ADVANCED));
    }

    public void testXmlViewWithCurrentUser() throws Exception {
        this.navigation.gotoPage("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?reporterSelect=issue_current_user&tempMax=1000");
        this.text.assertTextPresent(this.tester.getDialog().getResponseText(), "HSP-3");
        this.text.assertTextPresent(this.tester.getDialog().getResponseText(), "HSP-2");
        this.text.assertTextPresent(this.tester.getDialog().getResponseText(), "HSP-1");
        this.navigation.gotoPage("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?jqlQuery=reporter+%3D+currentUser()&tempMax=1000");
        this.text.assertTextPresent(this.tester.getDialog().getResponseText(), "HSP-3");
        this.text.assertTextPresent(this.tester.getDialog().getResponseText(), "HSP-2");
        this.text.assertTextPresent(this.tester.getDialog().getResponseText(), "HSP-1");
        this.navigation.logout();
        this.navigation.gotoPage("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?reporterSelect=issue_current_user&tempMax=1000");
        this.text.assertTextNotPresent(this.tester.getDialog().getResponseText(), "<item>");
        TestCurrentUser.assertEquals((int)200, (int)this.tester.getDialog().getResponse().getResponseCode());
        this.navigation.gotoPage("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?jqlQuery=reporter+%3D+currentUser()&tempMax=1000");
        this.text.assertTextNotPresent(this.tester.getDialog().getResponseText(), "<item>");
        TestCurrentUser.assertEquals((int)200, (int)this.tester.getDialog().getResponse().getResponseCode());
    }
}

