/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.navigator.NumberOfIssuesCondition;
import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class TestClausesDependentOnProperties
extends FuncTestCase {
    private static final AtomicBoolean dataSetUp = new AtomicBoolean(false);

    protected void setUpTest() {
        super.setUpTest();
        if (!dataSetUp.getAndSet(true)) {
            this.administration.restoreBlankInstance();
        }
    }

    public void testUserClausesSearchOnFullName() throws Exception {
        this.administration.generalConfiguration().setUserSearchingByFullName(true);
        this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "UserCF");
        this.assertSearchResults("assignee = 'Fred Normal'");
        this.assertSearchResults("assignee = fred");
        this.assertSearchResults("reporter = 'Fred Normal'");
        this.assertSearchResults("reporter = fred");
        this.assertSearchResults("UserCF = 'Fred Normal'");
        this.assertSearchResults("UserCF = fred");
        this.administration.generalConfiguration().setUserSearchingByFullName(false);
        this.assertSearchError("assignee = 'Fred Normal'", "The value 'Fred Normal' does not exist for the field 'assignee'.");
        this.assertSearchResults("assignee = fred");
        this.assertSearchError("reporter = 'Fred Normal'", "The value 'Fred Normal' does not exist for the field 'reporter'.");
        this.assertSearchResults("reporter = fred");
        this.assertSearchError("UserCF = 'Fred Normal'", "The value 'Fred Normal' does not exist for the field 'UserCF'.");
        this.assertSearchResults("UserCF = fred");
    }

    public void testTimeTrackingClausesInvalid() throws Exception {
        this.administration.activateTimeTracking();
        this.assertSearchResults("originalEstimate = 999");
        this.assertSearchResults("timeOriginalEstimate = 999");
        this.assertSearchResults("remainingEstimate = 999");
        this.assertSearchResults("timeEstimate = 999");
        this.assertSearchResults("timeSpent = 999");
        this.assertSearchResults("workRatio = 999");
        this.administration.deactivateTimeTracking();
        this.assertSearchError("originalEstimate = 999", "Field 'originalEstimate' does not exist.");
        this.assertSearchError("timeOriginalEstimate = 999", "Field 'timeOriginalEstimate' does not exist.");
        this.assertSearchError("remainingEstimate = 999", "Field 'remainingEstimate' does not exist.");
        this.assertSearchError("timeEstimate = 999", "Field 'timeEstimate' does not exist.");
        this.assertSearchError("timeSpent = 999", "Field 'timeSpent' does not exist.");
        this.assertSearchError("workRatio = 999", "Field 'workRatio' does not exist.");
    }

    public void testVotingClausesInvalid() throws Exception {
        this.administration.generalConfiguration().enableVoting();
        this.assertSearchResults("votes = 123");
        this.administration.generalConfiguration().disableVoting();
        this.assertSearchError("votes = 123", "Field 'votes' does not exist.");
    }

    public void testSubTaskClausesInvalid() throws Exception {
        this.administration.subtasks().enable();
        this.assertSearchError("parent = 'HSP-1'", "An issue with key 'HSP-1' does not exist for field 'parent'.");
        this.administration.subtasks().disable();
        this.assertSearchError("parent = 'HSP-1'", "Field 'parent' does not exist.");
    }

    private void assertSearchResults(String jqlQuery) {
        ArrayList<SearchResultsCondition> conditions = new ArrayList<SearchResultsCondition>();
        conditions.add(new NumberOfIssuesCondition(this.assertions.getTextAssertions(), 0));
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(conditions);
    }

    private void assertSearchError(String jqlQuery, String errorMsg) {
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getTextAssertions().assertTextPresent(new WebPageLocator(this.tester), errorMsg);
    }
}

