/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashSet;

abstract class AbstractJqlFuncTest
extends FuncTestCase {
    public static final String ORDER_BY_CLAUSE = " ORDER BY key DESC";

    AbstractJqlFuncTest() {
    }

    void assertFitsFilterForm(String jqlQuery, IssueNavigatorAssertions.FilterFormParam ... formParams) {
        this.assertions.getIssueNavigatorAssertions().assertJqlFitsInFilterForm(jqlQuery, formParams);
    }

    void assertTooComplex(String jqlQuery) {
        this.log("Asserting too complex: '" + jqlQuery + "'");
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
    }

    void assertFilterFormValue(IssueNavigatorAssertions.FilterFormParam formParam) {
        this.tester.setWorkingForm("filterform");
        AbstractJqlFuncTest.assertSameElements(formParam.getValues(), this.tester.getDialog().getForm().getParameterValues(formParam.getName()));
    }

    private static void assertSameElements(String[] a, String[] b) {
        HashSet<String> as = a == null || a.length == 0 ? null : new HashSet<String>(Arrays.asList(a));
        HashSet<String> bs = b == null || b.length == 0 ? null : new HashSet<String>(Arrays.asList(b));
        AbstractJqlFuncTest.assertEquals(as, (Object)bs);
    }

    void assertIssues(String ... keys) {
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(keys);
    }

    protected void executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode startEditMode, IssueNavigatorNavigation.NavigatorEditMode expectedEditMode, boolean resetQuery, String ... urlParameter) throws UnsupportedEncodingException {
        if (this.navigation.issueNavigator().getCurrentEditMode() != startEditMode) {
            this.navigation.issueNavigator().displayAllIssues();
            this.navigation.issueNavigator().gotoEditMode(startEditMode);
            AbstractJqlFuncTest.assertEquals((Object)((Object)startEditMode), (Object)((Object)this.navigation.issueNavigator().getCurrentEditMode()));
        }
        String params = this.encodeQueryString(urlParameter);
        params = resetQuery ? params.concat("&reset=true") : params.concat("&addParams=true");
        System.out.println("URL=secure/IssueNavigator.jspa?" + params + "&runQuery=true");
        this.tester.gotoPage("secure/IssueNavigator.jspa?" + params + "&runQuery=true");
        AbstractJqlFuncTest.assertEquals((Object)((Object)expectedEditMode), (Object)((Object)this.navigation.issueNavigator().getCurrentEditMode()));
    }

    protected String encodeQueryString(String ... urlParameter) throws UnsupportedEncodingException {
        StringBuffer params = new StringBuffer();
        for (String parameter : urlParameter) {
            int index = parameter.indexOf("=");
            String parameterName = parameter.substring(0, index);
            String parameterValue = parameter.substring(index + 1);
            params.append("&").append(parameterName).append("=").append(URLEncoder.encode(parameterValue, "UTF8"));
        }
        return params.substring(1);
    }

    void assertSearchWithResults(String jqlString, String ... issueKeys) {
        this.navigation.issueNavigator().createSearch(jqlString + ORDER_BY_CLAUSE);
        this.assertIssues(issueKeys);
    }

    void assertSearchWithError(String jqlString, String error) {
        this.navigation.issueNavigator().createSearch(jqlString);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(error);
    }

    protected static IssueNavigatorAssertions.FilterFormParam createFilterFormParam(String name, String ... values) {
        return new IssueNavigatorAssertions.FilterFormParam(name, values);
    }

    protected void assertJqlQueryInTextArea(String expectedJQL) {
        XPathLocator locator = new XPathLocator(this.tester, "//textarea[@id='jqltext']");
        this.text.assertTextPresent(locator, expectedJQL);
    }
}

