/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.WebLink;
import org.apache.commons.lang.StringUtils;

public class TestReturnToSearch
extends JIRAWebTest {
    private static final String DUMMY_FILE_NAME = "DummyAttachment";
    private static final String DUMMY_FILE_CONTENT = "This is a dummy file with no real purpose in life.";
    private static final String DUMMY_FILE_COMMENT = "Dummy file attatchment.";
    private static final String DELLINK_PREFIX = "del_";

    public TestReturnToSearch(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestReturnToSearch.xml");
    }

    public void testReturnToSearchPresentIfSearchRequestInvalid() {
        TestReturnToSearch.log("Testing 'Return to serach' box is not present on view issue if no results returned by previous search");
        this.clickLink("find_link");
        this.setFormElement("query", "TST-999]");
        this.submit("show");
        this.navigation.issue().viewIssue("TST-1");
        this.assertTextPresent("Return to search");
        this.assertTextNotPresent("Issue <b>1</b> of <b>2</b> issue(s)");
    }

    public void testReturnToSearchNotPresentIfNoSearchResults() {
        TestReturnToSearch.log("Testing 'Return to serach' box is not present on view issue if no results returned by previous search");
        this.clickLink("find_link");
        this.setFormElement("query", "TST-999");
        this.submit("show");
        this.navigation.issue().viewIssue("TST-1");
        this.assertTextPresent("Return to search");
        this.assertTextNotPresent("Issue <b>1</b> of <b>2</b> issue(s)");
    }

    public void testReturnToSearchPresentIfSearchResultsExist() {
        TestReturnToSearch.log("Testing 'Return to serach' box is present on view issue if results returned by previous search exist");
        this.clickLink("find_link");
        this.selectOption("type", "Bug");
        this.submit("show");
        this.navigation.issue().viewIssue("TST-3");
        this.assertTextPresent("Return to search");
        this.assertTextNotPresent("Issue <b>1</b> of <b>2</b> issue(s)");
        this.navigation.issue().viewIssue("TST-2");
        this.assertTextPresent("Return to search");
        this.assertTextPresent("Issue <b>1</b> of <b>2</b> issue(s)");
    }

    public void testManageAttachmentsReturnToSearch() {
        TestReturnToSearch.log("Testing 'Return to Search' box in Manage Attachments");
        this.enableAttachments();
        this.attachFile("TST-2");
        this.clickLink("find_link");
        this.selectOption("type", "Any");
        this.submit("show");
        this.clickLinkWithText("TST-2");
        this.assertLinkPresentWithText("Return to search");
        this.assertTextPresent("Issue <b>2</b> of <b>3</b> issue(s)");
        this.assertLinkPresentWithText("<< Previous");
        this.assertTextPresent("TST-2");
        this.assertLinkPresentWithText("Next >>");
        this.clickLinkWithText("File Attachments");
        this.assertLinkPresentWithText("Return to search");
        this.assertTextPresent("Issue <b>2</b> of <b>3</b> issue(s)");
        this.assertLinkPresentWithText("<< Previous");
        this.assertTextPresent("TST-2");
        this.assertLinkPresentWithText("Next >>");
    }

    public void testManageTrackbacksReturnToSearch() {
        TestReturnToSearch.log("Testing 'Return to Search' box in Manage Trackbacks");
        this.clickLink("find_link");
        this.selectOption("type", "Any");
        this.submit("show");
        this.clickLinkWithText("TST-2");
        this.assertLinkPresentWithText("Return to search");
        this.assertTextPresent("Issue <b>2</b> of <b>3</b> issue(s)");
        this.assertLinkPresentWithText("<< Previous");
        this.assertTextPresent("TST-2");
        this.assertLinkPresentWithText("Next >>");
        this.clickLinkWithText("Manage Trackbacks");
        this.assertLinkPresentWithText("Return to search");
        this.assertTextPresent("Issue <b>2</b> of <b>3</b> issue(s)");
        this.assertLinkPresentWithText("<< Previous");
        this.assertTextPresent("TST-2");
        this.assertLinkPresentWithText("Next >>");
    }

    public void testManageLinksReturnToSearch() {
        TestReturnToSearch.log("Testing 'Return to Search' box in Manage Links");
        this.clickLink("find_link");
        this.selectOption("type", "Any");
        this.submit("show");
        this.clickLinkWithText("TST-2");
        this.assertLinkPresentWithText("Return to search");
        this.assertTextPresent("Issue <b>2</b> of <b>3</b> issue(s)");
        this.assertLinkPresentWithText("<< Previous");
        this.assertTextPresent("TST-2");
        this.assertLinkPresentWithText("Next >>");
        this.clickLinkWithText("Issue Links:");
        this.assertLinkPresentWithText("Return to search");
        this.assertTextPresent("Issue <b>2</b> of <b>3</b> issue(s)");
        this.assertLinkPresentWithText("<< Previous");
        this.assertTextPresent("TST-2");
        this.assertLinkPresentWithText("Next >>");
    }

    public void testReturnToSearchNavigation() {
        this.clickLink("find_link");
        this.selectOption("type", "Any");
        this.submit("show");
        this.clickLinkWithText("TST-2");
        this.assertLinkPresentWithText("Return to search");
        this.assertTextPresent("Issue <b>2</b> of <b>3</b> issue(s)");
        this.assertLinkPresentWithText("<< Previous");
        this.assertTextPresent("TST-2");
        this.assertLinkPresentWithText("Next >>");
        this.clickLinkWithText("<< Previous");
        this.assertLinkPresentWithText("Return to search");
        this.assertTextPresent("Issue <b>1</b> of <b>3</b> issue(s)");
        this.assertLinkNotPresentWithText("<< Previous");
        this.assertTextPresent("&lt;&lt; Previous");
        this.assertTextPresent("TST-3");
        this.assertLinkPresentWithText("Next >>");
        this.clickLinkWithText("Next >>");
        this.clickLinkWithText("Next >>");
        this.assertLinkPresentWithText("Return to search");
        this.assertTextPresent("Issue <b>3</b> of <b>3</b> issue(s)");
        this.assertLinkPresentWithText("<< Previous");
        this.assertTextPresent("TST-1");
        this.assertLinkNotPresentWithText("Next >>");
        this.assertTextPresent("Next &gt;&gt;");
    }

    private String attachFile(String issueKey) {
        this.gotoIssue(issueKey);
        this.assertLinkPresent("attach_file");
        this.clickLink("attach_file");
        this.attachFile(TestReturnToSearch.generateAttachment(DUMMY_FILE_NAME, DUMMY_FILE_CONTENT), DUMMY_FILE_COMMENT);
        try {
            String[] strings;
            WebLink[] webLinks = this.getDialog().getResponse().getMatchingLinks(new HTMLElementPredicate(){

                public boolean matchesCriteria(Object o, Object argument) {
                    WebLink link = (WebLink)o;
                    return link.getID() != null && link.getID().startsWith(TestReturnToSearch.DELLINK_PREFIX);
                }
            }, null);
            if (webLinks == null || webLinks.length == 0) {
                TestReturnToSearch.fail((String)"Unable to find attachment id: No attachment delete links present.");
            }
            if ((strings = webLinks[0].getParameterValues("deleteAttachmentId")) == null || strings.length != 1 || StringUtils.isBlank((String)strings[0])) {
                TestReturnToSearch.fail((String)"Unable to find attachement id: Delete attachement link does not list attachment.");
            }
            return strings[0];
        }
        catch (Exception e) {
            TestReturnToSearch.fail((String)("Unable to retrieve Attachment Id, ex: " + e.getMessage()));
            return "fail";
        }
    }
}

