/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.webtests.JIRAWebTest;
import java.util.ArrayList;
import java.util.Collection;

public class TestNavigatorPages
extends JIRAWebTest {
    private static final String VOTED_ISSUES_TITLE = "Voted Issues";
    private static final String WATCHED_ISSUES_TITLE = "Watched Issues";
    private static final String TEST_FILTER_ID = "10000";
    private Collection issues = new ArrayList();
    private static final int numberOfIssues = 30;
    private static final int maximumIssuesPerPage = 10;
    private static final int halfmaximumIssuesPerPage = 5;
    private static final String NEXT = "Next";
    private static final String PREVIOUS = "Previous";
    private static final String TEST_FILTER = "All issues";

    public TestNavigatorPages(String name) {
        super(name);
    }

    protected void setMaximumIssuesPerPage(int maxIssues) {
        this.clickOnUserProfile();
        this.clickLinkWithText("Edit Preferences");
        this.setFormElement("userIssuesPerPage", Integer.toString(maxIssues));
        this.submit("Update");
        this.assertTextPresent("<b>Number of Issues displayed per Issue Navigator page:</b> " + maxIssues);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestNavigatorPages.xml");
    }

    public void tearDown() {
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testNavigatorPages() {
        this.issues.addAll(this.createIssuesInBulk(30, "homosapien", "HSP", "Bug", "test issue navigator paging", "Minor", null, null, null, "Bob The Builder", "test environment 1", "test description 1 for test issue paging", null, null));
        this.navigatorPagesIssueNavigator();
        this.navigatorPagesYourVotesTable();
        this.navigatorPagesYourWatchesTable();
    }

    public void navigatorPagesIssueNavigator() {
        TestNavigatorPages.log("Checking paging for issue navigator");
        this.setMaximumIssuesPerPage(10);
        this.gotoIssue("");
        this.sortIssues("issuekey", "ASC");
        this.checkIssuesInPages(this.issues, 1, 10);
        this.clickLink("page_2");
        this.checkIssuesInPages(this.issues, 2, 10);
        this.clickLinkWithText(NEXT);
        this.checkIssuesInPages(this.issues, 3, 10);
        this.clickLinkWithText(PREVIOUS);
        this.checkIssuesInPages(this.issues, 2, 10);
        this.saveFilter(TEST_FILTER, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navigatorPagesYourVotesTable() {
        TestNavigatorPages.log("Checking paging for 'Your Votes'");
        try {
            this.logout();
            this.login("bob", "bob_password");
            this.setMaximumIssuesPerPage(5);
            ArrayList votedIssues = new ArrayList();
            votedIssues.addAll(this.voteForIssues(this.issues));
            this.clickOnUserProfile();
            this.clickLinkWithText("Your Votes");
            this.sortIssues("UserVotes!default.jspa", "issuekey", "ASC");
            this.assertLinkPresentWithText("Unvote");
            this.checkIssuesInPages(VOTED_ISSUES_TITLE, votedIssues, 1, 5);
            this.clickLink("page_2");
            this.assertLinkPresentWithText("Unvote");
            this.checkIssuesInPages(VOTED_ISSUES_TITLE, votedIssues, 2, 5);
            this.clickLinkWithText(NEXT);
            this.assertLinkPresentWithText("Unvote");
            this.checkIssuesInPages(VOTED_ISSUES_TITLE, votedIssues, 3, 5);
            this.clickLinkWithText(PREVIOUS);
            this.assertLinkPresentWithText("Unvote");
            this.checkIssuesInPages(VOTED_ISSUES_TITLE, votedIssues, 2, 5);
        }
        finally {
            this.logout();
            this.login("admin", "admin");
        }
    }

    public void navigatorPagesYourWatchesTable() {
        TestNavigatorPages.log("Checking paging for 'Your Watches'");
        this.setMaximumIssuesPerPage(5);
        ArrayList watchedIssues = new ArrayList();
        watchedIssues.addAll(this.watchIssues(this.issues));
        this.clickOnUserProfile();
        this.clickLinkWithText("Your Watches");
        this.sortIssues("UserWatches!default.jspa", "issuekey", "ASC");
        this.assertLinkPresentWithText("Unwatch");
        this.checkIssuesInPages(WATCHED_ISSUES_TITLE, watchedIssues, 1, 5);
        this.clickLink("page_2");
        this.assertLinkPresentWithText("Unwatch");
        this.checkIssuesInPages(WATCHED_ISSUES_TITLE, watchedIssues, 2, 5);
        this.clickLinkWithText(NEXT);
        this.assertLinkPresentWithText("Unwatch");
        this.checkIssuesInPages(WATCHED_ISSUES_TITLE, watchedIssues, 3, 5);
        this.clickLinkWithText(PREVIOUS);
        this.assertLinkPresentWithText("Unwatch");
        this.checkIssuesInPages(WATCHED_ISSUES_TITLE, watchedIssues, 2, 5);
    }

    protected void checkIssuesInPages(Collection issuesInFilter, int currentPage, int maxIssues) {
        this.checkIssuesInPages(null, issuesInFilter, currentPage, maxIssues);
    }

    protected void checkIssuesInPages(String navTitle, Collection issuesInFilter, int currentPage, int maxIssues) {
        int numberOfIssuesInFilter = issuesInFilter.size();
        int startIssues = (currentPage - 1) * maxIssues;
        int endIssues = Math.min(numberOfIssuesInFilter, startIssues + maxIssues);
        if (navTitle == null) {
            this.assertTextPresent("Issue Navigator");
            if (maxIssues < numberOfIssuesInFilter) {
                this.assertIssueNavigatorDisplaying(String.valueOf(startIssues + 1), String.valueOf(endIssues), String.valueOf(numberOfIssuesInFilter));
            }
        } else {
            this.assertTextPresent(navTitle);
        }
        int i = 0;
        for (String issue : issuesInFilter) {
            if (i >= startIssues && i < endIssues) {
                this.assertTextPresent(issue);
            }
            ++i;
        }
    }

    protected Collection watchIssues(Collection allIssues) {
        ArrayList<String> issuesToWatch = new ArrayList<String>();
        int i = 0;
        for (String issue : allIssues) {
            if (i % 2 == 0) {
                this.startWatchingAnIssue(issue);
                issuesToWatch.add(issue);
            }
            ++i;
        }
        return issuesToWatch;
    }

    protected Collection voteForIssues(Collection allIssues) {
        ArrayList<String> issuesToVote = new ArrayList<String>();
        int i = 0;
        for (String issue : allIssues) {
            if (i % 2 == 0) {
                this.voteForIssue(issue);
                issuesToVote.add(issue);
            }
            ++i;
        }
        return issuesToVote;
    }
}

