/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.webtests.AbstractTestIssueNavigatorView;
import com.meterware.httpunit.WebResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;

public class TestIssueNavigatorXmlViewRedirect
extends AbstractTestIssueNavigatorView {
    private static final String XPATH_ITEM_COUNT = "count(/rss/channel/item)";
    private static String URL_3_6_5 = "/secure/IssueNavigator.jspa?view=rss&&type=1&pid=10000&resolution=-1&sorter/field=issuekey&sorter/order=DESC&tempMax=25&reset=true&decorator=none";
    private static String URL_VIEW_PARAM_LAST = "/secure/IssueNavigator.jspa?type=1&pid=10000&resolution=-1&sorter/field=issuekey&sorter/order=DESC&tempMax=25&reset=true&decorator=none&view=rss";
    private static String URL_VIEW_PARAM_MIDDLE = "/secure/IssueNavigator.jspa?reset=true&decorator=none&view=rss&type=1&pid=10000&resolution=-1&sorter/field=issuekey&sorter/order=DESC&tempMax=25";
    private static String URL_RESET_PARAM = "/secure/IssueNavigator.jspa?view=rss&reset=true";
    private static String URL_NO_PARAMS = "/secure/IssueNavigator.jspa?view=rss";
    private static final String URL_3_6_5_DATE_CREATED = "/secure/IssueNavigator.jspa?view=rss&&type=1&pid=10000&resolution=-1&sorter/field=datecreated&sorter/order=DESC&tempMax=25&reset=true&decorator=none";
    private static final String URL_3_6_5_DATE_UPDATED = "/secure/IssueNavigator.jspa?view=rss&&type=1&pid=10000&resolution=-1&sorter/field=lastupdated&sorter/order=DESC&tempMax=25&reset=true&decorator=none";

    public TestIssueNavigatorXmlViewRedirect(String name) {
        super(name);
    }

    public void testRedirectFrom365ForDateCreated() throws Exception {
        this.restoreData("TestIssueNavigatorXmlViewRedirect.xml");
        String oldParam = "sorter/field=datecreated";
        String newParam = "sorter/field=created";
        this.assertRedirection(URL_3_6_5_DATE_CREATED, "sorter/field=datecreated", "sorter/field=created");
        List originalUrls = UrlGenerator.getDateCreatedUrls();
        this.assertRedirection(originalUrls, "sorter/field=datecreated", "sorter/field=created");
    }

    public void testRedirectFrom365ForLastUpdated() throws Exception {
        this.restoreData("TestIssueNavigatorXmlViewRedirect.xml");
        String oldParam = "sorter/field=lastupdated";
        String newParam = "sorter/field=updated";
        this.assertRedirection(URL_3_6_5_DATE_UPDATED, "sorter/field=lastupdated", "sorter/field=updated");
        this.assertRedirection(UrlGenerator.getLastUpdatedUrls(), "sorter/field=lastupdated", "sorter/field=updated");
    }

    private void assertRedirection(List originalUrls, String oldParam, String newParam) {
        for (String originalUrl : originalUrls) {
            this.assertRedirection(originalUrl, oldParam, newParam);
        }
    }

    private void assertRedirection(String originalUrl, String oldParam, String newParam) {
        TestIssueNavigatorXmlViewRedirect.log("Checking for redirection: " + originalUrl);
        this.gotoPage(originalUrl);
        TestIssueNavigatorXmlViewRedirect.assertTrue((String)("Original URL does not contain old parameter '" + oldParam + "': " + originalUrl), (originalUrl.indexOf(oldParam) >= 0 ? 1 : 0) != 0);
        TestIssueNavigatorXmlViewRedirect.assertFalse((String)("Original URL contains new parameter '" + newParam + "': " + originalUrl), (originalUrl.indexOf(newParam) >= 0 ? 1 : 0) != 0);
        String actualUrl = this.getDialog().getResponse().getURL().toString();
        TestIssueNavigatorXmlViewRedirect.assertTrue((String)("Redirected URL does not contain expected parameter '" + newParam + "': " + actualUrl), (actualUrl.indexOf(newParam) >= 0 ? 1 : 0) != 0);
        TestIssueNavigatorXmlViewRedirect.assertFalse((String)("Redirected URL contains old parameter '" + oldParam + "': " + actualUrl), (actualUrl.indexOf(oldParam) >= 0 ? 1 : 0) != 0);
    }

    public void testRedirectFromVersion365() throws Exception {
        ListOrderedMap xpaths = new ListOrderedMap();
        xpaths.put(XPATH_ITEM_COUNT, "2");
        xpaths.put("/rss/channel/item[1]/key", "PX-3");
        xpaths.put("/rss/channel/item[2]/key", "PX-2");
        this.testRedirect(URL_3_6_5, (Map)xpaths);
    }

    public void testRedirectViewParamMiddle() throws Exception {
        ListOrderedMap xpaths = new ListOrderedMap();
        xpaths.put(XPATH_ITEM_COUNT, "2");
        xpaths.put("/rss/channel/item[1]/key", "PX-3");
        xpaths.put("/rss/channel/item[2]/key", "PX-2");
        this.testRedirect(URL_VIEW_PARAM_MIDDLE, (Map)xpaths);
    }

    public void testRedirectViewParamLast() throws Exception {
        ListOrderedMap xpaths = new ListOrderedMap();
        xpaths.put(XPATH_ITEM_COUNT, "2");
        xpaths.put("/rss/channel/item[1]/key", "PX-3");
        xpaths.put("/rss/channel/item[2]/key", "PX-2");
        this.testRedirect(URL_VIEW_PARAM_LAST, (Map)xpaths);
    }

    public void testRedirectResetParams() throws Exception {
        this._testRedirectAllIssues(URL_RESET_PARAM);
    }

    public void testRedirectNoParams() throws Exception {
        this._testRedirectAllIssues(URL_NO_PARAMS);
    }

    private void _testRedirectAllIssues(String url) throws Exception {
        ListOrderedMap xpaths = new ListOrderedMap();
        xpaths.put(XPATH_ITEM_COUNT, "6");
        xpaths.put("/rss/channel/item[1]/key", "PX-6");
        xpaths.put("/rss/channel/item[2]/key", "PX-5");
        xpaths.put("/rss/channel/item[3]/key", "PX-4");
        xpaths.put("/rss/channel/item[4]/key", "PX-3");
        xpaths.put("/rss/channel/item[5]/key", "PX-2");
        xpaths.put("/rss/channel/item[6]/key", "PX-1");
        this.testRedirect(url, (Map)xpaths);
    }

    private void testRedirect(String url, Map xpaths) throws Exception {
        this.restoreData("TestIssueNavigatorXmlViewRedirect.xml");
        this.gotoPage(url);
        WebResponse response = this.getDialog().getResponse();
        TestIssueNavigatorXmlViewRedirect.assertFalse((boolean)url.equals(response.getURL().toString()));
        String responseText = response.getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        for (Map.Entry e : xpaths.entrySet()) {
            String xpath = (String)e.getKey();
            String expectedValue = (String)e.getValue();
            XMLAssert.assertXpathEvaluatesTo((String)expectedValue, (String)xpath, (Document)doc);
        }
    }

    private static final class UrlGenerator {
        private static final Map VIEWS = new HashMap();

        private UrlGenerator() {
        }

        public static List getDateCreatedUrls() {
            return UrlGenerator.getUrls("datecreated");
        }

        public static List getLastUpdatedUrls() {
            return UrlGenerator.getUrls("lastupdated");
        }

        private static List getUrls(String sorterField) {
            ArrayList<String> urls = new ArrayList<String>(VIEWS.size());
            for (Map.Entry entry : VIEWS.entrySet()) {
                Object view = entry.getKey();
                Object fileExt = entry.getValue();
                StringBuffer sb = new StringBuffer();
                sb.append("/sr/jira.issueviews:").append(view).append("/temp/SearchRequest.").append(fileExt);
                sb.append("?sorter/field=").append(sorterField);
                sb.append("&amp;sorter/order=DESC&amp;tempMax=10");
                urls.add(sb.toString());
            }
            return urls;
        }

        static {
            VIEWS.put("searchrequest-printable", "html");
            VIEWS.put("searchrequest-fullcontent", "html");
            VIEWS.put("searchrequest-xml", "xml");
            VIEWS.put("searchrequest-rss", "xml");
            VIEWS.put("searchrequest-comments-rss", "xml");
            VIEWS.put("searchrequest-word", "doc");
            VIEWS.put("searchrequest-excel-all-fields", "xls");
            VIEWS.put("searchrequest-excel-current-fields", "xls");
        }
    }
}

