/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.w3c.dom.Attr;

public class TestIssueNavigatorSearchFilter
extends FuncTestCase {
    private static String EDIT_OPERATION = "filtereditshares";
    private static String EDIT_INVALID_OPERATION = "editinvalid";
    private static String SAVE_OPERATION = "filtersave";
    private static String SAVE_AS_OPERATION = "filtersaveas";
    private static String SAVE_NEW_OPERATION = "filtersavenew";
    private static String RELOAD_OPERATION = "reload";
    private static String VIEW_SUBSCRIPTION_OPERATION = "filterviewsubscriptions";
    private static String CREATE_NEW_OPERATION = "copyasnewfilter";
    private static String VIEW_TAB = "viewfilter";
    private static String EDIT_TAB = "editfilter";
    private static String NEW_TAB = "new_filter";
    private static String MANAGE_TAB = "managefilters";
    private static String SEARCH_REQUESTVIEWS = "viewOptions";
    private static String TOOLS_OPTIONS = "toolOptions";
    private static String PERMLINK = "permlink";

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueNavigatorSearchFilter.xml");
    }

    public void testIssueNavigatorViewFilterModifiedAndValid() throws Exception {
        this.tester.gotoPage("secure/IssueNavigator.jspa?mode=hide&requestId=10000");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.setWorkingForm("jqlform");
        String jqlQuery = "project = homosapien and status = \"open\"";
        this.tester.setFormElement("jqlQuery", "project = homosapien and status = \"open\"");
        this.tester.submit();
        this.tester.assertTextPresent("Filter modified since loading");
        this.navigation.issueNavigator().gotoViewMode();
        this.assertIDsPresent(EDIT_OPERATION, SAVE_OPERATION, SAVE_AS_OPERATION, RELOAD_OPERATION, VIEW_SUBSCRIPTION_OPERATION);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6");
        this.assertIDsPresent(SEARCH_REQUESTVIEWS, TOOLS_OPTIONS, PERMLINK);
        this._assertPermlink("project = homosapien and status = \"open\"");
        this.assertIDsPresent(EDIT_OPERATION, SAVE_OPERATION, SAVE_AS_OPERATION, RELOAD_OPERATION, VIEW_SUBSCRIPTION_OPERATION);
        this.assertIDsPresent(EDIT_TAB, NEW_TAB, MANAGE_TAB);
    }

    public void testIssueNavigatorViewFilterModifiedAndInvalid() throws Exception {
        this.tester.gotoPage("secure/IssueNavigator.jspa?mode=hide&requestId=10000");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.setWorkingForm("jqlform");
        this.tester.setFormElement("jqlQuery", "project = homosapien and status = \"blub\"");
        this.tester.submit();
        this.tester.assertTextPresent("The value 'blub' does not exist for the field 'status'.");
        this.assertIDsNotPresent(SEARCH_REQUESTVIEWS, TOOLS_OPTIONS, PERMLINK);
        this.tester.clickLink(VIEW_TAB);
        this.assertIDsPresent(VIEW_TAB, NEW_TAB, MANAGE_TAB);
        this.tester.clickLink(MANAGE_TAB);
        this.assertIDsPresent(VIEW_TAB, EDIT_TAB, NEW_TAB);
        this.assertIDsPresent(EDIT_INVALID_OPERATION, RELOAD_OPERATION);
    }

    public void testIssueNavigatorViewFilterNotModifiedAndValid() throws Exception {
        this.tester.gotoPage("secure/IssueNavigator.jspa?mode=hide&requestId=10000");
        this.navigation.issueNavigator().gotoViewMode();
        this.assertIDsPresent(EDIT_OPERATION, SAVE_AS_OPERATION, VIEW_SUBSCRIPTION_OPERATION);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.assertIDsPresent(SEARCH_REQUESTVIEWS, TOOLS_OPTIONS, PERMLINK);
        this._assertPermlink("project = homosapien");
        this.tester.clickLink(MANAGE_TAB);
        this.assertIDsPresent(EDIT_OPERATION, SAVE_AS_OPERATION, VIEW_SUBSCRIPTION_OPERATION);
    }

    public void testIssueNavigatorViewFilterNotModifiedInvalid() throws Exception {
        this.administration.permissionSchemes().getPermissionScheme("Copy of Default Permission Scheme").removePermission(10, "jira-administrators");
        this.tester.gotoPage("secure/IssueNavigator.jspa?mode=hide&requestId=10000");
        this.assertIDsPresent(EDIT_TAB, NEW_TAB, MANAGE_TAB);
        this.assertIDsPresent(EDIT_INVALID_OPERATION, VIEW_SUBSCRIPTION_OPERATION);
        this.tester.clickLink(MANAGE_TAB);
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='filterForm']"), "Edit", "the current filter to correct errors");
        this.assertIDsPresent(EDIT_OPERATION);
        this.assertIDsNotPresent(SEARCH_REQUESTVIEWS, TOOLS_OPTIONS, PERMLINK);
        this.administration.permissionSchemes().getPermissionScheme("Copy of Default Permission Scheme").grantPermissionToGroup(10, "jira-administrators");
    }

    public void testIssueNavigatorViewFilterNotOwnerModifiedAndValid() throws Exception {
        this.navigation.login("fred");
        this.tester.gotoPage("secure/IssueNavigator.jspa?mode=hide&requestId=10001");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("MKY-10", "MKY-9", "MKY-8", "MKY-7", "MKY-6", "MKY-5", "MKY-4", "MKY-3", "MKY-2", "MKY-1");
        this.assertIDsPresent(SEARCH_REQUESTVIEWS, TOOLS_OPTIONS, PERMLINK);
        this._assertPermlink("project = monkey");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertIDsPresent(VIEW_TAB, NEW_TAB, MANAGE_TAB);
        this.tester.setWorkingForm("jqlform");
        String jqlQuery = "project = monkey and status = \"open\"";
        this.tester.setFormElement("jqlQuery", "project = monkey and status = \"open\"");
        this.tester.submit();
        this.tester.assertTextPresent("Filter modified since loading");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("MKY-10", "MKY-9", "MKY-8", "MKY-7", "MKY-6");
        this.assertIDsPresent(SEARCH_REQUESTVIEWS, TOOLS_OPTIONS, PERMLINK);
        this._assertPermlink("project = monkey and status = \"open\"");
        this.assertIDsPresent(CREATE_NEW_OPERATION);
        this.tester.clickLink(VIEW_TAB);
        this.assertIDsPresent(EDIT_TAB, NEW_TAB, MANAGE_TAB);
        this.assertIDsPresent(CREATE_NEW_OPERATION, RELOAD_OPERATION);
        this.tester.clickLink(MANAGE_TAB);
        this.assertIDsPresent(CREATE_NEW_OPERATION, RELOAD_OPERATION);
    }

    public void testIssueNavigatorViewFilterNotOwnerModifiedAndInvalid() throws Exception {
        this.navigation.login("fred");
        this.tester.gotoPage("secure/IssueNavigator.jspa?mode=hide&requestId=10001");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertIDsPresent(VIEW_TAB, NEW_TAB, MANAGE_TAB);
        this.tester.setWorkingForm("jqlform");
        this.tester.setFormElement("jqlQuery", "project = monkey and status = \"blub\"");
        this.tester.submit();
        this.tester.assertTextPresent("Filter modified since loading");
        this.assertIDsNotPresent(SEARCH_REQUESTVIEWS, TOOLS_OPTIONS, PERMLINK);
        this.tester.clickLink(MANAGE_TAB);
        this.assertIDsPresent(EDIT_INVALID_OPERATION, RELOAD_OPERATION);
    }

    public void testIssueNavigatorViewFilterNotOwnerNotModifiedAndValid() throws Exception {
        this.navigation.login("fred");
        this.tester.gotoPage("secure/IssueNavigator.jspa?mode=hide&requestId=10001");
        this.assertIDsPresent(EDIT_TAB, NEW_TAB, MANAGE_TAB);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("MKY-10", "MKY-9", "MKY-8", "MKY-7", "MKY-6", "MKY-5", "MKY-4", "MKY-3", "MKY-2", "MKY-1");
        this.assertIDsPresent(CREATE_NEW_OPERATION);
        this.assertIDsPresent(SEARCH_REQUESTVIEWS, TOOLS_OPTIONS, PERMLINK);
        this._assertPermlink("project = monkey");
        this.tester.clickLink(EDIT_TAB);
        this.assertIDsPresent(VIEW_TAB, NEW_TAB, MANAGE_TAB);
        this.tester.clickLink(MANAGE_TAB);
        this.assertIDsPresent(VIEW_TAB, EDIT_TAB, NEW_TAB);
    }

    public void testIssueNavigatorViewFilterNotOwnerNotModifiedAndInvalid() throws Exception {
        this.navigation.login("fred");
        this.tester.gotoPage("secure/IssueNavigator.jspa?mode=hide&requestId=10000");
        this.assertIDsPresent(EDIT_TAB, NEW_TAB, MANAGE_TAB);
        this.assertIDsPresent(EDIT_INVALID_OPERATION);
        this.assertIDsNotPresent(SEARCH_REQUESTVIEWS, TOOLS_OPTIONS);
        this.tester.clickLink(EDIT_TAB);
        this.assertIDsPresent(VIEW_TAB, NEW_TAB, MANAGE_TAB);
        this.tester.assertTextPresent("A value with ID '10000' does not exist for the field 'project'.");
        this.tester.clickLink(MANAGE_TAB);
        this.assertIDsPresent(EDIT_TAB, VIEW_TAB, NEW_TAB);
        this.assertIDsPresent(EDIT_INVALID_OPERATION);
    }

    public void testIssueNavigatorViewFilterNotLoadedModifiedAndValid() throws Exception {
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.setWorkingForm("jqlform");
        String jqlQuery = "project = monkey";
        this.tester.setFormElement("jqlQuery", "project = monkey");
        this.tester.submit();
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("MKY-10", "MKY-9", "MKY-8", "MKY-7", "MKY-6", "MKY-5", "MKY-4", "MKY-3", "MKY-2", "MKY-1");
        this.assertIDsPresent(VIEW_TAB, NEW_TAB, MANAGE_TAB);
        this.assertIDsPresent(SAVE_NEW_OPERATION);
        this.assertIDsPresent(SEARCH_REQUESTVIEWS, TOOLS_OPTIONS, PERMLINK);
        this._assertPermlink("project = monkey");
        this.tester.clickLink(VIEW_TAB);
        this.assertIDsPresent(NEW_TAB, EDIT_TAB, MANAGE_TAB);
        this.assertIDsPresent(SAVE_NEW_OPERATION);
        this.tester.clickLink(MANAGE_TAB);
        this.assertIDsPresent(VIEW_TAB, NEW_TAB, EDIT_TAB);
        this.assertIDsPresent(SAVE_NEW_OPERATION);
    }

    public void testIssueNavigatorViewFilterNotLoadedModifiedAndInvalid() throws Exception {
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.setWorkingForm("jqlform");
        this.tester.setFormElement("jqlQuery", "project = monkey and status =\"blah\"");
        this.tester.submit();
        this.assertIDsPresent(VIEW_TAB, NEW_TAB, MANAGE_TAB);
        this.tester.clickLink(VIEW_TAB);
        this.assertIDsPresent(VIEW_TAB, NEW_TAB, MANAGE_TAB);
        this.tester.clickLink(MANAGE_TAB);
        this.assertIDsPresent(VIEW_TAB, NEW_TAB, EDIT_TAB);
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='filterForm']"), "Edit", "the current filter to correct errors");
        this.assertIDsPresent(EDIT_INVALID_OPERATION);
    }

    public void testIssueNavigatorNotLoggedIn() throws Exception {
        this.navigation.login("admin");
        this.administration.permissionSchemes().getPermissionScheme("Copy of Default Permission Scheme").grantPermissionToGroup(10, "");
        this.navigation.logout();
        this.tester.clickLinkWithText("Log in again.");
        this.navigation.issueNavigator().gotoViewMode();
        this.navigation.issueNavigator().createSearch("");
        this.assertIDsNotPresent(TOOLS_OPTIONS);
        this.assertIDsPresent(SEARCH_REQUESTVIEWS, PERMLINK);
    }

    private void assertIDsPresent(String ... operations) {
        for (String operation : operations) {
            this.tester.assertLinkPresent(operation);
        }
    }

    private void _assertPermlink(String jqlQuery) throws UnsupportedEncodingException {
        XPathLocator locator = new XPathLocator(this.tester, "//a[@id = 'permlink']");
        Attr hrefAttribute = (Attr)locator.getNode().getAttributes().getNamedItem("href");
        String link = hrefAttribute.getNodeValue();
        int startIndex = link.indexOf("jqlQuery") + 9;
        TestIssueNavigatorSearchFilter.assertEquals((String)URLEncoder.encode(jqlQuery, "UTF8"), (String)link.substring(startIndex));
    }

    private void assertIDsNotPresent(String ... operations) {
        for (String operation : operations) {
            this.tester.assertLinkNotPresent(operation);
        }
    }
}

