/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.webtests.AbstractTestIssueNavigatorColumnsView;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorView;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestIssueNavigatorPrintableView
extends AbstractTestIssueNavigatorColumnsView {
    public TestIssueNavigatorPrintableView(String name) {
        super(name);
    }

    public void testTimeTrackingPrintableView() throws SAXException {
        this.activateSubTasks();
        this.displayAllIssues();
        this.clickLinkWithText("Configure");
        this.selectOption("fieldId", "\u03a3 Original Estimate");
        this.submit("add");
        this.selectOption("fieldId", "\u03a3 Remaining Estimate");
        this.submit("add");
        this.selectOption("fieldId", "\u03a3 Time Spent");
        this.submit("add");
        this.selectOption("fieldId", "\u03a3 Progress");
        this.submit("add");
        this.clickLinkWithText("Issue Navigator");
        this.clickLink("printable");
        WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
        this.tableCellHasText(issueTable, 0, 44, "\u03a3 Original Estimate");
        this.tableCellHasText(issueTable, 0, 45, "\u03a3 Remaining Estimate");
        this.tableCellHasText(issueTable, 0, 46, "\u03a3 Time Spent");
        this.tableCellHasText(issueTable, 0, 47, "\u03a3 Progress");
        this.tableCellHasText(issueTable, 2, 45, "30 minutes");
        this.tableCellHasText(issueTable, 2, 46, "3 hours, 20 minutes");
        this.tableCellHasText(issueTable, 2, 47, "86%");
        this.tableCellHasText(issueTable, 3, 44, "1 day");
        this.tableCellHasText(issueTable, 3, 45, "1 day");
        this.tableCellHasText(issueTable, 3, 47, "0%");
    }

    public void testAllColumnsPrintableView() {
        TestIssueNavigatorPrintableView.log("Issue Navigator: Test that the printable view shows all required items");
        this.displayAllIssues();
        this.clickLink("printable");
        try {
            WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
            for (AbstractTestIssueNavigatorView.Item item : this.items) {
                new AbstractTestIssueNavigatorColumnsView.ItemVerifier(this, item, issueTable, this.getEnvironmentData().getBaseUrl()).verify();
            }
        }
        catch (Exception e) {
            TestIssueNavigatorPrintableView.log("Failed to parse the printable view", e);
            TestIssueNavigatorPrintableView.fail();
        }
    }

    public void testPrintableViewXSSBug() {
        this.displayAllIssues();
        this.clickLinkWithText("Save");
        this.setFormElement("filterName", "<script>alert('evil');</script>");
        this.submit("Save");
        this.assertTextPresent("&lt;script&gt;alert('evil');&lt;/script&gt;");
        this.assertTextPresent("Issue Navigator");
        this.clickLink("printable");
        this.assertTextPresent("&lt;script&gt;alert('evil');&lt;/script&gt; (Your Company JIRA)");
    }

    public void testAllColumnsPrintableViewDaysFormat() {
        this.reconfigureTimetracking("days");
        this.testAllColumnsPrintableView();
    }

    public void testAllColumnsPrintableViewHoursFormat() {
        this.reconfigureTimetracking("hours");
        this.testAllColumnsPrintableView();
    }

    public void testSearchRequestHeaderSummary() {
        TestIssueNavigatorPrintableView.log("Issue Navigator: Test that the printable view shows all required items");
        this.gotoPage("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?sorter/field=issuekey&sorter/order=DESC&tempMax=2");
        this.assertTextPresent("Displaying issues <b>1</b> to <b>2</b> of <b>3</b> matching issues");
        this.gotoPage("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?sorter/field=issuekey&sorter/order=DESC");
        this.assertTextPresent("Displaying issues <b>1</b> to <b>3</b> of <b>3</b> matching issues");
    }
}

