/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.webtests.AbstractTestIssueNavigatorColumnsView;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorView;
import com.meterware.httpunit.WebResponseUtil;
import com.meterware.httpunit.WebTable;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.xml.sax.SAXException;

public class TestIssueNavigatorExcelView
extends AbstractTestIssueNavigatorColumnsView {
    public TestIssueNavigatorExcelView(String name) {
        super(name);
    }

    public void testAllExcelViewHaveCorrectLinkToTheFilter() {
        this._testExcelViewHaveCorrectLinkToTheFilter("currentExcelFields");
    }

    public void testCurrentExcelViewHaveCorrectLinkToTheFilter() {
        this._testExcelViewHaveCorrectLinkToTheFilter("currentExcelFields");
    }

    public void _testExcelViewHaveCorrectLinkToTheFilter(String excelView) {
        TestIssueNavigatorExcelView.log("Issue Navigator: Test that the " + excelView + " views show correct link to the search filter");
        this.clickLink("find_link");
        this.selectOption("type", "New Feature");
        this.submit("show");
        this.assertIssueNavigatorDisplaying("1", "1", "1");
        this.assertLinkPresentWithText("Feature 00");
        String filterName = "rssview";
        String filterId = this.saveFilter(filterName, "");
        this.gotoFilter(filterName);
        this.assertIssueNavigatorDisplaying("1", "1", "1");
        this.assertLinkPresentWithText("Feature 00");
        this.clickLink("allExcelFields");
        try {
            if (!WebResponseUtil.replaceResponseContentType(this.getDialog().getResponse(), "text/html")) {
                TestIssueNavigatorExcelView.log("Failed to replace response content type with 'text/html'");
                TestIssueNavigatorExcelView.fail();
            } else {
                String expectedFilterUrl = this.getEnvironmentData().getBaseUrl().toString() + "/secure/IssueNavigator.jspa?requestId=" + filterId;
                String expectedLink = expectedFilterUrl + "\">" + filterName;
                this.assertTextPresent(expectedLink);
                this.gotoPage(expectedFilterUrl);
                this.assertIssueNavigatorDisplaying("1", "1", "1");
                this.assertLinkPresentWithText("Feature 00");
            }
        }
        catch (Exception e) {
            TestIssueNavigatorExcelView.log("Failed to parse the printable view", e);
            TestIssueNavigatorExcelView.fail();
        }
    }

    public void testAllColumnsExcelView() {
        TestIssueNavigatorExcelView.log("Issue Navigator: Test that the excel (All fields) view shows all required items");
        this.displayAllIssues();
        this.clickLink("allExcelFields");
        try {
            if (!WebResponseUtil.replaceResponseContentType(this.getDialog().getResponse(), "text/html")) {
                TestIssueNavigatorExcelView.log("Failed to replace response content type with 'text/html'");
                TestIssueNavigatorExcelView.fail();
            } else {
                WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
                for (AbstractTestIssueNavigatorView.Item item : this.items) {
                    new ExcelItemVerifier((AbstractTestIssueNavigatorColumnsView)this, item, issueTable, this.getEnvironmentData().getBaseUrl()).verify();
                }
            }
        }
        catch (Exception e) {
            TestIssueNavigatorExcelView.log("Failed to parse the printable view", e);
            TestIssueNavigatorExcelView.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExcelFilenameWithNonAsciiCharacters() {
        String encodedFilename = "%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F+%28jWebTest+JIRA+installation%29.xls";
        String oldUserAgent = this.getDialog().getWebClient().getClientProperties().getUserAgent();
        try {
            TestIssueNavigatorExcelView.log("Issue Navigator: Test that the excel view generates the correct filename when the search request has non-ASCII characters");
            this.restoreData("TestSearchRequestViewNonAsciiSearchName.xml");
            this.getDialog().getWebClient().getClientProperties().setUserAgent("Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)");
            this.gotoPage("/sr/jira.issueviews:searchrequest-excel-all-fields/10000/SearchRequest-10000.xls?tempMax=1000");
            String contentDisposition = this.getDialog().getResponse().getHeaderField("content-disposition");
            TestIssueNavigatorExcelView.assertFalse((contentDisposition.indexOf("filename*=UTF-8''%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F+%28jWebTest+JIRA+installation%29.xls") >= 0 ? 1 : 0) != 0);
            TestIssueNavigatorExcelView.assertTrue((contentDisposition.indexOf("filename=\"%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F+%28jWebTest+JIRA+installation%29.xls\"") >= 0 ? 1 : 0) != 0);
            this.gotoPage("/sr/jira.issueviews:searchrequest-excel-current-fields/10000/SearchRequest-10000.xls?tempMax=1000");
            contentDisposition = this.getDialog().getResponse().getHeaderField("content-disposition");
            TestIssueNavigatorExcelView.assertFalse((contentDisposition.indexOf("filename*=UTF-8''%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F+%28jWebTest+JIRA+installation%29.xls") >= 0 ? 1 : 0) != 0);
            TestIssueNavigatorExcelView.assertTrue((contentDisposition.indexOf("filename=\"%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F+%28jWebTest+JIRA+installation%29.xls\"") >= 0 ? 1 : 0) != 0);
            this.getDialog().getWebClient().getClientProperties().setUserAgent("Mozilla/5.001 (windows; U; NT4.0; en-US; rv:1.0) Gecko/25250101");
            this.gotoPage("/sr/jira.issueviews:searchrequest-excel-all-fields/10000/SearchRequest-10000.xls?tempMax=1000");
            contentDisposition = this.getDialog().getResponse().getHeaderField("content-disposition");
            TestIssueNavigatorExcelView.assertTrue((contentDisposition.indexOf("filename*=UTF-8''%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F+%28jWebTest+JIRA+installation%29.xls") >= 0 ? 1 : 0) != 0);
            TestIssueNavigatorExcelView.assertFalse((contentDisposition.indexOf("filename=\"%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F+%28jWebTest+JIRA+installation%29.xls\"") >= 0 ? 1 : 0) != 0);
            this.gotoPage("/sr/jira.issueviews:searchrequest-excel-current-fields/10000/SearchRequest-10000.xls?tempMax=1000");
            contentDisposition = this.getDialog().getResponse().getHeaderField("content-disposition");
            TestIssueNavigatorExcelView.assertTrue((contentDisposition.indexOf("filename*=UTF-8''%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F+%28jWebTest+JIRA+installation%29.xls") >= 0 ? 1 : 0) != 0);
            TestIssueNavigatorExcelView.assertFalse((contentDisposition.indexOf("filename=\"%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F+%28jWebTest+JIRA+installation%29.xls\"") >= 0 ? 1 : 0) != 0);
        }
        finally {
            this.getDialog().getWebClient().getClientProperties().setUserAgent(oldUserAgent);
        }
    }

    public void testExcelViewCanBeCached() {
        TestIssueNavigatorExcelView.log("Issue Navigator: Test that the excel view does not contain the Cache-control: no-cache header");
        this.displayAllIssues();
        this.clickLink("allExcelFields");
        if (!WebResponseUtil.replaceResponseContentType(this.getDialog().getResponse(), "text/html")) {
            TestIssueNavigatorExcelView.log("Failed to replace response content type with 'text/html'");
            TestIssueNavigatorExcelView.fail();
        } else {
            this.assertResponseCanBeCached();
        }
    }

    public void testTempMax() throws SAXException, IOException {
        this.gotoPage("/sr/jira.issueviews:searchrequest-excel-current-fields/temp/SearchRequest.xls?pid=10000&sorter/field=issuekey&sorter/order=DESC&tempMax=1&noResponseHeaders=true");
        WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
        this.assertTextSequence(new String[]{"Displaying", "1", "issues at"});
        TestIssueNavigatorExcelView.assertEquals((int)2, (int)issueTable.getRowCount());
    }

    public void testTempMaxDefault() throws SAXException, IOException {
        this.restoreData("TestIssueNavigatorViews.xml");
        this.clickOnUserProfile();
        this.clickLinkWithText("Edit Preferences");
        this.setFormElement("userIssuesPerPage", "3");
        this.submit("Update");
        this.clickLink("find_link");
        this.selectOption("pid", "All projects");
        this.submit("show");
        this.assertTextPresent("jira.issueviews:searchrequest-printable/temp/SearchRequest.html?jqlQuery=&amp;tempMax=1000");
        this.assertTextPresent("jira.issueviews:searchrequest-fullcontent/temp/SearchRequest.html?jqlQuery=&amp;tempMax=1000");
        this.assertTextPresent("jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?jqlQuery=&amp;tempMax=1000");
        this.assertTextPresent("jira.issueviews:searchrequest-rss/temp/SearchRequest.xml?jqlQuery=&amp;tempMax=1000");
        this.assertTextPresent("jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?jqlQuery=&amp;tempMax=1000");
        this.assertTextPresent("jira.issueviews:searchrequest-excel-all-fields/temp/SearchRequest.xls?jqlQuery=&amp;tempMax=1000");
        this.assertTextPresent("jira.issueviews:searchrequest-excel-current-fields/temp/SearchRequest.xls?jqlQuery=&amp;tempMax=1000");
        this.clickLink("allExcelFields");
        TestIssueNavigatorExcelView.assertEquals((String)"application/vnd.ms-excel", (String)this.getDialog().getResponse().getContentType());
        String text = this.getDialog().getResponse().getText();
        this.assertIssuePresentInExport("MKY-6", text);
        this.assertIssuePresentInExport("MKY-5", text);
        this.assertIssuePresentInExport("MKY-4", text);
        this.assertIssuePresentInExport("MKY-3", text);
        this.assertIssuePresentInExport("MKY-2", text);
        this.assertIssuePresentInExport("MKY-1", text);
    }

    private void assertIssuePresentInExport(String issueKey, String responseText) {
        TestIssueNavigatorExcelView.assertTrue((responseText.indexOf(issueKey) > -1 ? 1 : 0) != 0);
    }

    public void testPagerStartParam() throws SAXException {
        this.gotoPage("/sr/jira.issueviews:searchrequest-excel-current-fields/temp/SearchRequest.xls?pid=10000&sorter/field=issuekey&sorter/order=DESC&noResponseHeaders=true");
        WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
        TestIssueNavigatorExcelView.assertEquals((int)4, (int)issueTable.getRowCount());
        this.gotoPage("/sr/jira.issueviews:searchrequest-excel-current-fields/temp/SearchRequest.xls?pid=10000&sorter/field=issuekey&sorter/order=DESC&noResponseHeaders=true&pager/start=2");
        issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
        TestIssueNavigatorExcelView.assertEquals((int)2, (int)issueTable.getRowCount());
    }

    public void testGroupCustomFieldEscaped() throws Exception {
        this.restoreData("TestXssCustomFields.xml");
        this.gotoPage("/sr/jira.issueviews:searchrequest-excel-all-fields/10000/SearchRequest-10000.xls?tempMax=1000");
        TestIssueNavigatorExcelView.assertEquals((String)"application/vnd.ms-excel", (String)this.getDialog().getResponse().getContentType());
        String text = this.getDialog().getResponse().getText();
        TestIssueNavigatorExcelView.assertTrue((text.indexOf("&lt;xxx&gt;delta&lt;/xxx&gt;") >= 0 ? 1 : 0) != 0);
        TestIssueNavigatorExcelView.assertFalse((text.indexOf("<xxx>delta</xxx>") >= 0 ? 1 : 0) != 0);
    }

    protected void initFieldColumnMap() {
        this.issueFieldColumnMap.add("issueProject");
        this.issueFieldColumnMap.add("issueKey");
        this.issueFieldColumnMap.add("issueSummary");
        this.issueFieldColumnMap.add("issueType");
        this.issueFieldColumnMap.add("issueStatus");
        this.issueFieldColumnMap.add("issuePriority");
        this.issueFieldColumnMap.add("issueResolution");
        this.issueFieldColumnMap.add("issueAssignee");
        this.issueFieldColumnMap.add("issueReporter");
        this.issueFieldColumnMap.add("issueCreated");
        this.issueFieldColumnMap.add("issueUpdated");
        this.issueFieldColumnMap.add("issueResolved");
        this.issueFieldColumnMap.add("issueAffectsVersions");
        this.issueFieldColumnMap.add("issueFixVersions");
        this.issueFieldColumnMap.add("issueComponents");
        this.issueFieldColumnMap.add("issueDue");
        this.issueFieldColumnMap.add("issueVotes");
        this.issueFieldColumnMap.add("issueImages");
        this.issueFieldColumnMap.add("issueOriginalEstimate");
        this.issueFieldColumnMap.add("issueRemainingEstimate");
        this.issueFieldColumnMap.add("issueTimeSpent");
        this.issueFieldColumnMap.add("issueWorkRatio");
        this.issueFieldColumnMap.add("issueLinks");
        this.issueFieldColumnMap.add("issueEnvironment");
        this.issueFieldColumnMap.add("issueDescription");
        this.issueFieldColumnMap.add("issueSecurityLevel");
        this.issueFieldColumnMap.add("issueTimeTrackingProgress");
        this.issueFieldColumnMap.add("issueCascadingSelectField");
        this.issueFieldColumnMap.add("issueDatePickerField");
        this.issueFieldColumnMap.add("issueDateTimeField");
        this.issueFieldColumnMap.add("issueFreeTextField");
        this.issueFieldColumnMap.add("issueGroupPickerField");
        this.issueFieldColumnMap.add("issueImportIdField");
        this.issueFieldColumnMap.add("issueMultiCheckboxesField");
        this.issueFieldColumnMap.add("issueMultiGroupPickerField");
        this.issueFieldColumnMap.add("issueMultiSelectField");
        this.issueFieldColumnMap.add("issueMultiUserPickerField");
        this.issueFieldColumnMap.add("issueNumberField");
        this.issueFieldColumnMap.add("issueProjectPickerField");
        this.issueFieldColumnMap.add("issueROTextField");
        this.issueFieldColumnMap.add("issueRadioButtonsField");
        this.issueFieldColumnMap.add("issueSelectList");
        this.issueFieldColumnMap.add("issueSingleVersionPickerField");
        this.issueFieldColumnMap.add("issueTextField255");
        this.issueFieldColumnMap.add("issueURLField");
        this.issueFieldColumnMap.add("issueUserPickerField");
        this.issueFieldColumnMap.add("issueVersionPickerField");
    }

    protected AbstractTestIssueNavigatorView.Item createItem2() {
        AbstractTestIssueNavigatorView.Item item = super.createItem2();
        item.setAttribute("timeestimate", "1800");
        item.setAttribute("timespent", "12000");
        return item;
    }

    protected AbstractTestIssueNavigatorView.Item createItem3() {
        AbstractTestIssueNavigatorView.Item item = super.createItem3();
        item.setAttribute("timeoriginalestimate", "86400");
        item.setAttribute("timeestimate", "86400");
        return item;
    }

    protected class ExcelItemVerifier
    extends AbstractTestIssueNavigatorColumnsView.ItemVerifier {
        public ExcelItemVerifier(AbstractTestIssueNavigatorColumnsView test, AbstractTestIssueNavigatorView.Item item, WebTable table, URL baseUrl) {
            super(test, item, table, baseUrl);
        }

        public void verify() {
            String key = this.item.getAttribute("key");
            AbstractTestIssueNavigatorColumnsView.log("Checking item [" + key + "] on row [" + this.row + "]");
            String issueLink = this.baseUrl + "/browse/" + key;
            this.verifyCellIssueAttributeEmptyOrEquals("issueType", "type");
            this.verifyLinkExists("issueKey", issueLink);
            this.verifyCellIssueAttributeEmptyOrEquals("issueSummary", "summary");
            this.verifyCellIssueAttributeEmptyOrEquals("issueAssignee", "assignee");
            this.verifyCellIssueAttributeEmptyOrEquals("issueReporter", "reporter");
            this.verifyCellIssueAttributeEmptyOrEquals("issuePriority", "priority");
            this.verifyCellIssueAttributeEmptyOrEquals("issueStatus", "status");
            String resolution = this.item.getAttribute("resolution");
            this.verifyCellValueEmptyOrEquals("issueResolution", resolution.equals("Unresolved") ? "UNRESOLVED" : resolution);
            this.verifyCellIssueAttributeEmptyOrEquals("issueCreated", "created");
            this.verifyCellIssueAttributeEmptyOrEquals("issueUpdated", "updated");
            this.verifyCellIssueAttributeEmptyOrEquals("issueDue", "due");
            this.verifyCellIssueAttributeEmptyOrEquals("issueResolved", "resolved");
            this.verifyCellIssueAttributeEmptyOrEquals("issueAffectsVersions", "version");
            this.verifyCustomFieldDisplayValues("issueCascadingSelectField", "CascadingSelectField");
            for (String component : this.item.getComponents()) {
                this.verifyCellValueEmptyOrEquals("issueComponents", component);
            }
            this.verifyCustomFieldDisplayValues("issueDatePickerField", "DatePickerField");
            this.verifyCustomFieldDisplayValues("issueDateTimeField", "DateTimeField");
            this.verifyCellIssueAttributeEmptyOrEquals("issueDescription", "description");
            this.verifyCellIssueAttributeEmptyOrEquals("issueSecurityLevel", "securityLevel");
            this.verifyCellIssueAttributeEmptyOrEquals("issueEnvironment", "environment");
            this.verifyCellIssueAttributeEmptyOrEquals("issueFixVersions", "fixVersion");
            this.verifyCustomFieldDisplayValues("issueFreeTextField", "FreeTextField");
            this.verifyCustomFieldDisplayValues("issueGroupPickerField", "GroupPickerField");
            List attachments = this.item.getAttachments();
            if (attachments != null && !attachments.isEmpty()) {
                this.verifyLinkExists("issueImages", this.baseUrl + "/secure/attachment/");
                this.verifyLinkExists("issueImages", "_picture-attachment.jpg");
            }
            this.verifyCustomFieldDisplayValues("issueImportIdField", "ImportIdField");
            AbstractTestIssueNavigatorView.IssueLinks links = this.item.getLinks();
            for (AbstractTestIssueNavigatorView.IssueLink link : links.getInLinks()) {
                this.verifyCellValueEmptyOrEquals("issueLinks", link.getLink());
            }
            for (AbstractTestIssueNavigatorView.IssueLink link : links.getOutLinks()) {
                this.verifyCellValueEmptyOrEquals("issueLinks", link.getLink());
            }
            this.verifyCustomFieldDisplayValues("issueMultiCheckboxesField", "MultiCheckboxesField");
            this.verifyCustomFieldDisplayValues("issueMultiGroupPickerField", "MultiGroupPickerField");
            this.verifyCustomFieldDisplayValues("issueMultiSelectField", "MultiSelectField");
            this.verifyCustomFieldDisplayValues("issueMultiUserPickerField", "MultiUserPickerField");
            this.verifyCustomFieldDisplayValues("issueNumberField", "NumberField");
            this.verifyCellIssueAttributeEmptyOrEquals("issueOriginalEstimate", "timeoriginalestimate");
            this.verifyCellIssueAttributeEmptyOrEquals("issueProject", "project");
            this.verifyCustomFieldDisplayValues("issueProjectPickerField", "ProjectPickerField");
            this.verifyCustomFieldDisplayValues("issueROTextField", "ROTextField");
            this.verifyCustomFieldDisplayValues("issueRadioButtonsField", "RadioButtonsField");
            this.verifyCellIssueAttributeEmptyOrEquals("issueRemainingEstimate", "timeestimate");
            this.verifyCustomFieldDisplayValues("issueSelectList", "SelectList");
            this.verifyCustomFieldDisplayValues("issueSingleVersionPickerField", "SingleVersionPickerField");
            this.verifyCustomFieldDisplayValues("issueTextField255", "TextField255");
            this.verifyCellIssueAttributeEmptyOrEquals("issueTimeSpent", "timespent");
            this.verifyCustomFieldDisplayValues("issueURLField", "URLField");
            this.verifyCustomFieldLinks("issueURLField", "URLField");
            this.verifyCustomFieldDisplayValues("issueUserPickerField", "UserPickerField");
            this.verifyCustomFieldDisplayValues("issueVersionPickerField", "VersionPickerField");
            this.verifyCellIssueAttributeEmptyOrEquals("issueVotes", "votes");
            this.verifyCellIssueAttributeEmptyOrEquals("issueWorkRatio", "workRatio");
        }
    }
}

