/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.webtests.CustomFieldValue;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebLink;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestIssueNavigator
extends JIRAWebTest {
    private static final String FIELD_FIX_FOR = "Fix For:";
    private static final String FIELD_AFFECTS_VERSION = "Affects Versions:";
    private static final String FIELD_COMPONENTS = "Components:";
    private static final String CUSTOM_FIELD_GLOBAL = "global custom field";
    private static final String CUSTOM_FIELD_ISSUETYPE = "issueType only custom field";
    private static final String CUSTOM_FIELD_PROJECT = "project only custom field";
    private static final String CUSTOM_FIELD_ISSUETYPE_AND_PROJECT = "issue type & project custom field";
    private static final String PROJECT_DOG = "dog";
    private String homosapId = "10000";
    private static final String GROUP_NAME = "test group";
    private static List[] cfValuesPerIssue = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
    private static String issueKey = "HSP-1";
    private static String issueKey2 = "HSP-2";
    private static String issueKey3 = "HSP-3";
    private static String issueKey4 = "HSP-4";
    private static String customFieldIdSelectList = "10000";
    private static String customFieldIdRadioButton = "10001";
    private static String customFieldIdMultiSelect = "10002";
    private static String customFieldIdCheckBox = "10003";
    private static String customFieldIdTextField = "10004";
    private static String customFieldIdUserPicker = "10005";
    private static String customFieldIdDatePicker = "10006";
    private static final String CUSTOM_FIELD_SELECT = "Custom Field Select";
    private static final String CUSTOM_FIELD_RADIO = "Custom Field Radio";
    private static final String CUSTOM_FIELD_MULTI_SELECT = "Custom Field Multi Select";
    private static final String CUSTOM_FIELD_TEXTFIELD = "Custom Field Text Field";
    private static final String CUSTOM_FIELD_CHECKBOX = "Custom Field Check Box";
    private static final String CUSTOM_FIELD_USERPICKER = "Custom Field User Picker";
    private static final String CUSTOM_FIELD_DATEPICKER = "Custom Field Date Picker";
    private static final String ABC_USERNAME = "abcuser";
    private static final String DEF_USERNAME = "defuser";
    private static final String GHI_USERNAME = "ghiuser";
    private static final String[] defaultOptions = new String[]{"abc", "def", "ghi"};
    private static final String[] dateOptions = new String[]{"01/Jan/05", "01/Feb/05", "01/Mar/05"};
    private static final String[] userOptions = new String[]{"abcuser", "defuser", "ghiuser"};
    private static final String[] customFieldNames = new String[]{"Custom Field Select", "Custom Field Radio", "Custom Field Text Field", "Custom Field Multi Select", "Custom Field Check Box", "Custom Field User Picker", "Custom Field Date Picker"};
    private static String[] customFieldIds = new String[]{customFieldIdSelectList, customFieldIdRadioButton, customFieldIdTextField, customFieldIdMultiSelect, customFieldIdCheckBox, customFieldIdUserPicker, customFieldIdDatePicker};

    public TestIssueNavigator(String name) {
        super(name);
    }

    public void testSubtaskIssueNavigatorColumn() {
        this.restoreData("TestIssueNavigatorSubtaskColumnView.xml");
        this.login("admin", "admin");
        this.gotoIssue("");
        this.assertTextPresent("HSP-5");
        this.assertTextPresent("HSP-6");
        TestIssueNavigator.log("Successfully found subtask issue keys in the subtask issue navigator column");
    }

    protected void removeColumnFromIssueNavigatorByPosition(int pos) {
        this.clickLinkWithText("Profile");
        this.clickLinkWithText("Navigator Columns");
        this.clickLink("del_col_" + pos);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueNavigatorCommon.xml");
    }

    public void tearDown() {
        this.login("admin", "admin");
        super.tearDown();
    }

    public void testNavigatorColumnVisibilityForCustomFields() {
        this.restoreData("TestIssueNavigatorColumnVisibilityForCustomFields.xml");
        String dogProjectId = "10010";
        this.clickLink("find_link");
        this.submit("show");
        this.assertTextNotPresent("homosapien cf");
        this.assertTextNotPresent("homosapien bug cf");
        this.assertTextNotPresent("dog cf");
        this.assertTextNotPresent("dog bug cf");
        this.clickLink("new_filter");
        this.selectOption("pid", "homosapien");
        this.submit("show");
        this.assertTextPresent("homosapien cf");
        this.assertTextNotPresent("homosapien bug cf");
        this.assertTextNotPresent("dog cf");
        this.assertTextNotPresent("dog bug cf");
        this.clickLink("new_filter");
        this.selectOption("pid", "homosapien");
        this.selectOption("type", "Bug");
        this.submit("show");
        this.assertTextPresent("homosapien cf");
        this.assertTextPresent("homosapien bug cf");
        this.assertTextNotPresent("dog cf");
        this.assertTextNotPresent("dog bug cf");
        this.clickLink("new_filter");
        this.selectOption("pid", PROJECT_DOG);
        this.submit("show");
        this.assertTextNotPresent("homosapien cf");
        this.assertTextNotPresent("homosapien bug cf");
        this.assertTextPresent("dog cf");
        this.assertTextNotPresent("dog bug cf");
        this.clickLink("new_filter");
        this.selectOption("pid", PROJECT_DOG);
        this.selectOption("type", "Bug");
        this.submit("show");
        this.assertTextNotPresent("homosapien cf");
        this.assertTextNotPresent("homosapien bug cf");
        this.assertTextPresent("dog cf");
        this.assertTextPresent("dog bug cf");
        this.clickLink("new_filter");
        this.checkCheckbox("pid", this.homosapId);
        this.checkCheckbox("pid", dogProjectId);
        this.submit("show");
        this.assertTextPresent("homosapien cf");
        this.assertTextNotPresent("homosapien bug cf");
        this.assertTextPresent("dog cf");
        this.assertTextNotPresent("dog bug cf");
        this.clickLink("new_filter");
        this.checkCheckbox("pid", this.homosapId);
        this.checkCheckbox("pid", dogProjectId);
        this.selectOption("type", "Bug");
        this.submit("show");
        this.assertTextPresent("homosapien cf");
        this.assertTextPresent("homosapien bug cf");
        this.assertTextPresent("dog cf");
        this.assertTextPresent("dog bug cf");
    }

    public void testProjectDropDownVisibility() {
        TestIssueNavigator.log("Issue Navigator: Test Issue navigator with only one project");
        this.restoreData("TestIssueNavigatorProjectDropDownVisibility.xml");
        this.clickLink("find_link");
        this.assertTextPresent("Project:");
        this.assertTextNotPresent(FIELD_FIX_FOR);
        this.assertTextNotPresent(FIELD_COMPONENTS);
        this.assertTextNotPresent(FIELD_AFFECTS_VERSION);
        this.submit("hide");
        this.assertLinkPresentWithText("homosapien");
        this.assertLinkPresentWithText(issueKey);
        this.assertLinkPresentWithText("This issue is in the project homosapien");
        this.deleteIssue(issueKey);
    }

    public void testProjectCustomFieldsFixForAffectsComponetsVisibilityOneProject() {
        TestIssueNavigator.log("Issue Navigator: Test Issue navigator with only one project for visible related fields");
        this.restoreData("TestIssueNavigatorComponentsVisibilityOneProject.xml");
        this.clickLink("find_link");
        this.assertTextNotPresent(FIELD_FIX_FOR);
        this.assertTextNotPresent(FIELD_COMPONENTS);
        this.assertTextNotPresent(FIELD_AFFECTS_VERSION);
        this.assertTextNotPresent(CUSTOM_FIELD_PROJECT);
        this.logout();
        this.login("bob", "bob_password");
        this.clickLink("find_link");
        this.assertTextPresent(FIELD_FIX_FOR);
        this.assertTextPresent(FIELD_COMPONENTS);
        this.assertTextPresent(FIELD_AFFECTS_VERSION);
        this.assertTextPresent(CUSTOM_FIELD_PROJECT);
    }

    public void testSearchAfterProjectRemoval() {
        TestIssueNavigator.log("Issue Navigator: Searching right after removal of the last searched project");
        this.restoreData("TestIssueNavigatorSearchAfterProjectRemoval.xml");
        this.clickLink("find_link");
        this.assertFormElementPresent("pid");
        this.setFormElement("pid", this.homosapId);
        this.submit("hide");
        this.deleteProject("homosapien");
        this.addProject("homosapien", "HSP", "", "admin", "project to delete");
        this.clickLink("find_link");
        this.assertTextNotPresent("A system error has occurred");
    }

    public void testProjectComponentsVisibility() {
        TestIssueNavigator.log("Issue Navigator: Test project componenets visibility");
        this.restoreData("TestIssueNavigatorProjectComponentsVisibility.xml");
        String projectIdOne = "10010";
        String projectIdTwo = "10011";
        String projectIdThree = "10012";
        String projectIdFour = "10013";
        String issueKeyOne = "HSP-1";
        String issueKeyTwo = "MKY-1";
        String issueKeyThree = "NDT-1";
        String issueKeyFour = "DOG-1";
        TestIssueNavigator.log("  Search all projects ie. there should be no project components section");
        this.clickLink("find_link");
        this.setFormElement("pid", "-1");
        this.submit("show");
        this.assertLinkPresentWithText(issueKeyOne);
        this.assertLinkPresentWithText(issueKeyTwo);
        this.assertLinkPresentWithText(issueKeyThree);
        this.assertLinkPresentWithText(issueKeyFour);
        this.assertTextNotPresent(FIELD_FIX_FOR);
        this.assertTextNotPresent(FIELD_COMPONENTS);
        this.assertTextNotPresent(FIELD_AFFECTS_VERSION);
        TestIssueNavigator.log("  Search Project 1 that has NO components and versions field");
        this.clickLink("find_link");
        this.setFormElement("pid", projectIdOne);
        this.submit("show");
        this.assertLinkPresentWithText(issueKeyOne);
        this.assertLinkNotPresentWithText(issueKeyTwo);
        this.assertLinkNotPresentWithText(issueKeyThree);
        this.assertLinkNotPresentWithText(issueKeyFour);
        this.assertTextNotPresent(FIELD_FIX_FOR);
        this.assertTextNotPresent(FIELD_COMPONENTS);
        this.assertTextNotPresent(FIELD_AFFECTS_VERSION);
        TestIssueNavigator.log("  Search Project 2 that has components field");
        this.clickLink("find_link");
        this.setFormElement("pid", projectIdTwo);
        this.submit("show");
        this.assertLinkNotPresentWithText(issueKeyOne);
        this.assertLinkPresentWithText(issueKeyTwo);
        this.assertLinkNotPresentWithText(issueKeyThree);
        this.assertLinkNotPresentWithText(issueKeyFour);
        this.assertTextNotPresent(FIELD_FIX_FOR);
        this.assertTextPresent(FIELD_COMPONENTS);
        this.assertTextNotPresent(FIELD_AFFECTS_VERSION);
        TestIssueNavigator.log("  Search Project 3 that has versions field");
        this.clickLink("find_link");
        this.setFormElement("pid", projectIdThree);
        this.submit("show");
        this.assertLinkNotPresentWithText(issueKeyOne);
        this.assertLinkNotPresentWithText(issueKeyTwo);
        this.assertLinkPresentWithText(issueKeyThree);
        this.assertLinkNotPresentWithText(issueKeyFour);
        this.assertTextPresent(FIELD_FIX_FOR);
        this.assertTextNotPresent(FIELD_COMPONENTS);
        this.assertTextPresent(FIELD_AFFECTS_VERSION);
        TestIssueNavigator.log("  Search Project 4 that has a component and a version field");
        this.clickLink("find_link");
        this.setFormElement("pid", projectIdFour);
        this.submit("show");
        this.assertLinkNotPresentWithText(issueKeyOne);
        this.assertLinkNotPresentWithText(issueKeyTwo);
        this.assertLinkNotPresentWithText(issueKeyThree);
        this.assertLinkPresentWithText(issueKeyFour);
        this.assertTextPresent(FIELD_FIX_FOR);
        this.assertTextPresent(FIELD_COMPONENTS);
        this.assertTextPresent(FIELD_AFFECTS_VERSION);
        this.deleteProject(PROJECT_DOG);
    }

    public void testStatusHiddenWhenInvalidProjectIdsSetInUrl() {
        TestIssueNavigator.log("Issue Navigator: Test project componenets visibility");
        this.restoreData("TestIssueNavigatorProjectComponentsVisibility.xml");
        this.gotoPage("/secure/IssueNavigator.jspa?reset=true&pid=99999");
        this.assertElementNotPresent("status");
        this.gotoPage("/secure/IssueNavigator.jspa?reset=true&pid=99999&pid=88888");
        this.assertTextPresent("A value with ID '88888' does not exist for the field 'project'.");
        this.assertTextPresent("A value with ID '99999' does not exist for the field 'project'.");
        this.getAssertions().getIssueNavigatorAssertions().assertJqlTooComplex();
        this.gotoPage("/secure/IssueNavigator.jspa?reset=true&pid=99999&pid=88888&pid=10010");
        this.assertTextPresent("A value with ID '88888' does not exist for the field 'project'.");
        this.assertTextPresent("A value with ID '99999' does not exist for the field 'project'.");
        this.assertTextNotPresent("A value with ID '10010' does not exist for the field 'project'.");
        this.getAssertions().getIssueNavigatorAssertions().assertJqlTooComplex();
    }

    public void testCustomfieldVisibility() {
        this.restoreData("TestIssueNavigatorCustomfieldVisibility.xml");
        this.clickLink("find_link");
        this.setFormElement("type", "");
        this.setFormElement("pid", "-1");
        this.submit("show");
        this.assertTextPresent(CUSTOM_FIELD_GLOBAL);
        this.assertTextNotPresent(CUSTOM_FIELD_ISSUETYPE);
        this.assertTextNotPresent(CUSTOM_FIELD_PROJECT);
        this.assertTextNotPresent(CUSTOM_FIELD_ISSUETYPE_AND_PROJECT);
        this.clickLink("find_link");
        this.setFormElement("type", "1");
        this.setFormElement("pid", "-1");
        this.submit("show");
        this.assertTextPresent(CUSTOM_FIELD_GLOBAL);
        this.assertTextPresent(CUSTOM_FIELD_ISSUETYPE);
        this.assertTextNotPresent(CUSTOM_FIELD_PROJECT);
        this.assertTextNotPresent(CUSTOM_FIELD_ISSUETYPE_AND_PROJECT);
        this.clickLink("find_link");
        this.setFormElement("type", "");
        this.setFormElement("pid", this.homosapId);
        this.submit("show");
        this.assertTextPresent(CUSTOM_FIELD_GLOBAL);
        this.assertTextNotPresent(CUSTOM_FIELD_ISSUETYPE);
        this.assertTextPresent(CUSTOM_FIELD_PROJECT);
        this.assertTextNotPresent(CUSTOM_FIELD_ISSUETYPE_AND_PROJECT);
        this.clickLink("find_link");
        this.setFormElement("type", "1");
        this.setFormElement("pid", this.homosapId);
        this.submit("show");
        this.assertTextPresent(CUSTOM_FIELD_GLOBAL);
        this.assertTextPresent(CUSTOM_FIELD_ISSUETYPE);
        this.assertTextPresent(CUSTOM_FIELD_PROJECT);
        this.assertTextPresent(CUSTOM_FIELD_ISSUETYPE_AND_PROJECT);
    }

    public void testSearchParametersDisplayed() {
        String componentId = "10000";
        String versionFourId = "10000";
        String versionFiveId = "10001";
        String customFieldId = this.addCustomField("textfield", "global", CUSTOM_FIELD_GLOBAL, "custom field to check if the value is displayed on the view panel", null, null, null);
        this.clickLink("find_link");
        this.setFormElement("pid", this.homosapId);
        this.submit("show");
        this.setFormElement("type", "1");
        this.setFormElement("fixfor", versionFourId);
        this.setFormElement("component", componentId);
        this.setFormElement("version", versionFiveId);
        this.setFormElement("query", "this is the query field");
        this.setFormElement("reporterSelect", "specificuser");
        this.setFormElement("reporter", "admin");
        this.setFormElement("assigneeSelect", "issue_current_user");
        this.setFormElement("status", "1");
        this.setFormElement("resolution", "1");
        this.setFormElement("priority", "3");
        this.setFormElement("created:after", "15/Jul/05");
        this.setFormElement("created:before", "16/Jul/05");
        this.setFormElement("created:previous", "-1d");
        this.setFormElement("created:next", "2d");
        this.setFormElement("updated:after", "17/Jul/05");
        this.setFormElement("updated:before", "18/Jul/05");
        this.setFormElement("updated:previous", "-3d");
        this.setFormElement("updated:next", "4d");
        this.setFormElement("duedate:after", "19/Jul/05");
        this.setFormElement("duedate:before", "20/Jul/05");
        this.setFormElement("duedate:previous", "-5d");
        this.setFormElement("duedate:next", "6d");
        this.setFormElement("workratio:min", "12");
        this.setFormElement("workratio:max", "13");
        this.setFormElement("customfield_" + customFieldId, "custom value");
        this.submit("hide");
        this.assertTextPresentBeforeText("Project:", "homosapien");
        this.assertTextPresentBeforeText("Project:", "homosapien");
        this.assertTextPresentBeforeText("Issue Type:", "Bug");
        this.assertTextPresentBeforeText(FIELD_FIX_FOR, "New Version 4");
        this.assertTextPresentBeforeText(FIELD_COMPONENTS, "New Component 1");
        this.assertTextPresentBeforeText(FIELD_AFFECTS_VERSION, "New Version 5");
        this.assertTextPresentBeforeText("Query", "this is the query field");
        this.assertTextPresentBeforeText("Reporter:", "name=admin\">admin</a>");
        this.assertTextPresentBeforeText("Assignee:", "Current User");
        this.assertTextPresentBeforeText("Status:", "Open");
        this.assertTextPresentBeforeText("Resolutions:", "Fixed");
        this.assertTextPresentBeforeText("Priorities:", "Major");
        this.assertTextPresentBeforeText("Created After:", "15/Jul/05");
        this.assertTextPresentBeforeText("Created Before:", "16/Jul/05");
        this.assertTextPresentBeforeText("Created:", "From 1 day ago");
        this.assertTextPresentBeforeText("From 1 day ago", "2 days from now");
        this.assertTextPresentBeforeText("Updated After:", "17/Jul/05");
        this.assertTextPresentBeforeText("Updated Before:", "18/Jul/05");
        this.assertTextPresentBeforeText("Updated:", "From 3 days ago");
        this.assertTextPresentBeforeText("From 3 days ago", "4 days from now");
        this.assertTextPresentBeforeText("Due After:", "19/Jul/05");
        this.assertTextPresentBeforeText("Due Before:", "20/Jul/05");
        this.assertTextPresentBeforeText("Due Date:", "From 5 days ago");
        this.assertTextPresentBeforeText("From 5 days ago", "6 days from now");
        this.assertTextPresentBeforeText("Work Ratio Min:", "12%");
        this.assertTextPresentBeforeText("Work Ratio Max:", "13%");
        this.assertTextPresentBeforeText(CUSTOM_FIELD_GLOBAL, "custom value");
    }

    public void testIssueNavigatorSortByComponent() {
        TestIssueNavigator.log("Issue Navigator: Test that the filter correctly orders issues for components.");
        this.clickLink("find_link");
        this.submit("hide");
        this.clickLinkWithText("Configure");
        try {
            this.selectOption("fieldId", "Component/s");
            this.submit("add");
        }
        catch (Throwable t) {
            TestIssueNavigator.log("Component field already added");
        }
        this.clickLinkWithText("Issue Navigator");
        this.sortIssues("issuekey", "ASC");
        this.sortIssues("components", "ASC");
        this.assertTextPresentAfterText(issueKey2, issueKey4);
        this.assertTextPresentAfterText(issueKey, issueKey2);
        this.assertTextPresentAfterText(issueKey3, issueKey);
        this.sortIssues("components", "DESC");
        this.assertTextPresentAfterText(issueKey3, issueKey);
        this.assertTextPresentAfterText(issueKey2, issueKey3);
        this.assertTextPresentAfterText(issueKey4, issueKey2);
        this.clickLinkWithText("Configure");
        this.clickLinkWithText("Restore Defaults");
    }

    public void testIssueNavigatorSortByCustomField() {
        TestIssueNavigator.log("Issue Navigator: Test that the filter correctly orders issues for custom fields.");
        this.addColumnToIssueNavigator(customFieldNames);
        this.gotoIssue("");
        for (int i = 0; i < customFieldIds.length; ++i) {
            TestIssueNavigator.log("Sorting by " + customFieldNames[i]);
            this.sortIssues("customfield_" + customFieldIds[i], "ASC");
            this.assertTextPresentAfterText(issueKey4, issueKey3);
            this.assertTextPresentAfterText(issueKey3, issueKey2);
            this.assertTextPresentAfterText(issueKey2, issueKey);
            this.sortIssues("customfield_" + customFieldIds[i], "DESC");
            this.assertTextPresentAfterText(issueKey, issueKey2);
            this.assertTextPresentAfterText(issueKey2, issueKey3);
            this.assertTextPresentAfterText(issueKey3, issueKey4);
        }
        this.restoreColumnDefaults();
    }

    public void testIssueNavigatorHideReporter() {
        TestIssueNavigator.log("Issue Navigator: Test that the filter correctly hides the reporter field with full content view.");
        this.setHiddenFields("Reporter");
        this.gotoIssue("");
        this.clickLink("fullContent");
        this.assertTextNotPresent("Reporter");
        this.clickLinkWithText("test issue 1");
        this.setShownFields("Reporter");
        this.gotoIssue("");
        this.clickLink("fullContent");
        this.assertTextPresent("Reporter");
        this.clickLinkWithText("test issue 1");
    }

    public void issueNavigatorXMLView() {
        TestIssueNavigator.log("Issue Navigator: Test that the RSS page correctly shows the information.");
        this.gotoIssue("");
        this.clickLinkWithText("XML");
        this.assertTextPresent("This file is an XML representation of some issues");
        this.assertTextPresent("[" + issueKey + "] test issue 1");
        this.gotoPage("/");
    }

    public void testIssueNavigatorManyFields() {
        this.grantGlobalPermission(33, "jira-users");
        this.addIssue("homosapien", "HSP", "Bug", "test issue 6", "Trivial", new String[]{"New Component 1"}, new String[]{"New Version 5"}, new String[]{"New Version 5"}, "Administrator", "test environment 5", "test description 4 for project actions", null, null, dateOptions[1]);
        this.gotoIssue("");
        this.clickLink("new_filter");
        this.selectOption("type", "Bug");
        this.setFormElement("query", "issue 6");
        this.selectOption("reporterSelect", "Current User");
        this.selectOption("assigneeSelect", "Specify User");
        this.setFormElement("assignee", "admin");
        this.selectOption("status", "Open");
        this.selectOption("resolution", "Unresolved");
        this.selectOption("priority", "Trivial");
        this.setFormElement("created:after", dateOptions[0]);
        this.setFormElement("created:previous", "-1h");
        this.setFormElement("updated:after", dateOptions[0]);
        this.setFormElement("updated:previous", "-1h");
        this.setFormElement("duedate:after", dateOptions[0]);
        this.setFormElement("duedate:before", dateOptions[2]);
        this.clickButton("searchButton");
        this.assertTextPresent("all 1 issue");
        this.selectOption("type", "Task");
        this.clickButton("searchButton");
        this.assertTextPresent("No matching issues found");
        this.removeGlobalPermission(33, "jira-users");
    }

    public void testIssueNavigatorSelectGroup() {
        TestIssueNavigator.log("Issue Navigator: Test that all issues are filtered for a specific group");
        this.createGroup(GROUP_NAME);
        this.addUserToGroup("bob", GROUP_NAME);
        String testIssueKey = this.addIssue("homosapien", "HSP", "Bug", "test issue 5", "Trivial", new String[]{"New Component 1"}, new String[]{"New Version 5"}, new String[]{"New Version 5"}, "Bob The Builder", "test environment 5", "test description 4 for project actions", null, null, null);
        this.clickLink("find_link");
        try {
            this.clickLink("new_filter");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.selectOption("assigneeSelect", "Specify Group");
        this.setFormElement("assignee", GROUP_NAME);
        this.submit("hide");
        this.assertLinkPresentWithText(issueKey);
        this.assertLinkPresentWithText(issueKey3);
        this.assertLinkPresentWithText(testIssueKey);
        this.deleteIssue(testIssueKey);
        this.removeGroup(GROUP_NAME);
    }

    public String createCustomFields(String fieldType, String fieldScope, String fieldName, String fieldDescription, String issueType, String projectType, String[] fieldOptions) {
        String cfId;
        block5: {
            block7: {
                block6: {
                    block4: {
                        cfId = super.createCustomFields(fieldType, fieldScope, fieldName, fieldDescription, issueType, projectType, fieldOptions);
                        if (fieldOptions == null) break block4;
                        for (int i = 0; i < fieldOptions.length; ++i) {
                            CustomFieldValue cfValue = new CustomFieldValue(cfId, fieldType, fieldOptions[i]);
                            cfValuesPerIssue[i].add(cfValue);
                        }
                        break block5;
                    }
                    if (!"textfield".equals(fieldType)) break block6;
                    for (int i = 0; i < defaultOptions.length; ++i) {
                        CustomFieldValue cfValue = new CustomFieldValue(cfId, fieldType, defaultOptions[i]);
                        cfValuesPerIssue[i].add(cfValue);
                    }
                    break block5;
                }
                if (!"datepicker".equals(fieldType)) break block7;
                for (int i = 0; i < dateOptions.length; ++i) {
                    CustomFieldValue cfValue = new CustomFieldValue(cfId, fieldType, dateOptions[i]);
                    cfValuesPerIssue[i].add(cfValue);
                }
                break block5;
            }
            if (!"userpicker".equals(fieldType)) break block5;
            for (int i = 0; i < userOptions.length; ++i) {
                CustomFieldValue cfValue = new CustomFieldValue(cfId, fieldType, userOptions[i]);
                cfValuesPerIssue[i].add(cfValue);
            }
        }
        return cfId;
    }

    public void testIssueNavigatorXMLViewWithCustomFields() throws Exception {
        TestIssueNavigator.log("Issue Navigator: Test that the RSS page correctly shows the custom field information.");
        this.addColumnToIssueNavigator(customFieldNames);
        this.gotoIssue("");
        this.clickLinkWithText("XML");
        this.assertTextPresent("An XML representation of a search request");
        this.assertTextPresent("[" + issueKey + "] test issue 1");
        Document doc = XMLUnit.buildControlDocument((String)this.getDialog().getResponse().getText());
        for (int j = 0; j < cfValuesPerIssue.length; ++j) {
            for (CustomFieldValue customFieldValue : cfValuesPerIssue[j]) {
                if (customFieldValue.getCfType().equals("datepicker")) continue;
                TestIssueNavigator.log("Searching for existence of xpath //item/customfields/customfield[@id='customfield_" + customFieldValue.getCfId() + "'][customfieldname='" + this.getCustomFieldNameFromType(customFieldValue.getCfType()) + "'][customfieldvalues[customfieldvalue='" + customFieldValue.getCfValue() + "']]");
                XMLAssert.assertXpathExists((String)("//item/customfields/customfield[@id='customfield_" + customFieldValue.getCfId() + "'][customfieldname='" + this.getCustomFieldNameFromType(customFieldValue.getCfType()) + "'][customfieldvalues[customfieldvalue='" + customFieldValue.getCfValue() + "']]"), (Document)doc);
            }
        }
    }

    private String getCustomFieldNameFromType(String type) {
        if (type.equals("select")) {
            return CUSTOM_FIELD_SELECT;
        }
        if (type.equals("radiobuttons")) {
            return CUSTOM_FIELD_RADIO;
        }
        if (type.equals("multiselect")) {
            return CUSTOM_FIELD_MULTI_SELECT;
        }
        if (type.equals("multicheckboxes")) {
            return CUSTOM_FIELD_CHECKBOX;
        }
        if (type.equals("textfield")) {
            return CUSTOM_FIELD_TEXTFIELD;
        }
        if (type.equals("userpicker")) {
            return CUSTOM_FIELD_USERPICKER;
        }
        if (type.equals("datepicker")) {
            return CUSTOM_FIELD_DATEPICKER;
        }
        return null;
    }

    public void testSearchPermLink() throws SAXException {
        this.restoreData("TestNavigatorSearchPermLink.xml");
        this.login("admin", "admin");
        this.gotoFilter("HSP Unresolved");
        this.confirmSearchResults();
        WebLink permLink = this.getDialog().getResponse().getLinkWithID("permlink");
        String permlinkURLString = permLink.getURLString();
        this.gotoAdmin();
        this.beginAt(permlinkURLString);
        this.confirmSearchResults();
        this.logout();
        this.beginAt(permlinkURLString);
        this.confirmSearchResults();
    }

    public void testIssueNavigatorWithInvalidFilterId() {
        String invalidFilterId = "14a";
        this.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=14a");
        this.assertTextPresent("You do not currently have a search or filter selected.");
        this.assertTextPresent("Invalid filter id '14a'. Filter id must be a number.");
        this.assertTextPresent("The selected filter with id '14a' does not exist.");
    }

    public void testBackToPreviousViewLinks() {
        this.tester.gotoPage("secure/IssueNavigator.jspa?reset=true&jqlQuery=resolution+%3D+Unresolved+AND+assignee+%3D+currentUser%28%29+ORDER+BY+created+ASC%2C+priority+DESC");
        this.saveFilter("my issues", "");
        this.displayAllIssues();
        this.assertIssueNavigatorDisplaying("1", "4", "4");
        this.tester.gotoPage("secure/IssueNavigator.jspa?reset=true&jqlQuery=resolution+%3D+Unresolved+AND+assignee+%3D+currentUser%28%29+ORDER+BY+created+ASC%2C+priority+DESC");
        this.assertPrintableViewsBackToPreviousViewLink();
        this.gotoFilter("my issues");
        this.assertPrintableViewsBackToPreviousViewLink();
        this.tester.gotoPage("secure/IssueNavigator.jspa?reset=true&jqlQuery=resolution+%3D+Unresolved+AND+assignee+%3D+currentUser%28%29+ORDER+BY+created+ASC%2C+priority+DESC");
        this.assertFullContentViewsBackToPreviousViewLink();
        this.gotoFilter("my issues");
        this.assertFullContentViewsBackToPreviousViewLink();
    }

    private void assertPrintableViewsBackToPreviousViewLink() {
        String fromIssueCount = "1";
        String toIssueCount = "2";
        String totalIssueCount = "2";
        this.assertExpectedIssueLinksPresent();
        this.assertIssueNavigatorDisplaying(fromIssueCount, toIssueCount, totalIssueCount);
        this.clickLink("printable");
        this.assertExpectedIssueLinksPresent();
        this.assertIssueNavigatorDisplaying(fromIssueCount, toIssueCount, totalIssueCount);
        this.clickLinkWithText("<< Back to previous view");
        this.assertExpectedIssueLinksPresent();
        this.assertIssueNavigatorDisplaying(fromIssueCount, toIssueCount, totalIssueCount);
    }

    private void assertFullContentViewsBackToPreviousViewLink() {
        String fromIssueCount = "1";
        String toIssueCount = "2";
        String totalIssueCount = "2";
        this.assertExpectedIssueLinksPresent();
        this.assertIssueNavigatorDisplaying(fromIssueCount, toIssueCount, totalIssueCount);
        this.clickLink("fullContent");
        this.assertExpectedIssueLinksPresent();
        this.clickLinkWithText("<< Back to previous view");
        this.assertExpectedIssueLinksPresent();
        this.assertIssueNavigatorDisplaying(fromIssueCount, toIssueCount, totalIssueCount);
    }

    private void assertExpectedIssueLinksPresent() {
        this.assertLinkWithTextNotPresent("test issue 1");
        this.assertLinkWithTextNotPresent("test issue 3");
        this.assertLinkPresentWithText("test issue 2");
        this.assertLinkPresentWithText("test issue 4");
    }

    public void testSearchAbsoluteDateRangeDueDate() {
        this.restoreData("TestIssueNavigatorSearchParams.xml");
        this.clickLink("find_link");
        this.setFormElement("duedate:after", "12/Sep/06");
        this.submit("show");
        this.assertTextPresent("HSP-2");
        this.assertTextNotPresent("HSP-1");
        this.setFormElement("duedate:after", "11/Sep/06");
        this.submit("show");
        this.assertTextPresent("HSP-2");
        this.assertTextPresent("HSP-1");
        this.setFormElement("duedate:before", "13/Sep/06");
        this.submit("show");
        this.assertTextPresent("HSP-2");
        this.assertTextPresent("HSP-1");
        this.setFormElement("duedate:before", "12/Sep/06");
        this.submit("show");
        this.assertTextPresent("HSP-1");
        this.assertTextNotPresent("HSP-2");
        this.setFormElement("duedate:before", "13/Sep/06");
        this.setFormElement("duedate:after", "11/Sep/06");
        this.submit("show");
        this.assertTextPresent("HSP-2");
        this.assertTextPresent("HSP-1");
        this.setFormElement("duedate:before", "17/Sep/06");
        this.setFormElement("duedate:after", "15/Sep/06");
        this.submit("show");
        this.assertTextNotPresent("HSP-2");
        this.assertTextNotPresent("HSP-1");
    }

    public void testSearchRelativeDateRangeDueDate() {
        this.restoreData("TestIssueNavigatorSearchParams.xml");
        this.gotoIssue("HSP-1");
        this.clickLinkWithText("Edit");
        Date today = new Date();
        String todayString = new SimpleDateFormat("dd/MMM/yy").format(today);
        this.setFormElement("duedate", todayString);
        this.submit("Update");
        this.clickLink("find_link");
        this.setFormElement("duedate:previous", "-1d");
        this.setFormElement("duedate:next", "1d");
        this.submit("show");
        this.assertTextPresent("HSP-1");
        this.assertTextNotPresent("HSP-2");
        this.setFormElement("duedate:previous", "2d");
        this.setFormElement("duedate:next", "4d");
        this.submit("show");
        this.assertTextNotPresent("HSP-1");
        this.assertTextNotPresent("HSP-2");
        this.setFormElement("duedate:previous", "-1d");
        this.setFormElement("duedate:next", "");
        this.submit("show");
        this.assertTextPresent("HSP-1");
        this.assertTextNotPresent("HSP-2");
        this.setFormElement("duedate:previous", "");
        this.setFormElement("duedate:next", "1d");
        this.submit("show");
        this.assertTextPresent("HSP-1");
        this.assertTextPresent("HSP-2");
    }

    public void testSearchWorkRatioParam() {
        this.restoreData("TestIssueNavigatorSearchParams.xml");
        this.clickLink("find_link");
        this.setFormElement("workratio:min", "2");
        this.setFormElement("workratio:max", "5");
        this.submit("show");
        this.assertTextPresent("HSP-2");
        this.assertTextNotPresent("HSP-1");
        this.setFormElement("workratio:min", "4");
        this.setFormElement("workratio:max", "5");
        this.submit("show");
        this.assertTextPresent("HSP-2");
        this.assertTextNotPresent("HSP-1");
        this.setFormElement("workratio:min", "3");
        this.setFormElement("workratio:max", "4");
        this.submit("show");
        this.assertTextPresent("HSP-2");
        this.assertTextNotPresent("HSP-1");
        this.setFormElement("workratio:min", "5");
        this.setFormElement("workratio:max", "9");
        this.submit("show");
        this.assertTextNotPresent("HSP-2");
        this.assertTextNotPresent("HSP-1");
        this.setFormElement("workratio:min", "3");
        this.setFormElement("workratio:max", "");
        this.submit("show");
        this.assertTextPresent("HSP-2");
        this.assertTextNotPresent("HSP-1");
        this.setFormElement("workratio:min", "");
        this.setFormElement("workratio:max", "5");
        this.submit("show");
        this.assertTextPresent("HSP-2");
        this.assertTextNotPresent("HSP-1");
    }

    public void testSearchNumberCustomFieldParam() {
        this.restoreData("TestIssueNavigatorSearchParams.xml");
        this.clickLink("find_link");
        this.setFormElement("customfield_10000:greaterThan", "0");
        this.setFormElement("customfield_10000:lessThan", "3");
        this.submit("show");
        this.assertTextPresent("HSP-2");
        this.assertTextPresent("HSP-1");
        this.setFormElement("customfield_10000:greaterThan", "1");
        this.setFormElement("customfield_10000:lessThan", "3");
        this.submit("show");
        this.assertTextPresent("HSP-2");
        this.assertTextPresent("HSP-1");
        this.setFormElement("customfield_10000:greaterThan", "0");
        this.setFormElement("customfield_10000:lessThan", "2");
        this.submit("show");
        this.assertTextPresent("HSP-2");
        this.assertTextPresent("HSP-1");
        this.setFormElement("customfield_10000:greaterThan", "5");
        this.setFormElement("customfield_10000:lessThan", "9");
        this.submit("show");
        this.assertTextNotPresent("HSP-2");
        this.assertTextNotPresent("HSP-1");
        this.setFormElement("customfield_10000:greaterThan", "2");
        this.setFormElement("customfield_10000:lessThan", "");
        this.submit("show");
        this.assertTextPresent("HSP-2");
        this.assertTextNotPresent("HSP-1");
        this.setFormElement("customfield_10000:greaterThan", "");
        this.setFormElement("customfield_10000:lessThan", "1");
        this.submit("show");
        this.assertTextNotPresent("HSP-2");
        this.assertTextPresent("HSP-1");
    }

    public void testNavigatorOrdering() {
        this.clickLink("find_link");
        this.submit("show");
        this.gotoPage("secure/IssueNavigator.jspa?sorter/field=summary&sorter/order=ASC");
        this.assertTextSequence(new String[]{"test issue 1", "test issue 2", "test issue 3", "test issue 4"});
        this.gotoPage("secure/IssueNavigator.jspa?sorter/field=assignee&sorter/order=ASC");
        this.assertTextSequence(new String[]{"Administrator", "Administrator", "Bob The Builder", "Bob The Builder"});
        this.gotoPage("secure/IssueNavigator.jspa?sorter/field=summary&sorter/order=ASC");
        this.gotoPage("secure/IssueNavigator.jspa?sorter/field=duedate&sorter/order=ASC");
        this.assertTextSequence(new String[]{"test issue 1", "test issue 2", "test issue 3", "test issue 4"});
        this.clickLink("find_link");
        this.clickLinkWithText("Configure");
        this.selectOption("fieldId", "Work Ratio");
        this.submit("add");
        this.clickLink("find_link");
        this.gotoPage("secure/IssueNavigator.jspa?sorter/field=summary&sorter/order=ASC");
        this.gotoPage("secure/IssueNavigator.jspa?sorter/field=workratio&sorter/order=ASC");
        this.assertTextSequence(new String[]{"test issue 1", "test issue 2", "test issue 3", "test issue 4"});
    }

    public void testNavigatorTabs() {
        this.logout();
        this.gotoPage("secure/IssueNavigator.jspa");
        String[] loggedTabs = new String[]{"Filter:", "View", "New", "Manage"};
        this.assertTextSequence(loggedTabs);
        this.clickLink("viewfilter");
        this.assertTextSequence(loggedTabs);
        this.clickLink("new_filter");
        this.assertTextSequence(loggedTabs);
        this.clickLink("managefilters");
        this.assertTextSequence(loggedTabs);
        this.login("admin", "admin");
        this.gotoNavigator();
        this.assertTextSequence(loggedTabs);
        this.clickLink("viewfilter");
        this.assertTextSequence(loggedTabs);
        this.clickLink("managefilters");
        this.assertTextSequence(loggedTabs);
        this.clickLink("new_filter");
        this.assertTextSequence(loggedTabs);
        this.submit("hide");
        loggedTabs = new String[]{"Filter:", "View", "Edit", "New", "Manage"};
        this.assertTextSequence(loggedTabs);
        this.clickLink("editfilter");
        this.assertTextSequence(loggedTabs);
        this.clickLink("new_filter");
        loggedTabs = new String[]{"Filter:", "View", "New", "Manage"};
        this.assertTextSequence(loggedTabs);
        this.assertLinkNotPresent("new_filter");
        this.tester.clickLink("find_link");
        this.assertTextSequence(loggedTabs);
        this.assertLinkNotPresent("new_filter");
    }

    public void testSearchSortDescriptionForInvalidField() throws Exception {
        this.tester.clickLink("find_link");
        this.tester.submit("show");
        this.tester.clickLinkWithText("Save");
        this.tester.setFormElement("filterName", "My Test Filter");
        this.tester.submit("Save");
        this.tester.gotoPage("/secure/IssueNavigator.jspa?sorter/field=customfield_10006&sorter/order=ASC");
        this.assertTextSequence(new String[]{"Sorted by:", "Custom Field Date Picker ascending, then", "Key descending"});
        this.tester.clickLinkWithText("Save");
        this.tester.submit("Save");
        this.tester.clickLink("admin_link");
        this.tester.clickLink("view_custom_fields");
        this.tester.clickLink("del_customfield_10006");
        this.tester.submit("Delete");
        this.tester.clickLink("find_link");
        this.tester.assertTextNotPresent("Custom Field Date Picker ascending, then");
        this.assertTextSequence(new String[]{"Sorted by:", "Key descending"});
    }

    public void testNoColumnsDialog() throws Exception {
        this.restoreData("TestIssueNavigatorNoColumns.xml");
        this.tester.clickLink("find_link");
        this.tester.submit("show");
        TextAssertionsImpl text = new TextAssertionsImpl();
        text.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"No columns selected", "/secure/ViewUserIssueColumns!default.jspa", "Configure"});
    }

    private void confirmSearchResults() {
        this.assertIssueNavigatorDisplaying("1", "4", "4");
        this.assertLinkNotPresentWithText("this is a NDT bug - should not be shown on the HSP filter");
        this.assertLinkPresentWithText("unresolved issue 1");
        this.assertLinkPresentWithText("unresolved issue 2");
        this.assertLinkPresentWithText("unresolved issue 3");
        this.assertLinkPresentWithText("unresolved issue 4");
    }
}

