/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.webtests.LicenseKeys;
import com.meterware.httpunit.WebTable;
import java.io.File;
import java.io.IOException;

public class TestSetup
extends FuncTestCase {
    public void testSetupCannotBeRunTwice() {
        this.administration.restoreBlankInstance();
        String[] actions = new String[]{"Setup.jspa", "Setup!input.jspa", "Setup!default.jspa", "Setup2.jspa", "Setup2!default.jspa", "SetupExisting.jspa", "SetupExisting!default.jspa", "Setup3.jspa", "Setup3!default.jspa", "SetupComplete.jspa", "SetupComplete!default.jspa", "SetupImport.jspa", "SetupImport!default.jspa"};
        String[] views = new String[]{"setup.jsp", "setup2.jsp", "setup2-existingadmins.jsp", "setup3.jsp", "setup-import.jsp"};
        for (String action : actions) {
            this.tester.gotoPage("/secure/" + action);
            this.assertSetupAlreadyLong();
        }
        for (String view : views) {
            this.tester.gotoPage("/views/" + view);
            this.assertSetupAlreadyShort();
        }
    }

    public void testMissingTitle() throws Exception {
        this.gotoSetupStep1();
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        this.tester.assertTextPresent("Step 1 of 3: Application properties");
        this.tester.assertTextPresent("You must specify a title.");
        this.tester.assertTextNotPresent("Invalid license key specified.");
    }

    public void testMissingLicense() throws Exception {
        this.gotoSetupStep1();
        this.tester.setFormElement("title", "My JIRA");
        this.tester.submit();
        this.tester.assertTextPresent("Step 1 of 3: Application properties");
        this.tester.assertTextNotPresent("You must specify a title.");
        this.tester.assertTextPresent("Invalid license key specified.");
    }

    public void testInvalidLicense() throws Exception {
        this.gotoSetupStep1();
        this.tester.setFormElement("title", "My JIRA");
        this.tester.setFormElement("license", "blah");
        this.tester.submit();
        this.tester.assertTextPresent("Step 1 of 3: Application properties");
        this.tester.assertTextNotPresent("You must specify a title.");
        this.tester.assertTextPresent("Invalid license key specified.");
    }

    public void testMissingCustomIndexDirectory() throws Exception {
        this.gotoSetupStep1();
        this.tester.setFormElement("title", "My JIRA");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.setFormElement("indexPathOption", "CUSTOM");
        this.tester.setFormElement("indexPath", "");
        this.tester.submit();
        this.tester.assertTextPresent("Step 1 of 3: Application properties");
        this.tester.assertTextPresent("You must specify a location for index files");
    }

    public void testRelativeCustomIndexDirectory() throws Exception {
        this.gotoSetupStep1();
        this.tester.setFormElement("title", "My JIRA");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.setFormElement("indexPathOption", "CUSTOM");
        this.tester.setFormElement("indexPath", "child-directory");
        this.tester.submit();
        this.tester.assertTextPresent("Step 1 of 3: Application properties");
        this.tester.assertTextPresent("The path entered must be an absolute path.");
        this.tester.assertTextNotPresent("You must specify a location for index files");
    }

    public void testMissingCustomAttachmentsDirectory() throws Exception {
        this.gotoSetupStep1();
        this.tester.setFormElement("title", "My JIRA");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.setFormElement("attachmentPathOption", "CUSTOM");
        this.tester.setFormElement("attachmentPath", "");
        this.tester.submit();
        this.tester.assertTextPresent("Step 1 of 3: Application properties");
        this.tester.assertTextPresent("You must specify the attachment path.");
    }

    public void testRelativeCustomAttachmentsDirectory() throws Exception {
        this.gotoSetupStep1();
        this.tester.setFormElement("title", "My JIRA");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.setFormElement("indexPathOption", "CUSTOM");
        this.tester.setFormElement("indexPath", "child-directory");
        this.tester.submit();
        this.tester.assertTextPresent("Step 1 of 3: Application properties");
        this.tester.assertTextPresent("The path entered must be an absolute path.");
        this.tester.assertTextNotPresent("You must specify the attachment path.");
    }

    public void testMissingCustomBackupDirectory() throws Exception {
        this.gotoSetupStep1();
        this.tester.setFormElement("title", "My JIRA");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.setFormElement("backupPathOption", "CUSTOM");
        this.tester.setFormElement("backupPath", "");
        this.tester.submit();
        this.tester.assertTextPresent("Step 1 of 3: Application properties");
        this.tester.assertTextPresent("You must specify the backup path.");
    }

    public void testRelativeCustomBackupDirectory() throws Exception {
        this.gotoSetupStep1();
        this.tester.setFormElement("title", "My JIRA");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.setFormElement("backupPathOption", "CUSTOM");
        this.tester.setFormElement("backupPath", "child-directory");
        this.tester.submit();
        this.tester.assertTextPresent("Step 1 of 3: Application properties");
        this.tester.assertTextPresent("The path entered must be an absolute path.");
        this.tester.assertTextNotPresent("You must specify the backup path.");
    }

    public void testInvalidSmtpPorts() throws Exception {
        this.doSetupStep1();
        this.doSetupStep2();
        this.tester.setFormElement("server", "localhost");
        this.tester.setFormElement("smtpPort", "-1");
        this.tester.submit("Finish");
        this.tester.assertTextPresent("SMTP port must be a number between 0 and 65535");
        this.tester.setFormElement("server", "localhost");
        this.tester.setFormElement("smtpPort", String.valueOf(65536));
        this.tester.submit("Finish");
        this.tester.assertTextPresent("SMTP port must be a number between 0 and 65535");
    }

    public void testSetupWithDefaultDirectories() throws IOException {
        this.gotoSetupStep1();
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("title", "My JIRA");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        this.doSetupStep2and3();
        this.navigation.gotoAdminSection("attachments");
        this.tester.assertTextPresent("Attachment Settings");
        WebTable AttachmentSettings = this.tester.getDialog().getWebTableBySummaryOrId("AttachmentSettings");
        TestSetup.assertEquals((String)"Cell (1, 0) in table 'AttachmentSettings' should be 'Allow Attachments'.", (String)"Allow Attachments", (String)AttachmentSettings.getCellAsText(1, 0).trim());
        TestSetup.assertEquals((String)"Cell (1, 1) in table 'AttachmentSettings' should be 'ON'.", (String)"ON", (String)AttachmentSettings.getCellAsText(1, 1).trim());
        TestSetup.assertEquals((String)"Cell (2, 0) in table 'AttachmentSettings' should be 'Attachment Path'.", (String)"Attachment Path", (String)AttachmentSettings.getCellAsText(2, 0).trim());
        TestSetup.assertTrue((String)"Default Directory [/home/mlassau/jira_homes/jira_trunk/data/attachments]", (boolean)AttachmentSettings.getCellAsText(2, 1).trim().startsWith("Default Directory ["));
        this.navigation.gotoAdminSection("indexing");
        this.tester.assertTextPresent("Re-Indexing");
        this.tester.assertFormElementEquals("indexPathOption", "DEFAULT");
        this.tester.assertFormElementEquals("indexPath", "");
        this.administration.viewServices().gotoViewServices();
        this.tester.assertTextPresent("Backup Service");
        this.tester.assertTextPresent("<td><b>USE_DEFAULT_DIRECTORY:</b></td><td>true</td>");
        this.tester.assertTextNotPresent("<td><b>DIR_NAME:</b></td><td>");
        this.administration.viewServices().clickEdit("Backup Service");
        this.tester.assertFormElementEquals("USE_DEFAULT_DIRECTORY", "true");
        this.tester.assertFormElementEquals("DIR_NAME", "");
    }

    public void testSetupWithCustomDirectories() throws IOException {
        this.gotoSetupStep1();
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("title", "My JIRA");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.setFormElement("indexPathOption", "CUSTOM");
        String indexPath = new File(this.environmentData.getWorkingDirectory(), "indexes").getAbsolutePath();
        this.tester.setFormElement("indexPath", indexPath);
        this.tester.setFormElement("attachmentPathOption", "CUSTOM");
        String attachmentPath = new File(this.environmentData.getWorkingDirectory(), "attachments").getAbsolutePath();
        this.tester.setFormElement("attachmentPath", attachmentPath);
        String backupPath = new File(this.environmentData.getWorkingDirectory(), "backups").getAbsolutePath();
        this.tester.setFormElement("backupPathOption", "CUSTOM");
        this.tester.setFormElement("backupPath", backupPath);
        this.tester.submit();
        this.doSetupStep2and3();
        this.navigation.gotoAdminSection("attachments");
        this.tester.assertTextPresent("Attachment Settings");
        WebTable AttachmentSettings = this.tester.getDialog().getWebTableBySummaryOrId("AttachmentSettings");
        TestSetup.assertEquals((String)"Cell (1, 0) in table 'AttachmentSettings' should be 'Allow Attachments'.", (String)"Allow Attachments", (String)AttachmentSettings.getCellAsText(1, 0).trim());
        TestSetup.assertEquals((String)"Cell (1, 1) in table 'AttachmentSettings' should be 'ON'.", (String)"ON", (String)AttachmentSettings.getCellAsText(1, 1).trim());
        TestSetup.assertEquals((String)"Cell (2, 0) in table 'AttachmentSettings' should be 'Attachment Path'.", (String)"Attachment Path", (String)AttachmentSettings.getCellAsText(2, 0).trim());
        TestSetup.assertEquals((String)attachmentPath, (String)AttachmentSettings.getCellAsText(2, 1).trim());
        this.navigation.gotoAdminSection("indexing");
        this.tester.assertTextPresent("Re-Indexing");
        this.tester.assertFormElementEquals("indexPathOption", "CUSTOM");
        this.tester.assertFormElementEquals("indexPath", indexPath);
        this.administration.viewServices().gotoViewServices();
        this.navigation.gotoAdminSection("services");
        this.tester.assertTextPresent("Backup Service");
        this.tester.assertTextPresent("<td><b>DIR_NAME:</b></td><td>" + backupPath + "</td>");
        this.tester.assertTextNotPresent("<td><b>USE_DEFAULT_DIRECTORY:</b></td><td>true</td>");
        this.administration.viewServices().clickEdit("Backup Service");
        this.tester.assertFormElementEquals("USE_DEFAULT_DIRECTORY", null);
        this.tester.assertFormElementEquals("DIR_NAME", backupPath);
    }

    public void testSetupWithDisabledDirectories() throws IOException {
        this.gotoSetupStep1();
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("title", "My JIRA");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.setFormElement("attachmentPathOption", "DISABLED");
        this.tester.setFormElement("backupPathOption", "DISABLED");
        this.tester.submit();
        this.doSetupStep2and3();
        this.navigation.gotoAdminSection("attachments");
        this.tester.assertTextPresent("Attachment Settings");
        WebTable AttachmentSettings = this.tester.getDialog().getWebTableBySummaryOrId("AttachmentSettings");
        TestSetup.assertEquals((String)"Cell (1, 0) in table 'AttachmentSettings' should be 'Allow Attachments'.", (String)"Allow Attachments", (String)AttachmentSettings.getCellAsText(1, 0).trim());
        TestSetup.assertEquals((String)"Cell (1, 1) in table 'AttachmentSettings' should be 'OFF'.", (String)"OFF", (String)AttachmentSettings.getCellAsText(1, 1).trim());
        TestSetup.assertEquals((String)"Cell (2, 0) in table 'AttachmentSettings' should be 'Attachment Path'.", (String)"Attachment Path", (String)AttachmentSettings.getCellAsText(2, 0).trim());
        TestSetup.assertEquals((String)"Cell (2, 1) in table 'AttachmentSettings' should be ''.", (String)"", (String)AttachmentSettings.getCellAsText(2, 1).trim());
        this.navigation.gotoAdminSection("services");
        this.tester.assertTextNotPresent("Backup Service");
        this.tester.assertTextNotPresent("USE_DEFAULT_DIRECTORY");
        this.tester.assertTextNotPresent("DIR_NAME");
    }

    public void testSetupImportMissingFilename() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("This setup page is to import existing data from another JIRA installation.");
        this.tester.setFormElement("filename", "");
        this.tester.submit();
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("You must enter the location of an XML file.");
        this.tester.assertTextNotPresent("You must specify a location for index files");
    }

    public void testSetupImportMissingCustomIndexDirectory() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("This setup page is to import existing data from another JIRA installation.");
        this.tester.setFormElement("filename", File.createTempFile("import", ".xml").getAbsolutePath());
        this.tester.setFormElement("indexPathOption", "CUSTOM");
        this.tester.setFormElement("indexPath", "");
        this.tester.submit();
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("You must specify a location for index files");
        this.tester.assertTextNotPresent("You must enter the location of an XML file.");
    }

    public void testSetupImportRelativeCustomIndexDirectory() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("This setup page is to import existing data from another JIRA installation.");
        this.tester.setFormElement("filename", File.createTempFile("import", ".xml").getAbsolutePath());
        this.tester.setFormElement("indexPathOption", "CUSTOM");
        this.tester.setFormElement("indexPath", "relative");
        this.tester.submit();
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("The path entered must be an absolute path.");
        this.tester.assertTextNotPresent("You must enter the location of an XML file.");
        this.tester.assertTextNotPresent("Invalid license key specified.");
    }

    public void testSetupImportIndexPathNotADirectory() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        File tempFile = File.createTempFile("JRA", null);
        this.tester.setWorkingForm("jiraform");
        this.tester.checkCheckbox("indexPathOption", "CUSTOM");
        this.tester.setFormElement("indexPath", tempFile.getAbsolutePath());
        this.tester.submit();
        this.tester.assertTextPresent("This path entered exists, but is not a directory.");
        tempFile.delete();
    }

    public void testSetupImportInvalidLicense() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("This setup page is to import existing data from another JIRA installation.");
        this.tester.setFormElement("filename", File.createTempFile("import", ".xml").getAbsolutePath());
        this.tester.setFormElement("license", "wrong");
        this.tester.submit();
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("Invalid license key specified.");
        this.tester.assertTextNotPresent("You must enter the location of an XML file.");
    }

    public void testSetupImportWithOldLicenseInXML() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("This setup page is to import existing data from another JIRA installation.");
        this.tester.setFormElement("filename", new File(this.environmentData.getXMLDataLocation(), "oldlicense.xml").getAbsolutePath());
        this.tester.submit();
        this.text.assertTextPresent(new WebPageLocator(this.tester), "The license in the imported data is not compatible with this installation of JIRA.");
    }

    public void testSetupImportDefaultIndexDirectory() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("This setup page is to import existing data from another JIRA installation.");
        this.tester.setFormElement("filename", new File(this.environmentData.getXMLDataLocation(), "oldlicense.xml").getAbsolutePath());
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        this.tester.assertTextPresent("Setup Complete");
        this.navigation.login("admin");
        this.navigation.gotoAdminSection("indexing");
        this.tester.assertTextPresent("Re-Indexing");
        this.tester.assertFormElementEquals("indexPathOption", "DEFAULT");
        this.tester.assertFormElementEquals("indexPath", "");
    }

    public void testSetupImportCustomIndexDirectory() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("This setup page is to import existing data from another JIRA installation.");
        this.tester.setFormElement("filename", new File(this.environmentData.getXMLDataLocation(), "oldlicense.xml").getAbsolutePath());
        this.tester.setFormElement("indexPathOption", "CUSTOM");
        String indexPath = new File(this.environmentData.getWorkingDirectory(), "indexes").getAbsolutePath();
        this.tester.setFormElement("indexPath", indexPath);
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        this.tester.assertTextPresent("Setup Complete");
        this.navigation.login("admin");
        this.navigation.gotoAdminSection("indexing");
        this.tester.assertTextPresent("Re-Indexing");
        this.tester.assertFormElementEquals("indexPathOption", "CUSTOM");
        this.tester.assertFormElementEquals("indexPath", indexPath);
    }

    private void restoreEmptyInstance() {
        File file = new File(this.getEnvironmentData().getXMLDataLocation(), "TestEmpty.xml");
        this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.setFormElement("filename", file.getAbsolutePath());
        this.tester.submit();
        this.tester.assertTextPresent("Your project has been successfully imported");
    }

    private void assertSetupAlreadyLong() {
        this.tester.assertTextPresent("SETUP ALREADY");
        this.tester.assertTextPresent("It seems that you have tried to setup JIRA when it is already setup.");
    }

    private void assertSetupAlreadyShort() {
        this.tester.assertTextPresent("JIRA has already been set up.");
    }

    private void doSetupStep1() {
        this.gotoSetupStep1();
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("title", "TestSetup JIRA");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
    }

    private void doSetupStep2and3() {
        this.doSetupStep2();
        this.doSetupStep3();
    }

    private void doSetupStep3() {
        this.log("Noemail");
        this.tester.submit("noemail");
        this.log("Noemail");
        this.tester.assertTextPresent("Setup Complete");
        this.navigation.login("admin");
    }

    private void doSetupStep2() {
        this.tester.assertTextPresent("Step 2 of 3: Administrator account");
        this.tester.setFormElement("username", "admin");
        this.tester.setFormElement("password", "admin");
        this.tester.setFormElement("confirm", "admin");
        this.tester.setFormElement("fullname", "Mary Magdelene");
        this.tester.setFormElement("email", "admin@example.com");
        this.tester.submit();
        this.tester.assertTextPresent("Step 3 of 3: Email Notification");
    }

    private void gotoSetupStep1() {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/Setup.jspa");
        this.tester.assertTextPresent("Step 1 of 3: Application properties");
    }
}

