/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestRememberMeCookie
extends FuncTestCase {
    private static final String USER_LAGONIL = "lagonil";
    private static final String USER_ADMIN = "admin";

    public void testRememberMeCookieWorks() {
        this.administration.restoreBlankInstance();
        this.navigation.logout();
        this.navigation.login(USER_ADMIN, USER_ADMIN);
        this.administration.usersAndGroups().addUser(USER_LAGONIL);
        this.navigation.logout();
        this.navigation.login(USER_LAGONIL, USER_LAGONIL, true);
        this.tester.assertLinkPresent("find_link");
        this.tester.assertLinkPresentWithText(USER_LAGONIL);
        String seraphCookie = this.tester.getDialog().getWebClient().getCookieValue("seraph.os.cookie");
        TestRememberMeCookie.assertFalse((String)("Found bad characters in seraph.os.cookie: " + seraphCookie), (seraphCookie.indexOf(">") >= 0 ? 1 : 0) != 0);
        TestRememberMeCookie.assertFalse((String)("Found bad characters in seraph.os.cookie: " + seraphCookie), (seraphCookie.indexOf("<") >= 0 ? 1 : 0) != 0);
        this.clearCookies();
        this.tester.beginAt("/secure/Dashboard.jspa");
        this.tester.assertLinkNotPresent("find_link");
        this.tester.assertLinkNotPresentWithText(USER_LAGONIL);
        this.clearCookies();
        this.tester.getDialog().getWebClient().addCookie("seraph.os.cookie", seraphCookie);
        this.tester.beginAt("/secure/Dashboard.jspa");
        this.tester.assertLinkPresent("find_link");
        this.tester.assertLinkPresentWithText(USER_LAGONIL);
    }

    private void clearCookies() {
        this.tester.getDialog().getWebClient().clearContents();
    }
}

