/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.JIRAWebTest;

public class TestLoginActions
extends JIRAWebTest {
    private static final String NOT_RECORDED = "Not recorded";

    public TestLoginActions(String name) {
        super(name);
    }

    public void testLoginPageWithNoPassword() {
        this.login(null, null);
        this.assertTextPresent("Sorry, your username and password are incorrect - please try again.");
    }

    public void testBadPasswordLogin() {
        this.login("admin", "bad password");
        this.assertTextPresent("Sorry, your username and password are incorrect - please try again.");
    }

    public void testLogin() {
        this.login("admin", "admin");
        this.assertRedirectPath(this.getEnvironmentData().getContext() + "/secure/Dashboard.jspa");
    }

    public void testGoodPasswordNoPermission() {
        this.restoreBlankInstance();
        this.gotoUserBrowser();
        this.clickLink("fred");
        this.clickLink("editgroups_link");
        this.selectOption("groupsToLeave", "jira-users");
        this.submit("leave");
        this.selectOption("groupsToJoin", "jira-developers");
        this.submit("join");
        this.logout();
        this.login("fred", "fred");
        this.assertTextPresent("You do not have a permission to log in.");
    }

    public void testLastLoginInfoIsShown() {
        this.administration.restoreData("TestLastLogin.xml");
        this.gotoUserBrowser();
        TableLocator tableLocator = new TableLocator(this.tester, "user_browser_table");
        this.text.assertTextSequence(tableLocator, "admin", "Today", "fred", NOT_RECORDED, "nouserpermission", NOT_RECORDED);
        this.assertViewUser("admin", true, true, 1L);
        this.assertViewUser("fred", false, false, null);
        this.assertViewUser("nouserpermission", false, false, null);
        this.loginAsAndThenAs("fred", "admin");
        this.gotoUserBrowser();
        tableLocator = new TableLocator(this.tester, "user_browser_table");
        this.text.assertTextSequence(tableLocator, "admin", "Today", "fred", "Today", "nouserpermission", NOT_RECORDED);
        this.assertViewUser("fred", true, false, 1L);
        this.assertViewUser("nouserpermission", false, false, null);
        this.loginAsAndThenAs("fred", "admin");
        this.gotoUserBrowser();
        tableLocator = new TableLocator(this.tester, "user_browser_table");
        this.text.assertTextSequence(tableLocator, "admin", "Today", "fred", "Today", "nouserpermission", NOT_RECORDED);
        this.assertViewUser("fred", true, true, 2L);
        this.assertViewUser("nouserpermission", false, false, null);
        this.loginAsAndThenAs("nouserpermission", "admin");
        this.gotoUserBrowser();
        tableLocator = new TableLocator(this.tester, "user_browser_table");
        this.text.assertTextSequence(tableLocator, "admin", "Today", "fred", "Today", "nouserpermission", NOT_RECORDED);
        this.assertViewUser("fred", true, true, 2L);
        this.assertViewUser("nouserpermission", false, false, null);
    }

    private void gotoUserBrowser() {
        this.clickLink("admin_link");
        this.clickLink("user_browser");
    }

    private void loginAsAndThenAs(String userName1, String userName2) {
        this.navigation.logout();
        this.navigation.login(userName1);
        this.navigation.logout();
        this.navigation.login(userName2);
    }

    private void assertViewUser(String name, boolean lastLoginSet, boolean prevLoginSet, Long loginCount) {
        this.gotoPage("secure/admin/user/ViewUser.jspa?name=" + name);
        this.assertNotRecorded(lastLoginSet, new XPathLocator(this.tester, "//span[@id='lastLogin']"));
        this.assertNotRecorded(prevLoginSet, new XPathLocator(this.tester, "//span[@id='previousLogin']"));
        XPathLocator pathLocator = new XPathLocator(this.tester, "//span[@id='loginCount']");
        if (loginCount != null) {
            this.text.assertTextPresent(pathLocator, String.valueOf(loginCount));
        } else {
            TestLoginActions.assertEquals((String)"The login count should be Not Recorded", (String)NOT_RECORDED, (String)pathLocator.getText());
        }
    }

    private void assertNotRecorded(boolean lastLoginSet, XPathLocator loc) {
        if (!lastLoginSet) {
            this.text.assertTextPresent(loc, NOT_RECORDED);
        } else {
            this.text.assertTextNotPresent(loc, NOT_RECORDED);
        }
    }
}

