/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.opensymphony.util.FileUtils;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestEmptyStringDataRestore
extends JIRAWebTest {
    public TestEmptyStringDataRestore(String name) {
        super(name);
    }

    public void testEmtpyStringRestore() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        boolean isOracle = new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isOracle();
        String importFileName = "TestEmptyStringDataRestore";
        String inFile = importFileName + ".xml";
        this.restoreData(inFile);
        String outFile = importFileName + "_out.xml";
        this.exportData(outFile);
        String exportedFileString = FileUtils.readFile((File)new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + FS + outFile));
        Document doc = XMLUnit.buildControlDocument((String)exportedFileString);
        this.checkXpath("10002", "10000", "admin", "comment", "Comment3", doc);
        if (isOracle) {
            this.checkXpath("10001", "10000", "admin", "comment", null, doc);
        } else {
            this.checkXpath("10001", "10000", "admin", "comment", "", doc);
        }
        this.checkXpath("10000", "10000", "admin", "comment", null, doc);
    }

    private void checkXpath(String id, String issue, String author, String type, String body, Document doc) throws TransformerException {
        if (body == null) {
            String xpath = "//entity-engine-xml/Action[@id='" + id + "'][@issue='" + issue + "'][@author='" + author + "'][@type='" + type + "'][@body]";
            TestEmptyStringDataRestore.log("Searching for non-existence of xpath " + xpath);
            XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
            xpath = "//entity-engine-xml/Action[@id='" + id + "'][@issue='" + issue + "'][@author='" + author + "'][@type='" + type + "']";
            TestEmptyStringDataRestore.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        } else if (body.length() == 0) {
            String xpath = "//entity-engine-xml/Action[@id='" + id + "'][@issue='" + issue + "'][@author='" + author + "'][@type='" + type + "'][@body='']";
            TestEmptyStringDataRestore.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        } else {
            String xpath = "//entity-engine-xml/Action[@id='" + id + "'][@issue='" + issue + "'][@author='" + author + "'][@type='" + type + "'][@body='" + body + "']";
            TestEmptyStringDataRestore.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        }
    }
}

