/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestDefaultJiraDataFromInstall
extends JIRAWebTest {
    private TextAssertions text = new TextAssertionsImpl();

    public TestDefaultJiraDataFromInstall(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void testDefaultJiraData() throws SAXException {
        this.getTestContext().setBaseUrl(this.getEnvironmentData().getBaseUrl().toExternalForm());
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        if (!this.isJiraSetup()) {
            this.init();
            this._testEnterpriseDefaultJiraPermissions();
            this._testEnterpriseDefaultNotificationSchemes();
            this._testEnterpriseDefaultScreens();
            this._testEnterpriseDefaultScreenSchemes();
            this._testEnterpriseDefaultIssueTypeScreenSchemes();
            this._testEnterpriseDefaultEventTypes();
            this._testEnterpriseDefaultFieldsVisibility();
        } else {
            TestDefaultJiraDataFromInstall.fail((String)"TestDefaultJiraDataFromInstall needs to be prior to being setup");
        }
    }

    public void _testStandardDefaultFieldsVisibility() {
        this.gotoFieldConfigurationDefault();
        this.assertField("Affects Version/s", 0, false);
        this.assertField("Assignee", 1, false);
        this.assertField("Attachment", 2, false);
        this.assertField("Component/s", 4, false);
        this.assertField("Description", 5, false);
        this.assertField("Due Date", 6, false);
        this.assertField("Environment", 7, false);
        this.assertField("Fix Version/s", 8, false);
        this.assertField("Priority", 10, false);
        this.assertField("Reporter", 11, false);
        this.assertField("Resolution", 12, false);
        this.assertTextNotPresent("Security Level");
    }

    public void _testProfessionalDefaultFieldsVisibility() {
        this.gotoFieldConfigurationDefault();
        this.assertField("Affects Version/s", 0, false);
        this.assertField("Assignee", 1, false);
        this.assertField("Attachment", 2, false);
        this.assertField("Component/s", 4, false);
        this.assertField("Description", 5, false);
        this.assertField("Due Date", 6, false);
        this.assertField("Environment", 7, false);
        this.assertField("Fix Version/s", 8, false);
        this.assertField("Priority", 10, false);
        this.assertField("Reporter", 11, false);
        this.assertField("Resolution", 12, false);
    }

    public void _testEnterpriseDefaultFieldsVisibility() {
        this.gotoFieldConfigurationDefault();
        this.assertField("Affects Version/s", 0, false);
        this.assertField("Assignee", 1, false);
        this.assertField("Attachment", 2, false);
        this.assertField("Component/s", 4, false);
        this.assertField("Description", 5, false);
        this.assertField("Due Date", 6, false);
        this.assertField("Environment", 7, false);
        this.assertField("Fix Version/s", 8, false);
        this.assertField("Priority", 10, false);
        this.assertField("Reporter", 11, false);
        this.assertField("Resolution", 12, false);
        this.assertField("Security Level", 13, false);
    }

    private void assertField(String field, int id, boolean hide) {
        this.assertTextPresent(field);
        if (hide) {
            this.assertLinkPresent("hide_" + id);
        }
    }

    public void _testEnterpriseDefaultJiraPermissions() throws SAXException {
        this.gotoPermissionSchemes();
        XPathLocator nameLocator = new XPathLocator(this.tester, "//*[@href=\"EditPermissions!default.jspa?schemeId=0\"]");
        this.text.assertTextPresent(nameLocator, "Default Permission Scheme");
        String[] strings = new String[]{"Default Permission Scheme", "This is the default Permission Scheme. Any new projects that are created will be assigned this scheme."};
        this.text.assertTextSequence(this.tester.getDialog().getResponseText(), strings);
        this.clickLinkWithText("Default Permission Scheme");
        WebTable projectPermissionsTable = this.getDialog().getResponse().getTableWithID("edit_project_permissions");
        TestDefaultJiraDataFromInstall.log("Checking project permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)4, (int)projectPermissionsTable.getRowCount());
        this.assertTableRowEquals(projectPermissionsTable, 0, new String[]{"Project Permissions", "Users / Groups / Project Roles", "Operations"});
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(projectPermissionsTable, 1, 0, "Administer Projects"));
        this.assertAdminRole(projectPermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(projectPermissionsTable, 2, 0, "Browse Projects"));
        this.assertUserRole(projectPermissionsTable, 2);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(projectPermissionsTable, 3, 0, "View Version Control"));
        this.assertDevRole(projectPermissionsTable, 3);
        WebTable issuePermissionsTable = this.getDialog().getResponse().getTableWithID("edit_issue_permissions");
        TestDefaultJiraDataFromInstall.log("Checking issue permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)13, (int)issuePermissionsTable.getRowCount());
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 1, 0, "Create Issues"));
        this.assertUserRole(issuePermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 2, 0, "Edit Issues"));
        this.assertDevRole(issuePermissionsTable, 2);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 3, 0, "Schedule Issues"));
        this.assertDevRole(issuePermissionsTable, 3);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 4, 0, "Move Issues"));
        this.assertDevRole(issuePermissionsTable, 4);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 5, 0, "Assign Issues"));
        this.assertDevRole(issuePermissionsTable, 5);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 6, 0, "Assignable User"));
        this.assertDevRole(issuePermissionsTable, 6);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 7, 0, "Resolve Issues"));
        this.assertDevRole(issuePermissionsTable, 7);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 8, 0, "Close Issues"));
        this.assertDevRole(issuePermissionsTable, 8);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 9, 0, "Modify Reporter"));
        this.assertAdminRole(issuePermissionsTable, 9);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 10, 0, "Delete Issues"));
        this.assertAdminRole(issuePermissionsTable, 10);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 11, 0, "Link Issues"));
        this.assertDevRole(issuePermissionsTable, 11);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 12, 0, "Set Issue Security"));
        this.assertNoRole(issuePermissionsTable, 12);
        WebTable commentPermissionsTable = this.getDialog().getResponse().getTableWithID("edit_comments_permissions");
        TestDefaultJiraDataFromInstall.log("Checking comments permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)6, (int)commentPermissionsTable.getRowCount());
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(commentPermissionsTable, 1, 0, "Add Comments"));
        this.assertUserRole(commentPermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(commentPermissionsTable, 2, 0, "Edit All Comments"));
        this.assertDevRole(commentPermissionsTable, 2);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(commentPermissionsTable, 3, 0, "Edit Own Comments"));
        this.assertUserRole(commentPermissionsTable, 3);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(commentPermissionsTable, 4, 0, "Delete All Comments"));
        this.assertAdminRole(commentPermissionsTable, 4);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(commentPermissionsTable, 5, 0, "Delete Own Comments"));
        this.assertUserRole(commentPermissionsTable, 5);
        WebTable timetrackingPermissionsTable = this.getDialog().getResponse().getTableWithID("edit_timetracking_permissions");
        TestDefaultJiraDataFromInstall.log("Checking time tracking permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)6, (int)timetrackingPermissionsTable.getRowCount());
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(timetrackingPermissionsTable, 1, 0, "Work On Issues"));
        this.assertDevRole(timetrackingPermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(timetrackingPermissionsTable, 2, 0, "Edit Own Worklogs"));
        this.assertUserRole(timetrackingPermissionsTable, 2);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(timetrackingPermissionsTable, 3, 0, "Edit All Worklogs"));
        this.assertDevRole(timetrackingPermissionsTable, 3);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(timetrackingPermissionsTable, 4, 0, "Delete Own Worklogs"));
        this.assertUserRole(timetrackingPermissionsTable, 4);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(timetrackingPermissionsTable, 5, 0, "Delete All Worklogs"));
        this.assertAdminRole(timetrackingPermissionsTable, 5);
        WebTable attachmentsPermissionsTable = this.getDialog().getResponse().getTableWithID("edit_attachments_permissions");
        TestDefaultJiraDataFromInstall.log("Checking attachments permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)4, (int)attachmentsPermissionsTable.getRowCount());
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(attachmentsPermissionsTable, 1, 0, "Create Attachments"));
        this.assertUserRole(attachmentsPermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(attachmentsPermissionsTable, 2, 0, "Delete All Attachments"));
        this.assertAdminRole(attachmentsPermissionsTable, 2);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(attachmentsPermissionsTable, 3, 0, "Delete Own Attachments"));
        this.assertUserRole(attachmentsPermissionsTable, 3);
        WebTable votersAndWatchersPermissionsTable = this.getDialog().getResponse().getTableWithID("edit_votersandwatchers_permissions");
        TestDefaultJiraDataFromInstall.log("Checking voters & watchers permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)3, (int)votersAndWatchersPermissionsTable.getRowCount());
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(votersAndWatchersPermissionsTable, 1, 0, "View Voters and Watchers"));
        this.assertDevRole(votersAndWatchersPermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(votersAndWatchersPermissionsTable, 2, 0, "Manage Watcher List"));
        this.assertAdminRole(votersAndWatchersPermissionsTable, 2);
        TestDefaultJiraDataFromInstall.log("Checking Global Permissions");
        this.clickOnAdminPanel("admin.globalsettings", "global_permissions");
        WebTable globalPermissionsTable = this.getDialog().getResponse().getTableWithID("global_perms");
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 1, 0, "JIRA System Administrators"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 1, 1, "jira-administrators"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 2, 0, "JIRA Administrators"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 2, 1, "jira-administrators"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 3, 0, "JIRA Users"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 3, 1, "jira-users"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 4, 0, "Browse Users"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 4, 1, "jira-developers"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 5, 0, "Create Shared Objects"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 5, 1, "jira-users"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 6, 0, "Manage Group Filter Subscriptions"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 6, 1, "jira-developers"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 7, 0, "Bulk Change"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 7, 1, "jira-users"));
    }

    private void _testEnterpriseDefaultNotificationSchemes() {
        this.tester.clickLink("admin_link");
        this.tester.clickLink("notification_schemes");
        XPathLocator nameLocator = new XPathLocator(this.tester, "//*[@href=\"EditNotifications!default.jspa?schemeId=10000\"]");
        this.text.assertTextPresent(nameLocator, "Default Notification Scheme");
    }

    private void _testEnterpriseDefaultScreens() {
        String[] strings = new String[]{"Default Screen", "Allows to update all system fields.", "Resolve Issue Screen", "Allows to set resolution, change fix versions and assign an issue.", "Workflow Screen", "This screen is used in the workflow and enables you to assign issues"};
        this.tester.clickLink("admin_link");
        this.tester.clickLink("field_screens");
        this.text.assertTextSequence(this.tester.getDialog().getResponseText(), strings);
        this.text.assertTextNotPresent(this.tester.getDialog().getResponseText(), "Assign Issue Screen");
        this.text.assertTextNotPresent(this.tester.getDialog().getResponseText(), "Allows to assign an issue.");
    }

    private void _testEnterpriseDefaultScreenSchemes() {
        String[] strings = new String[]{"Default Screen Scheme", "Default Screen Scheme"};
        this.tester.clickLink("admin_link");
        this.tester.clickLink("field_screen_scheme");
        this.text.assertTextSequence(this.tester.getDialog().getResponseText(), strings);
    }

    private void _testEnterpriseDefaultIssueTypeScreenSchemes() {
        String[] strings = new String[]{"Default Issue Type Screen Scheme", "The default issue type screen scheme"};
        this.tester.clickLink("admin_link");
        this.tester.clickLink("issue_type_screen_scheme");
        this.text.assertTextSequence(this.tester.getDialog().getResponseText(), strings);
    }

    private void _testEnterpriseDefaultEventTypes() {
        String[] strings = new String[]{"Issue Created", "This is the 'issue created' event.", "Issue Updated", "This is the 'issue updated' event.", "Issue Assigned", "This is the 'issue assigned' event.", "Issue Resolved", "This is the 'issue resolved' event.", "Issue Closed", "This is the 'issue closed' event.", "Issue Commented", "This is the 'issue commented' event.", "Issue Comment Edited", "This is the 'issue comment edited' event.", "Issue Reopened", "This is the 'issue reopened' event.", "Issue Deleted", "This is the 'issue deleted' event.", "Issue Moved", "This is the 'issue moved' event.", "Work Logged On Issue", "This is the 'work logged on issue' event.", "Work Started On Issue", "This is the 'work started on issue' event.", "Work Stopped On Issue", "This is the 'work stopped on issue' event.", "Issue Worklog Updated", "This is the 'issue worklog updated' event.", "Issue Worklog Deleted", "This is the 'issue worklog deleted' event.", "Generic Event", "This is the 'generic event' event."};
        this.tester.clickLink("admin_link");
        this.tester.clickLink("eventtypes");
        this.text.assertTextSequence(this.tester.getDialog().getResponseText(), strings);
    }

    public void _testProfessionalDefaultJiraPermissions() throws SAXException {
        this.gotoPermissionSchemes();
        this.clickLinkWithText("Default Permission Scheme");
        WebTable projectPermissionsTable = this.getDialog().getResponse().getTableWithID("edit_project_permissions");
        TestDefaultJiraDataFromInstall.log("Checking project permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)4, (int)projectPermissionsTable.getRowCount());
        this.assertTableRowEquals(projectPermissionsTable, 0, new String[]{"Project Permissions", "Groups / Project Roles", "Operations"});
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(projectPermissionsTable, 1, 0, "Administer Projects"));
        this.assertAdminRole(projectPermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(projectPermissionsTable, 2, 0, "Browse Projects"));
        this.assertUserRole(projectPermissionsTable, 2);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(projectPermissionsTable, 3, 0, "View Version Control"));
        this.assertDevRole(projectPermissionsTable, 3);
        WebTable issuePermissionsTable = this.getDialog().getResponse().getTableWithID("edit_issue_permissions");
        TestDefaultJiraDataFromInstall.log("Checking issue permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)12, (int)issuePermissionsTable.getRowCount());
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 1, 0, "Create Issues"));
        this.assertUserRole(issuePermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 2, 0, "Edit Issues"));
        this.assertDevRole(issuePermissionsTable, 2);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 3, 0, "Schedule Issues"));
        this.assertDevRole(issuePermissionsTable, 3);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 4, 0, "Move Issues"));
        this.assertDevRole(issuePermissionsTable, 4);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 5, 0, "Assign Issues"));
        this.assertDevRole(issuePermissionsTable, 5);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 6, 0, "Assignable User"));
        this.assertDevRole(issuePermissionsTable, 6);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 7, 0, "Resolve Issues"));
        this.assertDevRole(issuePermissionsTable, 7);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 8, 0, "Close Issues"));
        this.assertDevRole(issuePermissionsTable, 8);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 9, 0, "Modify Reporter"));
        this.assertAdminRole(issuePermissionsTable, 9);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 10, 0, "Delete Issues"));
        this.assertAdminRole(issuePermissionsTable, 10);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 11, 0, "Link Issues"));
        this.assertDevRole(issuePermissionsTable, 11);
        WebTable commentPermissionsTable = this.getDialog().getResponse().getTableWithID("edit_comments_permissions");
        TestDefaultJiraDataFromInstall.log("Checking comments permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)6, (int)commentPermissionsTable.getRowCount());
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(commentPermissionsTable, 1, 0, "Add Comments"));
        this.assertUserRole(commentPermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(commentPermissionsTable, 2, 0, "Edit All Comments"));
        this.assertDevRole(commentPermissionsTable, 2);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(commentPermissionsTable, 3, 0, "Edit Own Comments"));
        this.assertUserRole(commentPermissionsTable, 3);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(commentPermissionsTable, 4, 0, "Delete All Comments"));
        this.assertAdminRole(commentPermissionsTable, 4);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(commentPermissionsTable, 5, 0, "Delete Own Comments"));
        this.assertUserRole(commentPermissionsTable, 5);
        WebTable timetrackingPermissionsTable = this.getDialog().getResponse().getTableWithID("edit_timetracking_permissions");
        TestDefaultJiraDataFromInstall.log("Checking time tracking permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)6, (int)timetrackingPermissionsTable.getRowCount());
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(timetrackingPermissionsTable, 1, 0, "Work On Issues"));
        this.assertDevRole(timetrackingPermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(timetrackingPermissionsTable, 2, 0, "Edit Own Worklogs"));
        this.assertUserRole(timetrackingPermissionsTable, 2);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(timetrackingPermissionsTable, 3, 0, "Edit All Worklogs"));
        this.assertDevRole(timetrackingPermissionsTable, 3);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(timetrackingPermissionsTable, 4, 0, "Delete Own Worklogs"));
        this.assertUserRole(timetrackingPermissionsTable, 4);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(timetrackingPermissionsTable, 5, 0, "Delete All Worklogs"));
        this.assertAdminRole(timetrackingPermissionsTable, 5);
        WebTable attachmentsPermissionsTable = this.getDialog().getResponse().getTableWithID("edit_attachments_permissions");
        TestDefaultJiraDataFromInstall.log("Checking attachments permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)4, (int)attachmentsPermissionsTable.getRowCount());
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(attachmentsPermissionsTable, 1, 0, "Create Attachments"));
        this.assertUserRole(attachmentsPermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(attachmentsPermissionsTable, 2, 0, "Delete All Attachments"));
        this.assertAdminRole(attachmentsPermissionsTable, 2);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(attachmentsPermissionsTable, 3, 0, "Delete Own Attachments"));
        this.assertUserRole(attachmentsPermissionsTable, 3);
        WebTable votersAndWatchersPermissionsTable = this.getDialog().getResponse().getTableWithID("edit_votersandwatchers_permissions");
        TestDefaultJiraDataFromInstall.log("Checking voters & watchers permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)3, (int)votersAndWatchersPermissionsTable.getRowCount());
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(votersAndWatchersPermissionsTable, 1, 0, "View Voters and Watchers"));
        this.assertDevRole(votersAndWatchersPermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(votersAndWatchersPermissionsTable, 2, 0, "Manage Watcher List"));
        this.assertAdminRole(votersAndWatchersPermissionsTable, 2);
        TestDefaultJiraDataFromInstall.log("Checking Global Permissions");
        this.clickOnAdminPanel("admin.globalsettings", "global_permissions");
        WebTable globalPermissionsTable = this.getDialog().getResponse().getTableWithID("global_perms");
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 1, 0, "JIRA System Administrators"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 1, 1, "jira-administrators"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 2, 0, "JIRA Administrators"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 2, 1, "jira-administrators"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 3, 0, "JIRA Users"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 3, 1, "jira-users"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 4, 0, "Browse Users"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 4, 1, "jira-developers"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 5, 0, "Create Shared Objects"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 5, 1, "jira-users"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 6, 0, "Manage Group Filter Subscriptions"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 6, 1, "jira-developers"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 7, 0, "Bulk Change"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 7, 1, "jira-users"));
    }

    public void _testStandardDefaultJiraPermissions() throws SAXException {
        this.gotoPermissionSchemes();
        this.clickLinkWithText("Default Permission Scheme");
        WebTable projectPermissionsTable = this.getDialog().getResponse().getTableWithID("edit_project_permissions");
        TestDefaultJiraDataFromInstall.log("Checking project permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)4, (int)projectPermissionsTable.getRowCount());
        this.assertTableRowEquals(projectPermissionsTable, 0, new String[]{"Project Permissions", "Groups / Project Roles", "Operations"});
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(projectPermissionsTable, 1, 0, "Administer Projects"));
        this.assertAdminRole(projectPermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(projectPermissionsTable, 2, 0, "Browse Projects"));
        this.assertUserRole(projectPermissionsTable, 2);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(projectPermissionsTable, 3, 0, "View Version Control"));
        this.assertDevRole(projectPermissionsTable, 3);
        WebTable issuePermissionsTable = this.getDialog().getResponse().getTableWithID("edit_issue_permissions");
        TestDefaultJiraDataFromInstall.log("Checking issue permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)12, (int)issuePermissionsTable.getRowCount());
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 1, 0, "Create Issues"));
        this.assertUserRole(issuePermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 2, 0, "Edit Issues"));
        this.assertDevRole(issuePermissionsTable, 2);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 3, 0, "Schedule Issues"));
        this.assertDevRole(issuePermissionsTable, 3);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 4, 0, "Move Issues"));
        this.assertDevRole(issuePermissionsTable, 4);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 5, 0, "Assign Issues"));
        this.assertDevRole(issuePermissionsTable, 5);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 6, 0, "Assignable User"));
        this.assertDevRole(issuePermissionsTable, 6);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 7, 0, "Resolve Issues"));
        this.assertDevRole(issuePermissionsTable, 7);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 8, 0, "Close Issues"));
        this.assertDevRole(issuePermissionsTable, 8);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 9, 0, "Modify Reporter"));
        this.assertAdminRole(issuePermissionsTable, 9);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 10, 0, "Delete Issues"));
        this.assertAdminRole(issuePermissionsTable, 10);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(issuePermissionsTable, 11, 0, "Link Issues"));
        this.assertDevRole(issuePermissionsTable, 11);
        WebTable commentPermissionsTable = this.getDialog().getResponse().getTableWithID("edit_comments_permissions");
        TestDefaultJiraDataFromInstall.log("Checking comments permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)6, (int)commentPermissionsTable.getRowCount());
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(commentPermissionsTable, 1, 0, "Add Comments"));
        this.assertUserRole(commentPermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(commentPermissionsTable, 2, 0, "Edit All Comments"));
        this.assertDevRole(commentPermissionsTable, 2);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(commentPermissionsTable, 3, 0, "Edit Own Comments"));
        this.assertUserRole(commentPermissionsTable, 3);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(commentPermissionsTable, 4, 0, "Delete All Comments"));
        this.assertAdminRole(commentPermissionsTable, 4);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(commentPermissionsTable, 5, 0, "Delete Own Comments"));
        this.assertUserRole(commentPermissionsTable, 5);
        WebTable timetrackingPermissionsTable = this.getDialog().getResponse().getTableWithID("edit_timetracking_permissions");
        TestDefaultJiraDataFromInstall.log("Checking time tracking permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)6, (int)timetrackingPermissionsTable.getRowCount());
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(timetrackingPermissionsTable, 1, 0, "Work On Issues"));
        this.assertDevRole(timetrackingPermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(timetrackingPermissionsTable, 2, 0, "Edit Own Worklogs"));
        this.assertUserRole(timetrackingPermissionsTable, 2);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(timetrackingPermissionsTable, 3, 0, "Edit All Worklogs"));
        this.assertDevRole(timetrackingPermissionsTable, 3);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(timetrackingPermissionsTable, 4, 0, "Delete Own Worklogs"));
        this.assertUserRole(timetrackingPermissionsTable, 4);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(timetrackingPermissionsTable, 5, 0, "Delete All Worklogs"));
        this.assertAdminRole(timetrackingPermissionsTable, 5);
        WebTable attachmentsPermissionsTable = this.getDialog().getResponse().getTableWithID("edit_attachments_permissions");
        TestDefaultJiraDataFromInstall.log("Checking attachments permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)4, (int)attachmentsPermissionsTable.getRowCount());
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(attachmentsPermissionsTable, 1, 0, "Create Attachments"));
        this.assertUserRole(attachmentsPermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(attachmentsPermissionsTable, 2, 0, "Delete All Attachments"));
        this.assertAdminRole(attachmentsPermissionsTable, 2);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(attachmentsPermissionsTable, 3, 0, "Delete Own Attachments"));
        this.assertUserRole(attachmentsPermissionsTable, 3);
        WebTable votersAndWatchersPermissionsTable = this.getDialog().getResponse().getTableWithID("edit_votersandwatchers_permissions");
        TestDefaultJiraDataFromInstall.log("Checking voters & watchers permissions table row count");
        TestDefaultJiraDataFromInstall.assertEquals((int)3, (int)votersAndWatchersPermissionsTable.getRowCount());
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(votersAndWatchersPermissionsTable, 1, 0, "View Voters and Watchers"));
        this.assertDevRole(votersAndWatchersPermissionsTable, 1);
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(votersAndWatchersPermissionsTable, 2, 0, "Manage Watcher List"));
        this.assertAdminRole(votersAndWatchersPermissionsTable, 2);
        TestDefaultJiraDataFromInstall.log("Checking Global Permissions");
        this.clickOnAdminPanel("admin.globalsettings", "global_permissions");
        WebTable globalPermissionsTable = this.getDialog().getResponse().getTableWithID("global_perms");
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 1, 0, "JIRA System Administrators"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 1, 1, "jira-administrators"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 2, 0, "JIRA Administrators"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 2, 1, "jira-administrators"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 3, 0, "JIRA Users"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 3, 1, "jira-users"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 4, 0, "Browse Users"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 4, 1, "jira-developers"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 5, 0, "Bulk Change"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(globalPermissionsTable, 5, 1, "jira-users"));
    }

    private void assertAdminRole(WebTable permissionsTable, int row) {
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(permissionsTable, row, 1, "(Administrators)"));
    }

    private void assertUserRole(WebTable permissionsTable, int row) {
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(permissionsTable, row, 1, "(Users)"));
    }

    private void assertDevRole(WebTable permissionsTable, int row) {
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellHasText(permissionsTable, row, 1, "(Developers)"));
    }

    private void assertNoRole(WebTable permissionsTable, int row) {
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellDoesNotHaveText(permissionsTable, row, 1, "(Administrators)"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellDoesNotHaveText(permissionsTable, row, 1, "(Users)"));
        TestDefaultJiraDataFromInstall.assertTrue((boolean)this.tableCellDoesNotHaveText(permissionsTable, row, 1, "(Developers)"));
    }
}

