/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.license;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.LicenseKeys;

public class TestUserLimitedLicense
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testCreateIssueOverLicenseLimit_Starter() {
        this._testCreateIssueOverLicenseLimit(LicenseKeys.V2_STARTER);
    }

    public void testCreateIssueOverLicenseLimit_CommercialLimited() {
        this._testCreateIssueOverLicenseLimit(LicenseKeys.V2_COMMERCIAL_LIMITED);
    }

    private void _testCreateIssueOverLicenseLimit(LicenseKeys.License license) {
        this.administration.switchToLicense(license);
        this.tester.clickLink("create_link");
        this.tester.submit("Next>>");
        this.tester.setFormElement("summary", "A little bug");
        this.tester.submit("Create");
        this.tester.assertTextPresent("A little bug");
        this.tester.assertTextPresent("Issue Details");
        this.administration.usersAndGroups().addUser("bob");
        this.tester.clickLink("create_link");
        this.tester.submit("Next>>");
        this.tester.setFormElement("summary", "This is a big one!");
        this.tester.submit("Create");
        this.tester.assertTextPresent("This is a big one!");
        this.tester.assertTextPresent("Issue Details");
        this.administration.restoreData("TestStarterLicenseTooManyUsers.xml");
        this.administration.switchToLicense(license);
        this.tester.clickLink("create_link");
        this.tester.assertTextPresent("You cannot create new issues at this time, as the user limit for JIRA has been exceeded. Please contact your JIRA administrators for further assistance.");
        this.tester.gotoPage("/secure/CreateIssueDetails.jspa");
        this.tester.assertTextPresent("You cannot create new issues at this time, as the user limit for JIRA has been exceeded. Please contact your JIRA administrators for further assistance.");
        this.tester.assertTextNotPresent("Issue Details");
        this.navigation.gotoAdmin();
        this.tester.clickLink("user_browser");
        this.tester.clickLink("editgroups_michael");
        this.tester.selectOption("groupsToLeave", "jira-users");
        this.tester.submit("leave");
        this.tester.clickLink("create_link");
        this.tester.submit("Next>>");
        this.tester.setFormElement("summary", "Let's create another bug!");
        this.tester.submit("Create");
        this.tester.assertTextPresent("Let's create another bug!");
        this.tester.assertTextPresent("Issue Details");
    }

    public void testAddUserOverLimitShowsWarning_Starter() {
        this._testAddUserOverLimitShowsWarning(LicenseKeys.V2_STARTER);
    }

    public void testAddUserOverLimitShowsWarning_CommercialLimited() {
        this._testAddUserOverLimitShowsWarning(LicenseKeys.V2_COMMERCIAL_LIMITED);
    }

    private void _testAddUserOverLimitShowsWarning(LicenseKeys.License license) {
        this.administration.switchToLicense(license);
        this.addUsersWhileUnderTheLimit("devman");
        this.addUsersWhileUnderTheLimit("prodman");
        this.addUsersWhileUnderTheLimit("fatman");
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("add_user");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Creating a new user will exceed the number of users allowed to use JIRA under your license.");
        this.tester.setFormElement("username", "barney");
        this.tester.setFormElement("password", "barney");
        this.tester.setFormElement("confirm", "barney");
        this.tester.setFormElement("fullname", "Barney");
        this.tester.setFormElement("email", "barney@example.com");
        this.tester.submit("Create");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "jira-users");
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.navigation.login("barney", "barney");
        this.tester.assertTextPresent("You do not have a permission to log in");
    }

    private void addUsersWhileUnderTheLimit(String userName) {
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("add_user");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "Creating a new user will exceed the number of users allowed to use JIRA under your license.");
        this.tester.setFormElement("username", userName);
        this.tester.setFormElement("password", userName);
        this.tester.setFormElement("confirm", userName);
        this.tester.setFormElement("fullname", userName);
        this.tester.setFormElement("email", userName + "@example.com");
        this.tester.submit("Create");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Groups:", "jira-users"});
    }

    public void testDeleteUserClearsActiveUserCount_Starter() {
        this._testDeleteUserClearsActiveUserCount(LicenseKeys.V2_STARTER);
    }

    public void testDeleteUserClearsActiveUserCount_CommercialLimited() {
        this._testDeleteUserClearsActiveUserCount(LicenseKeys.V2_COMMERCIAL_LIMITED);
    }

    private void _testDeleteUserClearsActiveUserCount(LicenseKeys.License license) {
        this.administration.switchToLicense(license);
        this.navigation.gotoAdminSection("license_details");
        this.tester.assertTextPresent("2 currently active");
        this.administration.usersAndGroups().deleteUser("fred");
        this.navigation.gotoAdminSection("license_details");
        this.tester.assertTextPresent("1 currently active");
    }

    public void testModifyGlobalPermissionsShowsWarning_Starter() {
        this._testModifyGlobalPermissionsShowsWarning(LicenseKeys.V2_STARTER);
    }

    public void testModifyGlobalPermissionsShowsWarning_CommercialLimited() {
        this._testModifyGlobalPermissionsShowsWarning(LicenseKeys.V2_COMMERCIAL_LIMITED);
    }

    private void _testModifyGlobalPermissionsShowsWarning(LicenseKeys.License license) {
        this.administration.restoreData("TestStarterLicenseGlobalPermissions.xml");
        this.administration.switchToLicense(license);
        this.navigation.gotoAdminSection("global_permissions");
        this.tester.assertTextPresent("Global Permissions");
        this.tester.assertTextPresent("These permissions apply to all projects. They are independent of project specific permissions.");
        this.tester.assertTextNotPresent("You have exceeded the number of users allowed to use JIRA under");
        this.administration.addGlobalPermission(1, "jira-developers");
        this.tester.assertTextPresent("You have exceeded the number of users allowed to use JIRA under");
        this.administration.removeGlobalPermission(1, "jira-developers");
        this.tester.assertTextNotPresent("You have exceeded the number of users allowed to use JIRA under");
    }

    public void testLicenseCanSubmitSupportRequest_Starter() {
        this._testLicenseCanSubmitSupportRequest(LicenseKeys.V2_STARTER);
    }

    public void testLicenseCanSubmitSupportRequest_CommercialLimited() {
        this._testLicenseCanSubmitSupportRequest(LicenseKeys.V2_COMMERCIAL_LIMITED);
    }

    private void _testLicenseCanSubmitSupportRequest(LicenseKeys.License license) {
        this.administration.switchToLicense(license);
        this.addUsersWhileUnderTheLimit("devman");
        this.addUsersWhileUnderTheLimit("prodman");
        this.addMailServerConfig();
        this.navigation.gotoAdminSection("support_request");
        this.tester.assertTextPresent("Please enter the details of your support problem here");
        String desc = license.getDescription();
        this.text.assertTextSequence(new XPathLocator(this.tester, "//table[@id='support_req_env']"), new String[]{"License Type", desc, "User Limit", "5 (4 currently active)"});
    }

    private void addMailServerConfig() {
        this.tester.clickLink("admin_link");
        this.tester.clickLink("mail_servers");
        this.tester.clickLinkWithText("Configure new SMTP mail server");
        this.tester.setFormElement("name", "mail");
        this.tester.setFormElement("description", "");
        this.tester.setFormElement("from", "mail_jira@example.com");
        this.tester.setFormElement("prefix", "JIRA:");
        this.tester.setFormElement("serverName", "localhost");
        this.tester.submit(" Add ");
    }

    public void testSignupOverLicenseLimit_Starter() {
        this._testSignupOverLicenseLimit(LicenseKeys.V2_STARTER);
    }

    public void testSignupOverLicenseLimit_CommercialLimited() {
        this._testSignupOverLicenseLimit(LicenseKeys.V2_COMMERCIAL_LIMITED);
    }

    private void _testSignupOverLicenseLimit(LicenseKeys.License license) {
        this.administration.switchToLicense(license);
        this.addUsersWhileUnderTheLimit("dudeman");
        this.addUsersWhileUnderTheLimit("prodman");
        this.navigation.logout();
        this.tester.gotoPage("login.jsp");
        this.tester.clickLink("signup");
        this.tester.setFormElement("username", "devman");
        this.tester.setFormElement("password", "devman");
        this.tester.setFormElement("confirm", "devman");
        this.tester.setFormElement("fullname", "Devman");
        this.tester.setFormElement("email", "devman@example.com");
        this.tester.submit("Sign up");
        this.tester.assertTextPresent("You have successfully signed up. If you forget your password, you can have it emailed to you.");
        this.tester.clickLinkWithText("Click here to log in");
        this.navigation.login("devman", "devman");
        XPathLocator anchorLocator = new XPathLocator(this.tester, "//div[@id='header-details-user']/a");
        this.text.assertTextPresent(anchorLocator, "Devman");
        this.navigation.logout();
        this.tester.gotoPage("login.jsp");
        this.tester.clickLink("signup");
        this.tester.assertTextPresent("You cannot sign up at this time, as the user limit for JIRA has been exceeded.");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Please contact your JIRA administrators for further assistance.");
        this.tester.gotoPage("/secure/Signup.jspa");
        this.tester.assertTextPresent("You cannot sign up at this time, as the user limit for JIRA has been exceeded.");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Please contact your JIRA administrators for further assistance.");
    }
}

