/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.trackbacks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;

public class TestTrackbackSending
extends FuncTestCase {
    private static final int MAX_WAIT_COUNT = 10;

    protected void setUpTest() {
        this.administration.restoreData("TestTrackbackSending.xml");
    }

    public void testCreateTrackBack() throws Exception {
        int waitCount;
        String baseURL = this.get127_0_0_1_BaseURL();
        String trackbackDesc = "This links back to " + baseURL + "/browse/TRACKBACK-3 with some russian \\u041a\\u043e\\u043c\\u043f\\u043e\\u043d\\u0435\\u043d\\u0442\\u044b just for good measure";
        this.navigation.issue().viewIssue("TRACKBACK-1");
        this.tester.clickLink("edit_issue");
        this.tester.setFormElement("description", trackbackDesc);
        this.tester.submit("Update");
        this.tester.clickLink("admin_link");
        this.tester.clickLink("mail_queue");
        this.tester.clickLinkWithText("Flush mail queue");
        this.navigation.issue().viewIssue("TRACKBACK-3");
        for (waitCount = 0; waitCount < 10; ++waitCount) {
            XPathLocator locator = new XPathLocator(this.tester, "//div[@class='trackbackexcerpt']");
            String trackbackText = locator.getText();
            if (trackbackText.length() > 0) {
                this.text.assertTextPresent(trackbackText, trackbackDesc);
                break;
            }
            Thread.sleep(500L);
        }
        if (waitCount >= 10) {
            TestTrackbackSending.fail((String)"The trackback did not turn up in time.  Its most likely the mail queue failed to flush.  email and trackbacks must be enabled!");
        }
    }

    private String get127_0_0_1_BaseURL() {
        JIRAEnvironmentData data = this.getEnvironmentData();
        StringBuffer sb = new StringBuffer();
        sb.append(data.getProperty("jira.protocol"));
        String hostName = data.getProperty("jira.host");
        hostName = hostName.equals("127.0.0.1") ? "localhost" : "127.0.0.1";
        sb.append("://");
        sb.append(hostName);
        sb.append(":");
        sb.append(data.getProperty("jira.port"));
        sb.append(data.getProperty("jira.context"));
        return sb.toString();
    }
}

