/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import net.sourceforge.jwebunit.ExpectedRow;
import net.sourceforge.jwebunit.ExpectedTable;

public class TestPromptUserForSecurityLevelOnMove
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreData("TestPromptUserForSecurityLevelOnMove.xml");
    }

    public void testMoveIssueType_Issue_RequiresSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issue().viewIssue("RAT-10");
        this.tester.clickLink("move_issue");
        this.tester.assertTextPresent("Choose the project and issue type to move to");
        this.tester.selectOption("issuetype", "New Feature");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Update the fields of the issue to relate to the new project.");
        this.tester.assertOptionEquals("security", "Level Mouse");
    }

    public void testMoveIssueType_Issue_DoesntRequireSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issue().viewIssue("RAT-10");
        this.tester.clickLink("move_issue");
        this.tester.assertTextPresent("Choose the project and issue type to move to");
        this.tester.selectOption("issuetype", "Improvement");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Update the fields of the issue to relate to the new project.");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextNotPresent("Security Level");
    }

    public void testMoveIssueType_Subtask_RequiresSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-14");
        this.tester.clickLink("move_issue");
        this.tester.checkCheckbox("operation", "move.subtask.type.operation.name");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Update the fields of the sub-task to relate to the new sub-task type.");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("The security level of subtasks is inherited from parents.");
    }

    public void testBulkMoveIssueType_Issue_RequiresSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("bulkedit_all");
        this.tester.checkCheckbox("bulkedit_10050", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.tester.selectOption("10022_1_issuetype", "New Feature");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Rattus' - Issue Type 'New Feature'");
        this.tester.assertTextPresent("*Security Level");
        this.tester.assertFormElementPresent("security");
    }

    public void testBulkMoveIssueType_Issue_DoesntRequireSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("bulkedit_all");
        this.tester.checkCheckbox("bulkedit_10050", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.tester.selectOption("10022_1_issuetype", "Improvement");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Rattus' - Issue Type 'Improvement'");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextNotPresent("Security Level");
    }

    public void testBulkMoveIssueType_Subtask_RequiresSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("bulkedit_all");
        this.tester.checkCheckbox("bulkedit_10060", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.tester.selectOption("10022_5_10022_issuetype", "Secure Sub-task");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Rattus' - Issue Type 'Secure Sub-task'");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("The security level of subtasks is inherited from parents.");
    }

    public void testMoveProject_Issue_RequiresSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-13");
        this.tester.clickLink("move_issue");
        this.tester.selectOption("pid", "Canine");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Update the fields of the issue to relate to the new project.");
        this.tester.assertTextPresent("Security Level:");
        this.tester.assertFormElementPresent("security");
        this.tester.selectOption("security", "Level Amber");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Step 4 of 4");
        this.tester.assertTextPresent("Confirm the move with all of the details you have just configured.");
    }

    public void testMoveProject_Issue_DoesntRequireSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-13");
        this.tester.clickLink("move_issue");
        this.tester.selectOption("pid", "Porcine");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Update the fields of the issue to relate to the new project.");
        this.tester.assertTextNotPresent("Security");
        this.tester.assertFormElementNotPresent("security");
    }

    public void testMoveProject_Issue_SecurityLevelInvalid() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-12");
        this.tester.clickLink("move_issue");
        this.tester.selectOption("pid", "Canine");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Security Level:");
        this.tester.assertFormElementPresent("security");
        this.tester.selectOption("security", "Level Green");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Confirm the move with all of the details you have just configured.");
        this.tester.assertTextPresent("Sub-Tasks associated with this issue will lose data stored in fields not applicable in the target.");
    }

    public void testMoveProject_Issue_SecurityLevelNotAvailableToUser() {
    }

    public void testMoveProject_Issue_SecurityLevelAvailableToUser() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-20");
        this.tester.clickLink("edit_issue");
        this.tester.selectOption("security", "Level Mouse");
        this.tester.submit("Update");
        this.tester.clickLink("move_issue");
        this.tester.selectOption("pid", "Bovine");
        this.tester.submit("Next >>");
        this.tester.assertFormElementNotPresent("security");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Confirm the move with all of the details you have just configured.");
        ExpectedTable expectedTable = new ExpectedTable();
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"", "Original Value (before move)", "New Value (after move)"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"Project", "Rattus", "Bovine"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"Type", "Bug", "Bug"}));
        this.tester.assertTableEquals("move_confirm_table", expectedTable);
    }

    public void testBulkMoveProject_Issue_RequiresSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("bulkedit_all");
        this.tester.checkCheckbox("bulkedit_10050", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Choose the operation you wish to perform");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.tester.selectOption("10022_1_pid", "Canine");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.tester.selectOption("10022_5_10020_issuetype", "Secure Sub-task");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Canine' - Issue Type 'Bug'");
        this.tester.assertTextPresent("Security Level:");
        this.tester.assertFormElementPresent("security");
        this.tester.selectOption("security", "Level Red");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Canine' - Issue Type 'Secure Sub-task'");
        this.tester.assertTextPresent("Fix Version/s:");
        this.tester.assertTextPresent("Affects Version/s:");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("The security level of subtasks is inherited from parents.");
    }

    public void testBulkMoveProject_Issue_DoesntRequireSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("bulkedit_all");
        this.tester.checkCheckbox("bulkedit_10050", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Choose the operation you wish to perform");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.tester.selectOption("10022_1_pid", "Porcine");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.tester.selectOption("10022_5_10021_issuetype", "Secure Sub-task");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Porcine' - Issue Type 'Bug'");
        this.tester.assertTextNotPresent("Security Level:");
        this.tester.assertFormElementNotPresent("security");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Porcine' - Issue Type 'Secure Sub-task'");
        this.tester.assertTextPresent("Fix Version/s:");
        this.tester.assertTextPresent("Affects Version/s:");
        this.tester.assertTextNotPresent("Security Level:");
        this.tester.assertFormElementNotPresent("security");
    }

    public void testBulkMoveProject_Issue_SecurityLevelInvalid() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("bulkedit_all");
        this.tester.checkCheckbox("bulkedit_10040", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Choose the operation you wish to perform");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.tester.selectOption("10022_1_pid", "Canine");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Canine' - Issue Type 'Bug'");
        this.tester.assertTextPresent("Security Level:");
        this.tester.assertFormElementPresent("security");
        this.tester.selectOption("security", "Level Green");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Canine' - Issue Type 'Sub-task'");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("The security level of subtasks is inherited from parents.");
    }

    public void testBulkMoveProject_Issue_SecurityLevelNotAvailableToUser() {
    }

    public void testBulkMoveProject_Issue_SecurityLevelAvailableToUser() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-20");
        this.tester.clickLink("edit_issue");
        this.tester.selectOption("security", "Level Mouse");
        this.tester.submit("Update");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("bulkedit_all");
        this.tester.checkCheckbox("bulkedit_10100", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Choose the operation you wish to perform");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.tester.selectOption("10022_1_pid", "Bovine");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.tester.selectOption("10022_6_10000_issuetype", "Sub-task");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Bovine' - Issue Type 'Bug'");
        this.tester.assertTextNotPresent("Security Level:");
        this.tester.assertFormElementNotPresent("security");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Bovine' - Issue Type 'Sub-task'");
        this.tester.assertTextNotPresent("Security Level:");
        this.tester.assertFormElementNotPresent("security");
    }

    public void testBulkMigrate_SecurityNotRequired() {
        this.tester.clickLink("admin_link");
        this.tester.clickLink("view_projects");
        this.tester.clickLinkWithText("Rattus");
        this.tester.clickLink("selectIssueTypeScheme");
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "Bugless Scheme");
        this.tester.assertTextPresent("Select Issue Type Scheme for project Rattus");
        this.tester.submit(" OK ");
        this.tester.assertTextPresent("Issue Type Migration: Overview (Step 1 of 6)");
        this.tester.assertTextPresent("Some issues have issue types that are no longer applicable. You will need to move these issues to another issue type.");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Select a new issue type for issues with current issue type Bug in project Rattus");
        this.tester.selectOption("issuetype", "Task");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Update fields for issues with current issue type Bug in project Rattus.");
        this.tester.assertTextPresent("All field values will be retained.");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Select a new issue type for issues with current issue type Sub-task in project Rattus");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Update fields for issues with current issue type Sub-task in project Rattus.");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("The security level of subtasks is inherited from parents.");
    }

    public void testBulkMigrate_SecurityRequired() {
        this.tester.clickLink("admin_link");
        this.tester.clickLinkWithText("Rattus");
        this.tester.clickLink("selectIssueTypeScheme");
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "Bugless Scheme");
        this.tester.submit(" OK ");
        this.tester.assertTextPresent("Issue Type Migration: Overview (Step 1 of 6)");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Select a new issue type for issues with current issue type Bug in project Rattus");
        this.tester.selectOption("issuetype", "New Feature");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Update fields for issues with current issue type Bug in project Rattus.");
        this.tester.assertTextPresent("Security Level:");
        this.tester.assertFormElementPresent("security");
        this.tester.selectOption("security", "Level Mouse");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Select a new issue type for issues with current issue type Sub-task in project Rattus");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Update fields for issues with current issue type Sub-task in project Rattus.");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("The security level of subtasks is inherited from parents.");
    }

    public void testConvertIssueToSubtask() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-10");
        this.tester.clickLink("issue_to_subtask");
        this.tester.setFormElement("parentIssueKey", "RAT-13");
        this.tester.assertTextPresent("Convert Issue to Sub-task: RAT-10");
        this.tester.selectOption("issuetype", "Secure Sub-task");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Convert Issue to Sub-task: RAT-10");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Step 3 of 4: Update the fields of the issue to relate to the new issue type ...");
        this.tester.assertTextPresent("All fields will be updated automatically.");
    }

    public void testConvertSubtaskWithoutSecurityToIssueThatRequiresSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-14");
        this.tester.clickLink("subtask_to_issue");
        this.tester.assertTextPresent("Convert Sub-task to Issue: RAT-14");
        this.tester.selectOption("issuetype", "New Feature");
        this.tester.submit("Next >>");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Step 3 of 4: Update the fields of the issue to relate to the new issue type ...");
        this.tester.assertTextPresent("Security Level:");
        this.tester.assertFormElementPresent("security");
    }

    public void testConvertSubtaskWithSecurityToIssueThatRequiresSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-14");
        this.tester.clickLink("subtask_to_issue");
        this.tester.assertTextPresent("Convert Sub-task to Issue: RAT-14");
        this.tester.selectOption("issuetype", "Task");
        this.tester.submit("Next >>");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Step 3 of 4: Update the fields of the issue to relate to the new issue type ...");
        this.tester.assertTextNotPresent("Security Level:");
        this.tester.assertFormElementNotPresent("security");
    }
}

