/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.webtests.JIRAWebTest;
import org.xml.sax.SAXException;

public class TestMoveIssue
extends JIRAWebTest {
    private static final String ISSUE_KEY_TO_MOVE = "HSP-1";
    private static final String ISSUE_KEY_NORMAL = "HSP-2";
    private static final String ANA_3 = "ANA-3";
    private static final String CURRENT_ISSUE_TYPE = "Current Issue Type";
    private static final String ANOTHER_TEST_PROJECT = "another test";
    private static final String NEW_ISSUE_TYPE = "New Issue Type";
    private static final String MORE_TESTS_ISSUE_TYPE = "more tests";
    private static final String ISSUETYPE_REQUEST_PARAM = "issuetype";
    private static final String PID_REQUEST_PARAM = "pid";
    private static final String JIRAFORM = "jiraform";
    private static final String MOVE_SUBMIT = "Move";
    private static final String RESULTING_ISSUE_TST_3 = "TST-3";
    private static final String TEST_PROJECT = "Test";
    private static final String MOVE_ISSUE_LINK = "move_issue";

    public TestMoveIssue(String name) {
        super(name);
    }

    public void testMoveIssue() {
        this.restoreData("TestMoveIssue.xml");
        this.moveOperationFunctionality(ISSUE_KEY_TO_MOVE);
        this.moveOperationWithMoveIssuesPermission(ISSUE_KEY_NORMAL);
        this.moveOperationWithInvalidDueDate(ISSUE_KEY_NORMAL);
        this.moveOperationWithDueDateRequired(ISSUE_KEY_NORMAL);
        this.moveOperationWithRequiredFields(ISSUE_KEY_NORMAL);
        this.moveIssueWithAssignableUser(ISSUE_KEY_NORMAL);
        this.deleteIssue(ISSUE_KEY_NORMAL);
        this.deleteIssue(ISSUE_KEY_TO_MOVE);
    }

    public void testMoveIssueIssueTypeAvailable() {
        TestMoveIssue.log("Move Operation: Test the visibility of the Issue Type field on move.");
        this.restoreData("TestMoveIssueIssueTypeAvailable.xml");
        String projectId = this.getProjectId(TEST_PROJECT);
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)ANA_3, (Object)"type", (Object)ANOTHER_TEST_PROJECT), EasyMap.build((Object)"key", (Object)RESULTING_ISSUE_TST_3, (Object)"title", (Object)"[TST-3] Test"), ANA_3);
        this.gotoIssue(ANA_3);
        this.clickLink(MOVE_ISSUE_LINK);
        this.assertTextPresent(CURRENT_ISSUE_TYPE);
        this.assertTextPresent(ANOTHER_TEST_PROJECT);
        this.assertTextPresent(NEW_ISSUE_TYPE);
        this.selectOption(ISSUETYPE_REQUEST_PARAM, MORE_TESTS_ISSUE_TYPE);
        this.setFormElement(PID_REQUEST_PARAM, projectId);
        this.submit();
        this.getDialog().setWorkingForm(JIRAFORM);
        this.submit();
        this.assertTextPresent(ANOTHER_TEST_PROJECT);
        this.assertTextPresent(MORE_TESTS_ISSUE_TYPE);
        this.submit(MOVE_SUBMIT);
        this.assertTextPresent(RESULTING_ISSUE_TST_3);
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)RESULTING_ISSUE_TST_3, (Object)"type", (Object)MORE_TESTS_ISSUE_TYPE, (Object)"priority", (Object)"Major"), null, RESULTING_ISSUE_TST_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveIssueAutomaticAssigneeWithComponents() {
        try {
            this.restoreData("TestMoveIssueAutomaticAssigneeWithComponents.xml");
            String issueKeyToMove = this.addIssue("homosapien", "HSP", "Bug", "test move issue", "Trivial", new String[]{"New Component 1"}, null, null, "user1", "test environment 5", "test description to be moved to another project", null, null, null);
            this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)ISSUE_KEY_TO_MOVE), EasyMap.build((Object)"key", (Object)"NDT-1", (Object)"component", (Object)"New Component 2"), issueKeyToMove);
            String projectId = this.getProjectId("neanderthal");
            this.gotoIssue(issueKeyToMove);
            this.clickLink(MOVE_ISSUE_LINK);
            this.setFormElement(PID_REQUEST_PARAM, projectId);
            this.submit("Next >>");
            this.selectOption("components", "New Component 2");
            this.submit("Next >>");
            this.submit(MOVE_SUBMIT);
            this.assertTextPresent("user2");
            this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)"NDT-1", (Object)"component", (Object)"New Component 2"), EasyMap.build((Object)"key", (Object)ISSUE_KEY_TO_MOVE), "NDT-1");
        }
        finally {
            this.deleteProject("homosapien");
            this.deleteProject("neanderthal");
            this.deletePermissionScheme("test move perm scheme");
            this.removeGroupPermission("Default Permission Scheme", 17, "jira-users");
            this.deleteUser("user1");
            this.deleteUser("user2");
        }
    }

    public void moveOperationFunctionality(String issueKey) {
        TestMoveIssue.log("Move Operation: Test the functionality of the 'Move' operation");
        String projectId = this.getProjectId("neanderthal");
        this.gotoIssue(issueKey);
        this.clickLink(MOVE_ISSUE_LINK);
        this.setFormElement(PID_REQUEST_PARAM, projectId);
        this.submit();
        this.getDialog().setWorkingForm(JIRAFORM);
        this.submit();
        this.assertTextPresent("New Value (after move)");
        this.submit(MOVE_SUBMIT);
        this.assertTextNotPresent("homosapien");
        this.assertTextPresent("neanderthal");
    }

    public void moveOperationWithMoveIssuesPermission(String issueKey) {
        TestMoveIssue.log("Move Operation: Test the availability of the 'Move' Link with 'Move Issues' Permission.");
        this.removeGroupPermission(25, "jira-developers");
        this.gotoIssue(issueKey);
        this.assertLinkNotPresentWithText(MOVE_SUBMIT);
        this.grantGroupPermission(25, "jira-developers");
        this.gotoIssue(issueKey);
        this.assertLinkPresentWithText(MOVE_SUBMIT);
    }

    public void moveOperationWithInvalidDueDate(String issueKey) {
        this.setDueDateToRequried();
        TestMoveIssue.log("Move Operation: selecting invalid due date");
        String projectId = this.getProjectId("monkey");
        this.gotoIssue(issueKey);
        this.clickLink(MOVE_ISSUE_LINK);
        this.assertTextPresent("Move Issue");
        this.setFormElement(PID_REQUEST_PARAM, projectId);
        this.submit();
        this.setFormElement("duedate", "stuff");
        this.submit();
        this.assertTextPresent("Step 3 of 4");
        this.assertTextPresent("You did not enter a valid date. Please enter the date in the format &quot;d/MMM/yy&quot;");
        this.resetFields();
    }

    public void moveOperationWithDueDateRequired(String issueKey) {
        this.setDueDateToRequried();
        TestMoveIssue.log("Move Operation: testing the availabilty of the 'Due Date' field with 'Due Date' required");
        String projectId = this.getProjectId("monkey");
        this.gotoIssue(issueKey);
        this.clickLink(MOVE_ISSUE_LINK);
        this.assertTextPresent("Move Issue");
        this.setFormElement(PID_REQUEST_PARAM, projectId);
        this.submit();
        this.assertFormElementPresent("duedate");
        this.resetFields();
        this.gotoIssue(issueKey);
        this.clickLink(MOVE_ISSUE_LINK);
        this.assertTextPresent("Move Issue");
        this.setFormElement(PID_REQUEST_PARAM, projectId);
        this.submit();
        this.assertFormElementNotPresent("duedate");
    }

    public void moveOperationWithRequiredFields(String issueKey) {
        this.setRequiredFields();
        TestMoveIssue.log("Move Operation: Moving issue with required fields.");
        String projectId = this.getProjectId("neanderthal");
        this.gotoIssue(issueKey);
        this.clickLink(MOVE_ISSUE_LINK);
        this.assertTextPresent("Move Issue");
        this.setFormElement(PID_REQUEST_PARAM, projectId);
        this.submit();
        this.assertTextPresent("Step 3 of 4");
        this.setWorkingForm(JIRAFORM);
        this.submit();
        this.assertErrorMsgFieldRequired("Component/s", "neanderthal", "components");
        this.assertErrorMsgFieldRequired("Fix Version/s", "neanderthal", "versions");
        this.assertErrorMsgFieldRequired("Affects Version/s", "neanderthal", "versions");
        this.resetFields();
    }

    public void moveIssueWithAssignableUser(String issueKey) {
        TestMoveIssue.log("Move Operation: Moving issue with no valid assignees.");
        this.grantGroupPermission(17, "jira-developers");
        this.gotoIssue(issueKey);
        this.clickLink(MOVE_ISSUE_LINK);
        this.selectOption(PID_REQUEST_PARAM, "monkey");
        this.submit();
        this.assertTextPresent("Step 3 of 4");
        this.removeGroupPermission(17, "jira-developers");
        this.gotoIssue(issueKey);
        this.clickLink(MOVE_ISSUE_LINK);
        this.selectOption(PID_REQUEST_PARAM, "monkey");
        this.submit();
        this.setWorkingForm(JIRAFORM);
        this.submit();
        this.assertTextPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.grantGroupPermission(17, "jira-developers");
    }

    public void testMoveWithMappingStatus() {
        this.restoreData("TestBulkMoveMapWorkflows.xml");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)"HSP-13", (Object)"summary", (Object)"bugs3", (Object)"status", (Object)"Totally Open"), null, "HSP-13");
        this.gotoIssue("HSP-13");
        this.assertTextPresent("Totally Open");
        this.clickLinkWithText(MOVE_SUBMIT);
        this.selectOption(PID_REQUEST_PARAM, "monkey");
        this.moveIssue();
        String movedIssueKey = this.getIssueKeyWithSummary("bugs3", "MKY");
        this.gotoIssue(movedIssueKey);
        this.assertTextNotPresent("Totally Open");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Open", (Object)"summary", (Object)"bugs3", (Object)"key", (Object)movedIssueKey), EasyMap.build((Object)"status", (Object)"Totally Open", (Object)"key", (Object)"HSP-13"), movedIssueKey);
    }

    public void testMoveIssueWithinProject() {
        this.restoreData("TestMoveIssue.xml");
        this.gotoIssue(ISSUE_KEY_TO_MOVE);
        this.clickLink(MOVE_ISSUE_LINK);
        this.selectOption(ISSUETYPE_REQUEST_PARAM, "New Feature");
        this.submit("Next >>");
        this.submit("Next >>");
        this.submit(MOVE_SUBMIT);
        this.clickLink("create_link");
        this.submit("Next>>");
        this.setFormElement("summary", "Test Bug 2");
        this.submit("Create");
        this.assertLinkPresentWithText("HSP-3");
    }

    public void testMoveIssueWithSubtasksBetweenProjects() {
        this.restoreData("TestMoveIssueWithSubtasks.xml");
        this.gotoIssue("HSP-3");
        this.clickLink(MOVE_ISSUE_LINK);
        this.selectOption(PID_REQUEST_PARAM, "neanderthal");
        this.selectOption(ISSUETYPE_REQUEST_PARAM, "Task");
        this.submit("Next >>");
        this.submit("Next >>");
        this.submit(MOVE_SUBMIT);
        this.assertLinkPresentWithText("NDT-1");
        this.clickLinkWithText("Sub-task 1");
        this.assertLinkPresentWithText("NDT-2");
        this.assertLastChangeHistoryIs("NDT-2", "Key", "HSP-4", "NDT-2");
        this.assertLastChangeHistoryIs("NDT-2", "Project", "homosapien", "neanderthal");
        this.assertLastChangeNotMadeToField("NDT-2", "Workflow");
        this.assertLastChangeNotMadeToField("NDT-2", "Status");
        this.assertLastChangeNotMadeToField("NDT-2", "Issue Type");
        this.assertLastChangeNotMadeToField("NDT-2", "Assignee");
        this.clickLink("parent_issue_summary");
        this.clickLinkWithText("Sub-task 2");
        this.assertLinkPresentWithText("NDT-3");
        this.assertLastChangeHistoryIs("NDT-2", "Project", "homosapien", "neanderthal");
        this.assertLastChangeNotMadeToField("NDT-3", "Workflow");
        this.assertLastChangeNotMadeToField("NDT-3", "Status");
        this.assertLastChangeNotMadeToField("NDT-3", "Issue Type");
        this.assertLastChangeNotMadeToField("NDT-3", "Assignee");
        this.clickLink("create_link");
        this.selectOption(PID_REQUEST_PARAM, "homosapien");
        this.submit("Next>>");
        this.setFormElement("summary", "Test Bug 3");
        this.submit("Create");
        this.assertLinkPresentWithText("HSP-6");
        this.clickLink("create_link");
        this.selectOption(PID_REQUEST_PARAM, "neanderthal");
        this.submit("Next>>");
        this.setFormElement("summary", "Test Bug 4");
        this.submit("Create");
        this.assertLinkPresentWithText("NDT-4");
    }

    public void testMoveSubtaskWithDifferentWorkflowAndStatuses() {
        this.restoreData("jra-14416-workflows.xml");
        this.gotoIssue("AA-1");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.tester.selectOption(PID_REQUEST_PARAM, "B");
        this.tester.submit("Next >>");
        this.assertTextPresent("Move Issue: Select Status");
        this.assertTextPresent("Step 2 of 4");
        this.assertTextPresent("1 task with status:");
        this.tester.selectOption("subtaskstatus_5_3", "Three");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.submit(MOVE_SUBMIT);
        this.gotoIssue("BB-2");
        this.assertTextPresent("Three");
        this.assertTextPresent("Go To Fourth Step");
        this.assertLastChangeHistoryIs("BB-2", "Key", "AA-2", "BB-2");
        this.assertLastChangeHistoryIs("BB-2", "Project", "A", "B");
        this.assertLastChangeHistoryIs("BB-2", "Workflow", "jira", "B");
        this.assertLastChangeHistoryIs("BB-2", "Status", "In Progress", "Three");
        this.assertLastChangeNotMadeToField("BB-2", "Issue Type");
        this.assertLastChangeNotMadeToField("BB-2", "Assignee");
    }

    public void testMoveSubtaskWithDifferentWorkflows() {
        this.restoreData("jra-14416-statuses.xml");
        this.gotoIssue("AA-1");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.tester.selectOption(PID_REQUEST_PARAM, "B");
        this.tester.submit("Next >>");
        this.assertTextPresent("Move Issue: Update Fields");
        this.assertTextPresent("Step 3 of 4");
        this.assertTextPresent("Step 2 is not required.");
        this.tester.submit("Next >>");
        this.tester.submit(MOVE_SUBMIT);
        this.gotoIssue("BB-2");
        this.assertTextPresent("Mark As Complete");
        this.assertTextPresent("Sub-task");
        this.assertTextPresent("In Progress");
        this.assertLastChangeHistoryIs("BB-2", "Key", "AA-2", "BB-2");
        this.assertLastChangeHistoryIs("BB-2", "Project", "A", "B");
        this.assertLastChangeHistoryIs("BB-2", "Workflow", "jira", "B");
        this.assertLastChangeNotMadeToField("BB-2", "Status");
        this.assertLastChangeNotMadeToField("BB-2", "Issue Type");
        this.assertLastChangeNotMadeToField("BB-2", "Assignee");
    }

    public void testMoveIssueWithSubtaskIssueTypesBetweenProjects() {
        this.restoreData("jra-14416.xml");
        this.gotoIssue("AL-1");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.tester.selectOption(PID_REQUEST_PARAM, "Baloney");
        this.tester.selectOption(ISSUETYPE_REQUEST_PARAM, "Issue Type Bentley");
        this.tester.submit("Next >>");
        this.assertTextPresent("Move Issues: Select Issue Types for Sub-Tasks");
        TableLocator tableLocator = new TableLocator(this.tester, "issuetypechoices");
        this.text.assertTextPresent(tableLocator, "Select New Issue Types for Sub-Tasks");
        this.text.assertTextPresent(tableLocator, "Subtask Apple");
        this.text.assertTextPresent(tableLocator, "Subtask Asterisk");
        this.tester.selectOption("subtaskissuetype_6", "Subtask Bacon");
        this.tester.selectOption("subtaskissuetype_9", "Subtask Butter");
        this.tester.submit("Next >>");
        this.assertTextPresent("Workflow Brown");
        this.assertTextPresent("1 task with status");
        this.tester.selectOption("subtaskstatus_6_10000", "B-Status-2");
        this.tester.submit("Next >>");
        this.tester.selectOption("assignee", "User B");
        this.tester.submit("Next >>");
        this.tester.submit(MOVE_SUBMIT);
        this.gotoIssue("BA-2");
        this.assertTextPresent("Subtask Bacon");
        this.assertTextPresent("Goto Hajime");
        this.assertLastChangeHistoryIs("BA-2", "Key", "AL-2", "BA-2");
        this.assertLastChangeHistoryIs("BA-2", "Issue Type", "Subtask Apple", "Subtask Bacon");
        this.assertLastChangeHistoryIs("BA-2", "Project", "Alabaster", "Baloney");
        this.assertLastChangeHistoryIs("BA-2", "Fix Version/s", "1.5", "");
        this.assertLastChangeHistoryIs("BA-2", "Affects Version/s", "1.5", "");
        this.assertLastChangeHistoryIs("BA-2", "Assignee", "User A", "admin");
        this.assertLastChangeHistoryIs("BA-2", "Workflow", "Workflow Astaire", "Workflow Brown");
        this.assertLastChangeHistoryIs("BA-2", "Status", "A-Status-1", "B-Status-2");
        this.gotoIssue("BA-3");
        this.assertTextPresent("Subtask Butter");
        this.assertLastChangeHistoryIs("BA-3", "Key", "AL-3", "BA-3");
        this.assertLastChangeHistoryIs("BA-3", "Issue Type", "Subtask Asterisk", "Subtask Butter");
        this.assertLastChangeHistoryIs("BA-2", "Project", "Alabaster", "Baloney");
    }

    public void testMoveIssueWithSubtasksBetweenProjectsWithSecurityLevel() throws SAXException {
        this.restoreData("TestReindexingSubtasks.xml");
        this.gotoIssue("RAT-5");
        this.assertTextPresentAfterText("Level Mouse", "Security Level");
        this.clickLink(MOVE_ISSUE_LINK);
        this.selectOption(PID_REQUEST_PARAM, "Porcine");
        this.submit("Next >>");
        this.assertTextPresent("Step 2 is not required.");
        this.submit("Next >>");
        this.assertTextPresent("Move Issue: Confirm");
        this.assertCollapsedTextSequence(new String[]{"Project", "Rattus", "Porcine", "Type", "Bug", "Bug", "Security Level", "Level Mouse", "None"});
        this.submit(MOVE_SUBMIT);
        this.assertTextPresent("Porcine");
        this.assertTextNotPresent("Rattus");
        this.assertTextNotPresent("RAT-");
        this.assertTextNotPresent("Level Mouse");
        this.gotoIssue("PIG-11");
        this.assertTextNotPresent("Security Level");
        this.displayAllIssues();
        this.assertTextNotPresent("RAT-");
        this.assertTextNotPresent("Level Mouse");
        this.assertTableCellHasText("issuetable", 1, 1, "PIG-11");
        this.assertTableCellHasText("issuetable", 1, 11, "");
        this.assertTableCellHasText("issuetable", 2, 1, "PIG-10");
        this.assertTableCellHasText("issuetable", 2, 11, "");
        this.assertTableCellHasText("issuetable", 3, 1, "PIG-9");
        this.assertTableCellHasText("issuetable", 3, 11, "");
        this.gotoIssue("PIG-9");
        this.clickLink(MOVE_ISSUE_LINK);
        this.selectOption(PID_REQUEST_PARAM, "Canine");
        this.submit("Next >>");
        this.assertTextPresent("Step 2 is not required.");
        this.assertTextPresent("Move Issue: Update Fields");
        this.selectOption("security", "Level Green");
        this.submit("Next >>");
        this.assertCollapsedTextSequence(new String[]{"Project", "Porcine", "Canine", "Type", "Bug", "Bug", "Security Level", "None", "Level Green"});
        this.submit(MOVE_SUBMIT);
        this.assertTextNotPresent("PIG");
        this.assertTextNotPresent("Porcine");
        this.assertTextPresent("Canine");
        this.assertTextPresentAfterText("Level Green", "Security Level:");
        this.gotoIssue("DOG-11");
        this.assertTextPresentAfterText("Level Green", "Security Level:");
        this.displayAllIssues();
        this.assertTextNotPresent("PIG");
        this.assertTableCellHasText("issuetable", 1, 1, "DOG-11");
        this.assertTableCellHasText("issuetable", 1, 11, "Level Green");
        this.assertTableCellHasText("issuetable", 2, 1, "DOG-10");
        this.assertTableCellHasText("issuetable", 2, 11, "Level Green");
        this.assertTableCellHasText("issuetable", 3, 1, "DOG-9");
        this.assertTableCellHasText("issuetable", 3, 11, "Level Green");
    }

    public void testMoveIssueWithoutVersionPermission() throws SAXException {
        this.restoreData("TestMoveIssueWithoutVersionPermission.xml");
        this.gotoIssue(ISSUE_KEY_TO_MOVE);
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.tester.selectOption(PID_REQUEST_PARAM, "monkey");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        int lastRow = this.getDialog().getWebTableBySummaryOrId("move_confirm_table").getRowCount() - 1;
        this.assertTableCellHasText("move_confirm_table", 1, 1, "homosapien");
        this.assertTableCellHasText("move_confirm_table", 1, 2, "monkey");
        this.assertTableCellHasText("move_confirm_table", lastRow, 1, "New Version 1");
        this.assertTableCellHasText("move_confirm_table", lastRow, 1, "New Version 4");
        this.assertTableCellHasNotText("move_confirm_table", lastRow, 2, "New Version 1");
        this.assertTableCellHasNotText("move_confirm_table", lastRow, 2, "New Version 4");
        this.tester.submit(MOVE_SUBMIT);
        this.assertTextPresent("MKY-1");
        this.assertTextPresent("Test issue 1");
        this.assertTextNotPresent("New Version 1");
        this.assertTextNotPresent("New Version 4");
    }

    private void moveIssue() {
        this.submit("Next >>");
        this.submit("Next >>");
        this.submit("Next >>");
        this.submit(MOVE_SUBMIT);
    }
}

