/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.clone;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.meterware.httpunit.WebLink;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import junit.framework.Assert;
import org.w3c.dom.Node;

public class TestCloneIssueAttachments
extends FuncTestCase {
    private static final String ATTACHMENT_FILE_NAME_1 = "info.txt";
    private static final String ATTACHMENT_FILE_NAME_2 = "anotherfile.txt";
    private static final String ATTACHMENT_ID_1 = "10010";
    private static final String ATTACHMENT_ID_2 = "10020";
    private static final String ATTACHMENT_CONTENTS_1 = "AAAAA";
    private static final String ATTACHMENT_CONTENTS_2 = "BBBBB";
    private static final String CLONE_ATTACHMENTS_CHECKBOX_NAME = "cloneAttachments";
    private static final String ORIGINAL_ISSUE_KEY = "RAT-1";
    private static final String ORIGINAL_SUBTASK_KEY_1 = "RAT-2";
    private static final String ORIGINAL_SUBTASK_KEY_3 = "RAT-4";
    private static final String ORIGINAL_COW_ISSUE_KEY = "COW-16";
    private static final String ATTACH_FILE_ISSUE_OPERATION_LINK_ID = "attach_file";
    private static final String DESIGN_ATTACHMENT_FILE_NAME_1 = "design_attachment_1.txt";
    private static final String DESIGN_ATTACHMENT_FILE_NAME_2 = "design_attachment_2.txt";
    private static final String DESIGN_ATTACHMENT_CONTENTS_1 = "Design Attachments Stuff";
    private static final String DESIGN_ATTACHMENT_CONTENTS_2 = "Some other Design Attachments Stuff";
    private static final String DESIGN_ATTACHMENT_ID_1 = "10030";
    private static final String DESIGN_ATTACHMENT_ID_2 = "10031";
    private static final String IMPLEMENT_ATTACHMENT_FILE_NAME_1 = "implment_attachment_1.txt";
    private static final String IMPLEMENT_ATTACHMENT_CONTENTS_1 = "Implement Attachments Stuff";
    private static final String IMPLEMENT_ATTACHMENT_ID_1 = "10032";
    private static final String COW_ATTACHMENT_FILE_NAME_1 = "cowfile.txt";
    private static final String CLONE_ATTACHMENTS_CHECKBOX_LABEL = "Clone Attachments";
    private static final String CLONE_ISSUE_OPERATION_NAME = "clone_issue";
    private static final String SUMMARY_FIELD_ID = "summary";
    private static final String CLONE_SUBTASKS_CHECK_BOX_ID = "cloneSubTasks";
    private static final String CREATE_BUTTON_NAME = "Create";
    private String attachmentPath;

    protected void setUpTest() {
        this.administration.restoreData("TestCloneIssueAttachments.xml");
        this.administration.enableAttachments();
        this.attachmentPath = this.administration.getCurrentAttachmentPath();
        try {
            this.installAttachedFile(ORIGINAL_ISSUE_KEY, ATTACHMENT_CONTENTS_1, ATTACHMENT_FILE_NAME_1, ATTACHMENT_ID_1);
            this.installAttachedFile(ORIGINAL_ISSUE_KEY, ATTACHMENT_CONTENTS_2, ATTACHMENT_FILE_NAME_2, ATTACHMENT_ID_2);
            this.installAttachedFile(ORIGINAL_SUBTASK_KEY_1, DESIGN_ATTACHMENT_CONTENTS_1, DESIGN_ATTACHMENT_FILE_NAME_1, DESIGN_ATTACHMENT_ID_1);
            this.installAttachedFile(ORIGINAL_SUBTASK_KEY_1, DESIGN_ATTACHMENT_CONTENTS_2, DESIGN_ATTACHMENT_FILE_NAME_2, DESIGN_ATTACHMENT_ID_2);
            this.installAttachedFile(ORIGINAL_SUBTASK_KEY_3, IMPLEMENT_ATTACHMENT_CONTENTS_1, IMPLEMENT_ATTACHMENT_FILE_NAME_1, IMPLEMENT_ATTACHMENT_ID_1);
        }
        catch (IOException e) {
            TestCloneIssueAttachments.fail((String)("Test failed due to exception: " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String installAttachedFile(String issueKey, String contents, String attachmentFileName, String attachmentId) throws IOException {
        File attachedFile = new File(this.attachmentPath + "/RAT/" + issueKey, attachmentId + "_" + attachmentFileName);
        attachedFile.getParentFile().mkdirs();
        PrintWriter out = new PrintWriter(new FileWriter(attachedFile));
        try {
            out.print(contents);
        }
        finally {
            out.close();
        }
        return this.attachmentPath;
    }

    private void deleteAttachments(String issueKey) throws Exception {
        WebLink[] links;
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLinkWithText("File Attachments:");
        for (WebLink link : links = this.tester.getDialog().getResponse().getLinks()) {
            if (!link.getID().startsWith("del_")) continue;
            this.tester.clickLink(link.getID());
            this.tester.submit("Delete");
        }
    }

    public void testCloneAttachmentsDisabled() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresent(ATTACH_FILE_ISSUE_OPERATION_LINK_ID);
        this.administration.disableAttachments();
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkNotPresent(ATTACH_FILE_ISSUE_OPERATION_LINK_ID);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextNotPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
    }

    public void testCloneAttchemntsAvailable() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.deleteAttachments(ORIGINAL_ISSUE_KEY);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.deleteAttachments(ORIGINAL_SUBTASK_KEY_1);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.deleteAttachments(ORIGINAL_SUBTASK_KEY_3);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextNotPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.navigation.issue().viewIssue(ORIGINAL_COW_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(COW_ATTACHMENT_FILE_NAME_1);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.deleteAttachments(ORIGINAL_COW_ISSUE_KEY);
        this.navigation.issue().viewIssue(ORIGINAL_COW_ISSUE_KEY);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextNotPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
    }

    public void testCloneAttchemntsAvailableForSubTasks() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.deleteAttachments(ORIGINAL_SUBTASK_KEY_1);
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextNotPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
    }

    public void testCloneNoLinksNoSubtasksNoAttachments() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.tester.assertCheckboxNotSelected(CLONE_ATTACHMENTS_CHECKBOX_NAME);
        String cloneSummary = "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.";
        this.tester.setFormElement(SUMMARY_FIELD_ID, "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.uncheckCheckbox(CLONE_SUBTASKS_CHECK_BOX_ID);
        this.tester.submit(CREATE_BUTTON_NAME);
        this.tester.assertTextPresent("CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.deleteAttachments(ORIGINAL_ISSUE_KEY);
    }

    public void testCloneNoLinksNoSubtasksCopyAttachments() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.tester.assertCheckboxNotSelected(CLONE_ATTACHMENTS_CHECKBOX_NAME);
        String cloneSummary = "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.";
        this.tester.setFormElement(SUMMARY_FIELD_ID, "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.uncheckCheckbox(CLONE_SUBTASKS_CHECK_BOX_ID);
        this.tester.checkCheckbox(CLONE_ATTACHMENTS_CHECKBOX_NAME, "true");
        this.tester.submit(CREATE_BUTTON_NAME);
        this.tester.assertTextPresent("CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        String cloneIssueKey = this.extractIssueKey();
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_2);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.deleteAttachments(cloneIssueKey);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_2);
        this.deleteAttachments(ORIGINAL_ISSUE_KEY);
    }

    public void testCloneNoLinksWithSubtasksCopyAttachments() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.tester.assertCheckboxNotSelected(CLONE_ATTACHMENTS_CHECKBOX_NAME);
        String cloneSummary = "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.";
        this.tester.setFormElement(SUMMARY_FIELD_ID, "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.assertFormElementEquals(CLONE_SUBTASKS_CHECK_BOX_ID, "true");
        this.tester.checkCheckbox(CLONE_ATTACHMENTS_CHECKBOX_NAME, "true");
        this.tester.submit(CREATE_BUTTON_NAME);
        this.tester.assertTextPresent("CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        String cloneIssueKey = this.extractIssueKey();
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_2);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.navigation.clickLinkWithExactText("Design Solution");
        String cloneSubtaskIssueKey1 = this.extractIssueKey();
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(cloneSubtaskIssueKey1);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_2);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.navigation.clickLinkWithExactText("Implement Solution");
        String cloneSubtaskIssueKey2 = this.extractIssueKey();
        this.tester.clickLinkWithText(IMPLEMENT_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(IMPLEMENT_ATTACHMENT_CONTENTS_1);
        this.deleteAttachments(cloneIssueKey);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_2);
        this.deleteAttachments(ORIGINAL_ISSUE_KEY);
        this.deleteAttachments(cloneSubtaskIssueKey1);
        this.navigation.issue().viewIssue(cloneSubtaskIssueKey1);
        this.tester.assertLinkNotPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_2);
        this.deleteAttachments(ORIGINAL_SUBTASK_KEY_1);
        this.deleteAttachments(cloneSubtaskIssueKey2);
        this.navigation.issue().viewIssue(cloneSubtaskIssueKey2);
        this.tester.assertLinkNotPresentWithText(IMPLEMENT_ATTACHMENT_FILE_NAME_1);
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_3);
        this.tester.assertLinkPresentWithText(IMPLEMENT_ATTACHMENT_FILE_NAME_1);
        this.tester.clickLinkWithText(IMPLEMENT_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(IMPLEMENT_ATTACHMENT_CONTENTS_1);
        this.deleteAttachments(ORIGINAL_SUBTASK_KEY_3);
    }

    public void testCloneSubTaskNoLinksCopyAttachments() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.tester.assertCheckboxNotSelected(CLONE_ATTACHMENTS_CHECKBOX_NAME);
        String cloneSummary = "CLONE - Sub-Task";
        this.tester.setFormElement(SUMMARY_FIELD_ID, "CLONE - Sub-Task");
        this.tester.checkCheckbox(CLONE_ATTACHMENTS_CHECKBOX_NAME, "true");
        this.tester.submit(CREATE_BUTTON_NAME);
        this.tester.assertTextPresent("CLONE - Sub-Task");
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        String cloneIssueKey = this.extractIssueKey();
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_2);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.deleteAttachments(cloneIssueKey);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.assertLinkNotPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_2);
        this.deleteAttachments(ORIGINAL_SUBTASK_KEY_1);
    }

    private String extractIssueKey() {
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//table[@id='issuedetails']/tr/td");
        Node[] tds = xPathLocator.getNodes();
        Assert.assertNotNull((Object)tds);
        String issueKey = xPathLocator.getText(tds[1]);
        Assert.assertNotNull((Object)issueKey);
        return issueKey;
    }
}

