/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.assign;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.webtests.JIRAWebTest;
import java.util.List;

public class TestAssignIssue
extends JIRAWebTest {
    private String issueKey;
    private String issueKey2 = "TST-1";
    private String issueId;
    private static boolean issueAssigned = true;
    public static final String ADMIN_SELECTED_OPTION = "<option value=\"admin";
    private static final String SEPARATOR = "---------------";

    public TestAssignIssue(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
        if (this.projectExists("homosapien")) {
            this.deleteProject("homosapien");
        }
        this.addProject("homosapien", "HSP", "", "admin", "project for homosapiens");
        this.issueKey = this.addIssue("homosapien", "HSP", "Bug", "This is a test issue", "Major", null, null, null, "Administrator", "test environment", "description for this is a test issue", null, null, null);
        this.issueId = this.getIssueIdWithIssueKey(this.issueKey);
        this.addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
        this.enableUnassignedIssues();
    }

    public void tearDown() {
        if (this.userExists("bob")) {
            this.disableUnassignedIssues();
            this.deleteUser("bob");
            this.deleteIssue(this.issueKey);
            this.deleteProject("homosapien");
        }
        super.tearDown();
    }

    public void testAssignIssue() {
        this._testUnassignedNotAvailable();
        this._testUserUnassign();
        this._testUserAssign();
        this._testUnassignUnassignedIssueError();
        this._testAlreadyAssignedError();
        this._testPermissionError();
        this._testReporterInMainOptionsList();
        this._testAssignWithComment();
        this._testDuplicateNamesInList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testUnassignedNotAvailable() {
        try {
            this.disableUnassignedIssues();
            this.gotoIssue(this.issueKey);
            this.clickLink("assign_issue");
            this.assertOptionNotPresent("assignee", "Unassigned");
        }
        finally {
            this.enableUnassignedIssues();
        }
    }

    public void _testAssignWithComment() {
        this.restoreData("TestBlankInstancePlusAFewUsers.xml");
        this.login("admin", "admin");
        this.assignWithComment("comment viewable by Administrators", "Administrators");
        this.assignWithComment("comment viewable by jira-administrators", "jira-administrators");
        this.assignWithComment("comment viewable by Users", "Users");
        this.assignWithComment("comment viewable by jira-users", "jira-users");
        this.assignWithComment("comment viewable by Developers", "Developers");
        this.assignWithComment("comment viewable by jira-developers", "jira-developers");
        List userComments = EasyList.build((Object)"comment viewable by Users", (Object)"comment viewable by jira-users");
        List developerComments = EasyList.build((Object)"comment viewable by Developers", (Object)"comment viewable by jira-developers");
        List adminComments = EasyList.build((Object)"comment viewable by Administrators", (Object)"comment viewable by jira-administrators");
        this.checkCommentVisibility("admin", this.issueKey2, EasyList.mergeLists((List)userComments, (List)developerComments, (List)adminComments), null);
        this.checkCommentVisibility("fred", this.issueKey2, userComments, EasyList.mergeLists((List)developerComments, (List)adminComments, null));
        this.checkCommentVisibility("devman", this.issueKey2, EasyList.mergeLists((List)userComments, (List)developerComments, null), adminComments);
        this.checkCommentVisibility("onlyadmin", this.issueKey2, EasyList.mergeLists((List)userComments, (List)adminComments, null), developerComments);
    }

    public void assignWithComment(String comment, String commentLevel) {
        this.gotoIssue(this.issueKey2);
        this.clickLink("assign_issue");
        if (issueAssigned) {
            this.selectOption("assignee", "Unassigned");
            issueAssigned = false;
        } else {
            this.selectOption("assignee", "Administrator");
            issueAssigned = true;
        }
        this.setFormElement("comment", comment);
        this.selectOption("commentLevel", commentLevel);
        this.submit("Assign");
    }

    public void _testUserUnassign() {
        this.gotoIssue(this.issueKey);
        this.clickLink("assign_issue");
        this.selectOption("assignee", "Unassigned");
        this.submit("Assign");
        this.assertTextPresent("Unassigned");
    }

    public void _testUserAssign() {
        this.gotoIssue(this.issueKey);
        this.clickLink("assign_issue");
        this.selectOption("assignee", "Administrator");
        this.submit("Assign");
        this.assertTextNotPresent("Unassigned");
        this.assertTextPresent("secure/ViewProfile.jspa?name=admin\">Administrator</a>");
    }

    public void _testUnassignUnassignedIssueError() {
        this.gotoIssue(this.issueKey);
        this.clickLink("assign_issue");
        this.selectOption("assignee", "Unassigned");
        this.submit("Assign");
        this.gotoIssue(this.issueKey);
        this.clickLink("assign_issue");
        this.selectOption("assignee", "Unassigned");
        this.submit("Assign");
        this.assertTextPresent("Issue already unassigned.");
    }

    public void _testAlreadyAssignedError() {
        this._testUserAssign();
        this.gotoIssue(this.issueKey);
        this.clickLink("assign_issue");
        this.selectOption("assignee", "Administrator");
        this.submit("Assign");
        this.assertTextPresent("Issue already assigned to Administrator (admin).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testPermissionError() {
        try {
            this.logout();
            this.login("bob", "bob_password");
            this.beginAt("/secure/AssignIssue!default.jspa?id=" + this.issueId);
            this.selectOption("assignee", "Unassigned");
            this.submit("Assign");
            this.assertTextPresent("You do not have permission to assign issues.");
        }
        finally {
            this.logout();
            this.login("admin", "admin");
        }
    }

    public void _testReporterInMainOptionsList() {
        this.gotoIssue(this.issueKey);
        this.clickLink("assign_issue");
        this.assertTextPresentBeforeText(ADMIN_SELECTED_OPTION, SEPARATOR);
        this.assertTextPresentAfterText(ADMIN_SELECTED_OPTION, SEPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testDuplicateNamesInList() {
        this.restoreData("TestAssigneeDuplicateNames.xml");
        try {
            this.gotoIssue(this.issueKey2);
            this.clickLink("edit_issue");
            this.assertOptionsEqual("assignee", new String[]{"Unassigned", "- Automatic -", "Administrator", "Administrator", "Mr Dev Man (devman)", "Mr Dev Man (devman2)"});
            this.setFormElement("reporter", "devman");
            this.submit("Update");
            this.clickLink("edit_issue");
            this.assertOptionsEqual("assignee", new String[]{"Unassigned", "- Automatic -", "Mr Dev Man (devman)", "Administrator", "Mr Dev Man (devman)", "Mr Dev Man (devman2)"});
            this.setFormElement("reporter", "devman2");
            this.submit("Update");
            this.clickLink("edit_issue");
            this.assertOptionsEqual("assignee", new String[]{"Unassigned", "- Automatic -", "Mr Dev Man (devman2)", "Administrator", "Mr Dev Man (devman)", "Mr Dev Man (devman2)"});
        }
        finally {
            this.restoreData("TestBlankInstancePlusAFewUsers.xml");
        }
    }
}

