/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;

public class TestWatchers
extends JIRAWebTest {
    private static final String ISSUE_KEY = "HSP-1";
    private static final String ISSUE_ID = "10000";

    public void setUp() {
        super.setUp();
        this.restoreData("TestWatchers.xml");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
    }

    public void tearDown() {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        super.tearDown();
    }

    public TestWatchers(String name) {
        super(name);
    }

    public void testWatchers() {
        this.watcherOperationRemove();
        this.watcherOperationDeleteWatcher();
        this.addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
        this.addUserToGroup("bob", "jira-developers");
        this.watcherOperationViewWatchingWithWatchPermission();
        this.watcherOperationWithManageandViewWatchingPermission();
        this.watcherOperationManageWatchingWithWatchPermission();
        this.login("admin", "admin");
    }

    public void testAnonymUserCannotVote() {
        this.logout();
        this.gotoPage("/secure/ViewIssue.jspa?id=10000&watch=true");
        this.assertTextPresent("You are not logged in.");
        this.assertTextPresent("You cannot view this URL as a guest.");
        this.assertTextPresent("If you think this message is wrong");
        this.login("admin", "admin");
    }

    private void watcherOperationRemove() {
        TestWatchers.log("Watcher Operation: Test the ability to manage watchers");
        this.startWatchingAnIssue(ISSUE_KEY);
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("watcher_issue");
        this.assertTextPresent("Manage Watch List");
        this.assertLinkPresent("watcher_link_admin");
        this.checkCheckbox("all");
        this.assertCheckboxSelected("all");
        this.getDialog().setWorkingForm("stopform");
        this.submit();
        this.assertTextPresent("There are currently no watchers associated with this issue.");
    }

    private void watcherOperationDeleteWatcher() {
        TestWatchers.log("Watcher Operation: Test that a user's watcher association is removed when the user is deleted");
        this.startWatchingAnIssue(ISSUE_KEY, new String[]{"bob", "admin"});
        this.deleteUser("bob");
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("view_watchers");
        this.assertLinkNotPresent("watcher_link_bob");
        this.assertLinkPresent("watcher_link_admin");
        this.removeAllWatchers(ISSUE_KEY);
    }

    private void watcherOperationViewWatchingWithWatchPermission() {
        TestWatchers.log("Watcher Operation: Test the availabilty of the 'View Watchers' Link with 'View Voters and Watchers' Permission");
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(ISSUE_KEY);
        this.assertLinkPresent("view_watchers");
        this.removeGroupPermission(31, "jira-developers");
        this.removeGroupPermission(32, "jira-administrators");
        this.gotoIssue(ISSUE_KEY);
        this.assertLinkNotPresent("view_watchers");
        this.grantGroupPermission(31, "jira-developers");
        this.grantGroupPermission(32, "jira-administrators");
    }

    private void watcherOperationManageWatchingWithWatchPermission() {
        TestWatchers.log("Watcher Operation: Test the availabilty of the 'Manage Watchers'link with the 'Manage Watchers' Permission");
        this.removeGroupPermission(31, "jira-developers");
        this.startWatchingAnIssue(ISSUE_KEY, new String[]{"fred"});
        this.logout();
        this.login("bob", "bob_password");
        this.gotoIssue(ISSUE_KEY);
        this.assertLinkNotPresent("view_watchers");
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("view_watchers");
        this.assertTextPresent("Manage Watch List");
        this.grantGroupPermission(31, "jira-developers");
        this.logout();
        this.login("bob", "bob_password");
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("view_watchers");
        this.assertTextNotPresent("Add Watchers");
        this.logout();
        this.login("admin", "admin");
        this.grantPermissionToReporter(32);
        this.logout();
        this.login("bob", "bob_password");
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("view_watchers");
        this.assertTextNotPresent("Add Watchers");
        this.logout();
        this.login("admin", "admin");
    }

    private void watcherOperationWithManageandViewWatchingPermission() {
        TestWatchers.log("Watcher Operation: Test the difference between viewing and managing watcher lists");
        this.startWatchingAnIssue(ISSUE_KEY);
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("view_watchers");
        this.assertFormElementPresent("stopwatch_admin");
        this.grantGroupPermission(31, "jira-users");
        this.logout();
        this.login("bob", "bob_password");
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("view_watchers");
        this.assertFormElementNotPresent("stopwatch_admin");
        this.logout();
        this.login("admin", "admin");
        this.stopWatchingAnIssue(ISSUE_KEY);
        this.removeGroupPermission(31, "jira-users");
    }
}

