/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestVoters
extends JIRAWebTest {
    private static final String ISSUE_KEY = "HSP-1";
    private static final String ISSUE_ID = "10010";

    public TestVoters(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestVoters.xml");
    }

    public void tearDown() {
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testVoters() {
        this.voteOperationVoting();
        this.voteOperationVotingWithVotingPermission();
        this.voteOperationDeleteVoter();
    }

    public void testAnonymUserCannotVote() {
        this.logout();
        this.gotoPage("/secure/ViewIssue.jspa?id=10010&vote=true");
        this.assertTextPresent("You are not logged in.");
        this.assertTextPresent("You cannot view this URL as a guest.");
        this.assertTextPresent("If you think this message is wrong");
        this.login("admin", "admin");
    }

    public void voteOperationVoting() {
        TestVoters.log("Vote Operation: Test the ability to vote and to view voters");
        this.gotoIssue(ISSUE_KEY);
        this.assertTextPresent("You cannot vote for an issue you have reported.");
        this.logout();
        this.login("bob", "bob_password");
        this.voteForIssue(ISSUE_KEY);
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("vote_issue");
        this.assertTextPresent("View Voters");
        this.assertTextPresent("Bob The Builder");
        this.logout();
        this.login("bob", "bob_password");
        this.unvoteForIssue(ISSUE_KEY);
        this.logout();
        this.login("admin", "admin");
    }

    public void voteOperationDeleteVoter() {
        TestVoters.log("Voter Operation: Test that a user's voter association is removed when the user is deleted");
        this.logout();
        this.login("bob", "bob_password");
        this.voteForIssue(ISSUE_KEY);
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("vote_issue");
        this.assertTextPresent("View Voters");
        this.assertLinkPresent("voter_link_bob");
        this.deleteUser("bob");
        this.deleteUser("fred");
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("vote_issue");
        this.assertTextPresent("View Voters");
        this.assertLinkNotPresent("voter_link_bob");
        this.assertTextPresent("There are no voters for this issue.");
    }

    public void voteOperationVotingWithVotingPermission() {
        TestVoters.log("Vote Operation: Test the availability of the 'View Voters' link with the 'View Voters and Watchers' Permission");
        this.removeRolePermission(31, 10001);
        this.gotoIssue(ISSUE_KEY);
        this.assertLinkNotPresent("view_votes");
        this.grantRolePermission(31, 10001);
        this.gotoIssue(ISSUE_KEY);
        this.assertLinkPresent("view_votes");
    }
}

