/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.table.LinkCell;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebTable;
import java.io.File;
import org.xml.sax.SAXException;

public class TestViewIssue
extends JIRAWebTest {
    private static final String IMAGE_ATTACHMENT_NAME = "picture-attachment.jpg";
    private static final String CLASSNAME_SUBTASK_PERCENTAGE_CELL = "nav progress";

    public TestViewIssue(String name) {
        super(name);
    }

    public void testViewIssuePageWithInvalidAssigneeAndReporters() {
        this.restoreData("TestViewIssueWithInvalidUsersProEnt.xml");
        this.enableAttachments();
        this._testViewIssuePageWithInvalidAssigneeAndReportersStandard();
        this._testViewIssuePageWithInvalidAssigneeAndReportersProEnt();
    }

    public void testEditedCommentVisibleWithDoubleQuotesInDateFormat() {
        this.restoreData("TestEditedCommentAndWorklogWithMalformedDateFormat.xml");
        this.gotoIssueTabPanel("HSP-1", "Comments");
        this.assertTextPresentBeforeText("this comment is edited", "this comment will not be edited");
        this.assertTextPresent("title=\"Administrator - 24/Jul/07 09:47 AM&quot; \"");
        this.assertTextNotPresent("25/Jul/07 09:48 AM&quot; ");
        this.gotoIssueTabPanel("HSP-1", "Work Log");
        this.assertTextPresentBeforeText("this work log is edited", "this work log will not be edited");
        this.assertTextPresent("title=\"Administrator - 18/Jul/07 09:42 AM&quot; \"");
        this.assertTextNotPresent("18/Jul/07 09:43 AM&quot; ");
    }

    public void testViewIssueWithCommentDivAndNoAttachmentPermission() {
        this.restoreData("TestViewIssueWithCommentDivAndNoAttachmentPermission.xml");
        this.enableAttachments();
        String issueKey = "TST-1";
        File file = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + IMAGE_ATTACHMENT_NAME);
        this.attachFile("TST-1", file, "");
        this.removeRolePermission(38, 10002);
        this.removeRolePermission(39, 10000);
        this.removeRolePermission(19, 10000);
        this.gotoIssue("TST-1");
        this.assertTextNotPresent("You do not have permission to manage the attachments for this issue.");
    }

    private void _testViewIssuePageWithInvalidAssigneeAndReportersStandard() {
        WebTable issueDetailsTable;
        this.gotoIssue("HSP-1");
        this.assertTextPresent("Issue with valid user");
        try {
            issueDetailsTable = this.getDialog().getResponse().getTableWithID("issuedetails");
            this.assertTableHasMatchingRow(issueDetailsTable, new Object[]{"Assignee", new LinkCell("/secure/ViewProfile.jspa?name=admin", "Administrator")});
            this.assertTableHasMatchingRow(issueDetailsTable, new Object[]{"Reporter", new LinkCell("/secure/ViewProfile.jspa?name=admin", "Administrator")});
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        try {
            issueDetailsTable = this.getDialog().getResponse().getTableWithID("tab1");
            this.assertTableHasMatchingRow(issueDetailsTable, new Object[]{"Custom User Picker", new LinkCell("/secure/ViewProfile.jspa?name=admin", "Administrator")});
            this.assertTableHasMatchingRow(issueDetailsTable, new Object[]{"Custom Multi User Picker", new LinkCell("/secure/ViewProfile.jspa?name=admin", "Administrator")});
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        this.assertLinkPresentWithText("Stop Progress");
        this.assertLinkPresentWithText("Resolve Issue");
        this.assertLinkPresentWithText("Close Issue");
        this.assertLinkPresentWithText("Assign");
        this.assertLinkPresentWithText("Attach file");
        this.assertLinkPresentWithText("Clone");
        this.assertLinkPresentWithText("Comment");
        this.assertLinkPresentWithText("Delete");
        this.assertLinkPresentWithText("Edit");
        this.assertLinkPresentWithText("Voting");
        this.assertLinkPresentWithText("Watching");
        this.assertLinkPresentWithText("Log work");
        this.gotoIssue("HSP-2");
        this.assertTextPresent("Issue with invalid users");
        try {
            issueDetailsTable = this.getDialog().getResponse().getTableWithID("issuedetails");
            this.assertTableHasMatchingRow(issueDetailsTable, new Object[]{"Assignee", "deletedassignee"});
            this.assertTableHasMatchingRow(issueDetailsTable, new Object[]{"Reporter", "deletedreporter"});
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        try {
            issueDetailsTable = this.getDialog().getResponse().getTableWithID("tab1");
            this.assertTextNotPresent("Custom User Picker");
            this.assertTableHasMatchingRow(issueDetailsTable, new Object[]{"Custom Multi User Picker", ""});
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        this.assertLinkNotPresentWithText("Stop Progress");
        this.assertLinkPresentWithText("Resolve Issue");
        this.assertLinkPresentWithText("Close Issue");
        this.assertLinkPresentWithText("Assign");
        this.assertLinkPresentWithText("Attach file");
        this.assertLinkPresentWithText("Clone");
        this.assertLinkPresentWithText("Comment");
        this.assertLinkPresentWithText("Delete");
        this.assertLinkPresentWithText("Edit");
        this.assertLinkPresentWithText("Voting");
        this.assertLinkPresentWithText("Watching");
        this.assertLinkPresentWithText("Log work");
    }

    private void _testViewIssuePageWithInvalidAssigneeAndReportersProEnt() {
        WebTable issueDetailsTable;
        this.gotoIssue("HSP-2");
        this.assertLinkPresentWithText("sub-task");
        this.assertLinkPresentWithText("Sub task with invalid user");
        this.gotoIssue("HSP-3");
        this.assertTextPresent("Sub task with invalid user");
        try {
            issueDetailsTable = this.getDialog().getResponse().getTableWithID("issuedetails");
            this.assertTableHasMatchingRow(issueDetailsTable, new Object[]{"Assignee", "deletedsubtaskuser"});
            this.assertTableHasMatchingRow(issueDetailsTable, new Object[]{"Reporter", "deletedsubtaskuser"});
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        try {
            issueDetailsTable = this.getDialog().getResponse().getTableWithID("tab1");
            this.assertTextNotPresent("Custom User Picker");
            this.assertTableHasMatchingRow(issueDetailsTable, new Object[]{"Custom Multi User Picker", ""});
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        this.assertLinkNotPresentWithText("Stop Progress");
        this.assertLinkPresentWithText("Resolve Issue");
        this.assertLinkPresentWithText("Close Issue");
        this.assertLinkPresentWithText("Assign");
        this.assertLinkPresentWithText("Attach file");
        this.assertLinkPresentWithText("Clone");
        this.assertLinkPresentWithText("Comment");
        this.assertLinkPresentWithText("Delete");
        this.assertLinkPresentWithText("Edit");
        this.assertLinkPresentWithText("Voting");
        this.assertLinkPresentWithText("Watching");
        this.assertLinkPresentWithText("Log work");
    }

    public void testSubtaskPercentageGraphPresence() {
        this.restoreBlankInstance();
        this.activateSubTasks();
        this.activateTimeTracking();
        String parentKey = this.addIssue("monkey", "MKY", "Bug", "bonobo");
        String sub1Key = this.addSubTaskToIssue(parentKey, "Sub-task", "sub1", "subdesc1");
        this.gotoIssue(parentKey);
        TestViewIssue.assertFalse((boolean)this.isSubtaskPercentageGraphPresent());
        this.addSubTaskToIssue(parentKey, "Sub-task", "sub2", "subdesc2");
        this.gotoIssue(parentKey);
        TestViewIssue.assertFalse((boolean)this.isSubtaskPercentageGraphPresent());
        this.gotoIssue(sub1Key);
        this.setEstimate("1m");
        this.gotoIssue(parentKey);
        TestViewIssue.assertTrue((boolean)this.isSubtaskPercentageGraphPresent());
        this.logWork(sub1Key, "1m", "1m");
        this.clickLink("parent_issue_summary");
        TestViewIssue.assertTrue((boolean)this.isSubtaskPercentageGraphPresent());
        this.assertTextPresent("50%");
        this.enableDeleteAllWorklogInDefaultPermissionScheme("jira-administrators");
        this.gotoIssue(sub1Key);
        if (this.getDialog().isLinkPresentWithText("Work Log")) {
            this.clickLinkWithText("Work Log");
        }
        this.clickLink("delete_worklog_10000");
        this.submit("Delete");
        this.gotoIssue(parentKey);
        TestViewIssue.assertTrue((String)"Expected to still see graph after worklog deletion, original estimate remains", (boolean)this.isSubtaskPercentageGraphPresent());
    }

    public void testProjectCFNotLinkedWithNoPermission() {
        this.restoreData("TestProjectCFWithNoPermission.xml");
        this.login("fred");
        this.gotoIssue("HSP-2");
        this.assertLinkWithTextExists("homosapien");
        this.gotoIssue("HSP-1");
        this.assertLinkWithTextNotPresent("monkey");
        this.assertTextPresent("monkey");
        this.login("admin");
        this.gotoIssue("HSP-1");
        this.assertLinkWithTextExists("monkey");
    }

    public void testComponentOrdering() {
        this.restoreBlankInstance();
        TestViewIssue.log("Testing ordering for components field");
        this.tester.clickLink("create_link");
        this.tester.submit("Next>>");
        this.tester.setFormElement("summary", "Test issue");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Create");
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 3"});
        this.tester.clickLink("edit_issue");
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("components", "New Component 2");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Update");
        this.assertTextSequence(new String[]{"Component/s", "New Component 2", "New Component 3"});
        this.tester.clickLink("edit_issue");
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 2");
        this.tester.submit("Update");
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 2"});
        this.tester.clickLink("edit_issue");
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 2");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Update");
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 2", "New Component 3"});
    }

    public void testVersionOrdering() {
        this.restoreBlankInstance();
        String[] versionFields = new String[]{"versions", "fixVersions"};
        String[] versionFieldNames = new String[]{"Affects Version/s", "Fix Version/s"};
        for (int i = 0; i < versionFields.length; ++i) {
            String versionField = versionFields[i];
            String versionFieldName = versionFieldNames[i];
            TestViewIssue.log("Testing ordering for versions field '" + versionField + "'");
            this.tester.clickLink("create_link");
            this.tester.submit("Next>>");
            this.tester.setFormElement("summary", "Test issue");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Create");
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 5"});
            this.tester.clickLink("edit_issue");
            this.tester.setWorkingForm("jiraform");
            this.selectMultiOption(versionField, "New Version 4");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Update");
            this.assertTextSequence(new String[]{versionFieldName, "New Version 4", "New Version 5"});
            this.tester.clickLink("edit_issue");
            this.tester.setWorkingForm("jiraform");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 4");
            this.tester.submit("Update");
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 4"});
            this.tester.clickLink("edit_issue");
            this.tester.setWorkingForm("jiraform");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 4");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Update");
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 4", "New Version 5"});
        }
    }

    private void enableDeleteAllWorklogInDefaultPermissionScheme(String groupName) {
        TestViewIssue.log("enabling delete all worklog deletion in default permission scheme for group " + groupName);
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("add_perm_43");
        this.checkCheckbox("type", "group");
        this.selectOption("group", groupName);
        this.submit(" Add ");
    }

    private boolean isSubtaskPercentageGraphPresent() {
        WebTable issueSummary = this.getDialog().getWebTableBySummaryOrId("issuetable");
        TableCell percentageCell = issueSummary.getTableCell(0, 5);
        return CLASSNAME_SUBTASK_PERCENTAGE_CELL.equals(percentageCell.getClassName());
    }
}

