/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.table.ImageCell;
import com.atlassian.jira.webtests.table.TextCell;
import com.meterware.httpunit.WebTable;
import java.util.List;
import org.xml.sax.SAXException;

public class TestLinkIssue
extends JIRAWebTest {
    private static final String USERNAME_FRED = "fred";
    private static final String PASSWORD_FRED = "fred";
    private static final String FULLNAME_FRED = "Fred";
    private static final String EMAIL_FRED = "fred@stuff.com.com";

    public TestLinkIssue(String name) {
        super(name);
    }

    public void tearDown() {
        this.deactivateIssueLinking();
        super.tearDown();
    }

    public void testLinkIssue() {
        this.restoreBlankInstance();
        if (this.projectExists("homosapien")) {
            TestLinkIssue.log("Project: homosapien exists");
        } else {
            this.addProject("homosapien", "HSP", "", "admin", "project for homsapiens.");
        }
        this.activateIssueLinking();
        this.activateSubTasks();
        TestLinkIssue.assertFalse((boolean)this.linkExists("jira_subtask_link"));
        if (this.linkExists("Duplicate")) {
            this.deleteLink("Duplicate");
        }
        if (this.linkExists("Cloners")) {
            this.deleteLink("Cloners");
        }
        if (this.linkExists("related")) {
            this.deleteLink("related");
        }
        this.deactivateIssueLinking();
        String issueKey1 = this.addIssue("homosapien", "HSP", "Bug", "test 1", "Minor", null, null, null, "Administrator", "test environment 1", "test description to clone 1", null, null, null);
        String issueKey2 = this.addIssue("homosapien", "HSP", "Bug", "test 1", "Minor", null, null, null, "Administrator", "test environment 1", "test description to clone 2", null, null, null);
        this.checkComponentOrdering("10000");
        this.checkVersionOrdering("10001");
        this.availabilityOfIssueLinkLink(issueKey1);
        this.linkingIssue(issueKey1, issueKey2);
        this.assertSubtaskLinkNotPresent(issueKey1, issueKey2);
        this.duplicateIssueLinkTypeNameError();
        this.issueOperationForCloningWithIssueLinking(issueKey1);
        this.cancelLinkDeletion();
        this.confirmLinkDeletion();
        this.deleteIssue(issueKey1);
        this.deleteIssue(issueKey2);
        this.activateIssueLinking();
        this.deleteLink("Duplicate");
        this.deleteLink("Cloners");
        this.deleteLink("related");
        this.deactivateIssueLinking();
    }

    public void checkComponentOrdering(String issueId) {
        TestLinkIssue.log("Testing ordering for components field");
        this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Update");
        this.gotoPage("/secure/ManageLinks.jspa?id=" + issueId);
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 3"});
        this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("components", "New Component 2");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Update");
        this.gotoPage("/secure/ManageLinks.jspa?id=" + issueId);
        this.assertTextSequence(new String[]{"Component/s", "New Component 2", "New Component 3"});
        this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 2");
        this.tester.submit("Update");
        this.gotoPage("/secure/ManageLinks.jspa?id=" + issueId);
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 2"});
        this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 2");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Update");
        this.gotoPage("/secure/ManageLinks.jspa?id=" + issueId);
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 2", "New Component 3"});
    }

    public void checkVersionOrdering(String issueId) {
        String[] versionFields = new String[]{"versions", "fixVersions"};
        String[] versionFieldNames = new String[]{"Affects Version/s", "Fix Version/s"};
        for (int i = 0; i < versionFields.length; ++i) {
            String versionField = versionFields[i];
            String versionFieldName = versionFieldNames[i];
            TestLinkIssue.log("Testing ordering for versions field '" + versionField + "'");
            this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
            this.tester.setWorkingForm("jiraform");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Update");
            this.gotoPage("/secure/ManageLinks.jspa?id=" + issueId);
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 5"});
            this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
            this.tester.setWorkingForm("jiraform");
            this.selectMultiOption(versionField, "New Version 4");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Update");
            this.gotoPage("/secure/ManageLinks.jspa?id=" + issueId);
            this.assertTextSequence(new String[]{versionFieldName, "New Version 4", "New Version 5"});
            this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
            this.tester.setWorkingForm("jiraform");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 4");
            this.tester.submit("Update");
            this.gotoPage("/secure/ManageLinks.jspa?id=" + issueId);
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 4"});
            this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
            this.tester.setWorkingForm("jiraform");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 4");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Update");
            this.gotoPage("/secure/ManageLinks.jspa?id=" + issueId);
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 4", "New Version 5"});
            this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
            this.tester.setWorkingForm("jiraform");
            this.uncheckCheckbox(versionField);
            this.tester.submit("Update");
        }
    }

    public void availabilityOfIssueLinkLink(String issueKey) {
        TestLinkIssue.log("Link Issue: test for availability of 'link issue' link");
        this.gotoIssue(issueKey);
        this.assertLinkNotPresent("link_issue");
        this.activateIssueLinking();
        this.gotoIssue(issueKey);
        this.assertLinkNotPresent("link_issue");
        this.deactivateIssueLinking();
        this.createIssueLinkType();
        this.activateIssueLinking();
        this.gotoIssue(issueKey);
        this.assertLinkPresent("link_issue");
        this.deactivateIssueLinking();
    }

    public void linkingIssue(String issueKey1, String issueKey2) {
        TestLinkIssue.log("Link Issue: test linking an issue");
        this.activateIssueLinking();
        this.gotoIssue(issueKey1);
        this.clickLink("link_issue");
        this.setFormElement("linkKey", issueKey2);
        this.submit("Link");
        this.assertTextPresent(issueKey2);
        this.deactivateIssueLinking();
    }

    public void assertSubtaskLinkNotPresent(String issueKey1, String issueKey2) {
        TestLinkIssue.log("Link Issue: test that the subtask links are not present when linking an issue");
        this.activateIssueLinking();
        this.gotoIssue(issueKey1);
        this.clickLink("link_issue");
        this.assertOptionNotPresent("linkDesc", "jira_subtask_outward");
        this.assertOptionNotPresent("linkDesc", "jira_subtask_inward");
        this.deactivateIssueLinking();
    }

    public void duplicateIssueLinkTypeNameError() {
        TestLinkIssue.log("Link Issue: test attempting to add duplicate link type name");
        this.activateIssueLinking();
        this.setFormElement("name", "Duplicate");
        this.setFormElement("outward", "is a duplicate of");
        this.setFormElement("inward", "duplicates");
        this.submit();
        this.assertTextPresent("Another link type with that name already exists");
        this.deactivateIssueLinking();
    }

    public void issueOperationForCloningWithIssueLinking(String issueKey) {
        TestLinkIssue.log("Issue Operation: Test the ability to automatically link the clone to its parent");
        this.createIssueLinkCloners();
        this.activateIssueLinking();
        this.gotoIssue(issueKey);
        this.clickLinkWithText("Clone");
        this.setFormElement("summary", "Second Clone of Test 1");
        this.submit();
        this.assertTextPresent("Second Clone of Test 1");
        this.assertTextPresent("Issue Links");
        this.clickLink("delete_issue");
        this.submit("Delete");
        this.deactivateIssueLinking();
    }

    public void cancelLinkDeletion() {
        TestLinkIssue.log("Testing cancel option of delete link wizard");
        String issueKey1 = this.addIssue("homosapien", "HSP", "Bug", "test 1", "Minor", null, null, null, "Administrator", "test environment 1", "test description", null, null, null);
        String issueId1 = this.getIssueIdWithIssueKey(issueKey1);
        String issueKey2 = this.addIssue("homosapien", "HSP", "Bug", "test 1", "Minor", null, null, null, "Administrator", "test environment 1", "test description", null, null, null);
        this.activateIssueLinking();
        this.gotoLinkDeleteConfirmationScreen(issueKey1, issueKey2);
        this.assertFormElementPresent("ManageLinks.jspa?id=" + issueId1);
        this.clickButton("cancelButton");
        this.assertTextPresent(issueKey1);
        this.assertTextPresent(issueKey2);
        this.assertTextPresent("relates to");
        this.deleteIssue(issueKey1);
        this.deleteIssue(issueKey2);
        this.deactivateIssueLinking();
    }

    public void testvisibilityOfDeleteIssueLink() throws SAXException {
        this.restoreBlankInstance();
        this.addUser("fred", "fred", FULLNAME_FRED, EMAIL_FRED);
        this.addUserToGroup("fred", "jira-users");
        this.activateIssueLinking();
        this.createIssueLinkType();
        String issueKey1 = this.addIssue("homosapien", "HSP", "Bug", "test 1", "Minor", null, null, null, "Administrator", "test environment 1", "test description to clone 1", null, null, null);
        String issueKey2 = this.addIssue("homosapien", "HSP", "Bug", "test 1", "Minor", null, null, null, "Administrator", "test environment 1", "test description to clone 2", null, null, null);
        this.linkingIssue(issueKey1, issueKey2);
        this.activateIssueLinking();
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(issueKey1);
        this.clickLinkWithText("Issue Links:");
        this.assertLinkWithNameExists("DeleteLink");
        this.removeGroupPermission(21, "jira-users");
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(issueKey1);
        this.clickLinkWithText("Issue Links:");
        this.assertLinkWithNameNotPresent("DeleteLink");
        this.logout();
        this.login("admin", "admin");
        this.grantGroupPermission(21, "jira-users");
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(issueKey1);
        this.clickLinkWithText("Issue Links:");
        this.assertLinkWithNameExists("DeleteLink");
        this.logout();
        this.login("admin", "admin");
        this.removeGroupPermission(21, "jira-users");
        this.deleteIssue(issueKey1);
        this.deleteIssue(issueKey2);
        this.deactivateIssueLinking();
    }

    public void confirmLinkDeletion() {
        TestLinkIssue.log("Testing confirm option of delete link wizard");
        String issueKey1 = this.addIssue("homosapien", "HSP", "Bug", "test 1", "Minor", null, null, null, "Administrator", "test environment 1", "test description", null, null, null);
        String issueKey2 = this.addIssue("homosapien", "HSP", "Bug", "test 1", "Minor", null, null, null, "Administrator", "test environment 1", "test description", null, null, null);
        this.activateIssueLinking();
        this.gotoLinkDeleteConfirmationScreen(issueKey1, issueKey2);
        this.submit("Delete");
        this.assertTextPresent(issueKey1);
        this.assertTextNotPresent(issueKey2);
        this.assertTextNotPresent("relates to");
        this.deleteIssue(issueKey1);
        this.deleteIssue(issueKey2);
        this.deactivateIssueLinking();
    }

    public void testLinkComment() {
        this.restoreData("TestBlankInstancePlusAFewUsers.xml");
        String roleUsers = "Users";
        String roleDev = "Developers";
        String roleAdmin = "Administrators";
        this.createIssueLinkType("duplicates", "duplicates", "is duplicated by");
        this.createIssueLinkType("resembles", "resembles", "is resembled by");
        this.createIssueLinkType("jokingly duplicates", "jokingly duplicates", "is jokingly duplicated by");
        this.createIssueLinkType("similar", "similar to", "is similar to");
        this.createIssueLinkType("duplicates", "duplicates", "is duplicated by");
        String issueKey1 = this.addIssue("homosapien", "HSP", "Test Bug", "Bug1");
        String issueKey2 = this.addIssue("homosapien", "HSP", "Test Bug", "Bug2");
        String issueKey3 = this.addIssue("homosapien", "HSP", "Test Bug", "Bug3");
        String issueKey4 = this.addIssue("homosapien", "HSP", "Test Bug", "Bug4");
        String issueKey5 = this.addIssue("homosapien", "HSP", "Test Bug", "Bug5");
        String issueKey6 = this.addIssue("homosapien", "HSP", "Test Bug", "Bug6");
        String COMMENT_JIRAUSERS1 = "comment visible to jira-users";
        String COMMENT_JIRAUSERS2 = "comment visible to All Users";
        String COMMENT_ADMINS1 = "comment visible to jira-administrators";
        String COMMENT_ADMINS2 = "comment visible to Administrators";
        String COMMENT_DEV1 = "comment visible to jira-developers";
        String COMMENT_DEV2 = "comment visible to Developers";
        List jiraUserComments = EasyList.build((Object)COMMENT_JIRAUSERS1, (Object)COMMENT_JIRAUSERS2);
        List jiraAdminComments = EasyList.build((Object)COMMENT_ADMINS1, (Object)COMMENT_ADMINS2);
        List jiraDevComments = EasyList.build((Object)COMMENT_DEV1, (Object)COMMENT_DEV2);
        this.activateIssueLinking();
        this.linkIssueWithComment(issueKey1, issueKey2, "duplicates", COMMENT_JIRAUSERS1, "jira-users");
        this.linkIssueWithComment(issueKey1, issueKey3, "resembles", COMMENT_ADMINS1, "jira-administrators");
        this.linkIssueWithComment(issueKey1, issueKey4, "duplicates", COMMENT_DEV1, "jira-developers");
        this.linkIssueWithComment(issueKey1, issueKey5, "duplicates", COMMENT_JIRAUSERS2, roleUsers);
        this.linkIssueWithComment(issueKey1, issueKey6, "duplicates", COMMENT_DEV2, roleDev);
        this.linkIssueWithComment(issueKey1, issueKey6, "duplicates", COMMENT_ADMINS2, roleAdmin);
        this.checkCommentVisibility("fred", issueKey1, jiraUserComments, EasyList.mergeLists((List)jiraAdminComments, (List)jiraDevComments, null));
        this.checkCommentVisibility("devman", issueKey1, EasyList.mergeLists((List)jiraUserComments, (List)jiraDevComments, null), jiraAdminComments);
        this.checkCommentVisibility("onlyadmin", issueKey1, EasyList.mergeLists((List)jiraUserComments, (List)jiraAdminComments, null), jiraDevComments);
        this.checkCommentVisibility("admin", issueKey1, EasyList.mergeLists((List)jiraUserComments, (List)jiraAdminComments, (List)jiraDevComments), null);
    }

    public void testPriorityIconIsHiddenIfPriorityFieldIsHidden() {
        this._testPriorityIconIsHiddenIfPriorityFieldIsHiddenEnterprise();
    }

    public void _testPriorityIconIsHiddenIfPriorityFieldIsHiddenEnterprise() {
        this.restoreData("TestLinkIssueWithPriorityFieldHiddenEnterprise.xml");
        this.gotoIssue("HSP-1");
        try {
            WebTable outwardLinksTable = this.getDialog().getResponse().getTableWithID("outwardLinks_table");
            TestLinkIssue.assertEquals((int)4, (int)outwardLinksTable.getRowCount());
            this.assertTableRowEquals(outwardLinksTable, 0, new Object[]{"This issue duplicates"});
            this.assertTableRowEquals(outwardLinksTable, 1, new Object[]{new ImageCell("/images/icons/link_out_top.gif"), new TextCell(new String[]{"MKY-1", "new feature in project monkey with no priority set on creation as it is hidden"}), "", new ImageCell("/images/icons/status_open.gif")});
            this.assertTableRowEquals(outwardLinksTable, 2, new Object[]{new ImageCell("/images/icons/link_out_mid.gif"), new TextCell(new String[]{"HSP-3", "this task is duplicated by hsp-1"}), new ImageCell("/images/icons/priority_major.gif"), new ImageCell("/images/icons/status_open.gif")});
            this.assertTableRowEquals(outwardLinksTable, 3, new Object[]{new ImageCell("/images/icons/link_out_bot.gif"), new TextCell(new String[]{"HSP-2", "improvement on project homosapien this issue will be linked to the homosapien bug and has its priority showing"}), new ImageCell("/images/icons/priority_critical.gif"), new ImageCell("/images/icons/status_open.gif")});
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        try {
            WebTable inwardLinksTable = this.getDialog().getResponse().getTableWithID("inwardLinks_table");
            TestLinkIssue.assertEquals((int)4, (int)inwardLinksTable.getRowCount());
            this.assertTableRowEquals(inwardLinksTable, 0, new Object[]{"This issue is duplicated by:"});
            this.assertTableRowEquals(inwardLinksTable, 1, new Object[]{new ImageCell("/images/icons/link_in_top.gif"), new TextCell(new String[]{"HSP-4", "this bug duplicates hsp-1"}), new ImageCell("/images/icons/priority_minor.gif"), new ImageCell("/images/icons/status_open.gif")});
            this.assertTableRowEquals(inwardLinksTable, 2, new Object[]{new ImageCell("/images/icons/link_in_mid.gif"), new TextCell(new String[]{"MKY-1", "new feature in project monkey with no priority set on creation as it is hidden"}), "", new ImageCell("/images/icons/status_open.gif")});
            this.assertTableRowEquals(inwardLinksTable, 3, new Object[]{new ImageCell("/images/icons/link_in_bot.gif"), new TextCell(new String[]{"HSP-2", "improvement on project homosapien this issue will be linked to the homosapien bug and has its priority showing"}), new ImageCell("/images/icons/priority_critical.gif"), new ImageCell("/images/icons/status_open.gif")});
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public void testChangeHistoryShowsHyperlinkCorrectly() {
        this.restoreData("TestLinkIssueChangeHistoryShowsHyperlink.xml");
        this.logout();
        this.login("fred");
        this.gotoIssue("HSP-1");
        this.clickLinkWithText("Change History");
        this.assertTextPresent("MKY-1");
        this.assertLinkNotPresentWithText("MKY-1");
        this.assertTextPresent("HSP-2");
        this.assertLinkNotPresentWithText("HSP-2");
        this.logout();
        this.login("admin");
        this.gotoAdmin();
        this.clickLinkWithText("monkey");
        this.clickLink("select_permission_scheme");
        this.selectOption("schemeIds", "Default Permission Scheme");
        this.submit("Associate");
        this.gotoIssue("HSP-2");
        this.clickLink("edit_issue");
        this.selectOption("security", "None");
        this.submit("Update");
        this.logout();
        this.login("fred");
        this.gotoIssue("HSP-1");
        this.clickLinkWithText("Change History");
        this.assertTextPresent("MKY-1");
        this.assertLinkPresentWithText("MKY-1");
        this.assertTextPresent("HSP-2");
        this.assertLinkPresentWithText("HSP-2");
        this.logout();
        this.login("admin");
        this.deleteIssue("HSP-2");
        this.gotoIssue("HSP-1");
        this.clickLinkWithText("Change History");
        this.assertTextPresent("HSP-2");
        this.assertLinkNotPresentWithText("HSP-2");
    }

    private void linkIssueWithComment(String issueKey1, String issueKey2, String link, String comment, String commentLevel) {
        this.gotoIssue(issueKey1);
        this.clickLink("link_issue");
        this.selectOption("linkDesc", link);
        this.setFormElement("linkKey", issueKey2);
        this.setFormElement("comment", comment);
        this.selectOption("commentLevel", commentLevel);
        this.submit("Link");
    }

    private String createIssueLinkType() {
        return this.createIssueLinkType("Duplicate", "is a duplicate of", "duplicates");
    }

    public String createIssueLinkType(String name, String outwardLinkName, String inwardLinkName) {
        String linkTypeId;
        this.activateIssueLinking();
        this.setFormElement("name", name);
        this.setFormElement("outward", outwardLinkName);
        this.setFormElement("inward", inwardLinkName);
        this.submit();
        try {
            String text = this.getDialog().getResponse().getText();
            int linkIdLocation = text.indexOf("del_" + name);
            int endOfLinkIdLocation = text.indexOf(">Del", linkIdLocation);
            String deleteLinkLocation = text.substring(linkIdLocation, endOfLinkIdLocation);
            linkIdLocation = deleteLinkLocation.indexOf("id=");
            endOfLinkIdLocation = deleteLinkLocation.indexOf("\"", linkIdLocation);
            linkTypeId = deleteLinkLocation.substring(linkIdLocation + "id=".length(), endOfLinkIdLocation);
        }
        catch (Exception e) {
            TestLinkIssue.fail((String)("Unable to retrieve Link Id for link type " + name + " : " + e.getMessage()));
            return "fail";
        }
        this.deactivateIssueLinking();
        return linkTypeId;
    }

    private void gotoLinkDeleteConfirmationScreen(String issueKey1, String issueKey2) {
        this.gotoIssue(issueKey1);
        String linkTypeId = this.createIssueLinkType("related", "is related to", "relates to");
        String destId = this.getIssueIdWithIssueKey(issueKey2);
        this.linkIssue(issueKey1, issueKey2, "relates to");
        this.activateIssueLinking();
        this.gotoIssue(issueKey1);
        this.clickLinkWithText("Issue Links");
        this.clickLink("del_" + destId + "_" + linkTypeId);
        this.assertTextPresentBeforeText("Delete Link: ", issueKey1 + " relates to " + issueKey2);
    }

    public void createIssueLinkCloners() {
        this.activateIssueLinking();
        this.setFormElement("name", "Cloners");
        this.setFormElement("inward", "clones");
        this.setFormElement("outward", "is cloned by");
        this.submit("Add");
        this.deactivateIssueLinking();
    }

    private boolean linkExists(String linkName) {
        this.clickOnAdminPanel("admin.globalsettings", "linking");
        return this.getDialog().isLinkPresent("del_" + linkName);
    }

    private void deleteLink(String linkName) {
        this.clickOnAdminPanel("admin.globalsettings", "linking");
        this.clickLink("del_" + linkName);
        this.submit("Delete");
    }
}

