/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestIssueTrackback
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreData("TestIssueTrackback.xml");
        this.administration.enableTrackBacks();
    }

    public void testIssueDoesNotHaveTrackbackIfTrackbacksDisabled() throws Exception {
        this.assertIssueHasTrackback("HSP-1", "10000", "This should be able to be linked to via trackbacks", "This is the description for HSP-1", "homosapien");
        this.assertIssueHasMinimalTrackback("OTH-1", "10002", "admin should not be able to see this issue", "This is the description for OTH-1", "otherproject");
        this.tester.gotoPage("/secure/admin/jira/TrackbackAdmin!default.jspa");
        this.tester.checkCheckbox("acceptPings", "false");
        this.tester.submit("Update");
        this.assertIssueHasNoTrackback("HSP-1");
        this.assertIssueHasNoMinimalTrackback("OTH-1");
        this.administration.enableTrackBacks();
        this.assertIssueHasTrackback("HSP-1", "10000", "This should be able to be linked to via trackbacks", "This is the description for HSP-1", "homosapien");
        this.assertIssueHasMinimalTrackback("OTH-1", "10002", "admin should not be able to see this issue", "This is the description for OTH-1", "otherproject");
    }

    public void testIssueHasTrackback() throws Exception {
        this.assertIssueHasTrackback("HSP-1", "10000", "This should be able to be linked to via trackbacks", "This is the description for HSP-1", "homosapien");
        this.assertIssueHasTrackback("HSP-2", "10001", "This also should have RDF comments", "This is the description for HSP-2", "homosapien");
    }

    public void testTrackbackDetailsAreEscaped() {
        this.tester.clickLink("create_link");
        this.tester.selectOption("issuetype", "New Feature");
        this.tester.submit("Next>>");
        this.tester.setFormElement("summary", "This field has -- in its summary");
        this.tester.setFormElement("description", "This field has -- in its description");
        this.tester.submit("Create");
        this.assertIssueHasTrackback("HSP-3", "10010", "This field has &#45;&#45; in its summary", "This field has &#45;&#45; in its description", "homosapien");
    }

    public void testNoPermissionTrackback() throws Exception {
        this.assertIssueHasMinimalTrackback("OTH-1", "10002", "admin should not be able to see this issue", "This is the description for OTH-1", "otherproject");
        this.navigation.login("testuser", "testuser");
        this.assertIssueHasTrackback("OTH-1", "10002", "admin should not be able to see this issue", "This is the description for OTH-1", "otherproject");
    }

    private void assertIssueHasTrackback(String issueKey, String issueId, String issueSummary, String issueDesc, String projectName) {
        this.navigation.issue().viewIssue(issueKey);
        String pageText = this.tester.getDialog().getResponseText();
        this.text.assertTextPresent(pageText, "<rdf:RDF");
        this.text.assertTextPresent(pageText, "</rdf:RDF");
        this.text.assertTextPresent(pageText, "dc:title=\"[#" + issueKey + "] " + issueSummary + "\"");
        this.text.assertTextPresent(pageText, "dc:subject=\"" + projectName + "\"");
        this.text.assertTextPresent(pageText, "dc:description=\"" + issueDesc + "\"");
        this.text.assertRegexMatch(pageText, "<rdf:Description rdf:about=\"http://.*/browse/" + issueKey + "\"");
        this.text.assertRegexMatch(pageText, "dc:identifier=\"http://.*/browse/" + issueKey + "\"");
        this.text.assertRegexMatch(pageText, "trackback:ping=\"http://.*/rpc/trackback/" + issueKey + "\"");
        this.text.assertRegexMatch(pageText, "<rdf:Description rdf:about=\"http://.*/secure/ViewIssue.jspa\\?id=" + issueId + "\"");
        this.text.assertRegexMatch(pageText, "dc:identifier=\"http://.*/secure/ViewIssue.jspa\\?id=" + issueId + "\"");
        this.text.assertRegexMatch(pageText, "<rdf:Description rdf:about=\"http://.*/secure/ViewIssue.jspa\\?key=" + issueKey + "\"");
        this.text.assertRegexMatch(pageText, "dc:identifier=\"http://.*/secure/ViewIssue.jspa\\?key=" + issueKey + "\"");
    }

    private void assertIssueHasNoTrackback(String issueKey) {
        this.navigation.issue().viewIssue(issueKey);
        String pageText = this.tester.getDialog().getResponseText();
        this.text.assertTextNotPresent(pageText, "<rdf:RDF");
        this.text.assertTextNotPresent(pageText, "</rdf:RDF");
        this.text.assertTextNotPresent(pageText, "<rdf:Description");
    }

    private void assertIssueHasMinimalTrackback(String issueKey, String issueId, String issueSummary, String issueDesc, String projectName) {
        this.navigation.issue().viewIssue(issueKey);
        String pageText = this.tester.getDialog().getResponseText();
        this.text.assertTextPresent(pageText, "<rdf:RDF");
        this.text.assertTextPresent(pageText, "</rdf:RDF");
        this.text.assertTextNotPresent(pageText, "dc:title=");
        this.text.assertTextNotPresent(pageText, "dc:subject=");
        this.text.assertTextNotPresent(pageText, "dc:description=");
        this.text.assertTextNotPresent(pageText, issueSummary);
        this.text.assertTextNotPresent(pageText, projectName);
        this.text.assertTextNotPresent(pageText, issueDesc);
        this.text.assertRegexMatch(pageText, "<rdf:Description rdf:about=\"http://.*/browse/" + issueKey + "\"");
        this.text.assertRegexMatch(pageText, "dc:identifier=\"http://.*/browse/" + issueKey + "\"");
        this.text.assertRegexMatch(pageText, "trackback:ping=\"http://.*/rpc/trackback/" + issueKey + "\"");
        this.text.assertRegexMatch(pageText, "<rdf:Description rdf:about=\"http://.*/secure/ViewIssue.jspa\\?id=" + issueId + "\"");
        this.text.assertRegexMatch(pageText, "dc:identifier=\"http://.*/secure/ViewIssue.jspa\\?id=" + issueId + "\"");
        this.text.assertRegexMatch(pageText, "<rdf:Description rdf:about=\"http://.*/secure/ViewIssue.jspa\\?key=" + issueKey + "\"");
        this.text.assertRegexMatch(pageText, "dc:identifier=\"http://.*/secure/ViewIssue.jspa\\?key=" + issueKey + "\"");
    }

    private void assertIssueHasNoMinimalTrackback(String issueKey) {
        this.navigation.issue().viewIssue(issueKey);
        String pageText = this.tester.getDialog().getResponseText();
        this.text.assertTextNotPresent(pageText, "<rdf:RDF");
        this.text.assertTextNotPresent(pageText, "</rdf:RDF");
        this.text.assertTextNotPresent(pageText, "<rdf:Description");
    }
}

