/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestIssueSecurityWithCustomFields
extends JIRAWebTest {
    private static final String GROUP_CUSTOM_FIELD_ID = "10001";
    private static final String USER_CUSTOM_FIELD_ID = "10010";
    private static final String GROUP_CF_ISSUE_ID = "HSP-1";
    private static final String USER_CF_ISSUE_ID = "MKY-1";
    private static final String PERMISSION_VIOLATION_ERROR = "It seems that you have tried to perform an operation which you are not permitted to perform.";

    public TestIssueSecurityWithCustomFields(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueSecurityWithCustomFields.xml");
    }

    public void testIssueSecurityWithCustomField() {
        this.displayAllIssues();
        this.assertTextPresent(GROUP_CF_ISSUE_ID);
        this.gotoIssue(GROUP_CF_ISSUE_ID);
        this.assertTextNotPresent(PERMISSION_VIOLATION_ERROR);
        this.logout();
        this.login("fred", "fred");
        this.displayAllIssues();
        this.assertTextNotPresent(GROUP_CF_ISSUE_ID);
        this.gotoIssue(GROUP_CF_ISSUE_ID);
        this.assertTextPresent(PERMISSION_VIOLATION_ERROR);
    }

    public void testViewIssueWithGroupCustomFieldDeleted() {
        this.deleteCustomField(GROUP_CUSTOM_FIELD_ID);
        this.assertTextPresent("Custom field cannot be deleted because it is used in the following Issue Level Security Scheme(s): My Issue Security Scheme");
    }

    public void testViewIssueWithUserCustomFieldDeleted() {
        this.deleteCustomField(USER_CUSTOM_FIELD_ID);
        this.assertTextPresent("Custom field cannot be deleted because it is used in the following Issue Level Security Scheme(s): My Issue Security Scheme");
    }

    public void _testSearchWithGroupCustomFieldDeleted() {
        this.deleteCustomField(GROUP_CUSTOM_FIELD_ID);
        this.displayAllIssues();
        this.assertTextNotPresent(GROUP_CF_ISSUE_ID);
    }

    public void _testSearchWithUserCustomFieldDeleted() {
        this.deleteCustomField(USER_CUSTOM_FIELD_ID);
        this.displayAllIssues();
        this.assertTextNotPresent(USER_CF_ISSUE_ID);
    }
}

