/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestIssueOperationsWithLimitedPermissions
extends JIRAWebTest {
    public static final String RESTRICTED_ISSUE_ID = "10000";
    public static final String PERMISSION_ERROR_DESC_ANONYMOUS = "You are not logged in, and do not have the permissions required to act on the selected issue as a guest.";
    public static final String PERMISSION_ERROR_DESC_USER = "You do not have permission to act on this issue.";
    private static final String LOGIN = "log in";
    private static final String SIGNUP = "sign up";

    public TestIssueOperationsWithLimitedPermissions(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.login("admin", "admin");
        this.restoreData("TestIssueOperationsWithLimitedPermissionsProEnt.xml");
    }

    public void testIssueOperationsWithLimitedPermissions() {
        this._testIssueOperationsWithLimitedPermissionsStandard();
        this._testIssueOperationsWithLimitedPermissionsProfessionalAndEnterprise();
    }

    public void _testIssueOperationsWithLimitedPermissionsStandard() {
        this.assertActionIsInaccessibleToAnonymousUser("ViewIssue.jspa?", "new test issue", "You cannot view this URL as a guest", true);
        this.assertActionIsInaccessibleToUser("ViewIssue.jspa?", "new test issue", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsAccessibleToAdmin("ViewIssue.jspa?", "new test issue", "You cannot view this URL as a guest");
        this.assertActionIsInaccessibleToAnonymousUser("ViewIssue.jspa?vote=unvote&", "new test issue", "You cannot view this URL as a guest", true);
        this.assertActionIsInaccessibleToUser("ViewIssue.jspa?vote=unvote&", "new test issue", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsAccessibleToAdmin("ViewIssue.jspa?vote=unvote&", "new test issue", "You cannot view this URL as a guest");
        this.assertTextPresent("You have not voted for this issue");
        this.assertActionIsInaccessibleToAnonymousUser("ViewIssue.jspa?vote=vote&", "new test issue", "You cannot view this URL as a guest", true);
        this.assertActionIsInaccessibleToUser("ViewIssue.jspa?vote=vote&", "new test issue", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsAccessibleToAdmin("ViewIssue.jspa?vote=vote&", "new test issue", "You cannot view this URL as a guest");
        this.assertTextPresent("You have already voted in support of this issue");
        this.assertActionIsInaccessibleToAnonymousUser("ViewIssue.jspa?watch=true&", "new test issue", "You cannot view this URL as a guest", true);
        this.assertActionIsInaccessibleToUser("ViewIssue.jspa?watch=true&", "new test issue", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsAccessibleToAdmin("ViewIssue.jspa?watch=true&", "new test issue", "You cannot view this URL as a guest");
        this.assertTextPresent("You are watching this issue");
        this.assertActionIsInaccessibleToAnonymousUser("ViewIssue.jspa?watch=false&", "new test issue", "You cannot view this URL as a guest", true);
        this.assertActionIsInaccessibleToUser("ViewIssue.jspa?watch=false&", "new test issue", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsAccessibleToAdmin("ViewIssue.jspa?watch=false&", "new test issue", "You cannot view this URL as a guest");
        this.assertTextPresent("You are not watching this issue");
        this.assertActionIsInaccessibleToAnonymousUser("WorkflowUIDispatcher.jspa?action=5&", "Resolve Issue", "You cannot view this URL as a guest", true);
        this.assertActionIsInaccessibleToUser("WorkflowUIDispatcher.jspa?action=5&", "Resolve Issue", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsAccessibleToAdmin("WorkflowUIDispatcher.jspa?action=5&", "Resolve Issue", "You cannot view this URL as a guest");
        this.assertActionIsInaccessibleToAnonymousUser("AssignIssue!default.jspa?", "Assign Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("AssignIssue!default.jspa?", "Assign Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("AssignIssue!default.jspa?", "Assign Issue", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("CommentAssignIssue!default.jspa?action=5&", "Resolve Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("CommentAssignIssue!default.jspa?action=5&", "Resolve Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("CommentAssignIssue!default.jspa?action=5&", "Resolve Issue", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("EditIssue!default.jspa?", "Edit Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("EditIssue!default.jspa?", "Edit Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("EditIssue!default.jspa?", "Edit Issue", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("CloneIssueDetails!default.jspa?", "Summary", "You do not have the permission to see the specified issue", false);
        this.assertActionIsInaccessibleToUser("CloneIssueDetails!default.jspa?", "Summary", "You do not have the permission to see the specified issue");
        this.assertActionIsAccessibleToAdmin("CloneIssueDetails!default.jspa?", "Summary", "You do not have the permission to see the specified issue");
        this.assertActionIsInaccessibleToAnonymousUser("MoveIssue!default.jspa?", "Current Project", "You are not logged in and do not have the permissions required to browse projects as a guest.", true);
        this.assertActionIsInaccessibleToUser("MoveIssue!default.jspa?", "Current Project", "You do not have the permissions required to browse any projects.");
        this.assertActionIsAccessibleToAdmin("MoveIssue!default.jspa?", "Current Project", "You are not logged in and do not have the permissions required to browse projects as a guest.");
        this.assertActionIsInaccessibleToAnonymousUser("ViewVoters!default.jspa?", "View Voters", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ViewVoters!default.jspa?", "View Voters", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ViewVoters!default.jspa?", "View Voters", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("ViewVoters!addVote.jspa?", "View Voters", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ViewVoters!addVote.jspa?", "View Voters", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ViewVoters!addVote.jspa?", "View Voters", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("ViewVoters!removeVote.jspa?", "View Voters", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ViewVoters!removeVote.jspa?", "View Voters", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ViewVoters!removeVote.jspa?", "View Voters", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!default.jspa?", "Manage Watch List", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!default.jspa?", "Manage Watch List", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!default.jspa?", "Manage Watch List", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!startWatching.jspa?", "Manage Watch List", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!startWatching.jspa?", "Manage Watch List", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!startWatching.jspa?", "Manage Watch List", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!stopWatching.jspa?", "Manage Watch List", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!stopWatching.jspa?", "Manage Watch List", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!stopWatching.jspa?", "Manage Watch List", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!startWatchers.jspa?userNames=admin&", "Manage Watch List", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!startWatchers.jspa?userNames=admin&", "Manage Watch List", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!startWatchers.jspa?userNames=admin&", "Manage Watch List", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!stopWatchers.jspa?userNames=admin&", "Manage Watch List", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!stopWatchers.jspa?userNames=admin&", "Manage Watch List", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!stopWatchers.jspa?userNames=admin&", "Manage Watch List", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("CreateWorklog!default.jspa?", "Log Work", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("CreateWorklog!default.jspa?", "Log Work", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("CreateWorklog!default.jspa?", "Log Work", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("UpdateWorklog!default.jspa?worklogId=10000&", "Log Work", "It seems that you have tried to perform an operation which you are not permitted to perform.", false);
        this.assertActionIsInaccessibleToUser("UpdateWorklog!default.jspa?worklogId=10000&", "Log Work", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsAccessibleToAdmin("UpdateWorklog!default.jspa?worklogId=10000&", "Log Work", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsInaccessibleToAnonymousUser("DeleteWorklog!default.jspa?worklogId=10000&", "Delete Worklog", "It seems that you have tried to perform an operation which you are not permitted to perform.", false);
        this.assertActionIsInaccessibleToUser("DeleteWorklog!default.jspa?worklogId=10000&", "Delete Worklog", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsAccessibleToAdmin("DeleteWorklog!default.jspa?worklogId=10000&", "Delete Worklog", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsInaccessibleToAnonymousUser("EditComment!default.jspa?commentId=10000&", "ignoreMeAndSeeAssertBelow", "You do not have the permission for this comment.", false);
        this.assertTextPresent("Edit Comment");
        this.assertActionIsInaccessibleToUser("EditComment!default.jspa?commentId=10000&", "ignoreMeAndSeeAssertBelow", "You do not have the permission for this comment.");
        this.assertTextPresent("Edit Comment");
        this.assertActionIsAccessibleToAdmin("EditComment!default.jspa?commentId=10000&", "Edit Comment", "You do not have the permission for this comment.");
        this.assertActionIsInaccessibleToAnonymousUser("DeleteComment!default.jspa?", "ignoreMeAndSeeAssertBelow", "You do not have the permission for this comment.", false);
        this.assertTextPresent("Delete Comment");
        this.assertActionIsInaccessibleToUser("DeleteComment!default.jspa?", "ignoreMeAndSeeAssertBelow", "You do not have the permission for this comment.");
        this.assertTextPresent("Delete Comment");
        this.assertActionIsAccessibleToAdmin("DeleteComment!default.jspa?", "Delete Comment", "You do not have the permission for this comment.");
    }

    private void _testIssueOperationsWithLimitedPermissionsProfessionalAndEnterprise() {
        this.assertActionIsInaccessibleToAnonymousUser("CreateSubTaskIssue!default.jspa?parentIssueId=10000&", "Create Sub-Task Issue", "You are not logged in and do not have the permissions required to browse projects as a guest.", true);
        this.assertActionIsInaccessibleToUser("CreateSubTaskIssue!default.jspa?parentIssueId=10000&", "Create Sub-Task Issue", "You do not have the permissions required to browse any projects");
        this.assertActionIsAccessibleToAdmin("CreateSubTaskIssue!default.jspa?parentIssueId=10000&", "Create Sub-Task Issue", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("CreateSubTaskIssue.jspa?parentIssueId=10000&", "Create Sub-Task Issue", "You are not logged in and do not have the permissions required to browse projects as a guest.", true);
        this.assertActionIsInaccessibleToUser("CreateSubTaskIssue.jspa?parentIssueId=10000&", "Create Sub-Task Issue", "You do not have the permissions required to browse any projects");
        this.assertActionIsAccessibleToAdmin("CreateSubTaskIssue.jspa?parentIssueId=10000&", "Create Sub-Task Issue", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("CreateSubTaskIssueDetails.jspa?parentIssueId=10000&issuetype=5&pid=10000&", "ignoreMeAndSeeAssertBelow", "pid: Anonymous users do not have permission to create issues in this project. Please try logging in first.", false);
        this.assertTextPresent("Create Sub-Task Issue");
        this.assertActionIsInaccessibleToUser("CreateSubTaskIssueDetails.jspa?parentIssueId=10000&issuetype=5&pid=10000&", "ignoreMeAndSeeAssertBelow", "pid: You do not have permission to create issues in this project.");
        this.assertTextPresent("Create Sub-Task Issue");
        this.assertActionIsAccessibleToAdmin("CreateSubTaskIssueDetails.jspa?parentIssueId=10000&issuetype=5&pid=10000&", "Create Sub-Task Issue", PERMISSION_ERROR_DESC_ANONYMOUS);
    }

    private void assertActionIsInaccessibleToAnonymousUser(String actionUrl, String textNotPresent, String error_desc, boolean hasLoginLink) {
        this.logout();
        this.gotoPage("/secure/" + actionUrl + "id=" + RESTRICTED_ISSUE_ID);
        this.assertTextPresent(error_desc);
        if (hasLoginLink) {
            this.assertLinkPresentWithText(LOGIN);
            this.assertLinkPresentWithText(SIGNUP);
        }
        this.assertTextNotPresent(textNotPresent);
    }

    private void assertActionIsInaccessibleToUser(String actionUrl, String textNotPresent, String error_desc) {
        this.login("fred", "fred");
        this.gotoPage("/secure/" + actionUrl + "id=" + RESTRICTED_ISSUE_ID);
        this.assertTextPresent(error_desc);
        this.assertLinkNotPresentWithText(LOGIN);
        this.assertLinkNotPresentWithText(SIGNUP);
        this.assertTextNotPresent(textNotPresent);
    }

    private void assertActionIsAccessibleToAdmin(String actionUrl, String textPresent, String textNotPresent) {
        this.login("admin", "admin");
        this.gotoPage("/secure/" + actionUrl + "id=" + RESTRICTED_ISSUE_ID);
        this.assertTextNotPresent(textNotPresent);
        this.assertLinkNotPresentWithText(LOGIN);
        this.assertLinkNotPresentWithText(SIGNUP);
        this.assertTextPresent(textPresent);
    }
}

