/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestIssueOperationsOnDeletedIssue
extends JIRAWebTest {
    public static final String DELETED_ISSUE_ID = "10000";
    public static final String EXISTING_ISSUE_ID = "10001";
    public static final String DELETED_ISSUE_ERROR = "The issue no longer exists.";
    public static final String DELETED_VIEW_ISSUE_ERROR = "The issue you are trying to view does not exist.";

    public TestIssueOperationsOnDeletedIssue(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueOperationsOnDeletedIssueProEnt.xml");
    }

    public void tearDown() {
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testIssueOperationsOnDeletedIssue() {
        this._testIssueOperationsOnDeletedIssueStandard();
        this._testIssueOperationsOnDeletedIssueProfessionalAndEnterprise();
    }

    public void _testIssueOperationsOnDeletedIssueStandard() {
        this.assertDeletedIssueError("ViewIssue.jspa?", "Issue Details", true);
        this.assertDeletedIssueError("ViewIssue.jspa?vote=unvote&", "Issue Details", true);
        this.assertDeletedIssueError("ViewIssue.jspa?vote=vote&", "Issue Details", true);
        this.assertDeletedIssueError("ViewIssue.jspa?watch=true&", "Issue Details", true);
        this.assertDeletedIssueError("ViewIssue.jspa?watch=false&", "Issue Details", true);
        this.assertDeletedIssueError("WorkflowUIDispatcher.jspa?action=5&", "Resolve Issue");
        this.gotoPage("/secure/WorkflowUIDispatcher.jspa?id=10001&action=5");
        this.assertTextPresent("Resolve Issue");
        this.gotoPage("/secure/WorkflowUIDispatcher.jspa?id=10000&action=5");
        this.assertTextPresent(DELETED_ISSUE_ERROR);
        this.assertTextNotPresent("Resolve Issue");
        this.assertDeletedIssueError("CommentAssignIssue!default.jspa?action=5&", "Resolve Issue");
        this.assertDeletedIssueError("AssignIssue!default.jspa?", "Assign Issue");
        this.assertDeletedIssueError("EditIssue!default.jspa?", "Edit Issue");
        this.assertDeletedIssueError("CloneIssueDetails!default.jspa?", "Summary");
        this.assertDeletedIssueError("MoveIssue!default.jspa?", "Current Project");
        this.assertDeletedIssueError("ViewVoters!default.jspa?", "View Voters");
        this.assertDeletedIssueError("ViewVoters!addVote.jspa?", "View Voters");
        this.assertDeletedIssueError("ViewVoters!removeVote.jspa?", "View Voters");
        this.assertDeletedIssueError("ManageWatchers!default.jspa?", "Manage Watch List");
        this.assertDeletedIssueError("ManageWatchers!startWatching.jspa?", "Manage Watch List");
        this.assertDeletedIssueError("ManageWatchers!stopWatching.jspa?", "Manage Watch List");
        this.assertDeletedIssueError("ManageWatchers!startWatchers.jspa?userNames=admin&", "Manage Watch List");
        this.assertDeletedIssueError("ManageWatchers!stopWatchers.jspa?userNames=admin&", "Manage Watch List");
        this.assertDeletedIssueError("CreateWorklog!default.jspa?", "Log Work");
        this.assertDeletedIssueError("UpdateWorklog!default.jspa?worklogId=10000&", "Log Work");
        this.assertDeletedIssueError("DeleteWorklog!default.jspa?worklogId=10000&", "Delete Worklog");
        this.assertDeletedIssueError("EditComment!default.jspa?commentId=10000&", "Edit Comment", "first comment", false);
    }

    private void _testIssueOperationsOnDeletedIssueProfessionalAndEnterprise() {
        this.gotoPage("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10001");
        this.assertTextPresent("Create Sub-Task Issue");
        this.gotoPage("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10000");
        this.assertTextNotPresent("Create Sub-Task Issue");
        this.assertTextPresent("Unable to perform action");
        this.assertTextPresent("The current issue is null. Cannot display the issue.");
        this.gotoPage("/secure/CreateSubTaskIssue.jspa?parentIssueId=10001");
        this.assertTextPresent("Create Sub-Task Issue");
        this.gotoPage("/secure/CreateSubTaskIssue.jspa?parentIssueId=10000");
        this.assertTextNotPresent("Create Sub-Task Issue");
        this.assertTextPresent("Unable to perform action");
        this.assertTextPresent("The current issue is null. Cannot display the issue.");
        this.gotoFieldConfigurationDefault();
        this.clickLink("hide_13");
        this.gotoPage("/secure/CreateSubTaskIssueDetails.jspa?issuetype=5&pid=10000&summary=createdSubtask&assignee=admin&reporter=admin&parentIssueId=10001");
        this.assertTextPresent("createdSubtask");
        this.assertTextNotPresent("Create Sub-Task Issue");
        this.assertTextNotPresent("Enter the details of the issue");
        this.assertTextPresent("Sub-task");
        this.gotoPage("/secure/CreateSubTaskIssueDetails.jspa?issuetype=5&pid=10000&summary=createdSubtask&assignee=admin&reporter=admin&parentIssueId=10000");
        this.assertTextPresent("Parent Issue cannot be null");
    }

    private void assertDeletedIssueError(String actionUrl, String textNotPresent, boolean isViewIssue) {
        this.assertDeletedIssueError(actionUrl, textNotPresent, textNotPresent, isViewIssue);
    }

    private void assertDeletedIssueError(String actionUrl, String textNotPresent) {
        this.assertDeletedIssueError(actionUrl, textNotPresent, textNotPresent, false);
    }

    private void assertDeletedIssueError(String actionUrl, String textPresent, String textNotPresent, boolean isViewIssue) {
        this.gotoPage("/secure/" + actionUrl + "id=" + EXISTING_ISSUE_ID);
        this.assertTextPresent(textPresent);
        this.gotoPage("/secure/" + actionUrl + "id=" + DELETED_ISSUE_ID);
        if (isViewIssue) {
            this.assertTextPresent(DELETED_VIEW_ISSUE_ERROR);
        } else {
            this.assertTextPresent(DELETED_ISSUE_ERROR);
        }
        this.assertTextNotPresent(textNotPresent);
    }
}

