/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.webtests.JIRAWebTest;
import java.io.File;

public class TestIssueOperations
extends JIRAWebTest {
    private static final String ATTACHMENT_DOUBLE_QUOTES = "bigdummy\"\"Attachment";
    private static final String ISSUE_KEY_1 = "HSP-1";
    private static final String ISSUE_KEY_2 = "HSP-2";
    private static final String TEST_USER_1 = "testuser";
    private static final String TEST_USER_2 = "testuser2";

    public TestIssueOperations(String name) {
        super(name);
    }

    public void testIssueOperations() {
        this.restoreData("TestIssueOperations.xml");
        this.enableAttachments();
        this.issueOperationsWithWorkOnPermission(ISSUE_KEY_1);
        this.issueOperationWithUnassignableUser(ISSUE_KEY_1);
        this.issueOperationWithAssignPermission(ISSUE_KEY_1);
        this.issueOperationWithCreateAttachmentsPermission(ISSUE_KEY_1);
        this.issueOperationCacheControl(ISSUE_KEY_1);
        this.issueWithoutBrowsePermissionLookForRDF(ISSUE_KEY_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void issueWithoutBrowsePermissionLookForRDF(String issueKey) {
        try {
            this.removeGroupPermission(10, "jira-users");
            this.addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
            this.logout();
            this.login("bob", "bob_password");
            this.beginAt("/browse/" + issueKey);
            this.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
            this.assertTextPresent("rdf:Description");
            this.assertTextPresent("trackback:ping=");
        }
        finally {
            try {
                this.logout();
                this.login("admin", "admin");
                this.deleteUser("bob");
                this.grantGroupPermission(10, "jira-users");
            }
            catch (Exception exception) {}
        }
    }

    public void issueOperationsWithWorkOnPermission(String issueKey) {
        TestIssueOperations.log("Issue Operation: Test availability of Log Work Link with 'Work On Issues' permission.");
        this.activateTimeTracking();
        this.removeGroupPermission(20, "jira-developers");
        this.gotoIssue(issueKey);
        this.assertTextPresent("You don't have permission to work on this issue.");
        this.assertLinkNotPresent("log_work");
        this.grantGroupPermission(20, "jira-developers");
        this.gotoIssue(issueKey);
        this.assertTextNotPresent("You don't have permission to work on this issue.");
        this.assertLinkPresent("log_work");
        this.deactivateTimeTracking();
    }

    public void testLogWorkOperationTimeTrackingDisabled() {
        this.restoreData("TestIssueOperations.xml");
        this.deactivateTimeTracking();
        this.gotoIssue(ISSUE_KEY_1);
        this.assertTextNotPresent("You don't have permission to work on this issue.");
        this.assertLinkNotPresent("log_work");
    }

    public void testLogWorkOperationAnonymous() {
        this.restoreData("TestIssueOperations.xml");
        this.activateTimeTracking();
        this.clickLink("admin_link");
        this.clickLink("permission_schemes");
        this.clickLinkWithText("Default Permission Scheme");
        this.clickLink("add_perm_10");
        this.checkCheckbox("type", "group");
        this.submit(" Add ");
        this.logout();
        this.gotoPage("/browse/HSP-1");
        this.assertTextNotPresent("You don't have permission to work on this issue.");
        this.assertLinkNotPresent("log_work");
    }

    public void testLogWorkOperationIssueInNonEditableState() {
        this.restoreData("TestIssueOperations.xml");
        this.activateTimeTracking();
        this.gotoIssue(ISSUE_KEY_1);
        this.clickLinkWithText("Close Issue");
        this.submit("Close Issue");
        this.assertTextNotPresent("You don't have permission to work on this issue.");
        this.assertLinkNotPresent("log_work");
    }

    public void testLogWorkOperationHappyPath() {
        this.restoreData("TestIssueOperations.xml");
        this.activateTimeTracking();
        this.gotoIssue(ISSUE_KEY_1);
        this.assertTextNotPresent("You don't have permission to work on this issue.");
        this.assertLinkPresent("log_work");
    }

    public void issueOperationWithUnassignableUser(String issueKey) {
        TestIssueOperations.log("Issue Operation: Attempt to set the assignee to be an unassignable user ...");
        this.removeGroupPermission(17, "jira-developers");
        this.gotoIssue(issueKey);
        this.clickLink("assign_issue");
        this.submit("Assign");
        this.assertTextPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.grantGroupPermission(17, "jira-developers");
    }

    public void issueOperationWithAssignPermission(String issueKey) {
        TestIssueOperations.log("Issue Operation: Test the availability of the 'Assign Link' with 'Assign Issues' Permission.");
        this.gotoIssue(issueKey);
        this.assertLinkPresent("assign_issue");
        this.removeGroupPermission(13, "jira-developers");
        this.gotoIssue(issueKey);
        this.assertLinkNotPresent("assign_issue");
        this.grantGroupPermission(13, "jira-developers");
    }

    public void issueOperationWithCreateAttachmentsPermission(String issueKey) {
        TestIssueOperations.log("Issue Operation: Test the availability of the 'Attach Link' with 'Create Attachments' Permission.");
        this.removeGroupPermission(19, "jira-users");
        this.gotoIssue(issueKey);
        this.assertLinkNotPresent("attach_file");
        this.grantGroupPermission(19, "jira-users");
        this.gotoIssue(issueKey);
        this.assertLinkPresent("attach_file");
    }

    public void issueOperationAttachFileWithDoubleQuote(String issueKey) {
        TestIssueOperations.log("Issue Operation: Test the functionality of the 'Attach File' operation");
        File attachment = TestIssueOperations.generateAttachment(ATTACHMENT_DOUBLE_QUOTES, "Attachment for testing purposes");
        this.gotoIssue(issueKey);
        this.clickLink("attach_file");
        this.attachFile(attachment, "Attaching file to " + issueKey);
        this.assertTextPresent("The filename of the file contains an invalid character: \"");
    }

    public void issueOperationCacheControl(String issueKey) {
        TestIssueOperations.log("Issue Operation: Test cache control for Issue Navigator pages.");
        this.clickLink("find_link");
        this.submit("hide");
        String cache = this.getDialog().getResponse().getHeaderField("Cache-Control");
        TestIssueOperations.assertEquals((String)cache, (String)"no-cache, no-store, must-revalidate");
        this.gotoIssue(issueKey);
        cache = this.getDialog().getResponse().getHeaderField("Cache-Control");
        TestIssueOperations.assertEquals((String)cache, (String)"no-cache, no-store, must-revalidate");
    }

    public void testIssueOperationManageWatcherList() {
        this.restoreData("TestIssueOperationsWithReporter.xml");
        this.enableAttachments();
        this.grantPermissionToReporter(32);
        this.logout();
        this.login(TEST_USER_1, TEST_USER_1);
        this.gotoIssue(ISSUE_KEY_2);
        this.assertLinkPresent("watcher_issue");
        this.logout();
        this.login(TEST_USER_2, TEST_USER_2);
        this.assertLinkNotPresent("watcher_issue");
        this.logout();
    }
}

