/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestInlineIssueLinking
extends JIRAWebTest {
    String summary1;
    String summary2;
    String issueKey1;
    String issueKey2;
    private float jiraJavaVersion;
    private static final float MIN_JAVA_VERSION = 1.3f;

    public TestInlineIssueLinking(String name) {
        super(name);
    }

    public void _setUp() {
        this.restoreBlankInstance();
        this.logout();
        this.login("admin", "admin");
        if (this.projectExists("homosapien")) {
            TestInlineIssueLinking.log("Project: homosapien exists");
        } else {
            this.addProject("homosapien", "HSP", "", "admin", "project for homsapiens.");
        }
        this.createSecurityScheme("admin_only_scheme", "");
        this.createSecurityLevel("admin_only_scheme", "admin_only", "");
        this.addGroupToSecurityLevel("admin_only_scheme", "admin_only", "jira-administrators");
        this.associateSecuritySchemeToProject("homosapien", "admin_only_scheme");
        this.grantGroupPermission(26, "jira-administrators");
        this.addUser("link_user", "link_user", "link_user", "link_user@local");
        this.grantGroupPermission(10, "Anyone");
        this.summary1 = "summary1";
        this.summary2 = "summary2";
        this.issueKey1 = this.addIssue("homosapien", "HSP", "Bug", this.summary1, "Minor", null, null, null, "Administrator", "test environment 1", "test description to clone 1", null, "admin_only", null);
        this.issueKey2 = this.addIssue("homosapien", "HSP", "Bug", this.summary2, "Minor", null, null, null, "Administrator", "test environment 1", this.issueKey1, null, null, null);
    }

    public void testSummaryOnLink() {
        this.jiraJavaVersion = this.getJiraJavaVersion();
        if (this.jiraJavaVersion > 1.3f) {
            this._setUp();
            this.checkForUserWithPerm();
            this.checkForNoUser();
            this.checkForUserNoPerm();
            this.logout();
            this.login("admin", "admin");
            this.setFieldConfigurationFieldToRenderer("Default Field Configuration", "Description", "Wiki Style Renderer");
            this.checkForUserWithPerm();
            this.checkForNoUser();
            this.checkForUserNoPerm();
            this._tearDown();
        }
    }

    private void checkForUserNoPerm() {
        this.logout();
        this.login("link_user", "link_user");
        this.gotoIssue(this.issueKey2);
        this.assertTextPresent("Log Out");
        this.assertTextNotPresent("title=\"" + this.summary1 + "\"");
        this.assertLinkWithTextNotPresent(this.issueKey1);
    }

    private void checkForNoUser() {
        this.logout();
        this.clickLinkWithText("Log in again.");
        this.gotoIssue(this.issueKey2);
        this.assertTextPresent("Log In");
        this.assertTextNotPresent("title=\"" + this.summary1 + "\"");
        this.assertLinkWithTextNotPresent(this.issueKey1);
    }

    private void checkForUserWithPerm() {
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(this.issueKey2);
        this.assertTextPresent("title=\"" + this.summary1 + "\"");
        this.assertTextPresent("/browse/" + this.issueKey1);
    }

    public void _tearDown() {
        this.logout();
        this.login("admin", "admin");
        this.setFieldConfigurationFieldToRenderer("Default Field Configuration", "Description", "Default Text Renderer");
        this.removeGroupPermission(10, "Anyone");
        this.removeGroupPermission(26, "jira-administrators");
        this.associateSecuritySchemeToProject("homosapien", "None");
        this.deleteSecurityScheme("admin_only_scheme");
    }
}

