/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import net.sourceforge.jwebunit.ExpectedRow;
import net.sourceforge.jwebunit.ExpectedTable;

public class TestEnvironmentField
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreData("TestEnvironmentField.xml");
    }

    public void testEnvironmentFieldNeverHidden() throws Exception {
        this.assertEnvironmentFieldShownOnViewIssue(true);
        this.navigation.gotoAdminSection("field_screens");
        this.tester.clickLink("configure_fieldscreen_Default Screen");
        this.tester.checkCheckbox("removeField_10", "on");
        this.tester.submit("deleteFieldsFromTab");
        this.assertEnvironmentFieldShownOnViewIssue(false);
    }

    public void testHideShowToggleButton() throws Exception {
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertTextNotPresent("Hide");
        this.tester.assertTextNotPresent("<div id=\"environment-open\">");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.assertTextPresent("Hide");
        this.tester.assertTextPresent("<div id=\"environment-open\">");
        this.tester.assertTextPresent("<div id=\"environment-closed\" style=\"display: none;\">");
    }

    private void assertEnvironmentFieldShownOnViewIssue(boolean shouldBeOnEdit) {
        this.navigation.issue().viewIssue("HSP-1");
        ExpectedTable expectedTable = new ExpectedTable();
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"Environment:", "this is the Environment Field"}));
        this.tester.assertTableEquals("issueDetailsTable", expectedTable);
        this.tester.clickLink("edit_issue");
        if (shouldBeOnEdit) {
            this.tester.assertTextPresent("Environment");
        } else {
            this.tester.assertTextNotPresent("Environment");
        }
    }
}

