/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.webtests.JIRAWebTest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TestCreateIssueViaDirectLink
extends JIRAWebTest {
    private static final String PROJECT_STD_NAME = "standardProject";
    private static final String PROJECT_ANY_NAME = "anyone";
    private static final String PROJECT_DEV_NAME = "developerProject";
    private static final String ERROR_MSG_NO_PERM_AND_NOT_LOGGED_IN = "You are not logged in, and do not have the permissions required to create an issue in this project as a guest.";
    private static final String ERROR_MSG_INVALID_PID = "You have not selected a valid project to create an issue in.";
    private static final String ERROR_MSG_NO_PERMISSION_TO_CREATE_ISSUE = "You do not have permission to create issues in this project.";
    private static final String SUMMARY_PREFIX = "test create issue via direct link";
    private static final String CUSTOM_FIELD_TEXTAREA_ID = "10000";
    private static final String CUSTOM_FIELD_DATEPICKER_ID = "10001";
    private static final String CUSTOM_FIELD_MULTICHECKBOX_ID = "10002";
    private static final String CUSTOM_FIELD_USERPICKER_ID = "10003";
    private static final String CUSTOM_FIELD_FLOAT_ID = "10004";
    private static final String CUSTOM_FIELD_TEXTAREA = "textarea";
    private static final String CUSTOM_FIELD_DATEPICKER = "datepicker";
    private static final String CUSTOM_FIELD_MULTICHECKBOX = "multicheckbox";
    private static final String CUSTOM_FIELD_USERPICKER = "userpicker";
    private static final String CUSTOM_FIELD_FLOAT = "numberfield";
    private static Map pidToName;
    public static final Map issueIdToName;
    private static final String LOGIN = "log in";

    public TestCreateIssueViaDirectLink(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestCreateIssueViaDirectLink.xml");
        pidToName = new HashMap();
        pidToName.put(CUSTOM_FIELD_TEXTAREA_ID, PROJECT_STD_NAME);
        pidToName.put(CUSTOM_FIELD_DATEPICKER_ID, PROJECT_DEV_NAME);
        pidToName.put(CUSTOM_FIELD_MULTICHECKBOX_ID, PROJECT_ANY_NAME);
    }

    public void tearDown() {
        this.login("admin", "admin");
        super.tearDown();
    }

    public void testCreateIssueViaDirectLink() {
        this.directIssueCreationLoggedInValidParams();
        this.directIssueCreationLoggedInNoPid();
        this.directIssueCreationLoggedInInvalidPid();
        this.directIssueCreationLoggedInNoPerm();
        this.directIssueCreationNotLoggedInNoGuestPerm();
        this.directIssueCreationNotLoggedInInvalidPid();
        this.directIssueCreationNotLoggedInNoPid();
        this.directIssueCreationNotLoggedInGuestPerm();
    }

    private void directIssueCreationNotLoggedInGuestPerm() {
        this.logout();
        Map outputParams = this.createIssueViaDirectLink(CUSTOM_FIELD_MULTICHECKBOX_ID, "2", "test create issue via direct link1", true);
        this.submit("Create");
        this.assertCreatedIssueDetails(outputParams);
    }

    private void directIssueCreationNotLoggedInNoPid() {
        this.logout();
        this.createIssueViaDirectLink(null, "1", "test create issue via direct link2");
        this.assertTextPresent(ERROR_MSG_NO_PERM_AND_NOT_LOGGED_IN);
    }

    private void directIssueCreationNotLoggedInInvalidPid() {
        this.logout();
        this.createIssueViaDirectLink("invalid", "2", "test create issue via direct link3");
        this.assertTextPresent(ERROR_MSG_NO_PERM_AND_NOT_LOGGED_IN);
    }

    private void directIssueCreationNotLoggedInNoGuestPerm() {
        this.logout();
        Map outputParams = this.createIssueViaDirectLink(CUSTOM_FIELD_DATEPICKER_ID, "4", "test create issue via direct link4");
        this.assertTextPresent("You are not logged in, and do not have the permissions required to create an issue in this project as a guest");
        this.assertLinkPresentWithText(LOGIN);
        this.clickLinkWithText(LOGIN);
        this.setFormElement("os_username", "admin");
        this.checkCheckbox("os_password", "admin");
        this.submit("");
        this.assertCreateIssueDetailsForm(this.getInputParamsForAssertion(CUSTOM_FIELD_DATEPICKER_ID, "4", "test create issue via direct link4"));
        this.submit("Create");
        this.assertCreatedIssueDetails(outputParams);
    }

    private void directIssueCreationLoggedInNoPerm() {
        this.login("bob", "bob_password");
        this.createIssueViaDirectLink(CUSTOM_FIELD_DATEPICKER_ID, "3", "test create issue via direct link5");
        this.assertTextPresent(ERROR_MSG_NO_PERMISSION_TO_CREATE_ISSUE);
    }

    private void directIssueCreationLoggedInInvalidPid() {
        this.login("admin", "admin");
        this.createIssueViaDirectLink("invalid", "2", "test create issue via direct link6");
        this.assertTextPresent(ERROR_MSG_INVALID_PID);
    }

    private void directIssueCreationLoggedInNoPid() {
        this.login("admin", "admin");
        this.createIssueViaDirectLink(null, "4", "test create issue via direct link7");
        this.assertTextPresent(ERROR_MSG_INVALID_PID);
    }

    private void directIssueCreationLoggedInValidParams() {
        this.login("admin", "admin");
        Map outputParams = this.createIssueViaDirectLink(CUSTOM_FIELD_TEXTAREA_ID, "1", "test create issue via direct link8", true);
        this.submit("Create");
        this.assertCreatedIssueDetails(outputParams);
    }

    private Map createIssueViaDirectLink(String pid, String issuetypeId, String summary) {
        return this.createIssueViaDirectLink(pid, issuetypeId, summary, false);
    }

    private Map createIssueViaDirectLink(String pid, String issuetypeId, String summary, boolean assertParams) {
        Map inputParams = this.getInputParams(pid, issuetypeId, summary);
        Map inputParamsForAssertion = this.getInputParamsForAssertion(pid, issuetypeId, summary);
        this.createIssueViaDirectLink(inputParams, inputParamsForAssertion, assertParams);
        return this.getOutputParams(pid, summary, issuetypeId);
    }

    private Map getInputParams(String pid, String issuetypeId, String summary) {
        HashMap<String, String> inputParams = new HashMap<String, String>();
        inputParams.put("pid", pid);
        inputParams.put("issuetype", issuetypeId);
        inputParams.put("summary", summary);
        inputParams.put("reporter", "admin");
        inputParams.put("assignee", "admin");
        inputParams.put("description", "description");
        inputParams.put("customfield_10000", "this is a textarea");
        inputParams.put("customfield_10001", "6/Dec/05");
        inputParams.put("customfield_10002", "1");
        inputParams.put("customfield_10003", "bob");
        inputParams.put("customfield_10004", "123456789");
        return inputParams;
    }

    private Map getInputParamsForAssertion(String pid, String issuetypeId, String summary) {
        HashMap<String, String> inputParams = new HashMap<String, String>();
        inputParams.put("pid", pid);
        inputParams.put("issuetype", issuetypeId);
        inputParams.put("summary", summary);
        inputParams.put("reporter", "admin");
        inputParams.put("assignee", "admin");
        inputParams.put("description", "\ndescription");
        inputParams.put("customfield_10000", "\nthis is a textarea");
        inputParams.put("customfield_10001", "6/Dec/05");
        inputParams.put("customfield_10002", "1");
        inputParams.put("customfield_10003", "bob");
        inputParams.put("customfield_10004", "123456789");
        return inputParams;
    }

    private Map getOutputParams(String pid, String summary, String issuetypeId) {
        HashMap<Object, String> outputParams = new HashMap<Object, String>();
        outputParams.put(pidToName.get(pid), summary);
        outputParams.put("<b>Type:</b>", (String)issueIdToName.get(issuetypeId));
        outputParams.put("<b>Reporter:</b>", "admin");
        outputParams.put("<b>Description</b>", "description");
        outputParams.put("<b>textarea:</b>", "this is a textarea");
        outputParams.put("<b>datepicker:</b>", " 06/Dec/05");
        outputParams.put("<b>multicheckbox:</b>", "1");
        outputParams.put("<b>userpicker:</b>", "Bob The Builder");
        outputParams.put("<b>numberfield:</b>", "123,456,789");
        return outputParams;
    }

    private void createIssueViaDirectLink(Map inputParams, Map inputParamsForAssertion, boolean assertParams) {
        StringBuffer linkToCreateIssue = new StringBuffer(this.getEnvironmentData().getContext() + "/secure/CreateIssueDetails!init.jspa?");
        Iterator iter = inputParams.entrySet().iterator();
        int count = 1;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (count != 1) {
                linkToCreateIssue.append("&");
            }
            linkToCreateIssue.append(entry.getKey()).append("=").append(entry.getValue());
            ++count;
        }
        String url = linkToCreateIssue.toString();
        this.gotoPage(url);
        if (assertParams) {
            this.assertCreateIssueDetailsForm(inputParamsForAssertion);
        }
    }

    private void assertCreateIssueDetailsForm(Map inputParams) {
        for (Map.Entry entry : inputParams.entrySet()) {
            String field = (String)entry.getKey();
            String value = (String)entry.getValue();
            if ("pid".equals(field)) {
                this.assertTextPresentBeforeText("Project:", (String)pidToName.get(value));
                continue;
            }
            if ("issuetype".equals(field)) {
                this.assertTextPresentBeforeText("Issue Type:", (String)issueIdToName.get(value));
                continue;
            }
            this.assertFormElementEquals(field, value);
        }
    }

    private void assertCreatedIssueDetails(Map outputParams) {
        this.assertTextPresent("Issue Details");
        for (Map.Entry entry : outputParams.entrySet()) {
            this.assertTextPresentBeforeText((String)entry.getKey(), (String)entry.getValue());
        }
    }

    static {
        issueIdToName = new HashMap();
        issueIdToName.put("1", "Bug");
        issueIdToName.put("2", "New Feature");
        issueIdToName.put("3", "Task");
        issueIdToName.put("4", "Improvement");
    }
}

