/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.webtests.JIRAWebTest;

public class TestCreateIssue
extends JIRAWebTest {
    private static final String PROJECT_MONKEY_ID = "10001";
    private static final String PROJECT_HOMOSAPIEN_ID = "10000";
    private static final String LOGIN_BUTTON = "login";
    private static final String LOGIN = "log in";

    public TestCreateIssue(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    public void testCreateIssueInJiraWithSingleProjectAndSingleIssueType() {
        this.clickLink("create_link");
        this.assertTextPresent("Choose the project and issue type");
        this.assertTextNotPresent("Enter the details of the issue");
        this.assertFormElementPresent("pid");
        this.assertFormElementPresent("issuetype");
        this.assertFormElementNotPresent("summary");
        this.restoreData("TestOneProjectWithOneIssueType.xml");
        this.clickLink("create_link");
        this.assertTextNotPresent("Choose the project and issue type");
        this.assertTextPresent("Enter the details of the issue");
        this.assertTextSequence(new String[]{"Project:", "homosapien", "Issue Type:", "Bug"});
        this.assertFormElementPresent("summary");
        this.clickLink("admin_link");
        this.clickLinkWithText("homosapien");
        this.clickLink("selectIssueTypeScheme");
        this.checkCheckbox("createType", "chooseScheme");
        this.selectOption("schemeId", "Bugs & Sub-tasks");
        this.submit();
        this.clickLink("create_link");
        this.assertTextNotPresent("Choose the project and issue type");
        this.assertTextPresent("Enter the details of the issue");
        this.assertTextSequence(new String[]{"Project:", "homosapien", "Issue Type:", "Bug"});
        this.assertFormElementPresent("summary");
    }

    public void testCreateIssue() {
        this.resetFields();
        String issueKey1 = this.createIssue();
        String issueKey2 = this.createIssueWithoutComponents();
        String issueKey3 = this.createIssueWithTimeTrackingDetails();
        String issueKey4 = this.createIssueWithoutAssignee();
        this.createIssueWithNoSummary();
        this.createIssueWithRequiredFields();
        this.createIssueWithHiddenFields();
        this.createIssueWithInvalidDueDate();
        this.createIssueWithCreatePermission();
        this.createIssueWithSchedulePermission();
        this.createIssueWithAssignPermission();
        this.createIssueWithModifyReporterPermission();
        this.createIssueWithTimeTracking();
        this.createIssueWithUnassignableUser();
        this.deleteCreatedIssue(issueKey1);
        this.deleteCreatedIssue(issueKey2);
        this.deleteCreatedIssue(issueKey3);
        this.deleteCreatedIssue(issueKey4);
        this.createIssueWithNoBrowsePermission();
    }

    public void testCreateIssueSkipStep1OnlyOneProjectAndOneIssueType() {
        String[] data = new String[]{"TestCreateIssueOneProjectOneIssueType.xml", "TestCreateIssueOneIssueCreateProjectOneIssueType.xml"};
        for (int i = 0; i < data.length; ++i) {
            this.restoreData(data[i]);
            this.assertRedirectAndFollow("/secure/CreateIssue!default.jspa", ".*CreateIssue\\.jspa\\?pid=10001&issuetype=3$");
            this.assertTextSequence(new String[]{"Create Issue", "Enter the details of the issue...", "Project:", "monkey", "Issue Type:", "Task", "Summary"});
        }
    }

    public void testCreateIssueSkipStep1IssueTypeSchemeInfersOneProjectAndIssueType() {
        this.restoreData("TestCreateMonkeyHasOneIssueType.xml");
        this.gotoProjectBrowse("MKY");
        this.clickLink("create_link");
        this.assertRadioOptionSelected("pid", PROJECT_MONKEY_ID);
        this.assertTextSequence(new String[]{"Create Issue", "Choose the project and issue type"});
        this.assertRedirectAndFollow("/secure/CreateIssue!default.jspa?pid=10001", ".*CreateIssue\\.jspa\\?pid=10001&issuetype=1$");
        this.assertTextSequence(new String[]{"Create Issue", "Enter the details of the issue...", "Project:", "monkey", "Issue Type:", "Bug", "Summary"});
        this.gotoPage("/secure/CreateIssue!default.jspa?pid=10000");
        this.assertRadioOptionSelected("pid", PROJECT_HOMOSAPIEN_ID);
        this.assertTextSequence(new String[]{"Create Issue", "Choose the project and issue type"});
        this.logout();
        this.gotoPage("/secure/CreateIssue!default.jspa?pid=10001");
        this.assertTextPresent("You are not logged in, and do not have the permissions required to create an issue in this project as a guest.");
        this.clickLinkWithText(LOGIN);
        this.setFormElement("os_username", "admin");
        this.setFormElement("os_password", "admin");
        this.clickButton(LOGIN_BUTTON);
        this.assertTextSequence(new String[]{"Create Issue", "Enter the details of the issue...", "Project:", "monkey", "Issue Type:", "Bug", "Summary"});
    }

    public void testCreateIssueUserHasNoCreateIssuePermission() {
        this.restoreData("TestCreateIssueOneProjectOneIssueType.xml");
        this.login("fred");
        this.assertLinkNotPresent("create_link");
        this.gotoProjectBrowse("MKY");
        this.assertLinkNotPresentWithText("Create a new issue in project monkey");
        this.gotoPage("/secure/CreateIssue!default.jspa?pid=10001");
        this.assertTextSequence(new String[]{"Create Issue", "Choose the project and issue type"});
        this.assertTextPresent("You do not have permission to create issues in this project.");
        this.gotoPage("/secure/CreateIssue!default.jspa");
        this.assertTextSequence(new String[]{"Create Issue", "Choose the project and issue type"});
        this.assertTextPresent("You have not selected a valid project to create an issue in.");
    }

    public void testCreateIssueWithNoPidInUrlOneProjectAvailableIssueTypeInUrl() {
        this.restoreData("TestCreateIssueOneProjectThreeIssueTypes.xml");
        this.clickLink("create_link");
        this.assertTextSequence(new String[]{"Create Issue", "Choose the project and issue type"});
        String monkeyTask = ".*CreateIssue\\.jspa\\?pid=10001&issuetype=3$";
        this.assertRedirectAndFollow("/secure/CreateIssue!default.jspa?issuetype=3", ".*CreateIssue\\.jspa\\?pid=10001&issuetype=3$");
        this.assertTextSequence(new String[]{"Create Issue", "Enter the details of the issue...", "Project:", "monkey", "Issue Type:", "Task", "Summary"});
    }

    private void deleteCreatedIssue(String issueKey) {
        this.deleteIssue(issueKey);
        this.assertPageDoesNotExist("The issue has not been removed from the index.", "/si/jira.issueviews:issue-xml/" + issueKey + "/" + issueKey + ".xml?jira.issue.searchlocation=index");
    }

    public String createIssue() {
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", "test 1", "Minor", new String[]{"New Component 1"}, new String[]{"New Version 1"}, new String[]{"New Version 1"}, "Administrator", "test environment 1", "test description 1 for test create issue", null, null, null);
        this.assertTextPresent("test 1");
        this.assertTextPresent("Bug");
        this.assertTextPresent("Minor");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"summary", (Object)"test 1"), null, issueKey);
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)issueKey), null, issueKey);
        return issueKey;
    }

    public String createIssueWithoutComponents() {
        String issueKey = this.addIssue("homosapien", "HSP", "Improvement", "test 2", "Major", null, null, null, "Administrator", "test environment 2", "test description 2 for test create issue", null, null, null);
        this.assertTextPresent("test 2");
        this.assertTextPresent("Improvement");
        this.assertTextPresent("Major");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"type", (Object)"Improvement"), null, issueKey);
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"summary", (Object)"test 2"), null, issueKey);
        return issueKey;
    }

    public String createIssueWithTimeTrackingDetails() {
        this.activateTimeTracking();
        String issueKey = this.addIssue("homosapien", "HSP", "New Feature", "test 3", "Critical", null, null, null, "Administrator", "test environment 3", "test description 3 for test create issue", "1w", null, null);
        this.assertTextPresent("test 3");
        this.assertTextPresent("New Feature");
        this.assertTextPresent("Critical");
        this.assertTextPresent("Original Estimate");
        this.assertTextPresent("1 week");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"priority", (Object)"Critical"), null, issueKey);
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"type", (Object)"New Feature"), null, issueKey);
        this.deactivateTimeTracking();
        return issueKey;
    }

    public String createIssueWithoutAssignee() {
        this.setUnassignedIssuesOption(true);
        String issueKey = this.addIssue("homosapien", "HSP", "Task", "test 4", "Blocker", new String[]{"New Component 1"}, null, null, "Unassigned", "test environment 4", "test description 4 for test create issue", null, null, null);
        this.assertTextPresent("test 4");
        this.assertTextPresent("Task");
        this.assertTextPresent("Blocker");
        this.assertTextPresentBeforeText("Assignee:", "Unassigned");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"priority", (Object)"Blocker"), null, issueKey);
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"environment", (Object)"test environment 4"), null, issueKey);
        this.assignIssue(issueKey, "Assigning issue to ADMIN", "Administrator");
        this.setUnassignedIssuesOption(false);
        return issueKey;
    }

    public void createIssueWithNoSummary() {
        TestCreateIssue.log("Create Issue: Adding issue without summary");
        this.createIssueStep1();
        this.selectOption("priority", "Minor");
        this.submit();
        this.assertTextPresent("Enter the details of the issue");
        this.assertTextPresent("You must specify a summary of the issue.");
    }

    public void createIssueWithRequiredFields() {
        this.setRequiredFields();
        TestCreateIssue.log("Create Issue: Test the creation of an issue using required fields");
        this.createIssueStep1();
        this.setFormElement("summary", "This is a new summary");
        this.setFormElement("reporter", "");
        this.submit("Create");
        this.assertTextPresent("Enter the details of the issue");
        this.assertTextPresent("Component/s is required");
        this.assertTextPresent("Affects Version/s is required");
        this.assertTextPresent("Fix Version/s is required");
        this.resetFields();
    }

    public void createIssueWithHiddenFields() {
        this.setHiddenFields("Component/s");
        this.setHiddenFields("Affects Version/s");
        this.setHiddenFields("Fix Version/s");
        TestCreateIssue.log("Create Issue: Test the creation of am issue using hidden fields");
        this.createIssueStep1();
        this.assertFormElementNotPresent("components");
        this.assertFormElementNotPresent("versions");
        this.assertFormElementNotPresent("fixVersions");
        this.resetFields();
    }

    public void createIssueWithInvalidDueDate() {
        TestCreateIssue.log("Create Issue: Adding issue with invalid due date");
        this.createIssueStep1();
        this.assertTextPresent("Enter the details of the issue");
        this.setFormElement("summary", "stuff");
        this.setFormElement("duedate", "stuff");
        this.submit("Create");
        this.assertTextPresent("Enter the details of the issue");
        this.assertTextPresent("You did not enter a valid date. Please enter the date in the format &quot;d/MMM/yy&quot;");
    }

    public void createIssueWithCreatePermission() {
        TestCreateIssue.log("Create Issue: Test availability of 'Create Issue' link with 'Create Issue' permission.");
        this.removeGroupPermission(11, "jira-users");
        this.gotoAdmin();
        this.assertLinkNotPresent("create_link");
        this.grantGroupPermission(11, "jira-users");
        this.gotoAdmin();
        this.assertLinkPresent("create_link");
    }

    public void createIssueWithSchedulePermission() {
        TestCreateIssue.log("Create Issue: Test prescence of 'Due Date' field with 'Schedule Issue' permission.");
        this.removeGroupPermission(28, "jira-developers");
        this.createIssueStep1();
        this.assertTextNotPresent("Due Date");
        this.grantGroupPermission(28, "jira-developers");
        this.createIssueStep1();
        this.assertTextPresent("Due Date");
    }

    public void createIssueWithAssignPermission() {
        TestCreateIssue.log("Create Issue: Test ability to specify assignee with 'Assign Issue' permission.");
        this.removeGroupPermission(13, "jira-developers");
        this.createIssueStep1();
        this.assertFormElementNotPresent("assignee");
        this.grantGroupPermission(13, "jira-developers");
        this.createIssueStep1();
        this.assertFormElementPresent("assignee");
    }

    public void createIssueWithModifyReporterPermission() {
        TestCreateIssue.log("Create Issue: Test availability of Reporter with 'Modify Reporter' permission.");
        this.removeGroupPermission(30, "jira-administrators");
        this.createIssueStep1();
        this.assertFormElementNotPresent("reporter");
        this.grantGroupPermission(30, "jira-administrators");
        this.createIssueStep1();
        this.assertFormElementPresent("reporter");
    }

    public void createIssueWithTimeTracking() {
        TestCreateIssue.log("Create Issue: Test availability of time tracking ...");
        this.deactivateTimeTracking();
        this.createIssueStep1();
        this.assertFormElementNotPresent("timetracking");
        this.activateTimeTracking();
        this.createIssueStep1();
        this.assertFormElementPresent("timetracking");
        this.deactivateTimeTracking();
    }

    public void createIssueWithUnassignableUser() {
        TestCreateIssue.log("Create Issue: Attempt to set the assignee to be an unassignable user ...");
        this.removeGroupPermission(17, "jira-developers");
        this.createIssueStep1();
        this.submit("Create");
        this.setFormElement("summary", "Test summary");
        this.assertTextPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.grantGroupPermission(17, "jira-developers");
    }

    public void createIssueWithNoBrowsePermission() {
        TestCreateIssue.log("Create Issue: Adding issue with no browse permission for user");
        this.restoreData("TestCantViewCreatedIssue.xml");
        this.logout();
        this.clickLinkWithText("Log in again.");
        this.addIssueOnly("noBrowseProject", "NBP", "Bug", "test1", "Minor", null, null, null, null, null, "description", null, null, null);
        this.assertIssueCreatedButCannotView(false);
        this.clickLinkWithText(LOGIN);
        this.setFormElement("os_username", "nobrowseuser");
        this.setFormElement("os_password", "password");
        this.clickButton(LOGIN_BUTTON);
        this.assertIssueCreatedButCannotView(true);
        this.addIssueOnly("noBrowseProject", "NBP", "Bug", "test1", "Minor", null, null, null, null, null, "description", null, null, null);
        this.assertIssueCreatedButCannotView(true);
        this.logout();
        this.clickLinkWithText("Log in again.");
        this.addIssueOnly("noBrowseProject", "NBP", "Bug", "test1", "Minor", null, null, null, null, null, "description", null, null, null);
        this.assertIssueCreatedButCannotView(false);
        this.clickLinkWithText(LOGIN);
        this.setFormElement("os_username", "admin");
        this.setFormElement("os_password", "admin");
        this.clickButton(LOGIN_BUTTON);
        this.assertTextNotPresent("Issue Created Successfully");
        this.assertLinkNotPresentWithText(LOGIN);
        this.assertTextPresent("Issue Details");
        this.restoreBlankInstance();
    }

    public void testEscapeProjectNameOnFirstScreenOfCreateIssue() {
        this.clickLink("admin_link");
        this.clickLink("add_project");
        this.setFormElement("name", "Xss Project &trade;");
        this.setFormElement("key", "XP");
        this.setFormElement("lead", "admin");
        this.submit("Add");
        this.clickLink("create_link");
        this.assertTextNotPresent("&trade;");
        this.assertTextPresent("&amp;trade;");
    }

    public void testXssInDueDate() {
        TextAssertionsImpl text = new TextAssertionsImpl();
        String value = "\"><script>";
        String valueEncoded = "&quot;&gt;&lt;script&gt;";
        String expectedFormElement = "<input type=\"text\" name=\"duedate\" id=\"duedate\" value=\"";
        String notExpected = "<input type=\"text\" name=\"duedate\" id=\"duedate\" value=\"\"><script>\"";
        String expected = "<input type=\"text\" name=\"duedate\" id=\"duedate\" value=\"&quot;&gt;&lt;script&gt;\"";
        this.clickLink("create_link");
        this.submit("Next>>");
        this.setFormElement("duedate", "\"><script>");
        this.submit("Create");
        WebPageLocator locator = new WebPageLocator(this.tester);
        text.assertTextPresent(locator.getHTML(), "<input type=\"text\" name=\"duedate\" id=\"duedate\" value=\"&quot;&gt;&lt;script&gt;\"");
        text.assertTextNotPresent(locator.getHTML(), "<input type=\"text\" name=\"duedate\" id=\"duedate\" value=\"\"><script>\"");
    }

    private void assertIssueCreatedButCannotView(boolean loggedIn) {
        this.assertTextPresent("Issue Created Successfully");
        this.assertTextPresentBeforeText("You have successfully created the issue (", "), however you do not have the permission to view the created issue.");
        if (!loggedIn) {
            this.assertLinkPresentWithText(LOGIN);
        }
        this.assertLinkPresentWithText("administrators");
    }
}

