/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.project;

import com.atlassian.jira.webtests.ztests.imports.project.AbstractProjectImportTestCase;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebTable;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class TestProjectImportUsersDoNotExistPage
extends AbstractProjectImportTestCase {
    private File tempFile;

    protected void setUpTest() {
        this.administration.restoreData("TestProjectImportUsersDoNotExist.xml");
        try {
            this.tempFile = File.createTempFile("ProjectImportFuncTest", ".xml");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.administration.exportDataToPath(this.tempFile.getAbsolutePath());
    }

    protected void tearDownTest() {
        this.tempFile.delete();
    }

    public void testProjectImportMissingOptionalUsersExtMgmt() throws Exception {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("delete_project_10001");
        this.tester.submit("Delete");
        this.administration.usersAndGroups().addUser("barney");
        this.administration.generalConfiguration().setExternalUserManagement(true);
        this.navigation.gotoAdminSection("project_import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", this.tempFile.getAbsolutePath());
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.tester.assertTextPresent("There are '1' user(s) referenced that are in use in the project and missing from the current system. External user management is enabled so the import is unable to create the user(s).");
        this.tester.assertTextPresent("You may want to add the user(s) to the system before performing the import but the import can proceed without them. Click the 'View Details' link to see a full list of user(s) that are in use.");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.tester.clickLinkWithText("View Details");
        this.tester.assertTextPresent("Missing Optional Users");
        this.tester.assertTextPresent("1 optional user(s) are referenced in the data you are trying to import");
        this.tester.assertTextPresent("been enabled therefore this import can not create users");
        this.tester.assertTextNotPresent("To see all the users, use the export link.");
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("usersdonotexist");
        TestProjectImportUsersDoNotExistPage.assertEquals((int)2, (int)table.getRowCount());
        TestProjectImportUsersDoNotExistPage.assertTrue((table.getTableCell(0, 0).asText().indexOf("Username") != -1 ? 1 : 0) != 0);
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"betty", (String)table.getTableCell(1, 0).asText());
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"", (String)table.getTableCell(1, 1).asText());
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"", (String)table.getTableCell(1, 2).asText());
        this.tester.clickButton("backButton");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.tester.assertTextPresent("There are '1' user(s) referenced that are in use in the project and missing from the current system. External user management is enabled so the import is unable to create the user(s).");
    }

    public void testProjectImportMissingMandatoryUsersExtMgmt() throws Exception {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("delete_project_10001");
        this.tester.submit("Delete");
        this.administration.usersAndGroups().addUser("betty");
        this.administration.generalConfiguration().setExternalUserManagement(true);
        this.navigation.gotoAdminSection("project_import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", this.tempFile.getAbsolutePath());
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.tester.assertTextPresent("There are 1 required user(s) that are missing from the current system. External user management is enabled so the import is unable to create the user(s). You must add the user(s) to the system before the import can proceed. Click the 'View Details' link to see a full list of user(s) that are required.");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.tester.clickLinkWithText("View Details");
        this.tester.assertTextPresent("Missing Mandatory Users");
        this.tester.assertTextPresent("1 required user(s) are referenced in the data you are trying to import");
        this.tester.assertTextPresent("been enabled therefore this import can not create users");
        this.tester.assertTextNotPresent("To see all the users, use the export link.");
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("usersdonotexist");
        TestProjectImportUsersDoNotExistPage.assertEquals((int)2, (int)table.getRowCount());
        TestProjectImportUsersDoNotExistPage.assertTrue((table.getTableCell(0, 0).asText().indexOf("Username") != -1 ? 1 : 0) != 0);
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"barney", (String)table.getTableCell(1, 0).asText());
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"", (String)table.getTableCell(1, 1).asText());
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"", (String)table.getTableCell(1, 2).asText());
        this.tester.clickButton("backButton");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.tester.assertTextPresent("There are 1 required user(s) that are missing from the current system. External user management is enabled so the import is unable to create the user(s). You must add the user(s) to the system before the import can proceed. Click the 'View Details' link to see a full list of user(s) that are required.");
    }

    public void testProjectImportMissingMandatoryUsersCantAutoCreate() throws Exception {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("delete_project_10001");
        this.tester.submit("Delete");
        this.administration.usersAndGroups().addUser("betty");
        this.administration.generalConfiguration().setExternalUserManagement(false);
        this.navigation.gotoAdminSection("project_import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", this.tempFile.getAbsolutePath());
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.tester.assertTextPresent("There are '1' required user(s) that JIRA can not automatically create.");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.tester.clickLinkWithText("View Details");
        this.tester.assertTextPresent("There are 1 required user(s) that do not currently exist in JIRA and the import cannot create them. These user(s) need to exist for the import to proceed and we are unable to automatically create them because their details do not exist in the backup XML data.");
        this.tester.assertTextNotPresent("To see all the users, use the export link.");
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("usersdonotexist");
        TestProjectImportUsersDoNotExistPage.assertEquals((int)2, (int)table.getRowCount());
        TestProjectImportUsersDoNotExistPage.assertTrue((table.getTableCell(0, 0).asText().indexOf("Username") != -1 ? 1 : 0) != 0);
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"barney", (String)table.getTableCell(1, 0).asText());
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"", (String)table.getTableCell(1, 1).asText());
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"", (String)table.getTableCell(1, 2).asText());
        this.tester.clickButton("backButton");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.tester.assertTextPresent("There are '1' required user(s) that JIRA can not automatically create.");
    }

    public void testProjectImportMissingOptionalUsersCantAutoCreate() throws Exception {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("delete_project_10001");
        this.tester.submit("Delete");
        this.administration.usersAndGroups().addUser("barney");
        this.administration.generalConfiguration().setExternalUserManagement(false);
        this.navigation.gotoAdminSection("project_import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", this.tempFile.getAbsolutePath());
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.tester.assertTextPresent("There are '1' user(s) referenced that JIRA can not automatically create. You may want to create these users before performing the import.");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.tester.clickLinkWithText("View Details");
        this.tester.assertTextPresent("There are 1 optional user(s) that do not currently exist in JIRA and the import cannot create them. We are unable to automatically create them because their details do not exist in the backup XML data. The user(s) are not required to exist for the import to proceed, however you may wish to create them.");
        this.tester.assertTextNotPresent("To see all the users, use the export link.");
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("usersdonotexist");
        TestProjectImportUsersDoNotExistPage.assertEquals((int)2, (int)table.getRowCount());
        TestProjectImportUsersDoNotExistPage.assertTrue((table.getTableCell(0, 0).asText().indexOf("Username") != -1 ? 1 : 0) != 0);
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"betty", (String)table.getTableCell(1, 0).asText());
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"", (String)table.getTableCell(1, 1).asText());
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"", (String)table.getTableCell(1, 2).asText());
        this.tester.clickButton("backButton");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.tester.assertTextPresent("There are '1' user(s) referenced that JIRA can not automatically create. You may want to create these users before performing the import.");
    }

    public void testProjectImportUsersToAutoCreate() throws Exception {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("delete_project_10001");
        this.tester.submit("Delete");
        this.administration.usersAndGroups().addUser("barney");
        this.administration.usersAndGroups().addUser("betty");
        this.administration.usersAndGroups().deleteUser("fred");
        this.administration.usersAndGroups().deleteUser("wilma");
        this.administration.generalConfiguration().setExternalUserManagement(false);
        this.navigation.gotoAdminSection("project_import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", this.tempFile.getAbsolutePath());
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.tester.assertTextPresent("There are '2' users that will be automatically created if the import continues.");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.tester.clickLinkWithText("View Details");
        this.tester.assertTextPresent("There are 2 user(s) referenced in the data you are trying to import that do not currently exist in JIRA. The project import will automatically create these user(s).");
        this.tester.assertTextNotPresent("To see all the users, use the export link.");
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("usersdonotexist");
        TestProjectImportUsersDoNotExistPage.assertEquals((int)3, (int)table.getRowCount());
        TestProjectImportUsersDoNotExistPage.assertTrue((table.getTableCell(0, 0).asText().indexOf("Username") != -1 ? 1 : 0) != 0);
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"fred", (String)table.getTableCell(1, 0).asText());
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"Fred Normal", (String)table.getTableCell(1, 1).asText());
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"fred@example.com", (String)table.getTableCell(1, 2).asText());
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"wilma", (String)table.getTableCell(2, 0).asText());
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"Wilma O'Flinstone", (String)table.getTableCell(2, 1).asText());
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"wilma@example.com", (String)table.getTableCell(2, 2).asText());
        this.tester.clickButton("backButton");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.tester.assertTextPresent("There are '2' users that will be automatically created if the import continues.");
    }

    public void testProjectImportUsersToAutoCreateWithUserCountLimit() throws Exception {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("delete_project_10001");
        this.tester.submit("Delete");
        this.administration.usersAndGroups().addUser("barney");
        this.administration.usersAndGroups().addUser("betty");
        this.administration.usersAndGroups().deleteUser("fred");
        this.administration.usersAndGroups().deleteUser("wilma");
        this.administration.generalConfiguration().setExternalUserManagement(false);
        this.navigation.gotoAdminSection("project_import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", this.tempFile.getAbsolutePath());
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.tester.assertTextPresent("There are '2' users that will be automatically created if the import continues.");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.tester.gotoPage("/secure/admin/ProjectImportMissingUsersAutoCreate.jspa?userCountLimit=1");
        this.tester.assertTextPresent("There are 2 user(s) referenced in the data you are trying to import that do not currently exist in JIRA. The project import will automatically create these user(s).");
        this.tester.assertTextPresent("Displaying the first 1 users. To see all the users, use the export link.");
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("usersdonotexist");
        TestProjectImportUsersDoNotExistPage.assertEquals((int)2, (int)table.getRowCount());
        TestProjectImportUsersDoNotExistPage.assertTrue((table.getTableCell(0, 0).asText().indexOf("Username") != -1 ? 1 : 0) != 0);
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"fred", (String)table.getTableCell(1, 0).asText());
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"Fred Normal", (String)table.getTableCell(1, 1).asText());
        TestProjectImportUsersDoNotExistPage.assertEquals((String)"fred@example.com", (String)table.getTableCell(1, 2).asText());
        this.tester.clickButton("backButton");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.tester.assertTextPresent("There are '2' users that will be automatically created if the import continues.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXmlExport() throws IOException, SAXException, ParserConfigurationException, TransformerException {
        try {
            this.navigation.gotoAdminSection("view_projects");
            this.tester.clickLink("delete_project_10001");
            this.tester.submit("Delete");
            this.administration.usersAndGroups().addUser("barney");
            this.administration.usersAndGroups().addUser("betty");
            this.administration.usersAndGroups().deleteUser("fred");
            this.administration.usersAndGroups().deleteUser("wilma");
            this.administration.generalConfiguration().setExternalUserManagement(false);
            this.navigation.gotoAdminSection("project_import");
            this.tester.assertTextPresent("Project Import: Select Backup File");
            this.tester.setFormElement("backupXmlPath", this.tempFile.getAbsolutePath());
            this.tester.submit("Next");
            this.advanceThroughWaitingPage();
            this.tester.assertTextPresent("Project Import: Select Project to Import");
            this.tester.selectOption("projectKey", "monkey");
            this.tester.submit("Next");
            this.advanceThroughWaitingPage();
            this.tester.assertTextPresent("The results of automatic mapping are displayed below");
            this.tester.assertTextPresent("There are '2' users that will be automatically created if the import continues.");
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.tester.gotoPage("/secure/admin/ProjectImportMissingUsersAutoCreate.jspa?userCountLimit=1");
            this.tester.assertTextPresent("There are 2 user(s) referenced in the data you are trying to import that do not currently exist in JIRA. The project import will automatically create these user(s).");
            this.tester.assertTextPresent("Displaying the first 1 users. To see all the users, use the export link.");
            WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("usersdonotexist");
            TestProjectImportUsersDoNotExistPage.assertEquals((int)2, (int)table.getRowCount());
            TestProjectImportUsersDoNotExistPage.assertTrue((table.getTableCell(0, 0).asText().indexOf("Username") != -1 ? 1 : 0) != 0);
            TestProjectImportUsersDoNotExistPage.assertEquals((String)"fred", (String)table.getTableCell(1, 0).asText());
            TestProjectImportUsersDoNotExistPage.assertEquals((String)"Fred Normal", (String)table.getTableCell(1, 1).asText());
            TestProjectImportUsersDoNotExistPage.assertEquals((String)"fred@example.com", (String)table.getTableCell(1, 2).asText());
            this.tester.clickLinkWithText("Export to XML");
            String responseText = this.tester.getDialog().getResponseText();
            String expected = "\n<users>\n        <user>\n            <name>fred</name>\n            <fullname>Fred Normal</fullname>\n            <email>fred@example.com</email>\n            <properties>\n                <property>\n                <key>bspropertykey</key>\n                    <value>&lt;/value&gt;</value>\n                </property>\n            </properties>\n        </user>\n        <user>\n            <name>wilma</name>\n            <fullname>Wilma O&apos;Flinstone</fullname>\n            <email>wilma@example.com</email>\n            <properties>\n            </properties>\n        </user>\n</users>";
            TestProjectImportUsersDoNotExistPage.assertEquals((String)expected, (String)responseText);
        }
        finally {
            this.tester.gotoPage("/secure/admin/ProjectImportSelectBackup!default.jspa");
        }
    }
}

