/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.project;

import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.util.TempDirectoryUtil;
import com.atlassian.jira.webtests.ztests.imports.project.AbstractProjectImportTestCase;
import com.meterware.httpunit.HttpUnitOptions;
import java.io.File;

public class TestProjectImportSummary
extends AbstractProjectImportTestCase {
    public void testJumpToImportSummary() throws Exception {
        this.administration.restoreBlankInstance();
        this.tester.gotoPage("/secure/admin/ProjectImportSummary!default.jspa");
        this.tester.assertTextPresent("There is no mapping result to display. Perhaps your session has timed out, please restart the project import wizard");
        this.tester.assertSubmitButtonNotPresent("Import");
        this.tester.assertSubmitButtonNotPresent("prevButton");
        this.tester.assertTextPresent("Cancel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueTypeValidation() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummary.xml", "TestProjectImportSummaryIssueTypes2.xml", null);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertTextPresent("The issue type 'NotInScheme' exists in the system but is not valid for the projects issue type scheme.");
            this.tester.assertTextPresent("The issue type 'Bug' is required for the import but does not exist in the current JIRA instance");
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)20, (int)pathLocator.getNodes().length);
            this.tester.assertSubmitButtonNotPresent("Import");
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubTaskDoesNotExistIssueTypeValidation() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummarySubTask.xml", "TestProjectImportSummarySubTask2.xml", null);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertTextPresent("Sub-tasks are currently disabled in JIRA, please enable sub-tasks. The sub-task issue type 'NotExistSubTask' is required for the import but does not exist in the current JIRA instance.");
            this.tester.assertTextPresent("The issue type 'NonSubTask' is defined as a normal issue type in the backup project, but it is a sub-task issue type in the current JIRA instance.");
            this.tester.assertTextPresent("The issue type 'Sub-task' is defined as a sub-task in the backup project, but it is a normal issue type in the current JIRA instance.");
            this.tester.assertTextPresent("The issue type 'Bug' is required for the import but does not exist in the current JIRA instance");
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)20, (int)pathLocator.getNodes().length);
            this.tester.assertSubmitButtonNotPresent("Import");
            this.administration.activateSubTasks();
            this.importToPreImportSummaryPage(null, tempFile);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertTextPresent("The sub-task issue type 'NotExistSubTask' is required for the import but does not exist in the current JIRA instance.");
            this.tester.assertTextPresent("The issue type 'NonSubTask' is defined as a normal issue type in the backup project, but it is a sub-task issue type in the current JIRA instance.");
            this.tester.assertTextPresent("The issue type 'Sub-task' is defined as a sub-task in the backup project, but it is a normal issue type in the current JIRA instance.");
            this.tester.assertTextPresent("The issue type 'Bug' is required for the import but does not exist in the current JIRA instance");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)20, (int)pathLocator.getNodes().length);
            this.tester.assertSubmitButtonNotPresent("Import");
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomFieldValidation() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummary.xml", "TestProjectImportSummaryCustomFields2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.assertTextPresent("The custom field 'number cf' in the backup project is of type 'Number Field' but the field with the same name in the current JIRA instance is of a different type.");
            this.tester.assertTextPresent("The custom field 'Cascading Select CF' in the backup project is used by issue types 'Bug' but the field with the same name in the current JIRA instance is not available to those issue types in this project.");
            this.tester.assertTextPresent("The custom field 'Project CF' of type 'Project Picker' is required for the import but does not exist in the current JIRA instance.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)19, (int)pathLocator.getNodes().length);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStatusValidationDefaultWorkflowNoProject() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummary.xml", "TestProjectImportSummaryStatuses2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)19, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.assertTextPresent("The status 'Snafu' is required for the import but does not exist in the current JIRA instance.");
            this.tester.assertTextPresent("The status 'Fubar' is in use by an issue of type 'NonSubTask' in the backup file. The default workflow 'jira', which is associated with issue type 'NonSubTask', does not use this status. This workflow is not editable. You must create a project with key 'MKY', instead of letting the import create it for you, and associate a workflow with issue type 'NonSubTask' that uses the status. To do this you will need to use a workflow scheme.");
            this.tester.assertTextPresent("The status 'Snafu' is in use by an issue of type 'Sub-task' in the backup file. The default workflow 'jira', which is associated with issue type 'Sub-task', does not use this status. This workflow is not editable. You must create a project with key 'MKY', instead of letting the import create it for you, and associate a workflow with issue type 'Sub-task' that uses the status. To do this you will need to use a workflow scheme.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStatusValidationDefaultWorkflowProjectExists() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummary.xml", "TestProjectImportSummaryStatusesProjectExists2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)19, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.assertTextPresent("The status 'Snafu' is required for the import but does not exist in the current JIRA instance.");
            this.tester.assertTextPresent("The status 'Fubar' is in use by an issue of type 'NonSubTask' in the backup file. The default workflow 'jira', which is associated with issue type 'NonSubTask', does not use this status. This workflow is not editable. You must associate a workflow with issue type 'NonSubTask' that uses the status. To do this you will need to use a workflow scheme.");
            this.tester.assertTextPresent("The status 'Snafu' is in use by an issue of type 'Sub-task' in the backup file. The default workflow 'jira', which is associated with issue type 'Sub-task', does not use this status. This workflow is not editable. You must associate a workflow with issue type 'Sub-task' that uses the status. To do this you will need to use a workflow scheme.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStatusValidationCustomWorkflowProjectExists() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummary.xml", "TestProjectImportSummaryStatusesProjectExistsCustomWorkflow2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)19, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.assertTextPresent("The status 'Snafu' is required for the import but does not exist in the current JIRA instance.");
            this.tester.assertTextPresent("The status 'Fubar' is in use by an issue of type 'NonSubTask' in the backup file. The workflow 'Copy of jira', which is associated with issue type 'NonSubTask', does not use this status. You must either edit the workflow to use the status or associate a workflow with issue type 'NonSubTask' that uses the status.");
            this.tester.assertTextPresent("The status 'Snafu' is in use by an issue of type 'Sub-task' in the backup file. The workflow 'Copy of jira', which is associated with issue type 'Sub-task', does not use this status. You must either edit the workflow to use the status or associate a workflow with issue type 'Sub-task' that uses the status.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPriorityAndResolutionValidation() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummary.xml", "TestProjectImportSummaryResolutionPriority2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)18, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.assertTextPresent("The priority 'Major' is required for the import but does not exist in the current JIRA instance.");
            this.tester.assertTextPresent("The resolution 'Fixed' is required for the import but does not exist in the current JIRA instance.");
            this.tester.assertTextNotPresent("Please note that performing an import will cause JIRA to be unavailable to all users until the import has completed.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)2, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserValidation() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummary.xml", "TestProjectImportSummaryUser2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)19, (int)pathLocator.getNodes().length);
            this.tester.assertTextNotPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.assertTextPresent("There are '1' users that will be automatically created if the import continues.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)2, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProjectRoleValidation() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummary.xml", "TestProjectImportSummaryProjectRole2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)19, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.assertTextPresent("The project role 'Developers' is required for the import but does not exist in the current JIRA instance.");
            this.tester.assertTextPresent("The project role 'dudes' is required for the import but does not exist in the current JIRA instance.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGroupValidation() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummary.xml", "TestProjectImportSummaryGroups2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)19, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.assertTextPresent("The group 'baddies' is required for the import but does not exist in the current JIRA instance.");
            this.tester.assertTextPresent("The group 'goodies' is required for the import but does not exist in the current JIRA instance.");
            this.tester.assertTextNotPresent("The group 'The Others' is required for the import but does not exist in the current JIRA instance.");
            this.tester.assertTextNotPresent("The group 'The Dark Brotherhood' is required for the import but does not exist in the current JIRA instance.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueLinkTypeValidation() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummary.xml", "TestProjectImportSummaryIssueLinkTypes2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)19, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.assertTextPresent("The project to import includes subtasks, but subtasks are disabled in the current system.");
            this.tester.assertTextPresent("The Issue Link Type 'Duplicate' is required for the import but does not exist in the current JIRA instance.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueCustomFieldOptionsValidation() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummary.xml", "TestProjectImportSummaryCustomFieldOptions2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)19, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.assertTextPresent("The custom field 'Cascading Select CF' requires option with parent option 'A' and child option 'A2' for the import but it does not exist in the current JIRA instance.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueCustomFieldValuesValidation() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummaryCustomFieldValues.xml", "TestProjectImportSummaryCustomFieldValues2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)15, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.assertTextPresent("The custom field 'target_milestone' requires option 'dylan 1' for the import but it does not exist in the current JIRA instance.");
            this.tester.assertTextPresent("The custom field 'Multi--select cf' requires option 'option 2' for the import but it does not exist in the current JIRA instance. (NOTE: repetitive spaces have been replaced by '-' characters)");
            this.tester.assertTextPresent("The group 'goodies' is required for the import but does not exist in the current JIRA instance.");
            this.tester.assertTextPresent("The project 'HSP' does not exist in the current JIRA system. This custom field value will not be imported.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)4, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)3, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileAttachmentsValidation21FilesDoNotExist() throws Exception {
        File tempFile = null;
        File attachmentsBackupDir = null;
        File projectDir = null;
        try {
            attachmentsBackupDir = TempDirectoryUtil.createTempDirectory("Attachments");
            attachmentsBackupDir.mkdir();
            projectDir = new File(attachmentsBackupDir, "MKY");
            projectDir.mkdir();
            tempFile = this.doProjectImport("TestProjectImportSummary.xml", "TestProjectImportSummaryFileAttachments2.xml", attachmentsBackupDir.getAbsolutePath());
            this.tester.assertTextPresent("There are more than twenty attachment entries that do not exist in the attachment directory. See your logs for full details.");
            this.tester.assertTextNotPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonPresent("Import");
        }
        finally {
            if (projectDir != null) {
                projectDir.delete();
            }
            if (attachmentsBackupDir != null) {
                attachmentsBackupDir.delete();
            }
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileAttachmentsValidationProjectDirectoryDoesNotExist() throws Exception {
        File tempFile = null;
        File attachmentsBackupDir = null;
        try {
            attachmentsBackupDir = TempDirectoryUtil.createTempDirectory("Attachments");
            attachmentsBackupDir.mkdir();
            tempFile = this.doProjectImport("TestProjectImportSummary.xml", "TestProjectImportSummaryFileAttachments2.xml", attachmentsBackupDir.getAbsolutePath());
            this.tester.assertTextPresent("The provided attachment path does not contain a sub-directory called 'MKY'. If you proceed with the import attachments will not be included.");
            this.tester.assertTextNotPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonPresent("Import");
        }
        finally {
            if (attachmentsBackupDir != null) {
                attachmentsBackupDir.delete();
            }
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileAttachmentsValidation20FilesDoNotExist() throws Exception {
        File tempFileOther = null;
        File attachmentsBackupDir = null;
        File projectDir = null;
        File issueDir = null;
        File tempFile = null;
        try {
            attachmentsBackupDir = TempDirectoryUtil.createTempDirectory("Attachments");
            attachmentsBackupDir.mkdir();
            projectDir = new File(attachmentsBackupDir, "MKY");
            projectDir.mkdir();
            issueDir = new File(projectDir, "MKY-1");
            issueDir.mkdir();
            tempFile = new File(issueDir, "10020_test.html");
            tempFile.createNewFile();
            tempFileOther = this.doProjectImport("TestProjectImportSummary.xml", "TestProjectImportSummaryFileAttachments2.xml", attachmentsBackupDir.getAbsolutePath());
            this.tester.assertTextNotPresent("The attachment 'test.html' does not exist at '" + tempFile.getAbsolutePath() + "'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test1.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10030_test1.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test2.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10040_test2.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test3.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10050_test3.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test4.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10060_test4.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test5.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10070_test5.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test6.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10080_test6.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test7.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10090_test7.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test8.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10100_test8.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test9.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10110_test9.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test10.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10120_test10.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test11.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10130_test11.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test12.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10140_test12.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test13.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10150_test13.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test14.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10160_test14.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test15.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10170_test15.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test16.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10180_test16.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test17.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10190_test17.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test18.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10200_test18.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test19.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10210_test19.txt'. It will not be imported.");
            this.tester.assertTextPresent("The attachment 'test20.txt' does not exist at '" + issueDir.getAbsolutePath() + File.separator + "10220_test20.txt'. It will not be imported.");
            this.tester.assertTextNotPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonPresent("Import");
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
            if (issueDir != null) {
                issueDir.delete();
            }
            if (projectDir != null) {
                projectDir.delete();
            }
            if (attachmentsBackupDir != null) {
                attachmentsBackupDir.delete();
            }
            if (tempFileOther != null) {
                tempFileOther.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoCustomFieldsIncludedAndHappyPath() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummaryNoCustomFields.xml", "TestProjectImportSummaryNoCustomFields2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)11, (int)pathLocator.getNodes().length);
            this.tester.assertTextNotPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertTextPresent("No importable custom fields");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            this.tester.assertTextPresent("Please note that performing an import will cause JIRA to be unavailable to all users until the import has completed.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertSubmitButtonPresent("Import");
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReMapAndValidate() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummary.xml", "TestProjectImportSummaryGroups2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)19, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.assertTextPresent("The group 'baddies' is required for the import but does not exist in the current JIRA instance.");
            this.tester.assertTextPresent("The group 'goodies' is required for the import but does not exist in the current JIRA instance.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
            this.administration.usersAndGroups().addGroup("baddies");
            this.administration.usersAndGroups().addGroup("goodies");
            this.tester.gotoPage("/secure/admin/ProjectImportSummary!default.jspa");
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.assertSubmitButtonPresent("refreshValidationButton");
            this.tester.assertTextPresent("The group 'baddies' is required for the import but does not exist in the current JIRA instance.");
            this.tester.assertTextPresent("The group 'goodies' is required for the import but does not exist in the current JIRA instance.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
            this.tester.clickButton("refreshValidationButton");
            this.advanceThroughWaitingPage();
            this.tester.assertTextNotPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.clickLinkWithText("Refresh validations");
            this.advanceThroughWaitingPage();
            this.tester.assertTextNotPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.assertTextNotPresent("The group 'baddies' is required for the import but does not exist in the current JIRA instance.");
            this.tester.assertTextNotPresent("The group 'goodies' is required for the import but does not exist in the current JIRA instance.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreviousButton() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummary.xml", "TestProjectImportSummaryGroups2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)19, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.assertTextPresent("The group 'baddies' is required for the import but does not exist in the current JIRA instance.");
            this.tester.assertTextPresent("The group 'goodies' is required for the import but does not exist in the current JIRA instance.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
            this.tester.submit("prevButton");
            this.tester.assertTextPresent("Project Import: Select Project to Import");
            this.tester.selectOption("projectKey", "monkey");
            this.tester.selectOption("projectKey", "homosapien");
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProjectImportResumeLinkStep2() throws Exception {
        File tempFile = null;
        try {
            String backupFileName = "TestProjectImportSummaryNoCustomFields.xml";
            String currentSystemXML = "TestProjectImportSummaryNoCustomFields2.xml";
            this.administration.restoreData("TestProjectImportSummaryNoCustomFields.xml");
            tempFile = File.createTempFile("TestProjectImportSummaryNoCustomFields", ".xml");
            this.administration.exportDataToPath(tempFile.getAbsolutePath());
            this.administration.restoreData("TestProjectImportSummaryNoCustomFields2.xml");
            this.administration.enableAttachments();
            this.navigation.gotoAdminSection("project_import");
            this.tester.assertTextNotPresent("You were in the middle of performing an import");
            this.tester.assertTextPresent("Project Import: Select Backup File");
            this.tester.setFormElement("backupXmlPath", tempFile.getAbsolutePath());
            this.tester.submit("Next");
            this.advanceThroughWaitingPage();
            this.tester.assertTextPresent("Project Import: Select Project to Import");
            this.navigation.gotoAdminSection("project_import");
            this.tester.assertTextPresent("You were in the middle of performing an import. Would you");
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.tester.clickLinkWithText("resume");
            this.tester.assertTextPresent("Select the project you wish to import");
            this.tester.selectOption("projectKey", "monkey");
            this.tester.selectOption("projectKey", "homosapien");
            this.tester.clickButton("cancelButton");
            this.tester.assertTextPresent("This tool allows you to import a single JIRA project from a backup file.");
            this.tester.assertTextNotPresent("You were in the middle of performing an import. Would you");
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProjectImportResumeLinkStep3() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummaryNoCustomFields.xml", "TestProjectImportSummaryNoCustomFields2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)11, (int)pathLocator.getNodes().length);
            this.tester.assertTextNotPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertTextPresent("No importable custom fields");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertSubmitButtonPresent("Import");
            this.navigation.gotoAdminSection("project_import");
            this.tester.assertTextPresent("You were in the middle of performing an import for project 'monkey'. Would you");
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.tester.clickLinkWithText("resume");
            this.advanceThroughWaitingPage();
            this.tester.assertTextNotPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertTextPresent("No importable custom fields");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)0, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.clickButton("cancelButton");
            this.tester.assertTextPresent("This tool allows you to import a single JIRA project from a backup file.");
            this.tester.assertTextNotPresent("You were in the middle of performing an import of project 'monkey'. Would you");
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueSecurityLevelValidation() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummaryWithSecurityLevels.xml", "TestProjectImportSummaryNoCustomFields2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)10, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.assertTextPresent("The issue security level 'level2' is required for the import. Please create a project with key 'MKY', and configure its issue security scheme.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueSecurityLevelValidationProjectExists() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportSummaryWithSecurityLevels.xml", "TestProjectImportSummaryIssueSecurity2.xml", null);
            XPathLocator pathLocator = new XPathLocator(this.tester, "//li/img[@alt='OK']");
            TestProjectImportSummary.assertEquals((int)10, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.assertTextPresent("The issue security level 'level2' is required for the import but does not exist in the configured issue security scheme for this project.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='error']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            pathLocator = new XPathLocator(this.tester, "//li[@class='warning']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
            this.tester.assertTextPresent("File attachments will not be imported because you have not provided a backup attachment path.");
            pathLocator = new XPathLocator(this.tester, "//li[@class='unprocessed']");
            TestProjectImportSummary.assertEquals((int)1, (int)pathLocator.getNodes().length);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }
}

