/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.project;

import com.atlassian.jira.webtests.ztests.imports.project.AbstractProjectImportTestCase;
import java.io.File;

public class TestProjectImportSelectBackup
extends AbstractProjectImportTestCase {
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testValidationInvalidPaths() {
        this.administration.enableAttachments();
        this.navigation.gotoAdmin();
        this.tester.clickLink("attachments");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("attachmentPathOption", "CUSTOM");
        this.tester.setFormElement("attachmentPath", System.getProperty("java.io.tmpdir"));
        this.tester.submit("Update");
        this.navigation.gotoAdminSection("project_import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", "");
        this.tester.submit("Next");
        this.tester.assertTextPresent("You must provide a path to the JIRA backup XML file.");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", "/iamafilethatwillneverexisthahahahaha/bak.xml");
        this.tester.submit("Next");
        this.tester.assertTextPresent("The path to the JIRA backup XML file is not valid.");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", System.getProperty("java.io.tmpdir"));
        this.tester.submit("Next");
        this.tester.assertTextPresent("The path to the JIRA backup XML file is not valid.");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", System.getProperty("java.io.tmpdir"));
        this.tester.setFormElement("backupAttachmentPath", "/iamafilethatwillneverexisthahahahaha");
        this.tester.submit("Next");
        this.tester.assertTextPresent("The path to the JIRA backup XML file is not valid.");
        this.tester.assertTextPresent("The path to the JIRA backup attachments directory is not valid.");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", System.getProperty("java.io.tmpdir"));
        this.tester.setFormElement("backupAttachmentPath", System.getProperty("java.io.tmpdir"));
        this.tester.submit("Next");
        this.tester.assertTextPresent("The path to the JIRA backup XML file is not valid.");
        this.tester.assertTextPresent("This is the same path as this JIRA instance uses for its attachments. You must specify a different attachment path.");
    }

    public void testValidationInvalidbackupAttachmentsNotEnabled() {
        this.administration.disableAttachments();
        this.navigation.gotoAdminSection("project_import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", "");
        this.tester.submit("Next");
        this.tester.assertTextPresent("You must provide a path to the JIRA backup XML file.");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", "/iamafilethatwillneverexisthahahahaha/bak.xml");
        this.tester.submit("Next");
        this.tester.assertTextPresent("The path to the JIRA backup XML file is not valid.");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", System.getProperty("java.io.tmpdir"));
        this.tester.submit("Next");
        this.tester.assertTextPresent("The path to the JIRA backup XML file is not valid.");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", System.getProperty("java.io.tmpdir"));
        this.tester.setFormElement("backupAttachmentPath", "/iamafilethatwillneverexisthahahahaha");
        this.tester.submit("Next");
        this.tester.assertTextPresent("The path to the JIRA backup XML file is not valid.");
        this.tester.assertTextPresent("You cannot import attachments, because attachments are currently disabled in this instance of JIRA.");
    }

    public void testInvalidEditionAndBuildNumber() {
        this.navigation.gotoAdminSection("project_import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", this.environmentData.getXMLDataLocation().getAbsolutePath() + "/BlankProjectsOldBuild.xml");
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("but the supplied backup file does not specify the edition.");
        this.tester.assertTextPresent("but the supplied backup file was for build number '283'.");
    }

    public void testJumpToProgressScreen() {
        this.navigation.gotoAdminSection("project_import");
        this.tester.gotoPage("/secure/admin/ProjectImportBackupOverviewProgress.jspa");
        this.tester.assertTextPresent("Can not find any running task information. Perhaps your session has timed out, please restart the project import wizard.");
        this.tester.assertTextNotPresent("Refresh");
        this.tester.assertTextPresent("Cancel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParseExceptionInJIRAData() throws Exception {
        File file = this.importAndExportBackupAndSetupCurrentInstance("TestProjectImportParseExceptionScreen1.xml", "blankprojects.xml");
        try {
            this.navigation.gotoAdminSection("project_import");
            this.tester.assertTextPresent("Project Import: Select Backup File");
            this.tester.setFormElement("backupXmlPath", file.getAbsolutePath());
            this.tester.submit("Next");
            this.advanceThroughWaitingPage();
            this.tester.assertTextPresent("Project Import: Select Backup File");
            this.tester.assertTextPresent("There was a problem parsing the backup XML file at " + file.getAbsolutePath() + ": No 'key' field for Issue 10022.");
        }
        finally {
            file.delete();
        }
    }
}

