/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import java.io.File;
import java.io.IOException;

public abstract class AbstractProjectImportTestCase
extends FuncTestCase {
    public void advanceThroughWaitingPage() {
        int count = 0;
        while (this.tester.getDialog().getResponseText().indexOf("Project Import: Progress") != -1) {
            this.tester.submit("Refresh");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (++count < 100) continue;
            AbstractProjectImportTestCase.fail((String)"Our project import backup selection has taken too long!");
        }
    }

    public File doProjectImport(String backupFileName, String currentSystemXML, String attachmentPath) {
        File tempFile = this.importAndExportBackupAndSetupCurrentInstance(backupFileName, currentSystemXML);
        this.importToPreImportSummaryPage(attachmentPath, tempFile);
        return tempFile;
    }

    public void importToPreImportSummaryPage(String attachmentPath, File tempFile) {
        this.navigation.gotoAdminSection("project_import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", tempFile.getAbsolutePath());
        if (attachmentPath != null) {
            this.tester.setFormElement("backupAttachmentPath", attachmentPath);
        }
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
    }

    public File importAndExportBackupAndSetupCurrentInstance(String backupFileName, String currentSystemXML) {
        File tempFile;
        this.administration.restoreData(backupFileName);
        try {
            tempFile = File.createTempFile(backupFileName, ".xml");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.administration.exportDataToPath(tempFile.getAbsolutePath());
        this.administration.restoreData(currentSystemXML);
        this.administration.enableAttachments();
        return tempFile;
    }
}

