/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.UserProfileImpl;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigator.IssueTypeCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearchBuilder;
import com.atlassian.jira.functest.framework.navigator.QuerySearchCondition;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.FilterList;
import com.atlassian.jira.functest.framework.sharing.GlobalTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.GroupTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.ProjectTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.SimpleTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.functest.framework.util.json.TestJSONException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSaveAsFilterSharing
extends FuncTestCase {
    private static final String ADMIN_USER = "admin";
    private static final String NO_SHARE_USER = "user_cant_share_filters";
    private static final String SHARE_USER = "user_can_share_filters";
    private static final String SHARE_GROUP = "group_share_filters_with_me";
    private static final String ADMINISTRATOR_GROUP = "jira-administrators";
    private static final long HOMOSAPIEN_PROJECT_ID = 10000L;
    private static final long SHARE_ROLE_ID = 10004L;
    private static final long HOMOSAPIEN_ROLE_ID = 10005L;
    private static final NavigatorSearch NAV_SEARCH2;
    private static final NavigatorSearch NAV_SEARCH1;
    private static final long PRIVATE_CANT_SHARE_ID = 10022L;
    private static final NavigatorSearch PRIVATE_CANT_SHARE;
    private static final SharedEntityInfo PRIVATE_CANT_SHARE_INFO;
    private static final long PUBLIC_BUG_SHARE_ID = 10020L;
    private static final NavigatorSearch PUBLIC_BUG_SHARE;
    private static final SharedEntityInfo PUBLIC_BUG_SHARE_INFO;
    private static final long PRIVATE_BUG_SHARE_ID = 10021L;
    private static final NavigatorSearch PRIVATE_BUG_SHARE;
    private static final SharedEntityInfo PRIVATE_BUG_SHARE_INFO;
    private static final Pattern FILTER_PATTERN;
    private static final int NOBROWSE_PROJECT_ID = 10002;
    private static final int NON_EXISTENT_ROLE_ID = 629;
    private static final int NON_EXISTENT_PROJECT_ID = 496;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("sharedfilters/TestFilterSharing.xml");
    }

    public void testSharesOption() {
        this.loginAsUser(SHARE_USER);
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("Save");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Shares:");
    }

    public void testSaveNoSharePermission() {
        SharedEntityInfo info = new SharedEntityInfo("TestFilter", null, true, null);
        this.loginAsUser(NO_SHARE_USER);
        this.navigation.issueNavigator().createSearch(NAV_SEARCH1);
        this.tester.clickLinkWithText("Save");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "Shares:");
        this.tester.assertFormElementNotPresent("shareValues");
        this.tester.setFormElement("filterName", info.getName());
        this.tester.submit("Save");
        this.assertSearchSavedCorrectly(info, NAV_SEARCH1, null);
    }

    public void testSaveAsNoSharePermission() {
        SharedEntityInfo info = new SharedEntityInfo("testSaveAsNoSharePermission", null, true, null);
        this.loginAsUser(NO_SHARE_USER);
        this.navigation.issueNavigator().loadFilter(10022L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.issueNavigator().modifySearch(NAV_SEARCH2);
        this.tester.clickLinkWithText("Save as");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "Shares:");
        this.tester.assertFormElementNotPresent("shareValues");
        this.tester.setFormElement("filterName", info.getName());
        this.tester.submit("Save");
        this.assertSearchSavedCorrectly(info, NAV_SEARCH2, null);
        this.navigation.issueNavigator().loadFilter(10022L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertSearchSavedCorrectly(PRIVATE_CANT_SHARE_INFO, PRIVATE_CANT_SHARE, null);
    }

    public void testAllowedToSaveSharedFilter() {
        SharedEntityInfo info = new SharedEntityInfo("testAllowedToSaveSharedFilter", null, true, null);
        this.loginAsUser(NO_SHARE_USER);
        this.navigation.issueNavigator().loadFilter(10020L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.clickLink("copyasnewfilter");
        this.tester.assertLinkNotPresentWithText("Save");
        this.tester.assertLinkNotPresentWithText("Save as");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "Shares:");
        this.tester.assertFormElementNotPresent("shareValues");
        this.tester.setFormElement("filterName", info.getName());
        this.tester.submit("Save");
        this.assertSearchSavedCorrectly(info, PUBLIC_BUG_SHARE, null);
    }

    public void testCannotURLHackSharingSaveAs() {
        SharedEntityInfo info = new SharedEntityInfo("testCannotURLHackSharingSaveAs", null, false, null);
        this.loginAsUser(NO_SHARE_USER);
        this.navigation.issueNavigator().loadFilter(10022L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.issueNavigator().modifySearch(NAV_SEARCH2);
        Set<TestSharingPermission> globalSet = Collections.singleton(GlobalTestSharingPermission.GLOBAL_PERMISSION);
        this.tester.gotoPage(this.createSaveUrl(info.getName(), null, false, globalSet));
        this.text.assertTextPresent(new WebPageLocator(this.tester), "You do not have permission to share. All shares are invalid.");
        this.assertSaveScreenCorrect(info, globalSet);
        this.navigation.issueNavigator().loadFilter(10022L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertSearchSavedCorrectly(PRIVATE_CANT_SHARE_INFO, PRIVATE_CANT_SHARE, null);
        this.assertFilterNotOnManage(info);
    }

    public void testCannotURLHackSharingSave() {
        SharedEntityInfo info = new SharedEntityInfo("testCannotURLHackSharing", null, false, null);
        this.loginAsUser(NO_SHARE_USER);
        this.navigation.issueNavigator().displayAllIssues();
        HashSet<TestSharingPermission> globalSet = new HashSet<TestSharingPermission>();
        globalSet.add(GlobalTestSharingPermission.GLOBAL_PERMISSION);
        globalSet.add(new GroupTestSharingPermission(SHARE_GROUP));
        this.tester.gotoPage(this.createSaveUrl(info.getName(), null, false, globalSet));
        this.text.assertTextPresent(new WebPageLocator(this.tester), "You do not have permission to share. All shares are invalid.");
        this.assertSaveScreenCorrect(info, globalSet);
        this.assertFilterNotOnManage(info);
    }

    public void testSaveEmptyShares() {
        this.loginAsUser(NO_SHARE_USER);
        SharedEntityInfo info = new SharedEntityInfo("testSaveEmptyShares", null, false, null);
        this.createAndCheckFilter(info, NAV_SEARCH1, null);
    }

    public void testSaveAsEmptyShares() {
        this.loginAsUser(NO_SHARE_USER);
        this.navigation.issueNavigator().loadFilter(10022L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.issueNavigator().modifySearch(NAV_SEARCH1);
        SharedEntityInfo info = new SharedEntityInfo("testSaveAsEmptyShares", null, false, null);
        this.saveFilter(info, Collections.<TestSharingPermission>emptySet());
        this.assertSearchSavedCorrectly(info, NAV_SEARCH1, null);
        this.navigation.issueNavigator().loadFilter(10022L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertSearchSavedCorrectly(PRIVATE_CANT_SHARE_INFO, PRIVATE_CANT_SHARE, null);
    }

    public void testSaveDefaultPriavtePermissions() {
        UserProfileImpl profile = new UserProfileImpl(this.tester, this.environmentData);
        this.loginAsUser(ADMIN_USER);
        profile.changeDefaultSharingType(false);
        this.loginAsUser(SHARE_USER);
        this.navigation.issueNavigator().createSearch(NAV_SEARCH1);
        this.tester.clickLinkWithText("Save");
        this.assertSaveScreenCorrect(new SharedEntityInfo(null, null, true, null), Collections.<TestSharingPermission>emptySet());
    }

    public void testSaveAsDefaultPublicPermissions() {
        UserProfileImpl profile = new UserProfileImpl(this.tester, this.environmentData);
        this.loginAsUser(ADMIN_USER);
        profile.changeDefaultSharingType(true);
        this.loginAsUser(SHARE_USER);
        this.navigation.issueNavigator().loadFilter(10020L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.issueNavigator().modifySearch(NAV_SEARCH2);
        this.tester.clickLinkWithText("Save as");
        this.assertSaveScreenCorrect(new SharedEntityInfo(null, null, true, null), TestSharingPermissionUtils.createPublicPermissions());
        this.navigation.issueNavigator().loadFilter(10020L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertSearchSavedCorrectly(PUBLIC_BUG_SHARE_INFO, PUBLIC_BUG_SHARE, TestSharingPermissionUtils.createPublicPermissions());
    }

    public void testSaveUserPublicPermissions() {
        UserProfileImpl profile = new UserProfileImpl(this.tester, this.environmentData);
        this.loginAsUser(ADMIN_USER);
        profile.changeDefaultSharingType(false);
        this.navigation.logout();
        this.loginAsUser(SHARE_USER);
        profile.changeUserSharingType(true);
        this.navigation.issueNavigator().createSearch(NAV_SEARCH1);
        this.tester.clickLinkWithText("Save");
        this.assertSaveScreenCorrect(new SharedEntityInfo(null, null, true, null), TestSharingPermissionUtils.createPublicPermissions());
    }

    public void testSaveAsUserPrivatePermissions() {
        UserProfileImpl profile = new UserProfileImpl(this.tester, this.environmentData);
        this.loginAsUser(ADMIN_USER);
        profile.changeDefaultSharingType(true);
        this.loginAsUser(SHARE_USER);
        profile.changeUserSharingType(false);
        this.navigation.issueNavigator().loadFilter(10020L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.issueNavigator().modifySearch(NAV_SEARCH2);
        this.tester.clickLinkWithText("Save as");
        this.assertSaveScreenCorrect(new SharedEntityInfo(null, null, true, null), Collections.<TestSharingPermission>emptySet());
        this.navigation.issueNavigator().loadFilter(10020L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertSearchSavedCorrectly(PUBLIC_BUG_SHARE_INFO, PUBLIC_BUG_SHARE, TestSharingPermissionUtils.createPublicPermissions());
    }

    public void testSaveGlobalPermission() {
        this.loginAsUser(SHARE_USER);
        SharedEntityInfo info = new SharedEntityInfo("testSaveGlobalPermission", null, false, null);
        this.createAndCheckFilter(info, NAV_SEARCH2, Collections.singleton(GlobalTestSharingPermission.GLOBAL_PERMISSION));
    }

    public void testSaveAsGlobalPermission() {
        this.loginAsUser(SHARE_USER);
        SharedEntityInfo info = new SharedEntityInfo("testSaveAsGlobalPermission", null, true, null);
        this.modifyAndCheckFilter(info, NAV_SEARCH2, Collections.singleton(GlobalTestSharingPermission.GLOBAL_PERMISSION));
    }

    public void testSaveGroupPermission() {
        this.loginAsUser(SHARE_USER);
        SharedEntityInfo info = new SharedEntityInfo("testSaveGroupPermission", null, false, null);
        this.createAndCheckFilter(info, NAV_SEARCH2, Collections.singleton(new GroupTestSharingPermission(SHARE_GROUP)));
    }

    public void testSaveAsGroupPermission() {
        this.loginAsUser(SHARE_USER);
        SharedEntityInfo info = new SharedEntityInfo("testSaveAsGroupPermission", null, false, null);
        this.modifyAndCheckFilter(info, NAV_SEARCH2, Collections.singleton(new GroupTestSharingPermission(SHARE_GROUP)));
    }

    public void testSaveProjectPermission() {
        this.loginAsUser(SHARE_USER);
        SharedEntityInfo info = new SharedEntityInfo("testSaveProjectPermission", null, false, null);
        this.createAndCheckFilter(info, NAV_SEARCH2, Collections.singleton(new ProjectTestSharingPermission(10000L)));
    }

    public void testSaveAsProjectPermission() {
        this.loginAsUser(SHARE_USER);
        SharedEntityInfo info = new SharedEntityInfo("testSaveAsProjectPermission", null, false, null);
        this.modifyAndCheckFilter(info, NAV_SEARCH2, Collections.singleton(new ProjectTestSharingPermission(10000L)));
    }

    public void testSaveRolePermission() {
        this.loginAsUser(SHARE_USER);
        SharedEntityInfo info = new SharedEntityInfo("testSaveRolePermission", null, false, null);
        this.createAndCheckFilter(info, NAV_SEARCH2, Collections.singleton(new ProjectTestSharingPermission(10000L, 10004L)));
    }

    public void testSaveAsRolePermission() {
        this.loginAsUser(SHARE_USER);
        SharedEntityInfo info = new SharedEntityInfo("testSaveAsRolePermission", null, true, null);
        this.modifyAndCheckFilter(info, NAV_SEARCH2, Collections.singleton(new ProjectTestSharingPermission(10000L, 10004L)));
    }

    public void testSaveMultiplePermission() {
        this.loginAsUser(SHARE_USER);
        HashSet<TestSharingPermission> shares = new HashSet<TestSharingPermission>();
        shares.add(new ProjectTestSharingPermission(10000L));
        shares.add(new ProjectTestSharingPermission(10000L, 10004L));
        SharedEntityInfo info = new SharedEntityInfo("testSaveMultiplePermission", null, false, null);
        this.createAndCheckFilter(info, NAV_SEARCH2, shares);
    }

    public void testSaveAsMultiplePermission() {
        this.loginAsUser(SHARE_USER);
        HashSet<TestSharingPermission> shares = new HashSet<TestSharingPermission>();
        shares.add(new ProjectTestSharingPermission(10000L));
        shares.add(new ProjectTestSharingPermission(10000L, 10004L));
        shares.add(new GroupTestSharingPermission(SHARE_GROUP));
        SharedEntityInfo info = new SharedEntityInfo("testSaveAsMultiplePermission", null, true, null);
        this.modifyAndCheckFilter(info, NAV_SEARCH2, shares);
    }

    public void testSaveInvalidGlobal() {
        this.loginAsUser(SHARE_USER);
        HashSet<TestSharingPermission> shares = new HashSet<TestSharingPermission>();
        shares.add(new GroupTestSharingPermission(SHARE_GROUP));
        shares.add(GlobalTestSharingPermission.GLOBAL_PERMISSION);
        this.checkCannotSaveInvalidPermissions(shares, "Permission type 'global' must not be included with other permissions.");
    }

    public void testSaveAsInvalidGlobal() {
        this.loginAsUser(SHARE_USER);
        HashSet<TestSharingPermission> shares = new HashSet<TestSharingPermission>();
        shares.add(new GroupTestSharingPermission(SHARE_GROUP));
        shares.add(GlobalTestSharingPermission.GLOBAL_PERMISSION);
        this.checkCannotSaveAsInvalidPermissions(shares, "Permission type 'global' must not be included with other permissions.");
    }

    public void testSaveInvalidGroup() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new GroupTestSharingPermission("qqqqqaaa"));
        this.checkCannotSaveInvalidPermissions(shares, "Group: 'qqqqqaaa' does not exist.");
    }

    public void testSaveAsInvalidGroup() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new GroupTestSharingPermission(""));
        this.checkCannotSaveAsInvalidPermissions(shares, "Group permission is not valid: Invalid group name ''");
    }

    public void testSaveNotMemberGroup() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new GroupTestSharingPermission(ADMINISTRATOR_GROUP));
        this.checkCannotSaveAsInvalidPermissions(shares, "You do not have permission to share with Group: 'jira-administrators'.");
    }

    public void testSaveAsNotMemberGroup() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new GroupTestSharingPermission(ADMINISTRATOR_GROUP));
        this.checkCannotSaveAsInvalidPermissions(shares, "You do not have permission to share with Group: 'jira-administrators'.");
    }

    public void testSaveInvalidProjectId() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new SimpleTestSharingPermission("project", "abc", null));
        this.checkCannotSaveInvalidPermissions(shares, "Project permission is not valid: Invalid project identifier 'abc'.");
    }

    public void testSaveAsInvalidProjectId() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new ProjectTestSharingPermission(-1L));
        this.checkCannotSaveAsInvalidPermissions(shares, "Project permission is not valid: Invalid project identifier ''.");
    }

    public void testSaveProjectDoesNotExist() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new ProjectTestSharingPermission(496L));
        this.checkCannotSaveInvalidPermissions(shares, "Selected project does not exist.");
    }

    public void testSaveAsProjectDoesNotExist() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new ProjectTestSharingPermission(496L));
        this.checkCannotSaveAsInvalidPermissions(shares, "Selected project does not exist.");
    }

    public void testSaveProjectNoBrowse() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new ProjectTestSharingPermission(10002L));
        this.checkCannotSaveInvalidPermissions(shares, "You do not have permission to share with Project: '");
    }

    public void testSaveAsProjectNoBrowse() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new ProjectTestSharingPermission(10002L));
        this.checkCannotSaveAsInvalidPermissions(shares, "You do not have permission to share with Project: '");
    }

    public void testSaveInvalidRoleId() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new SimpleTestSharingPermission("project", "10000", "abc"));
        this.checkCannotSaveInvalidPermissions(shares, "Project permission is not valid: Invalid role identifier 'abc'.");
    }

    public void testSaveAsInvalidRoleId() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new SimpleTestSharingPermission("project", "10000", "-300s"));
        this.checkCannotSaveAsInvalidPermissions(shares, "Project permission is not valid: Invalid role identifier '-300s'.");
    }

    public void testSaveRoleDoesNotExist() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new ProjectTestSharingPermission(10000L, 629L));
        this.checkCannotSaveInvalidPermissions(shares, "Selected role does not exist.");
    }

    public void testSaveAsRoleDoesNotExist() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new ProjectTestSharingPermission(10000L, 629L));
        this.checkCannotSaveAsInvalidPermissions(shares, "Selected role does not exist.");
    }

    public void testSaveRoleNotMember() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new ProjectTestSharingPermission(10000L, 10005L));
        this.checkCannotSaveInvalidPermissions(shares, "You do not have permission to share with Project:");
    }

    public void testSaveAsRoleNotMember() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new ProjectTestSharingPermission(10000L, 10005L));
        this.checkCannotSaveAsInvalidPermissions(shares, "You do not have permission to share with Project:");
    }

    public void testSaveInvalidShareType() {
        this.loginAsUser(SHARE_USER);
        HashSet<TestSharingPermission> shares = new HashSet<TestSharingPermission>();
        shares.add(new SimpleTestSharingPermission((String)null));
        shares.add(GlobalTestSharingPermission.GLOBAL_PERMISSION);
        this.checkCannotSaveInvalidPermissions(shares, "Unable to parse shares.", Collections.<TestSharingPermission>emptySet());
    }

    public void testSaveAsInvalidShareType() {
        this.loginAsUser(SHARE_USER);
        HashSet<TestSharingPermission> shares = new HashSet<TestSharingPermission>();
        shares.add(new SimpleTestSharingPermission((String)null));
        shares.add(GlobalTestSharingPermission.GLOBAL_PERMISSION);
        this.checkCannotSaveAsInvalidPermissions(shares, "Unable to parse shares.", Collections.<TestSharingPermission>emptySet());
    }

    public void testSaveInvalidJSON() {
        this.loginAsUser(SHARE_USER);
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.gotoPage("secure/SaveAsFilter.jspa?filterName=testInvalidJSON&shareValues=dsajsksdja");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Unable to parse shares.");
    }

    public void testSaveAsInvalidJSON() {
        this.loginAsUser(SHARE_USER);
        this.navigation.issueNavigator().loadFilter(10020L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.issueNavigator().modifySearch(NAV_SEARCH1);
        this.tester.gotoPage("secure/SaveAsFilter.jspa?filterName=testInvalidJSON&shareValues=dsajsksdja");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Unable to parse shares.");
        this.navigation.issueNavigator().loadFilter(10020L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertSearchSavedCorrectly(PUBLIC_BUG_SHARE_INFO, PUBLIC_BUG_SHARE, TestSharingPermissionUtils.createPublicPermissions());
    }

    public void testSaveInvalidShareTypeDoesNotExist() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new SimpleTestSharingPermission("blah", null, null));
        this.checkCannotSaveInvalidPermissions(shares, "Share permission of type 'blah' is unknown.");
    }

    public void testSaveAsInvalidShareTypeDoesNotExist() {
        this.loginAsUser(SHARE_USER);
        Set<TestSharingPermission> shares = Collections.singleton(new SimpleTestSharingPermission("blah", null, null));
        this.checkCannotSaveAsInvalidPermissions(shares, "Share permission of type 'blah' is unknown.");
    }

    public void checkCannotSaveInvalidPermissions(Set<TestSharingPermission> shares, String assertText) {
        this.checkCannotSaveInvalidPermissions(shares, assertText, shares);
    }

    private void checkCannotSaveInvalidPermissions(Set<TestSharingPermission> shares, String assertText, Set<TestSharingPermission> expectedPermissions) {
        SharedEntityInfo info = new SharedEntityInfo("cannotSaveInvalidPermissions", null, true, null);
        this.navigation.issueNavigator().createSearch(NAV_SEARCH1);
        this.saveFilterNoId(info, shares);
        this.text.assertTextPresent(new WebPageLocator(this.tester), assertText);
        TestSaveAsFilterSharing.assertEquals(expectedPermissions, this.parsePermissions());
        this.assertFilterNotOnManage(info);
    }

    private void checkCannotSaveAsInvalidPermissions(Set<TestSharingPermission> shares, String assertText) {
        this.checkCannotSaveAsInvalidPermissions(shares, assertText, shares);
    }

    private void checkCannotSaveAsInvalidPermissions(Set<TestSharingPermission> shares, String assertText, Set<TestSharingPermission> expectedShares) {
        SharedEntityInfo info = new SharedEntityInfo("cannotSaveAsInvalidPermissions", null, true, null);
        this.navigation.issueNavigator().loadFilter(10021L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.issueNavigator().modifySearch(NAV_SEARCH2);
        this.saveAsFilterNoId(info, shares);
        this.text.assertTextPresent(new WebPageLocator(this.tester), assertText);
        this.assertSaveScreenCorrect(info, expectedShares);
        this.assertFilterNotOnManage(info);
        this.navigation.issueNavigator().loadFilter(10021L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertSearchSavedCorrectly(PRIVATE_BUG_SHARE_INFO, PRIVATE_BUG_SHARE, Collections.<TestSharingPermission>emptySet());
    }

    private long modifyAndCheckFilter(SharedEntityInfo info, NavigatorSearch search, Set<TestSharingPermission> permissions) {
        this.navigation.issueNavigator().loadFilter(10021L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.issueNavigator().modifySearch(search);
        long id = this.saveAsFilter(info, permissions);
        this.assertSearchSavedCorrectly(info, search, permissions);
        this.navigation.issueNavigator().loadFilter(10021L, null);
        this.assertSearchSavedCorrectly(PRIVATE_BUG_SHARE_INFO, PRIVATE_BUG_SHARE, Collections.<TestSharingPermission>emptySet());
        return id;
    }

    private long createAndCheckFilter(SharedEntityInfo info, NavigatorSearch search, Set<TestSharingPermission> permissions) {
        this.navigation.issueNavigator().createSearch(search);
        long id = this.saveFilter(info, permissions);
        this.assertSearchSavedCorrectly(info, search, permissions);
        return id;
    }

    private void saveFilterNoId(SharedEntityInfo search, Set<TestSharingPermission> permissions) {
        this.saveAsFilterNoId(search.getName(), search.getDescription(), search.isFavourite(), permissions, "Save");
    }

    private void saveAsFilterNoId(SharedEntityInfo search, Set<TestSharingPermission> permissions) {
        this.saveAsFilterNoId(search.getName(), search.getDescription(), search.isFavourite(), permissions, "Save as");
    }

    private long saveFilter(SharedEntityInfo search, Set<TestSharingPermission> permissions) {
        this.saveFilterNoId(search, permissions);
        return this.getFilterIdAfterSave();
    }

    private long saveAsFilter(SharedEntityInfo search, Set<TestSharingPermission> permissions) {
        this.saveAsFilterNoId(search, permissions);
        return this.getFilterIdAfterSave();
    }

    private void saveAsFilterNoId(String name, String description, boolean favourite, Set<TestSharingPermission> permissions, String linkText) {
        if (favourite && (permissions == null || permissions.isEmpty())) {
            this.tester.clickLinkWithText(linkText);
            this.tester.setFormElement("filterName", name);
            if (!StringUtils.isBlank((String)description)) {
                this.tester.setFormElement("filterDescription", description);
            }
            this.tester.submit("Save");
        } else {
            this.saveUsingPut(name, description, favourite, permissions);
        }
    }

    private void saveUsingPut(String name, String description, boolean favourite, Set<TestSharingPermission> permissions) {
        this.tester.gotoPage(this.createSaveUrl(name, description, favourite, permissions));
    }

    private String createSaveUrl(String name, String description, boolean favourite, Set<TestSharingPermission> permissions) {
        StringBuffer buffer = new StringBuffer("secure/SaveAsFilter.jspa?submit=Save");
        if (!StringUtils.isBlank((String)name)) {
            buffer.append("&filterName=").append(this.encode(name));
        }
        if (!StringUtils.isBlank((String)description)) {
            buffer.append("&filterDescription=").append(this.encode(description));
        }
        if (permissions != null) {
            buffer.append("&shareValues=").append(this.encode(TestSharingPermissionUtils.createJsonString(permissions)));
        }
        buffer.append("&favourite=").append(String.valueOf(favourite));
        return buffer.toString();
    }

    private String encode(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private long getFilterIdAfterSave() {
        URL url = this.tester.getDialog().getResponse().getURL();
        if (url.getQuery() == null) {
            TestSaveAsFilterSharing.fail((String)"Unable to save filter: Not redirected to navigator.");
        } else if (url.getPath() == null || !url.getPath().endsWith("IssueNavigator.jspa")) {
            TestSaveAsFilterSharing.fail((String)"Unable to save filter: Not redirected to navigator.");
        } else {
            Matcher matcher = FILTER_PATTERN.matcher(url.getQuery());
            if (matcher.find()) {
                return Long.parseLong(matcher.group(1));
            }
            TestSaveAsFilterSharing.fail((String)"Unable to save filter: Not redirected to navigator.");
        }
        return Long.MIN_VALUE;
    }

    private void loginAsUser(String user) {
        this.navigation.login(user, user);
    }

    private void assertSearchSavedCorrectly(SharedEntityInfo info, NavigatorSearch expectedSearch, Set<TestSharingPermission> expectedPermissions) {
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertions.getIssueNavigatorAssertions().assertSimpleSearch(expectedSearch, this.tester);
        this.assertions.getIssueNavigatorAssertions().assertSearchInfo(info);
        this.tester.gotoPage("secure/EditFilter!default.jspa");
        TestSaveAsFilterSharing.assertEquals((String)"Expected and actual permissions did not match.", expectedPermissions, this.parsePermissions());
        this.assertFilterOnManage(info);
    }

    private void assertFilterOnManage(SharedEntityInfo info) {
        this.navigation.manageFilters().myFilters();
        FilterList list = this.parse.filter().parseFilterList("mf_owned");
        for (FilterItem item : list.getFilterItems()) {
            if (!info.getName().equals(item.getName())) continue;
            if (info.getDescription() == null) {
                TestSaveAsFilterSharing.assertNull((Object)item.getDescription());
            } else {
                TestSaveAsFilterSharing.assertEquals((String)info.getDescription(), (String)item.getDescription());
            }
            TestSaveAsFilterSharing.assertEquals((boolean)info.isFavourite(), (boolean)item.isFav());
            return;
        }
        TestSaveAsFilterSharing.fail((String)"Filter not displayed on manage filters.");
    }

    private void assertFilterNotOnManage(SharedEntityInfo info) {
        this.navigation.manageFilters().myFilters();
        FilterList list = this.parse.filter().parseFilterList("mf_owned");
        for (FilterItem item : list.getFilterItems()) {
            if (!info.getName().equals(item.getName())) continue;
            TestSaveAsFilterSharing.fail((String)"Filter should not be on the manage filters page.");
        }
    }

    private void assertSaveScreenCorrect(SharedEntityInfo expectedInfo, Set<TestSharingPermission> expectedPermissions) {
        this.tester.assertFormElementEquals("filterName", expectedInfo.getName());
        this.tester.assertFormElementEquals("filterDescription", expectedInfo.getDescription());
        this.tester.assertFormElementEquals("favourite", String.valueOf(expectedInfo.isFavourite()));
        TestSaveAsFilterSharing.assertEquals(expectedPermissions, this.parsePermissions());
    }

    private Set<TestSharingPermission> parsePermissions() {
        XPathLocator xpath = new XPathLocator(this.tester, "//span[@id='shares_data']");
        String value = xpath.getText();
        try {
            return TestSharingPermissionUtils.parsePermissions(value);
        }
        catch (TestJSONException e) {
            TestSaveAsFilterSharing.fail((String)("Unable to parse shares: " + e.getMessage()));
            return null;
        }
    }

    static {
        PRIVATE_CANT_SHARE_INFO = new SharedEntityInfo("PrivateHumanCantShare", "Cant share this.", true, null);
        PUBLIC_BUG_SHARE_INFO = new SharedEntityInfo("PublicBugShare", null, false, null);
        PRIVATE_BUG_SHARE_INFO = new SharedEntityInfo("PrivateBugShare", null, true, null);
        FILTER_PATTERN = Pattern.compile("requestId=(\\d+)");
        NavigatorSearchBuilder builder = new NavigatorSearchBuilder();
        builder.addIssueType(IssueTypeCondition.IssueType.BUG);
        builder.addQueryString("NAV_SEARCH1").addQueryField(QuerySearchCondition.QueryField.SUMMARY);
        NAV_SEARCH1 = builder.createSearch();
        builder = new NavigatorSearchBuilder();
        builder.addQueryString("NAV_SEARCH2").addQueryField(QuerySearchCondition.QueryField.ENVIRONMENT).addQueryField(QuerySearchCondition.QueryField.COMMENTS);
        NAV_SEARCH2 = builder.createSearch();
        builder = new NavigatorSearchBuilder();
        builder.addProject("homosapien");
        builder.addQueryString("human").addQueryField(QuerySearchCondition.QueryField.SUMMARY).addQueryField(QuerySearchCondition.QueryField.COMMENTS);
        PRIVATE_CANT_SHARE = builder.createSearch();
        builder = new NavigatorSearchBuilder();
        builder.addIssueType(IssueTypeCondition.IssueType.BUG);
        PUBLIC_BUG_SHARE = builder.createSearch();
        builder = new NavigatorSearchBuilder();
        builder.addIssueType(IssueTypeCondition.IssueType.BUG);
        PRIVATE_BUG_SHARE = builder.createSearch();
    }
}

