/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestFilterWarnings
extends JIRAWebTest {
    private static final String NO_MAIL_SERVER_IS_CURRENTLY_CONFIGURED = "No mail server is currently configured. Notifications will not be sent.";

    public TestFilterWarnings(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
        this.submit();
        this.clickLinkWithText("Save");
        this.setFormElement("filterName", "Test Filter");
        this.submit("Save");
    }

    private void addSubscription() {
        this.clickLinkWithText("Subscriptions");
        this.clickLinkWithText("Add subscription");
        this.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daysOfMonth");
        this.submit("Subscribe");
    }

    public void testMailNotConfiguredWarning() {
        this.addSubscription();
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.assertTextPresent(NO_MAIL_SERVER_IS_CURRENTLY_CONFIGURED);
        this.tester.clickLink("filterlink_10000");
        this.tester.clickLinkWithText("Subscriptions");
        this.assertTextPresent(NO_MAIL_SERVER_IS_CURRENTLY_CONFIGURED);
        this.assertTextNotPresent("Run now");
    }

    public void testMailConfiguredNoWarning() {
        this.addSubscription();
        this.gotoDashboard();
        this.tester.clickLink("admin_link");
        this.tester.clickLink("mail_servers");
        this.tester.clickLinkWithText("Configure new SMTP mail server");
        this.tester.setFormElement("name", "testserver");
        this.tester.setFormElement("from", "admin@example.com");
        this.tester.setFormElement("prefix", "JIRA");
        this.tester.setFormElement("jndiLocation", "fake");
        this.tester.submit(" Add ");
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.assertTextNotPresent(NO_MAIL_SERVER_IS_CURRENTLY_CONFIGURED);
        this.tester.clickLink("filterlink_10000");
        this.tester.clickLinkWithText("Subscriptions");
        this.assertTextNotPresent(NO_MAIL_SERVER_IS_CURRENTLY_CONFIGURED);
        this.assertTextPresent("Run now");
    }

    public void testNoMailServerNoSubscriptions() {
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.assertTextNotPresent(NO_MAIL_SERVER_IS_CURRENTLY_CONFIGURED);
    }
}

