/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.meterware.httpunit.HttpUnitOptions;

public class TestFilterPageNavigation
extends FuncTestCase {
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("sharedfilters/SharedFiltersBase.xml");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
    }

    protected void tearDownTest() {
        super.tearDownTest();
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    public void testBasicNavigationPage() throws Exception {
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.tester.clickLinkWithText("Edit");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("filtereditshares");
        this.tester.setFormElement("filterName", "Nothing in The Session Filter");
        this.tester.submit("Save");
        this.assertOnManageFiltersPage();
        this.tester.clickLinkWithText("Save");
        this.tester.submit("Save");
        this.tester.clickLink("filtereditshares");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("filtereditshares");
        this.tester.setFormElement("filterName", "Now Its In The Session Filter");
        this.tester.submit("Save");
        this.assertOnManageFiltersPage();
        this.tester.clickLinkWithText("Save");
        this.tester.submit("Save");
        this.tester.clickLink("viewfilter");
        this.tester.clickLink("filtereditshares");
        this.pressCancel();
        this.assertOnFilterPage("Now Its In The Session Filter");
        this.tester.clickLink("filtereditshares");
        this.tester.setFormElement("filterName", "Now has New Name");
        this.tester.submit("Save");
        this.assertOnFilterPage("Now has New Name");
        this.tester.clickLinkWithText("Save");
        this.tester.submit("Save");
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.tester.clickLinkWithText("Delete");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLinkWithText("Delete");
        this.tester.submit("Delete");
        this.assertOnManageFiltersPage();
    }

    public void testEditValidationFailures() throws Exception {
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.tester.clickLinkWithText("Edit");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("filtereditshares");
        this.tester.setFormElement("filterName", "");
        this.tester.submit("Save");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLinkWithText("Save");
        this.tester.submit("Save");
        this.tester.clickLink("filtereditshares");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("filtereditshares");
        this.tester.setFormElement("filterName", "");
        this.tester.submit("Save");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("filtereditshares");
        this.tester.setFormElement("filterName", "Now Its In The Session Filter");
        this.tester.submit("Save");
        this.assertOnManageFiltersPage();
        this.tester.clickLinkWithText("Save");
        this.tester.submit("Save");
        this.tester.clickLink("viewfilter");
        this.tester.clickLink("filtereditshares");
        this.pressCancel();
        this.assertOnFilterPage("Now Its In The Session Filter");
        this.tester.clickLink("filtereditshares");
        this.tester.setFormElement("filterName", "");
        this.tester.submit("Save");
        this.tester.setFormElement("filterName", "Now has New Name");
        this.tester.submit("Save");
        this.assertOnFilterPage("Now has New Name");
    }

    private void assertOnFilterPage(String pageName) {
        XPathLocator mfLocator = new XPathLocator(this.tester, "//h2[@class='formtitle2']");
        TestFilterPageNavigation.assertTrue((String)("we are on the filters page " + pageName), (mfLocator.getText().indexOf(pageName) > 0 ? 1 : 0) != 0);
    }

    private void assertOnManageFiltersPage() {
        XPathLocator mfLocator = new XPathLocator(this.tester, "//h3[@class='formtitle']");
        TestFilterPageNavigation.assertEquals((String)"Manage Filters", (String)mfLocator.getText());
    }

    private void pressCancel() {
        TestFilterPageNavigation.assertTrue((String)"Scripting must be enabled in the HttpUnit for cancel to work correctly", (boolean)HttpUnitOptions.isScriptingEnabled());
        this.tester.setWorkingForm("jiraform");
        this.tester.clickButton("cancelButton");
    }
}

