/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.FilterList;
import com.atlassian.jira.functest.framework.parser.filter.WebTestSharePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TestFavouriteAndMyFilters
extends FuncTestCase {
    private static final List NO_OPERATIONS = EasyList.build();
    private static final List GLOBAL_SHARE = Collections.singletonList(new WebTestSharePermission("global", null, null));
    private static final List GROUP_DEVELOPERS_SHARE = Collections.singletonList(new WebTestSharePermission("group", "jira-developers", null));
    private static final String JOE = "joe";
    private static final String ADMIN_LONG = "admin (admin)";
    private static final String JOE_LONG = "joe (joe)";
    private static final String NOBODY = "nobody";
    private static final String NOBODY_LONG = "nobody (nobody)";
    private static final List OPERATIONS = EasyList.build((Object)"Edit", (Object)"Delete", (Object)"Columns");
    static final FilterItem FILTER_10000 = new FilterItem(new Long(10000L), "All", "", "admin (admin)", new Long(2L), Collections.EMPTY_LIST, Boolean.FALSE, new Long(1L), OPERATIONS, new Long(0L));
    static final FilterItem FILTER_10001 = new FilterItem(new Long(10001L), "All My", "yadayada", "joe (joe)", new Long(2L), GLOBAL_SHARE, Boolean.TRUE, new Long(2L), OPERATIONS, new Long(3L));
    static final FilterItem FILTER_10010 = new FilterItem(new Long(10010L), "Nick", "", "admin (admin)", new Long(2L), GLOBAL_SHARE, Boolean.FALSE, new Long(4L), OPERATIONS, new Long(0L));
    static final FilterItem FILTER_10020 = new FilterItem(new Long(10020L), "New Features", "", "admin (admin)", new Long(0L), GROUP_DEVELOPERS_SHARE, Boolean.TRUE, new Long(0L), OPERATIONS, new Long(1L));
    static final FilterItem FILTER_10030 = new FilterItem(new Long(10030L), "Nobody's All", "Yadyayda", "nobody (nobody)", new Long(2L), Collections.EMPTY_LIST, Boolean.TRUE, new Long(0L), OPERATIONS, new Long(1L));
    private static final int SHARE_FILTERS = 22;

    protected void setUpTest() {
        this.administration.restoreData("TestDeleteUserForFiltersAndSubscriptions.xml");
    }

    public void testStickyTabs() {
        this.navigation.login("admin", "admin");
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@id='filter_type_table']/li", "Favourites");
        this.navigation.manageFilters().myFilters();
        this.tester.assertTextPresent("My");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@id='filter_type_table']/li", "My");
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@id='filter_type_table']/li", "My");
        this.navigation.manageFilters().goToDefault();
        this.tester.assertTextPresent("Favourites");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@id='filter_type_table']/li", "Favourites");
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@id='filter_type_table']/li", "Favourites");
    }

    public void testOperations() {
        this._testInitAnonymousScreen();
        this._testInitNobodyScreen();
        this._testInitJoeScreen();
        this._testInitAdminScreen();
        this.administration.removeGlobalPermission(22, "jira-users");
        this._testInitAnonymousScreen();
        this._testInitAdminScreen();
        this._testInitNobodyScreen();
        this.navigation.login(JOE, JOE);
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        FilterItem filterItem = this.noFavCount(this.makeMine(this.setSubCount(this.setFavCount(this.noOps(FILTER_10001), 3), 2)));
        filterItem.setOperations(EasyList.build((Object)"Edit", (Object)"Delete", (Object)"Columns"));
        compareList.add(filterItem);
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
    }

    public void testDeleteUser() {
        this._testInitAnonymousScreen();
        this._testInitAdminScreen();
        this._testInitJoeScreen();
        this._testInitNobodyScreen();
        this.navigation.login("admin", "admin");
        this._testDeleteConfirm("admin", 2, 2, 0);
        this._testDeleteConfirm(JOE, 4, 1, 1);
        this._testDeleteConfirm(NOBODY, 4, 0, 0);
        this.tester.submit("Delete");
        this._testJoeScreenAfterNobodyDelete();
        this.navigation.manageFilters().addFavourite(10010);
        this._testAdminScreenAfterNobodyDelete();
        this._testAnonymousScreenAfterNobodyDelete();
        this.navigation.login("admin", "admin");
        this.navigation.manageFilters().removeFavourite(10001);
        this.navigation.manageFilters().allFilters();
        this.assertNavigatorTabsPresent();
        FilterList filters = this.parse.filter().parseFilterList("mf_browse");
        List filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.makeMine(this.setSubCount(this.setFavCount(this.noOps(this.makeNotFav(FILTER_10000)), 0), 1)));
        compareList.add(this.setSubCount(this.setFavCount(this.noOps(this.makeNotFav(FILTER_10001)), 1), 1));
        compareList.add(this.makeMine(this.setSubCount(this.setFavCount(this.noOps(FILTER_10020), 1), 0)));
        compareList.add(this.makeMine(this.setSubCount(this.setFavCount(this.noOps(FILTER_10010), 1), 4)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
        this._testDeleteConfirm(JOE, 4, 1, 0);
        this.tester.submit("Delete");
        this._testAdminScreenAfterJoeDelete();
        this._testAnonymousScreenAfterJoeDelete();
    }

    public void testDeleteFilter() {
        this._testInitAnonymousScreen();
        this._testInitAdminScreen();
        this._testInitJoeScreen();
        this._testInitNobodyScreen();
        this._testDeleteFilterPermission(10020L);
        this.navigation.login(NOBODY, NOBODY);
        this._testDeleteFilterPermission(10020L);
        this.navigation.login("admin", "admin");
        this._testDeleteFilterConfirm(10020L, 0L, 0L);
        this.navigation.login(JOE, JOE);
        this._testDeleteFilterConfirm(10001L, 2L, 2L);
        this.navigation.manageFilters().goToDefault();
        TestFavouriteAndMyFilters.assertTrue((boolean)this.parse.filter().parseFilterList("mf_favourites").isEmpty());
        this.navigation.manageFilters().myFilters();
        this.assertNavigatorTabsPresent();
        TestFavouriteAndMyFilters.assertTrue((boolean)this.parse.filter().parseFilterList("mf_owned").isEmpty());
        this._testDeleteFilterPermission(10000L);
        this.navigation.login("admin", "admin");
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextNotPresent(locator, "All My");
        this.navigation.logout();
        this.navigation.manageFilters().goToDefault();
        this.checkAnonymousScreen(Collections.singletonList(this.noOps(this.setSubCount(this.setIssueCount(FILTER_10010, 0), 0))));
        this.navigation.login("admin", "admin");
        this._testDeleteFilterConfirm(10010L, 0L, 4L);
        this.checkAnonymousScreen(null);
        locator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(locator, "Your search criteria did not match any filters.");
    }

    private void _testDeleteFilterPermission(long filterId) {
        this.tester.gotoPage("secure/DeleteFilter!default.jspa?filterId=" + filterId);
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(locator, "You do not have permission to delete this filter or this filter may not exist.");
        this.text.assertTextNotPresent(locator, "Users who have nominated this filter as a favourite");
        this.text.assertTextNotPresent(locator, "Subscriptions attached to this filter");
        this.text.assertTextNotPresent(locator, "Deleting this filter will delete all the subscriptions");
        this.tester.assertButtonNotPresent("Delete");
    }

    private void _testDeleteFilterConfirm(long filterId, long favouriteCount, long subscriptionCount) {
        this.tester.gotoPage("secure/DeleteFilter!default.jspa?filterId=" + filterId);
        WebPageLocator locator = new WebPageLocator(this.tester);
        ArrayList<String> messages = new ArrayList<String>();
        if (favouriteCount > 0L) {
            messages.add("Users who have nominated this filter as a favourite");
            messages.add(String.valueOf(favouriteCount));
            messages.add("Users will not be able to view or run filter");
        } else {
            this.text.assertTextNotPresent(locator, "Users who have nominated this filter as a favourite");
        }
        if (subscriptionCount > 0L) {
            messages.add("Subscriptions attached to this filter");
            messages.add(String.valueOf(subscriptionCount));
            messages.add("Deleting this filter will delete all the subscriptions");
        } else {
            this.text.assertTextPresent(locator, "Deleting this filter will not alter any subscriptions, as there are 0 subscriptions associated with it.");
            this.text.assertTextNotPresent(locator, "Subscriptions attached to this filter");
            this.text.assertTextNotPresent(locator, "Deleting this filter will delete all the subscriptions");
        }
        if (!messages.isEmpty()) {
            this.text.assertTextSequence(locator, messages.toArray(new String[messages.size()]));
        }
        this.tester.submit("Delete");
    }

    private void _testDeleteConfirm(String user, int row, int shared, int favs) {
        this.tester.gotoPage("secure/admin/user/DeleteUser!default.jspa?returnUrl=UserBrowser.jspa&name=" + user);
        TableCellLocator cellLocator = new TableCellLocator(this.tester, "delete_user_confirm", row, 1);
        this.text.assertTextPresent(cellLocator, "" + shared);
        cellLocator = new TableCellLocator(this.tester, "delete_user_confirm", row + 1, 1);
        this.text.assertTextPresent(cellLocator, "" + favs);
    }

    private void checkAnonymousScreen(List expectedFilters) {
        this.navigation.logout();
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        XPathLocator locator = new XPathLocator(this.tester, "//ul[@id='filter_type_table']");
        this.text.assertTextPresent(locator, "Search");
        this.text.assertTextPresent(locator, "Popular");
        this.text.assertTextNotPresent(locator, "Favourite");
        this.text.assertTextNotPresent(locator, "My");
        this.navigation.manageFilters().allFilters();
        FilterList filterList = this.parse.filter().parseFilterList("mf_browse");
        List actualFilters = null;
        if (filterList != null) {
            actualFilters = filterList.getFilterItems();
        }
        TestFavouriteAndMyFilters.assertEquals((Object)expectedFilters, (Object)actualFilters);
        TestFavouriteAndMyFilters.assertNull((Object)this.parse.filter().parseFilterList("mf_favourites"));
        TestFavouriteAndMyFilters.assertNull((Object)this.parse.filter().parseFilterList("mf_owned"));
    }

    private void assertNavigatorTabsPresent() {
        XPathLocator locator = new XPathLocator(this.tester, "//ul[@id='filterFormHeader']");
        this.text.assertTextPresent(locator, "Manage");
        this.text.assertTextPresent(locator, "New");
        this.text.assertTextPresent(locator, "View");
    }

    private void _testInitAnonymousScreen() {
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noOps(this.makeNotFav(this.setIssueCount(this.setSubCount(FILTER_10001, 0), 0))));
        compareList.add(this.noOps(this.setIssueCount(this.setSubCount(FILTER_10010, 0), 0)));
        this.checkAnonymousScreen(compareList);
    }

    private void _testAnonymousScreenAfterNobodyDelete() {
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noOps(this.makeNotFav(this.setFavCount(this.setIssueCount(this.setSubCount(FILTER_10001, 0), 0), 2))));
        compareList.add(this.noOps(this.setFavCount(this.setIssueCount(this.setSubCount(FILTER_10010, 0), 0), 1)));
        this.checkAnonymousScreen(compareList);
    }

    private void _testAnonymousScreenAfterJoeDelete() {
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noOps(this.setFavCount(this.setIssueCount(this.setSubCount(FILTER_10010, 0), 0), 0)));
        this.checkAnonymousScreen(compareList);
    }

    private void _testInitNobodyScreen() {
        this.navigation.login(NOBODY, NOBODY);
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(this.setSubCount(this.noOps(FILTER_10001), 0)));
        compareList.add(this.noFavCount(this.makeMine(FILTER_10030)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10030)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filters.getFilterItems());
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.setSubCount(this.noOps(FILTER_10001), 0));
        compareList.add(this.noOps(this.makeNotFav(FILTER_10020)));
        compareList.add(this.setSubCount(this.noOps(FILTER_10010), 2));
        compareList.add(this.makeMine(this.noOps(FILTER_10030)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
    }

    private FilterItem setIssueCount(FilterItem filter, int count) {
        FilterItem filterItem1 = filter.cloneFilter();
        filterItem1.setIssues(count);
        return filterItem1;
    }

    private FilterItem setSubCount(FilterItem filter, int count) {
        FilterItem filterItem1 = filter.cloneFilter();
        filterItem1.setSubscriptions(count);
        return filterItem1;
    }

    private FilterItem makeFav(FilterItem filter) {
        FilterItem filterItem1 = filter.cloneFilter();
        filterItem1.setFav(Boolean.TRUE);
        return filterItem1;
    }

    private FilterItem makeNotFav(FilterItem filter) {
        FilterItem filterItem1 = filter.cloneFilter();
        filterItem1.setFav(Boolean.FALSE);
        return filterItem1;
    }

    private FilterItem setFavCount(FilterItem filter, int count) {
        FilterItem item = filter.cloneFilter();
        item.setFavCount(count);
        return item;
    }

    private FilterItem noFavCount(FilterItem filter) {
        FilterItem item = filter.cloneFilter();
        item.setFavCount(null);
        return item;
    }

    private FilterItem noOps(FilterItem filter) {
        FilterItem filterItem = filter.cloneFilter();
        filterItem.setOperations(NO_OPERATIONS);
        return filterItem;
    }

    private FilterItem noAuthor(FilterItem filterItem1) {
        FilterItem filterItem = filterItem1.cloneFilter();
        filterItem.setAuthor(null);
        return filterItem;
    }

    private FilterItem makeMine(FilterItem filter) {
        return filter;
    }

    private void _testInitJoeScreen() {
        this.navigation.login(JOE, JOE);
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(this.makeMine(FILTER_10001)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10001)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noOps(this.makeMine(FILTER_10001)));
        compareList.add(this.noOps(this.setSubCount(FILTER_10010, 2)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
    }

    private void _testInitAdminScreen() {
        this.navigation.login("admin", "admin");
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(this.setSubCount(this.noOps(FILTER_10001), 1)));
        compareList.add(this.noFavCount(this.makeMine(FILTER_10020)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        TestFavouriteAndMyFilters.assertFalse((boolean)filters.containsColumn("Author"));
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10000)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10020)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10010)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noOps(this.makeMine(FILTER_10000)));
        compareList.add(this.setSubCount(this.noOps(FILTER_10001), 1));
        compareList.add(this.noOps(this.makeMine(FILTER_10020)));
        compareList.add(this.noOps(this.makeMine(FILTER_10010)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
    }

    private void _testAdminScreenAfterNobodyDelete() {
        this.navigation.login("admin", "admin");
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(this.setSubCount(this.noOps(FILTER_10001), 1)));
        compareList.add(this.noFavCount(this.makeMine(FILTER_10020)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        TestFavouriteAndMyFilters.assertFalse((boolean)filters.containsColumn("Author"));
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10000)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10020)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10010)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noOps(this.makeMine(FILTER_10000)));
        compareList.add(this.setFavCount(this.setSubCount(this.noOps(FILTER_10001), 1), 2));
        compareList.add(this.noOps(this.makeMine(FILTER_10020)));
        compareList.add(this.setFavCount(this.noOps(this.makeMine(FILTER_10010)), 1));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
    }

    private void _testAdminScreenAfterJoeDelete() {
        this.navigation.login("admin", "admin");
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(this.makeMine(FILTER_10020)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        TestFavouriteAndMyFilters.assertFalse((boolean)filters.containsColumn("Author"));
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10000)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10020)));
        compareList.add(this.noFavCount(this.setSubCount(this.noAuthor(FILTER_10010), 3)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noOps(this.makeMine(FILTER_10000)));
        compareList.add(this.noOps(this.makeMine(FILTER_10020)));
        compareList.add(this.noOps(this.makeMine(this.setSubCount(FILTER_10010, 3))));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
    }

    private void _testJoeScreenAfterNobodyDelete() {
        this.navigation.login(JOE, JOE);
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(this.makeMine(FILTER_10001)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10001)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.setFavCount(this.noOps(this.makeMine(FILTER_10001)), 2));
        compareList.add(this.noOps(this.setSubCount(FILTER_10010, 2)));
        TestFavouriteAndMyFilters.assertEquals(compareList, (Object)filterList);
    }
}

