/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;

public class TestResolutionDateField
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreData("TestResolutionDateField.xml");
    }

    public void testViewIssuePage() {
        this.navigation.issue().viewIssue("HSP-1");
        TableLocator locator = new TableLocator(this.tester, "issue_header_summary");
        this.text.assertTextPresent(locator, "First test issue");
        this.text.assertTextNotPresent(locator, "Resolved");
        this.text.assertTextSequence(locator, "First test issue", "Created", "Updated");
        this.navigation.issue().viewIssue("HSP-2");
        TableLocator locator2 = new TableLocator(this.tester, "issue_header_summary");
        this.text.assertTextPresent(locator2, "Second test issue");
        this.text.assertTextPresent(locator2, "Resolved");
        this.text.assertTextSequence(locator2, "Second test issue", "Created", "Updated", "Resolved");
    }

    public void testResolveIssueUpdatesDate() {
        this.navigation.issue().viewIssue("HSP-1");
        TableLocator locator = new TableLocator(this.tester, "issue_header_summary");
        this.text.assertTextPresent(locator, "First test issue");
        this.text.assertTextNotPresent(locator, "Resolved");
        this.text.assertTextSequence(locator, "First test issue", "Created", "Updated");
        this.tester.clickLink("action_id_5");
        this.tester.submit("Resolve");
        TableLocator locator2 = new TableLocator(this.tester, "issue_header_summary");
        this.text.assertTextPresent(locator2, "First test issue");
        this.text.assertTextPresent(locator2, "Resolved");
        this.text.assertTextSequence(locator2, "First test issue", "Created", "Updated", "Resolved");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Issue Navigator");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 2, 1), "HSP-1");
        String resolvedCell = this.tester.getDialog().getWebTableBySummaryOrId("issuetable").getCellAsText(2, 11).trim();
        TestResolutionDateField.assertTrue((resolvedCell.length() > 0 ? 1 : 0) != 0);
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLink("action_id_3");
        this.tester.submit("Reopen Issue");
        TableLocator locator3 = new TableLocator(this.tester, "issue_header_summary");
        this.text.assertTextPresent(locator3, "First test issue");
        this.text.assertTextNotPresent(locator3, "Resolved");
        this.text.assertTextSequence(locator3, "First test issue", "Created", "Updated");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Issue Navigator");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 2, 1), "HSP-1");
        this.assertTableCellEmpty("issuetable", 2, 11);
    }

    public void testIssueNavigatorColumns() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Issue Navigator");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 0, 11), "Resolved");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 1, 1), "HSP-2");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 1, 11), "14/Oct/08");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 2, 1), "HSP-1");
        this.assertTableCellEmpty("issuetable", 2, 11);
    }

    public void testSearcher() {
        this.navigation.issueNavigator().gotoNavigator();
        this.tester.setFormElement("resolutiondate:after", "13/Oct/08");
        this.tester.setFormElement("resolutiondate:before", "16/Oct/08");
        this.tester.setFormElement("resolutiondate:next", "");
        this.tester.submit("show");
        this.tester.assertTextPresent("Issue Navigator");
        TestResolutionDateField.assertEquals((int)2, (int)this.tester.getDialog().getWebTableBySummaryOrId("issuetable").getRowCount());
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 0, 11), "Resolved");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 1, 1), "HSP-2");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 1, 11), "14/Oct/08");
        this.tester.setFormElement("resolutiondate:after", "15/Oct/08");
        this.tester.setFormElement("resolutiondate:before", "16/Oct/08");
        this.tester.setFormElement("resolutiondate:next", "");
        this.tester.submit("show");
        this.tester.assertTextPresent("No matching issues found.");
        TestResolutionDateField.assertNull((Object)this.tester.getDialog().getWebTableBySummaryOrId("issuetable"));
    }

    public void testIssueViews() {
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLinkWithText("Printable");
        this.tester.assertTextNotPresent("Resolved:");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.clickLinkWithText("Printable");
        this.tester.assertTextPresent("Resolved:");
    }

    private void assertTableCellEmpty(String tableId, int row, int col) {
        String resolvedCell = this.tester.getDialog().getWebTableBySummaryOrId(tableId).getCellAsText(row, col).trim();
        TestResolutionDateField.assertTrue((resolvedCell.length() == 0 ? 1 : 0) != 0);
    }
}

