/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.webtests.JIRAEmailTest;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class TestCurrentAssigneeNotifications
extends JIRAEmailTest {
    public void setUpTest() {
        super.setUpTest();
        if (this.getName().indexOf("PreJRA6244") != -1) {
            this.restoreDataAndConfigureSmtp("TestCurrentAssigneeNotifications_PreJRA6244.xml");
        } else {
            this.restoreDataAndConfigureSmtp("TestCurrentAssigneeNotifications_PostJRA6244.xml");
        }
    }

    public void testAssignIssue_PreJRA6244() throws InterruptedException, MessagingException, IOException {
        this.navigation.issue().assignIssue("HSP-1", "This has been re-assigned", "homer");
        this.assertHomerAndBartsEmails(1, 1);
    }

    public void testAssignIssue_PostJRA6244() throws InterruptedException, MessagingException, IOException {
        this.navigation.issue().assignIssue("HSP-1", "This has been re-assigned", "homer");
        this.assertHomerAndBartsEmails(1, 1);
    }

    public void testEditIssue_PreJRA6244() throws MessagingException, InterruptedException, IOException {
        this.editIssueAndChangeAssignee("HSP-1", "This has been re-assigned", "homer");
        this.assertHomerAndBartsEmails(1, 0);
    }

    public void testEditIssue_PostJRA6244() throws MessagingException, InterruptedException, IOException {
        this.editIssueAndChangeAssignee("HSP-1", "This has been re-assigned", "homer");
        this.assertHomerAndBartsEmails(1, 1);
    }

    public void testTransitionIssue_PreJRA6244() throws MessagingException, InterruptedException, IOException {
        this.workflowIssueAndChangeAssignee("HSP-1", "homer");
        this.assertHomerAndBartsEmails(1, 0);
    }

    public void testTransitionIssue_PostJRA6244() throws MessagingException, InterruptedException, IOException {
        this.workflowIssueAndChangeAssignee("HSP-1", "homer");
        this.assertHomerAndBartsEmails(1, 1);
    }

    public void testBulkEditIssue_PreJRA6244() throws MessagingException, InterruptedException, IOException {
        this.bulkEditHSP_1("homer");
        this.assertHomerAndBartsEmails(1, 0);
    }

    public void testBulkEditIssue_PostJRA6244() throws MessagingException, InterruptedException, IOException {
        this.bulkEditHSP_1("homer");
        this.assertHomerAndBartsEmails(1, 1);
    }

    public void testBulkTransitionIssue_PreJRA6244() throws MessagingException, InterruptedException, IOException {
        this.bulkTransitionHSP_1("homer");
        this.assertHomerAndBartsEmails(1, 0);
    }

    public void testBulkTransitionIssue_PostJRA6244() throws MessagingException, InterruptedException, IOException {
        this.bulkTransitionHSP_1("homer");
        this.assertHomerAndBartsEmails(1, 1);
    }

    private void bulkEditHSP_1(String newAssigneeName) {
        this.tester.clickLink("find_link");
        this.tester.submit("show");
        this.tester.clickLink("bulkedit_all");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.checkCheckbox("actions", "assignee");
        this.tester.selectOption("assignee", newAssigneeName);
        this.tester.checkCheckbox("sendBulkNotification", "true");
        this.tester.submit("Next");
        this.tester.submit("Confirm");
    }

    private void bulkTransitionHSP_1(String newAssigneeName) {
        this.tester.clickLink("find_link");
        this.tester.submit("show");
        this.tester.clickLink("bulkedit_all");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.tester.submit("Next");
        this.tester.checkCheckbox("wftransition", "jira_5_5");
        this.tester.submit("Next");
        this.tester.checkCheckbox("actions", "resolution");
        this.tester.selectOption("resolution", "Won't Fix");
        this.tester.checkCheckbox("actions", "assignee");
        this.tester.selectOption("assignee", newAssigneeName);
        this.tester.checkCheckbox("sendBulkNotification", "true");
        this.tester.submit("Next");
        this.tester.submit("Next");
    }

    private void editIssueAndChangeAssignee(String issueKey, String commentStr, String newAssigneeName) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("edit_issue");
        this.tester.selectOption("assignee", newAssigneeName);
        this.tester.setFormElement("comment", commentStr);
        this.tester.submit("Update");
    }

    private void workflowIssueAndChangeAssignee(String issueKey, String newAssigneeName) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("action_id_5");
        this.tester.selectOption("resolution", "Won't Fix");
        this.tester.selectOption("assignee", newAssigneeName);
        this.tester.submit("Resolve");
    }

    private void assertHomerAndBartsEmails(int expectedHomerEmailCount, int expectedBartEmailCount) throws MessagingException, InterruptedException, IOException {
        this.flushMailQueueAndWait(expectedHomerEmailCount + expectedBartEmailCount);
        this.assertHomerWasAssignedEmails("homer@localhost", expectedHomerEmailCount);
        this.assertHomerWasAssignedEmails("bart@localhost", expectedBartEmailCount);
    }

    private void assertHomerWasAssignedEmails(String emailAddress, int expectedEmailCount) throws MessagingException, IOException {
        List<MimeMessage> messagesForRecipient = this.getMessagesForRecipient(emailAddress);
        TestCurrentAssigneeNotifications.assertEquals((int)expectedEmailCount, (int)messagesForRecipient.size());
        Iterator<MimeMessage> i$ = messagesForRecipient.iterator();
        while (i$.hasNext()) {
            MimeMessage msg;
            MimeMessage message = msg = i$.next();
            String subject = message.getSubject();
            String body = String.valueOf(message.getContent());
            TestCurrentAssigneeNotifications.assertTrue((subject.indexOf("HSP-1") != -1 ? 1 : 0) != 0);
            TestCurrentAssigneeNotifications.assertTrue((body.indexOf("HSP-1") != -1 ? 1 : 0) != 0);
            TestCurrentAssigneeNotifications.assertTrue((body.indexOf("Assignee: homer") != -1 ? 1 : 0) != 0);
            TestCurrentAssigneeNotifications.assertTrue((body.indexOf("(was: bart)") != -1 ? 1 : 0) != 0);
        }
    }

    private void restoreDataAndConfigureSmtp(String fileName) {
        this.administration.restoreData(fileName);
        this.configureAndStartSmtpServer();
    }
}

