/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.webtests.JIRAEmailTest;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class TestBulkHeaders
extends JIRAEmailTest {
    public void testBulkHeadersPresent() throws InterruptedException, MessagingException {
        this.administration.restoreData("TestIssueNotifications.xml");
        this.configureAndStartSmtpServer();
        String issueId = "COW-1";
        this.navigation.issue().viewIssue(issueId);
        this.tester.clickLink("delete_issue");
        this.tester.submit("Delete");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.getGreenMail().getReceivedMessages();
        TestBulkHeaders.assertEquals((int)2, (int)mimeMessages.length);
        for (MimeMessage msg : mimeMessages) {
            String[] prec = msg.getHeader("Precedence");
            String[] auto = msg.getHeader("Auto-Submitted");
            TestBulkHeaders.assertEquals((String)"bulk", (String)prec[0]);
            TestBulkHeaders.assertEquals((String)"auto-generated", (String)auto[0]);
        }
    }

    public void testBulkHeadersNotPresent() throws InterruptedException, MessagingException {
        this.administration.restoreData("TestStripBulk.xml");
        this.configureAndStartSmtpServer();
        String issueId = "MKY-1";
        this.navigation.issue().viewIssue(issueId);
        this.tester.clickLink("delete_issue");
        this.tester.submit("Delete");
        this.flushMailQueueAndWait(3);
        MimeMessage[] mimeMessages = this.getGreenMail().getReceivedMessages();
        TestBulkHeaders.assertEquals((int)3, (int)mimeMessages.length);
        for (MimeMessage msg : mimeMessages) {
            TestBulkHeaders.assertNull((Object)msg.getHeader("Precedence"));
            TestBulkHeaders.assertNull((Object)msg.getHeader("Auto-Submitted"));
        }
    }
}

