/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.table.ImageCell;
import com.atlassian.jira.webtests.table.TableData;
import com.meterware.httpunit.WebTable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class TestVersionWorkloadReport
extends JIRAWebTest {
    private static final String VERSION_WITH_ESTIMATES = "Version with estimates";
    private static final String VERSION_WITH_NO_ESTIMATE = "Version with no estimate";
    private static final String VERSION_WITH_NO_ISSUES = "Version with no issues";
    private static final String NO_ESTIMATE = "No Estimate";
    private static final Object[] TABLE_HEADER_COLUMNS = new Object[]{"Key", "Type", "Priority", "Summary", "Estimated Time Remaining"};
    private static final Object[] NO_ESTIMATE_TOTAL = new Object[]{"Totals", "No Estimate", "No Estimate", "No Estimate", "No Estimate", "No Estimate", "0 minutes"};
    private static final String DEVELOPER_FULLNAME = "\"Developer<input>";
    private static final String HTML_SUMMARY = "\"summary<input>";
    private static final ImageCell IMAGE_BUG_CELL = new ImageCell("/images/icons/bug.gif");
    private static final ImageCell IMAGE_NEWFEATURE_CELL = new ImageCell("/images/icons/newfeature.gif");
    private static final ImageCell IMAGE_IMPROVEMENT_CELL = new ImageCell("/images/icons/improvement.gif");
    private static final ImageCell IMAGE_SUB_TASK_CELL = new ImageCell("/images/icons/issue_subtask.gif");
    private static final ImageCell IMAGE_GENERIC_CELL = new ImageCell("/images/icons/genericissue.gif");
    private static final ImageCell IMAGE_BLOCKER_CELL = new ImageCell("/images/icons/priority_blocker.gif");
    private static final ImageCell IMAGE_CRITICAL_CELL = new ImageCell("/images/icons/priority_critical.gif");
    private static final ImageCell IMAGE_MAJOR_CELL = new ImageCell("/images/icons/priority_major.gif");
    private static final ImageCell IMAGE_MINOR_CELL = new ImageCell("/images/icons/priority_minor.gif");
    private static final ImageCell IMAGE_TRIVIAL_CELL = new ImageCell("/images/icons/priority_trivial.gif");
    private static final String DEV_USERNAME = "dev";
    private static final Object IGNORE = null;
    private static final Long PROJECT_HOMOSAP_ID = 10000L;
    private static final Map SUBTASK_INCLUSION_MAP = new HashMap();
    private static final String ALL_VERSION_SUBTASKS = "ALL_VERSION_SUBTASKS";
    private static final String ALSO_BLANK_VERSION_SUBTASKS = "ALSO_BLANK_VERSION_SUBTASKS";
    private static final String ONLY_VERSION_SUBTASKS = "ONLY_VERSION_SUBTASKS";

    public TestVersionWorkloadReport(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestVersionWorkloadReport.xml");
    }

    public void testVersionWorkloadReportValidation() {
        this.gotoPage("/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:version-workload");
        this.selectOption("versionId", "Unreleased Versions");
        this.submit("Next");
        this.assertTextPresent("Please select an actual version.");
    }

    public void testVersionWorkLoadReport() {
        this.restoreData("TestVersionWorkloadReportFormat.xml");
        this.generateVersionWorkLoadReport(PROJECT_HOMOSAP_ID, "New Version 1");
        this.assertTextPresent("6 days, 16 hours");
        this.reconfigureTimetracking("hours");
        this.generateVersionWorkLoadReport(PROJECT_HOMOSAP_ID, "New Version 1");
        this.assertTextPresent("160h");
        this.reconfigureTimetracking("days");
        this.generateVersionWorkLoadReport(PROJECT_HOMOSAP_ID, "New Version 1");
        this.assertTextPresent("6d 16h");
        this.reconfigureTimetracking("pretty");
        this.setFixForVersion("HSP-2", "New Version 4");
        this.generateVersionWorkLoadReport(PROJECT_HOMOSAP_ID, "New Version 1");
        this.assertTextPresent("5 days, 19 hours, 30 minutes");
        this.reconfigureTimetracking("hours");
        this.generateVersionWorkLoadReport(PROJECT_HOMOSAP_ID, "New Version 1");
        this.assertTextPresent("139.5h");
        this.reconfigureTimetracking("days");
        this.generateVersionWorkLoadReport(PROJECT_HOMOSAP_ID, "New Version 1");
        this.assertTextPresent("5.81d");
        this.reconfigureTimetracking("pretty");
        this.logWorkOnIssueWithComment("HSP-1", "5d", "the workload should decreased by 5 days");
        this.generateVersionWorkLoadReport(PROJECT_HOMOSAP_ID, "New Version 1");
        this.assertTextNotPresent("5 days, 19 hours, 30 minutes");
        this.assertTextPresent("19 hours, 30 minutes");
        this.reconfigureTimetracking("days");
        this.generateVersionWorkLoadReport(PROJECT_HOMOSAP_ID, "New Version 4");
        this.assertTextPresent("HSP-2");
        this.assertTextPresent("0d 20.5h");
    }

    public void testVersionWorkloadReportNoIssues() throws SAXException {
        this.generateVersionWorkLoadReport(PROJECT_HOMOSAP_ID, VERSION_WITH_NO_ISSUES);
        this.assertTextPresent("homosapien (HSP) - Version with no issues");
        WebTable reportSummaryTable = this.getDialog().getResponse().getTableWithID("report_summary");
        TestVersionWorkloadReport.assertEquals((int)2, (int)reportSummaryTable.getRowCount());
        TestVersionWorkloadReport.assertEquals((int)7, (int)reportSummaryTable.getColumnCount());
        this.assertReportSummaryHeader(reportSummaryTable);
        this.assertTableRowEquals(reportSummaryTable, 1, NO_ESTIMATE_TOTAL);
    }

    public void testVersionWorkloadReportNoEstimates() throws SAXException {
        this.generateVersionWorkLoadReport(PROJECT_HOMOSAP_ID, VERSION_WITH_NO_ESTIMATE);
        this.assertTextPresent("homosapien (HSP) - Version with no estimate");
        WebTable reportSummaryTable = this.getDialog().getResponse().getTableWithID("report_summary");
        TestVersionWorkloadReport.assertEquals((int)3, (int)reportSummaryTable.getRowCount());
        TestVersionWorkloadReport.assertEquals((int)7, (int)reportSummaryTable.getColumnCount());
        this.assertReportSummaryHeader(reportSummaryTable);
        this.assertTableRowEquals(reportSummaryTable, 1, new Object[]{"Administrator", "-", "-", "-", "-", "-", NO_ESTIMATE});
        this.assertTableRowEquals(reportSummaryTable, 2, NO_ESTIMATE_TOTAL);
        WebTable reportAdminTable = this.getDialog().getResponse().getTableWithID("report_admin");
        TestVersionWorkloadReport.assertEquals((int)6, (int)reportAdminTable.getRowCount());
        TestVersionWorkloadReport.assertEquals((int)5, (int)reportAdminTable.getColumnCount());
        this.assertTableRowEquals(reportAdminTable, 0, new Object[]{"Administrator", NO_ESTIMATE});
        this.assertTableRowEquals(reportAdminTable, 1, new Object[]{"Bug", NO_ESTIMATE});
        this.assertTableRowEquals(reportAdminTable, 2, TABLE_HEADER_COLUMNS);
        this.assertTableHasMatchingRowFromTo(reportAdminTable, 3, 5, new Object[]{"HSP-1", IMAGE_BUG_CELL, IMAGE_CRITICAL_CELL, "Issue with no estimate", NO_ESTIMATE});
        this.assertTableHasMatchingRowFromTo(reportAdminTable, 3, 5, new Object[]{"HSP-2", IMAGE_BUG_CELL, IMAGE_TRIVIAL_CELL, "Issue without estimate", NO_ESTIMATE});
        TestVersionWorkloadReport.assertTrue((boolean)this.tableCellHasText(reportAdminTable, 5, 0, "Return to Summary"));
    }

    public void testVersionWorkloadReportWithEstimates() throws SAXException {
        this.generateVersionWorkLoadReport(PROJECT_HOMOSAP_ID, VERSION_WITH_ESTIMATES);
        this.assertTextPresent("homosapien (HSP) - Version with estimates");
        WebTable reportSummaryTable = this.getDialog().getResponse().getTableWithID("report_summary");
        TestVersionWorkloadReport.assertEquals((int)5, (int)reportSummaryTable.getRowCount());
        TestVersionWorkloadReport.assertEquals((int)7, (int)reportSummaryTable.getColumnCount());
        this.assertReportSummaryHeader(reportSummaryTable);
        this.assertTableRowEquals(reportSummaryTable, 1, new Object[]{DEVELOPER_FULLNAME, "6 hours", "-", "-", "6 days", "6 minutes", "6 days, 6 hours, 6 minutes"});
        this.assertTableRowEquals(reportSummaryTable, 2, new Object[]{"Administrator", "1 week, 2 days, 3 hours, 9 minutes", "-", "-", "-", "-", "1 week, 2 days, 3 hours, 9 minutes"});
        this.assertTableRowEquals(reportSummaryTable, 3, new Object[]{"Unassigned", "-", "5 weeks, 6 days, 23 hours, 59 minutes", "-", "-", "-", "5 weeks, 6 days, 23 hours, 59 minutes"});
        this.assertTableRowEquals(reportSummaryTable, 4, new Object[]{"Totals", "1 week, 2 days, 9 hours, 9 minutes", "5 weeks, 6 days, 23 hours, 59 minutes", NO_ESTIMATE, "6 days", "6 minutes", "8 weeks, 1 day, 9 hours, 14 minutes"});
        WebTable reportAdminTable = this.getDialog().getResponse().getTableWithID("report_admin");
        TestVersionWorkloadReport.assertEquals((int)6, (int)reportAdminTable.getRowCount());
        TestVersionWorkloadReport.assertEquals((int)5, (int)reportAdminTable.getColumnCount());
        this.assertTableRowEquals(reportAdminTable, 0, new Object[]{"Administrator", "1 week, 2 days, 3 hours, 9 minutes"});
        this.assertTableRowEquals(reportAdminTable, 1, new Object[]{"Bug", "1 week, 2 days, 3 hours, 9 minutes"});
        this.assertTableRowEquals(reportAdminTable, 2, TABLE_HEADER_COLUMNS);
        this.assertTableHasMatchingRowFromTo(reportAdminTable, 3, 5, new Object[]{"HSP-3", IMAGE_BUG_CELL, IMAGE_BLOCKER_CELL, "bug 1 with estimate", "1 week, 2 days, 3 hours, 4 minutes"});
        this.assertTableHasMatchingRowFromTo(reportAdminTable, 3, 5, new Object[]{"HSP-4", IMAGE_BUG_CELL, IMAGE_MAJOR_CELL, "bug 2 with estimate", "5 minutes"});
        TestVersionWorkloadReport.assertTrue((boolean)this.tableCellHasText(reportAdminTable, 5, 0, "Return to Summary"));
        WebTable reportDevTable = this.getDialog().getResponse().getTableWithID("report_dev");
        TestVersionWorkloadReport.assertEquals((int)11, (int)reportDevTable.getRowCount());
        TestVersionWorkloadReport.assertEquals((int)5, (int)reportDevTable.getColumnCount());
        this.assertTableRowEquals(reportDevTable, 0, new Object[]{DEVELOPER_FULLNAME, "6 days, 6 hours, 6 minutes"});
        TableData expectedSubTable = new TableData().addRow(new Object[]{"Bug", "6 hours"}).addRow(TABLE_HEADER_COLUMNS).addRow(new Object[]{"HSP-5", IMAGE_BUG_CELL, IMAGE_MAJOR_CELL, "new bug with estimate", "6 hours"});
        this.assertTableHasSubTable(reportDevTable, expectedSubTable.toArray());
        expectedSubTable = new TableData().addRow(new Object[]{"Improvement", "6 days"}).addRow(TABLE_HEADER_COLUMNS).addRow(new Object[]{"HSP-6", IMAGE_IMPROVEMENT_CELL, IMAGE_MINOR_CELL, "improvement with estimate", "6 days"});
        this.assertTableHasSubTable(reportDevTable, expectedSubTable.toArray());
        expectedSubTable = new TableData().addRow(new Object[]{"Sub-task", "6 minutes"}).addRow(TABLE_HEADER_COLUMNS).addRow(new Object[]{"HSP-6", IMAGE_SUB_TASK_CELL, IMAGE_CRITICAL_CELL, "subtask issue with estimate", "6 minutes"});
        this.assertTableHasSubTable(reportDevTable, expectedSubTable.toArray());
        expectedSubTable = new TableData().addRow(new Object[]{"Sub-task", "6 minutes"}).addRow(TABLE_HEADER_COLUMNS).addRow(new Object[]{"HSP-7", IMAGE_SUB_TASK_CELL, IMAGE_CRITICAL_CELL, "subtask issue with estimate", "6 minutes"});
        this.assertTableHasSubTable(reportDevTable, expectedSubTable.toArray());
        WebTable reportUnassignedTable = this.getDialog().getResponse().getTableWithID("report_Unassigned");
        TestVersionWorkloadReport.assertEquals((int)6, (int)reportUnassignedTable.getRowCount());
        TestVersionWorkloadReport.assertEquals((int)5, (int)reportUnassignedTable.getColumnCount());
        this.assertTableRowEquals(reportUnassignedTable, 0, new Object[]{"Unassigned", "5 weeks, 6 days, 23 hours, 59 minutes"});
        this.assertTableRowEquals(reportUnassignedTable, 1, new Object[]{"New Feature", "5 weeks, 6 days, 23 hours, 59 minutes"});
        this.assertTableRowEquals(reportUnassignedTable, 2, TABLE_HEADER_COLUMNS);
        this.assertTableHasMatchingRowFromTo(reportUnassignedTable, 3, 5, new Object[]{"HSP-8", IMAGE_NEWFEATURE_CELL, IMAGE_TRIVIAL_CELL, "unassigned issue with estimate", "5 weeks, 6 days, 23 hours, 59 minutes"});
        this.assertTableHasMatchingRowFromTo(reportUnassignedTable, 3, 5, new Object[]{"HSP-9", IMAGE_NEWFEATURE_CELL, IMAGE_MAJOR_CELL, HTML_SUMMARY, NO_ESTIMATE});
        TestVersionWorkloadReport.assertTrue((boolean)this.tableCellHasText(reportUnassignedTable, 5, 0, "Return to Summary"));
    }

    public void testVersionIsEncoded() {
        this.restoreData("TestVersionAndComponentsWithHTMLNames.xml");
        this.generateVersionWorkLoadReport(PROJECT_HOMOSAP_ID, "\"version<input >");
        this.assertTextPresent("&quot;version&lt;input &gt;");
        this.assertTextNotPresent("\"version<input >");
    }

    public void test_TT_AllSubtasks_DisplayUnestimated() throws SAXException {
        this.test_TT_AllSubtasks(true);
    }

    public void test_TT_AllSubtasks_NoDisplayUnestimated() throws SAXException {
        this.test_TT_AllSubtasks(false);
    }

    private void test_TT_AllSubtasks(boolean displayUnestimated) throws SAXException {
        this.restoreData("TestVersionWorkLoadReportSubTasks.xml");
        this.generateVersionWorkLoadReport(PROJECT_HOMOSAP_ID, VERSION_WITH_ESTIMATES, ALL_VERSION_SUBTASKS, displayUnestimated);
        this.assertTextPresent("homosapien (HSP) - Version with estimates");
        this.assertTextNotPresent("HSP-21");
        this.assertTextNotPresent("ST of HSP-6 - developer - VWE - resolved");
        WebTable reportAdminTable = this.getDialog().getResponse().getTableWithID("report_admin");
        TestVersionWorkloadReport.assertEquals((int)5, (int)reportAdminTable.getColumnCount());
        int rowCount = reportAdminTable.getRowCount();
        int rowIndex = this.tableIndexOf(reportAdminTable, new Object[]{"Sub-task", "5 hours"});
        TestVersionWorkloadReport.assertTrue((String)"Sub task row is not present in report", (rowIndex != -1 ? 1 : 0) != 0);
        this.assertTableRowEquals(reportAdminTable, rowIndex + 1, TABLE_HEADER_COLUMNS);
        this.assertTableHasMatchingRowFromTo(reportAdminTable, rowIndex, rowCount, new Object[]{"HSP-15", IGNORE, IGNORE, IGNORE, "3 hours"});
        this.assertTableHasMatchingRowFromTo(reportAdminTable, rowIndex, rowCount, new Object[]{"HSP-11", IGNORE, IGNORE, IGNORE, "2 hours"});
        WebTable reportDevTable = this.getDialog().getResponse().getTableWithID("report_dev");
        TestVersionWorkloadReport.assertEquals((int)5, (int)reportDevTable.getColumnCount());
        rowCount = reportDevTable.getRowCount();
        rowIndex = this.tableIndexOf(reportDevTable, new Object[]{"Sub-task", "23 hours, 6 minutes"});
        TestVersionWorkloadReport.assertTrue((String)"Sub task row is not present in report", (rowIndex != -1 ? 1 : 0) != 0);
        this.assertTableRowEquals(reportDevTable, rowIndex + 1, TABLE_HEADER_COLUMNS);
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-7", IGNORE, IGNORE, IGNORE, "6 minutes"});
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-10", IGNORE, IGNORE, IGNORE, "3 hours"});
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-12", IGNORE, IGNORE, IGNORE, "4 hours"});
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-13", IGNORE, IGNORE, IGNORE, "4 hours"});
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-14", IGNORE, IGNORE, IGNORE, "0 minutes"});
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-16", IGNORE, IGNORE, IGNORE, "5 hours"});
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-17", IGNORE, IGNORE, IGNORE, "7 hours"});
        if (displayUnestimated) {
            this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-18", IGNORE, IGNORE, IGNORE, NO_ESTIMATE});
            this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-19", IGNORE, IGNORE, IGNORE, NO_ESTIMATE});
            this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-20", IGNORE, IGNORE, IGNORE, NO_ESTIMATE});
        } else {
            this.assertTableHasNoMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-18", IGNORE, IGNORE, IGNORE, NO_ESTIMATE});
            this.assertTableHasNoMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-19", IGNORE, IGNORE, IGNORE, NO_ESTIMATE});
            this.assertTableHasNoMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-20", IGNORE, IGNORE, IGNORE, NO_ESTIMATE});
        }
        WebTable reportSummaryTable = this.getDialog().getResponse().getTableWithID("report_summary");
        TestVersionWorkloadReport.assertEquals((int)5, (int)reportSummaryTable.getRowCount());
        TestVersionWorkloadReport.assertEquals((int)7, (int)reportSummaryTable.getColumnCount());
        this.assertTableRowEquals(reportSummaryTable, 1, new Object[]{DEVELOPER_FULLNAME, "6 hours", "-", "-", "6 days", "23 hours, 6 minutes", "1 week, 5 hours, 6 minutes"});
        this.assertTableRowEquals(reportSummaryTable, 2, new Object[]{"Administrator", "1 week, 2 days, 3 hours, 9 minutes", "-", "-", "-", "5 hours", "1 week, 2 days, 8 hours, 9 minutes"});
        this.assertTableRowEquals(reportSummaryTable, 3, new Object[]{"Unassigned", "-", "5 weeks, 6 days, 23 hours, 59 minutes", "-", "-", "-", "5 weeks, 6 days, 23 hours, 59 minutes"});
        this.assertTableRowEquals(reportSummaryTable, 4, new Object[]{"Totals", "1 week, 2 days, 9 hours, 9 minutes", "5 weeks, 6 days, 23 hours, 59 minutes", NO_ESTIMATE, "6 days", "1 day, 4 hours, 6 minutes", "8 weeks, 2 days, 13 hours, 14 minutes"});
    }

    public void test_TT_OnlyVersionOrBlankVersionSubtasks_DisplayUnestimated() throws SAXException {
        this.test_TT_OnlyVersionOrBlankVersionSubtasks(true);
    }

    public void test_TT_OnlyVersionOrBlankVersionSubtasks_NoDisplayUnestimated() throws SAXException {
        this.test_TT_OnlyVersionOrBlankVersionSubtasks(false);
    }

    private void test_TT_OnlyVersionOrBlankVersionSubtasks(boolean displayUnestimated) throws SAXException {
        this.restoreData("TestVersionWorkLoadReportSubTasks.xml");
        this.generateVersionWorkLoadReport(PROJECT_HOMOSAP_ID, VERSION_WITH_ESTIMATES, ALSO_BLANK_VERSION_SUBTASKS, displayUnestimated);
        this.assertTextPresent("homosapien (HSP) - Version with estimates");
        this.assertTextNotPresent("HSP-21");
        this.assertTextNotPresent("ST of HSP-6 - developer - VWE - resolved");
        WebTable reportAdminTable = this.getDialog().getResponse().getTableWithID("report_admin");
        int rowCount = reportAdminTable.getRowCount();
        TestVersionWorkloadReport.assertEquals((int)5, (int)reportAdminTable.getColumnCount());
        int rowIndex = this.tableIndexOf(reportAdminTable, new Object[]{"Sub-task", "2 hours"});
        TestVersionWorkloadReport.assertTrue((String)"Sub task row is not present in report", (rowIndex != -1 ? 1 : 0) != 0);
        this.assertTableRowEquals(reportAdminTable, rowIndex + 1, TABLE_HEADER_COLUMNS);
        this.assertTableHasMatchingRowFromTo(reportAdminTable, rowIndex + 2, rowCount, new Object[]{"HSP-11", null, null, null, "2 hours"});
        WebTable reportDevTable = this.getDialog().getResponse().getTableWithID("report_dev");
        rowCount = reportDevTable.getRowCount();
        TestVersionWorkloadReport.assertEquals((int)5, (int)reportDevTable.getColumnCount());
        rowIndex = this.tableIndexOf(reportDevTable, new Object[]{"Sub-task", "19 hours, 6 minutes"});
        TestVersionWorkloadReport.assertTrue((String)"Sub task row is not present in report", (rowIndex != -1 ? 1 : 0) != 0);
        this.assertTableRowEquals(reportDevTable, rowIndex + 1, TABLE_HEADER_COLUMNS);
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-7", IGNORE, IGNORE, IGNORE, "6 minutes"});
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-10", IGNORE, IGNORE, IGNORE, "3 hours"});
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-13", IGNORE, IGNORE, IGNORE, "4 hours"});
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-14", IGNORE, IGNORE, IGNORE, "0 minutes"});
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-16", IGNORE, IGNORE, IGNORE, "5 hours"});
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-17", IGNORE, IGNORE, IGNORE, "7 hours"});
        if (displayUnestimated) {
            this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-18", IGNORE, IGNORE, IGNORE, NO_ESTIMATE});
            this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-20", IGNORE, IGNORE, IGNORE, NO_ESTIMATE});
        } else {
            this.assertTableHasNoMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-18", IGNORE, IGNORE, IGNORE, NO_ESTIMATE});
            this.assertTableHasNoMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-20", IGNORE, IGNORE, IGNORE, NO_ESTIMATE});
        }
        this.assertTableHasNoMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-19", IGNORE, IGNORE, IGNORE, NO_ESTIMATE});
        WebTable reportSummaryTable = this.getDialog().getResponse().getTableWithID("report_summary");
        TestVersionWorkloadReport.assertEquals((int)5, (int)reportSummaryTable.getRowCount());
        TestVersionWorkloadReport.assertEquals((int)7, (int)reportSummaryTable.getColumnCount());
        this.assertTableRowEquals(reportSummaryTable, 1, new Object[]{DEVELOPER_FULLNAME, "6 hours", "-", "-", "6 days", "19 hours, 6 minutes", "1 week, 1 hour, 6 minutes"});
        this.assertTableRowEquals(reportSummaryTable, 2, new Object[]{"Administrator", "1 week, 2 days, 3 hours, 9 minutes", "-", "-", "-", "2 hours", "1 week, 2 days, 5 hours, 9 minutes"});
        this.assertTableRowEquals(reportSummaryTable, 3, new Object[]{"Unassigned", "-", "5 weeks, 6 days, 23 hours, 59 minutes", "-", "-", "-", "5 weeks, 6 days, 23 hours, 59 minutes"});
        this.assertTableRowEquals(reportSummaryTable, 4, new Object[]{"Totals", "1 week, 2 days, 9 hours, 9 minutes", "5 weeks, 6 days, 23 hours, 59 minutes", NO_ESTIMATE, "6 days", "21 hours, 6 minutes", "8 weeks, 2 days, 6 hours, 14 minutes"});
    }

    public void test_TT_OnlyVersionSubtasks_DisplayUnestimated() throws SAXException {
        this.test_TT_OnlyVersionSubtasks(true);
    }

    public void test_TT_OnlyVersionSubtasks_NoDisplayUnestimated() throws SAXException {
        this.test_TT_OnlyVersionSubtasks(false);
    }

    private void test_TT_OnlyVersionSubtasks(boolean displayUnestimated) throws SAXException {
        this.restoreData("TestVersionWorkLoadReportSubTasks.xml");
        this.generateVersionWorkLoadReport(PROJECT_HOMOSAP_ID, VERSION_WITH_ESTIMATES, ONLY_VERSION_SUBTASKS, displayUnestimated);
        this.assertTextPresent("homosapien (HSP) - Version with estimates");
        this.assertTextNotPresent("HSP-21");
        this.assertTextNotPresent("ST of HSP-6 - developer - VWE - resolved");
        WebTable reportAdminTable = this.getDialog().getResponse().getTableWithID("report_admin");
        TestVersionWorkloadReport.assertEquals((int)5, (int)reportAdminTable.getColumnCount());
        int rowIndex = this.tableIndexOf(reportAdminTable, new Object[]{"Sub-task"});
        TestVersionWorkloadReport.assertTrue((String)"Sub task row SHOULD NOT be present in report", (rowIndex == -1 ? 1 : 0) != 0);
        WebTable reportDevTable = this.getDialog().getResponse().getTableWithID("report_dev");
        int rowCount = reportDevTable.getRowCount();
        TestVersionWorkloadReport.assertEquals((int)5, (int)reportDevTable.getColumnCount());
        rowIndex = this.tableIndexOf(reportDevTable, new Object[]{"Sub-task", "19 hours, 6 minutes"});
        TestVersionWorkloadReport.assertTrue((String)"Sub task row is not present in report", (rowIndex != -1 ? 1 : 0) != 0);
        this.assertTableRowEquals(reportDevTable, rowIndex + 1, TABLE_HEADER_COLUMNS);
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-7", IGNORE, IGNORE, IGNORE, "6 minutes"});
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-10", IGNORE, IGNORE, IGNORE, "3 hours"});
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-13", IGNORE, IGNORE, IGNORE, "4 hours"});
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-14", IGNORE, IGNORE, IGNORE, "0 minutes"});
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-16", IGNORE, IGNORE, IGNORE, "5 hours"});
        this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-17", IGNORE, IGNORE, IGNORE, "7 hours"});
        if (displayUnestimated) {
            this.assertTableHasMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-18", IGNORE, IGNORE, IGNORE, NO_ESTIMATE});
        } else {
            this.assertTableHasNoMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-18", IGNORE, IGNORE, IGNORE, NO_ESTIMATE});
        }
        this.assertTableHasNoMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-19", IGNORE, IGNORE, IGNORE, NO_ESTIMATE});
        this.assertTableHasNoMatchingRowFromTo(reportDevTable, rowIndex, rowCount, new Object[]{"HSP-20", IGNORE, IGNORE, IGNORE, NO_ESTIMATE});
        WebTable reportSummaryTable = this.getDialog().getResponse().getTableWithID("report_summary");
        TestVersionWorkloadReport.assertEquals((int)5, (int)reportSummaryTable.getRowCount());
        TestVersionWorkloadReport.assertEquals((int)7, (int)reportSummaryTable.getColumnCount());
        this.assertTableRowEquals(reportSummaryTable, 1, new Object[]{DEVELOPER_FULLNAME, "6 hours", "-", "-", "6 days", "19 hours, 6 minutes", "1 week, 1 hour, 6 minutes"});
        this.assertTableRowEquals(reportSummaryTable, 2, new Object[]{"Administrator", "1 week, 2 days, 3 hours, 9 minutes", "-", "-", "-", "-", "1 week, 2 days, 3 hours, 9 minutes"});
        this.assertTableRowEquals(reportSummaryTable, 3, new Object[]{"Unassigned", "-", "5 weeks, 6 days, 23 hours, 59 minutes", "-", "-", "-", "5 weeks, 6 days, 23 hours, 59 minutes"});
        this.assertTableRowEquals(reportSummaryTable, 4, new Object[]{"Totals", "1 week, 2 days, 9 hours, 9 minutes", "5 weeks, 6 days, 23 hours, 59 minutes", NO_ESTIMATE, "6 days", "19 hours, 6 minutes", "8 weeks, 2 days, 4 hours, 14 minutes"});
    }

    private void generateVersionWorkLoadReport(Long projectId, String versionName, String subtaskInclusion, boolean displayUnestimated) {
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=" + projectId + "&reportKey=com.atlassian.jira.plugin.system.reports:version-workload");
        this.selectOption("versionId", "- " + versionName);
        if (subtaskInclusion != null) {
            String optionText = (String)SUBTASK_INCLUSION_MAP.get(subtaskInclusion);
            this.selectOption("subtaskInclusion", optionText);
        }
        this.selectOption("displayUnknown", displayUnestimated ? "Yes" : "No");
        this.submit("Next");
    }

    private void generateVersionWorkLoadReport(long projectId, String versionName) {
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=" + projectId + "&reportKey=com.atlassian.jira.plugin.system.reports:version-workload");
        this.selectOption("versionId", "- " + versionName);
        this.submit("Next");
    }

    private void setFixForVersion(String issuekey, String version) {
        this.gotoIssue(issuekey);
        this.clickLink("edit_issue");
        this.selectOption("fixVersions", version);
        this.selectOption("versions", version);
        this.submit("Update");
    }

    private void assertReportSummaryHeader(WebTable firstTab) {
        List expectedColumnNames = EasyList.build((Object)"User", (Object)"Bug", (Object)"New Feature", (Object)"Task", (Object)"Improvement", (Object)"Sub-task", (Object)"Total Time Remaining");
        List columnNames = this.getTableRowAsList(firstTab, 0);
        TestVersionWorkloadReport.assertEquals((Object)expectedColumnNames, (Object)columnNames);
    }

    static {
        SUBTASK_INCLUSION_MAP.put(ALL_VERSION_SUBTASKS, "Including all sub-tasks");
        SUBTASK_INCLUSION_MAP.put(ALSO_BLANK_VERSION_SUBTASKS, "Also including sub-tasks without a version set");
        SUBTASK_INCLUSION_MAP.put(ONLY_VERSION_SUBTASKS, "Only including sub-tasks with the selected version");
    }
}

